// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// ExportAuthenticationFlavor Represents an authentication flavor. The following flavors are supported:
// * any - All authentication flavors
// * none - Special authentication flavor for anonymization
// * never - Special authentication flavor to represent access denial
// * krb5 - Kerberos V4 Authentication
// * krb5i - Kerberos V4 Integrity
// * krb5p - Kerberos V4 Privacy
// * ntlm - CIFS NTLM Authentication
// * sys - AUTH_SYS or AUTH_UNIX Authentication
//
// swagger:model export_authentication_flavor
type ExportAuthenticationFlavor string

func NewExportAuthenticationFlavor(value ExportAuthenticationFlavor) *ExportAuthenticationFlavor {
	return &value
}

// Pointer returns a pointer to a freshly-allocated ExportAuthenticationFlavor.
func (m ExportAuthenticationFlavor) Pointer() *ExportAuthenticationFlavor {
	return &m
}

const (

	// ExportAuthenticationFlavorAny captures enum value "any"
	ExportAuthenticationFlavorAny ExportAuthenticationFlavor = "any"

	// ExportAuthenticationFlavorNone captures enum value "none"
	ExportAuthenticationFlavorNone ExportAuthenticationFlavor = "none"

	// ExportAuthenticationFlavorNever captures enum value "never"
	ExportAuthenticationFlavorNever ExportAuthenticationFlavor = "never"

	// ExportAuthenticationFlavorKrb5 captures enum value "krb5"
	ExportAuthenticationFlavorKrb5 ExportAuthenticationFlavor = "krb5"

	// ExportAuthenticationFlavorKrb5i captures enum value "krb5i"
	ExportAuthenticationFlavorKrb5i ExportAuthenticationFlavor = "krb5i"

	// ExportAuthenticationFlavorKrb5p captures enum value "krb5p"
	ExportAuthenticationFlavorKrb5p ExportAuthenticationFlavor = "krb5p"

	// ExportAuthenticationFlavorNtlm captures enum value "ntlm"
	ExportAuthenticationFlavorNtlm ExportAuthenticationFlavor = "ntlm"

	// ExportAuthenticationFlavorSys captures enum value "sys"
	ExportAuthenticationFlavorSys ExportAuthenticationFlavor = "sys"
)

// for schema
var exportAuthenticationFlavorEnum []interface{}

func init() {
	var res []ExportAuthenticationFlavor
	if err := json.Unmarshal([]byte(`["any","none","never","krb5","krb5i","krb5p","ntlm","sys"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		exportAuthenticationFlavorEnum = append(exportAuthenticationFlavorEnum, v)
	}
}

func (m ExportAuthenticationFlavor) validateExportAuthenticationFlavorEnum(path, location string, value ExportAuthenticationFlavor) error {
	if err := validate.EnumCase(path, location, value, exportAuthenticationFlavorEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this export authentication flavor
func (m ExportAuthenticationFlavor) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateExportAuthenticationFlavorEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this export authentication flavor based on context it is used
func (m ExportAuthenticationFlavor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
