// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FcInterface A Fibre Channel (FC) interface is the logical endpoint for FC network connections to an SVM. An FC interface provides FC access to storage within the interface SVM using either Fibre Channel Protocol or NVMe over Fibre Channel (NVMe/FC).<br/>
// An FC interface is created on an FC port which is located on a cluster node. The FC port must be specified to identify the location of the interface for a POST or PATCH operation that relocates an interface. You can identify the port by supplying either the cluster node and port names or the port UUID.
//
// swagger:model fc_interface
type FcInterface struct {

	// links
	Links *FcInterfaceInlineLinks `json:"_links,omitempty"`

	// A user configurable comment. Optional in POST; valid in PATCH. To clear a prior comment, set the property to an empty string in PATCH.
	//
	Comment *string `json:"comment,omitempty"`

	// The data protocol for which the FC interface is configured. Required in POST.
	//
	// Enum: ["fcp","fc_nvme"]
	DataProtocol *string `json:"data_protocol,omitempty"`

	// The administrative state of the FC interface. The FC interface can be disabled to block all FC communication with the SVM through this interface. Optional in POST and PATCH; defaults to _true_ (enabled) in POST.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// location
	Location *FcInterfaceInlineLocation `json:"location,omitempty"`

	// metric
	Metric *FcInterfaceInlineMetric `json:"metric,omitempty"`

	// The name of the FC interface. Required in POST; optional in PATCH.
	//
	// Example: fc_lif1
	Name *string `json:"name,omitempty"`

	// The port address of the FC interface. Each FC port in an FC switched fabric has its own unique FC port address for routing purposes. The FC port address is assigned by a switch in the fabric when that port logs in to the fabric. This property refers to the address given by a switch to the FC interface when the SVM performs a port login (PLOGI).<br/>
	// This is useful for obtaining statistics and diagnostic information from FC switches.<br/>
	// This is a hexadecimal encoded numeric value.
	//
	// Example: 5060F
	// Read Only: true
	PortAddress *string `json:"port_address,omitempty"`

	// The current operational state of the FC interface. The state is set to _down_ if the interface is not enabled.<br/>
	// If the cluster node hosting the port is down or unavailable, no state value is returned.
	//
	// Read Only: true
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *FcInterfaceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *FcInterfaceInlineSvm `json:"svm,omitempty"`

	// The unique identifier of the FC interface. Required in the URL.
	//
	// Example: bce9827d-4d8f-60af-c771-6e8e9af2c6f0
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// The world wide node name (WWNN) of the FC interface SVM. The WWNN is generated by ONTAP when Fibre Channel Protocol or the NVMe service is created for the FC interface SVM.
	//
	// Example: 20:00:00:50:56:b4:13:01
	// Read Only: true
	Wwnn *string `json:"wwnn,omitempty"`

	// The world wide port name (WWPN) of the FC interface. The WWPN is generated by ONTAP when the FC interface is created.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this fc interface
func (m *FcInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceTypeDataProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","fc_nvme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceTypeDataProtocolPropEnum = append(fcInterfaceTypeDataProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface
	// FcInterface
	// data_protocol
	// DataProtocol
	// fcp
	// END DEBUGGING
	// FcInterfaceDataProtocolFcp captures enum value "fcp"
	FcInterfaceDataProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// fc_interface
	// FcInterface
	// data_protocol
	// DataProtocol
	// fc_nvme
	// END DEBUGGING
	// FcInterfaceDataProtocolFcNvme captures enum value "fc_nvme"
	FcInterfaceDataProtocolFcNvme string = "fc_nvme"
)

// prop value enum
func (m *FcInterface) validateDataProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceTypeDataProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcInterface) validateDataProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.DataProtocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateDataProtocolEnum("data_protocol", "body", *m.DataProtocol); err != nil {
		return err
	}

	return nil
}

func (m *FcInterface) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterface) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceTypeStatePropEnum = append(fcInterfaceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface
	// FcInterface
	// state
	// State
	// up
	// END DEBUGGING
	// FcInterfaceStateUp captures enum value "up"
	FcInterfaceStateUp string = "up"

	// BEGIN DEBUGGING
	// fc_interface
	// FcInterface
	// state
	// State
	// down
	// END DEBUGGING
	// FcInterfaceStateDown captures enum value "down"
	FcInterfaceStateDown string = "down"
)

// prop value enum
func (m *FcInterface) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcInterface) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *FcInterface) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterface) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface based on the context it is used
func (m *FcInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwnn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterface) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterface) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterface) contextValidatePortAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "port_address", "body", m.PortAddress); err != nil {
		return err
	}

	return nil
}

func (m *FcInterface) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *FcInterface) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterface) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterface) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *FcInterface) contextValidateWwnn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "wwnn", "body", m.Wwnn); err != nil {
		return err
	}

	return nil
}

func (m *FcInterface) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterface) UnmarshalBinary(b []byte) error {
	var res FcInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLinks fc interface inline links
//
// swagger:model fc_interface_inline__links
type FcInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline links
func (m *FcInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline links based on the context it is used
func (m *FcInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocation The location of the FC interface is defined by the location of its port. An FC port is identified by its UUID, or a combination of its cluster node name and port name. Either the UUID or the cluster node name and port name are required for POST. To move an interface, supply either the port UUID or the cluster node name and port name in a PATCH.<br/>
// `location.node` and `location.port` refer to the current location of the FC interface. This can be different from `location.home_node` and `location.home_port` in instances where the FC interface has failed over to its HA partner node. The `location.node`, `location.port`, and `location.is_home` properties are not available for interfaces on the inactive side of a MetroCluster relationship.
//
// swagger:model fc_interface_inline_location
type FcInterfaceInlineLocation struct {

	// home node
	HomeNode *FcInterfaceInlineLocationInlineHomeNode `json:"home_node,omitempty"`

	// home port
	HomePort *FcInterfaceInlineLocationInlineHomePort `json:"home_port,omitempty"`

	// Indicates if the FC interface is currently on its home node.
	// Read Only: true
	IsHome *bool `json:"is_home,omitempty"`

	// node
	Node *FcInterfaceInlineLocationInlineNode `json:"node,omitempty"`

	// port
	Port *FcInterfaceInlineLocationInlinePort `json:"port,omitempty"`
}

// Validate validates this fc interface inline location
func (m *FcInterfaceInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHomePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocation) validateHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(m.HomeNode) { // not required
		return nil
	}

	if m.HomeNode != nil {
		if err := m.HomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocation) validateHomePort(formats strfmt.Registry) error {
	if swag.IsZero(m.HomePort) { // not required
		return nil
	}

	if m.HomePort != nil {
		if err := m.HomePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocation) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location based on the context it is used
func (m *FcInterfaceInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHomePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsHome(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocation) contextValidateHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if m.HomeNode != nil {
		if err := m.HomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocation) contextValidateHomePort(ctx context.Context, formats strfmt.Registry) error {

	if m.HomePort != nil {
		if err := m.HomePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocation) contextValidateIsHome(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "location"+"."+"is_home", "body", m.IsHome); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocation) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocation) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlineHomeNode fc interface inline location inline home node
//
// swagger:model fc_interface_inline_location_inline_home_node
type FcInterfaceInlineLocationInlineHomeNode struct {

	// links
	Links *FcInterfaceInlineLocationInlineHomeNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline home node
func (m *FcInterfaceInlineLocationInlineHomeNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomeNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home node based on the context it is used
func (m *FcInterfaceInlineLocationInlineHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomeNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomeNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomeNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlineHomeNodeInlineLinks fc interface inline location inline home node inline links
//
// swagger:model fc_interface_inline_location_inline_home_node_inline__links
type FcInterfaceInlineLocationInlineHomeNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline home node inline links
func (m *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home node inline links based on the context it is used
func (m *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomeNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomeNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlineHomePort An FC port is the physical port of an FC adapter on a cluster node that can be connected to an FC network.
//
// swagger:model fc_interface_inline_location_inline_home_port
type FcInterfaceInlineLocationInlineHomePort struct {

	// links
	Links *FcInterfaceInlineLocationInlineHomePortInlineLinks `json:"_links,omitempty"`

	// The name of the FC port.
	//
	// Example: 0a
	Name *string `json:"name,omitempty"`

	// node
	Node *FcInterfaceInlineLocationInlineHomePortInlineNode `json:"node,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline home port
func (m *FcInterfaceInlineLocationInlineHomePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocationInlineHomePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home port based on the context it is used
func (m *FcInterfaceInlineLocationInlineHomePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocationInlineHomePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomePort) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlineHomePortInlineLinks fc interface inline location inline home port inline links
//
// swagger:model fc_interface_inline_location_inline_home_port_inline__links
type FcInterfaceInlineLocationInlineHomePortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline home port inline links
func (m *FcInterfaceInlineLocationInlineHomePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline home port inline links based on the context it is used
func (m *FcInterfaceInlineLocationInlineHomePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineHomePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomePortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlineHomePortInlineNode The node on which the FC port is located.
//
// swagger:model fc_interface_inline_location_inline_home_port_inline_node
type FcInterfaceInlineLocationInlineHomePortInlineNode struct {

	// The name of the node on which the FC port is located.
	//
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this fc interface inline location inline home port inline node
func (m *FcInterfaceInlineLocationInlineHomePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fc interface inline location inline home port inline node based on context it is used
func (m *FcInterfaceInlineLocationInlineHomePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomePortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineHomePortInlineNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineHomePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlineNode fc interface inline location inline node
//
// swagger:model fc_interface_inline_location_inline_node
type FcInterfaceInlineLocationInlineNode struct {

	// links
	Links *FcInterfaceInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline node
func (m *FcInterfaceInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline node based on the context it is used
func (m *FcInterfaceInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlineNodeInlineLinks fc interface inline location inline node inline links
//
// swagger:model fc_interface_inline_location_inline_node_inline__links
type FcInterfaceInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline node inline links
func (m *FcInterfaceInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline node inline links based on the context it is used
func (m *FcInterfaceInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlinePort An FC port is the physical port of an FC adapter on a cluster node that can be connected to an FC network.
//
// swagger:model fc_interface_inline_location_inline_port
type FcInterfaceInlineLocationInlinePort struct {

	// links
	Links *FcInterfaceInlineLocationInlinePortInlineLinks `json:"_links,omitempty"`

	// The name of the FC port.
	//
	// Example: 0a
	Name *string `json:"name,omitempty"`

	// node
	Node *FcInterfaceInlineLocationInlinePortInlineNode `json:"node,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline location inline port
func (m *FcInterfaceInlineLocationInlinePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlinePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocationInlinePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline port based on the context it is used
func (m *FcInterfaceInlineLocationInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlinePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineLocationInlinePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlinePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlinePort) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlinePortInlineLinks fc interface inline location inline port inline links
//
// swagger:model fc_interface_inline_location_inline_port_inline__links
type FcInterfaceInlineLocationInlinePortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline location inline port inline links
func (m *FcInterfaceInlineLocationInlinePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlinePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline location inline port inline links based on the context it is used
func (m *FcInterfaceInlineLocationInlinePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineLocationInlinePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlinePortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlinePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlinePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineLocationInlinePortInlineNode The node on which the FC port is located.
//
// swagger:model fc_interface_inline_location_inline_port_inline_node
type FcInterfaceInlineLocationInlinePortInlineNode struct {

	// The name of the node on which the FC port is located.
	//
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this fc interface inline location inline port inline node
func (m *FcInterfaceInlineLocationInlinePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fc interface inline location inline port inline node based on context it is used
func (m *FcInterfaceInlineLocationInlinePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlinePortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineLocationInlinePortInlineNode) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineLocationInlinePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineMetric Performance numbers, such as IOPS latency and throughput
//
// swagger:model fc_interface_inline_metric
type FcInterfaceInlineMetric struct {

	// links
	Links *FcInterfaceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *FcInterfaceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *FcInterfaceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *FcInterfaceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc interface inline metric
func (m *FcInterfaceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceInlineMetricTypeDurationPropEnum = append(fcInterfaceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT15S captures enum value "PT15S"
	FcInterfaceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT4M captures enum value "PT4M"
	FcInterfaceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT30M captures enum value "PT30M"
	FcInterfaceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT2H captures enum value "PT2H"
	FcInterfaceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationP1D captures enum value "P1D"
	FcInterfaceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// FcInterfaceInlineMetricDurationPT5M captures enum value "PT5M"
	FcInterfaceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *FcInterfaceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcInterfaceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceInlineMetricTypeStatusPropEnum = append(fcInterfaceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusOk captures enum value "ok"
	FcInterfaceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusError captures enum value "error"
	FcInterfaceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	FcInterfaceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	FcInterfaceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	FcInterfaceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	FcInterfaceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusNotFound captures enum value "not_found"
	FcInterfaceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	FcInterfaceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcInterfaceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcInterfaceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_metric
	// FcInterfaceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcInterfaceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcInterfaceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *FcInterfaceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcInterfaceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc interface inline metric based on the context it is used
func (m *FcInterfaceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineMetric) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model fc_interface_inline_metric_inline_iops
type FcInterfaceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline metric inline iops
func (m *FcInterfaceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline metric inline iops based on the context it is used
func (m *FcInterfaceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model fc_interface_inline_metric_inline_latency
type FcInterfaceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline metric inline latency
func (m *FcInterfaceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline metric inline latency based on the context it is used
func (m *FcInterfaceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineMetricInlineLinks fc interface inline metric inline links
//
// swagger:model fc_interface_inline_metric_inline__links
type FcInterfaceInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline metric inline links
func (m *FcInterfaceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline metric inline links based on the context it is used
func (m *FcInterfaceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model fc_interface_inline_metric_inline_throughput
type FcInterfaceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline metric inline throughput
func (m *FcInterfaceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline metric inline throughput based on the context it is used
func (m *FcInterfaceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model fc_interface_inline_statistics
type FcInterfaceInlineStatistics struct {

	// iops raw
	IopsRaw *FcInterfaceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *FcInterfaceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *FcInterfaceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc interface inline statistics
func (m *FcInterfaceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceInlineStatisticsTypeStatusPropEnum = append(fcInterfaceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusOk captures enum value "ok"
	FcInterfaceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusError captures enum value "error"
	FcInterfaceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	FcInterfaceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	FcInterfaceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	FcInterfaceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	FcInterfaceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusNotFound captures enum value "not_found"
	FcInterfaceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	FcInterfaceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcInterfaceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcInterfaceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_interface_inline_statistics
	// FcInterfaceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcInterfaceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcInterfaceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *FcInterfaceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcInterfaceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc interface inline statistics based on the context it is used
func (m *FcInterfaceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model fc_interface_inline_statistics_inline_iops_raw
type FcInterfaceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline statistics inline iops raw
func (m *FcInterfaceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline statistics inline iops raw based on the context it is used
func (m *FcInterfaceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model fc_interface_inline_statistics_inline_latency_raw
type FcInterfaceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline statistics inline latency raw
func (m *FcInterfaceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline statistics inline latency raw based on the context it is used
func (m *FcInterfaceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model fc_interface_inline_statistics_inline_throughput_raw
type FcInterfaceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc interface inline statistics inline throughput raw
func (m *FcInterfaceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc interface inline statistics inline throughput raw based on the context it is used
func (m *FcInterfaceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model fc_interface_inline_svm
type FcInterfaceInlineSvm struct {

	// links
	Links *FcInterfaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface inline svm
func (m *FcInterfaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline svm based on the context it is used
func (m *FcInterfaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceInlineSvmInlineLinks fc interface inline svm inline links
//
// swagger:model fc_interface_inline_svm_inline__links
type FcInterfaceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface inline svm inline links
func (m *FcInterfaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface inline svm inline links based on the context it is used
func (m *FcInterfaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
