// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FcInterfaceSvm fc interface svm
//
// swagger:model fc_interface_svm
type FcInterfaceSvm struct {

	// links
	Links *FcInterfaceSvmInlineLinks `json:"_links,omitempty"`

	// The data protocol for which the Fibre Channel interface is configured.
	// Enum: ["fcp","fc_nvme"]
	DataProtocol *string `json:"data_protocol,omitempty"`

	// location
	Location *FcInterfaceSvmInlineLocation `json:"location,omitempty"`

	// The name of the Fibre Channel interface.
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the Fibre Channel interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc interface svm
func (m *FcInterfaceSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var fcInterfaceSvmTypeDataProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","fc_nvme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcInterfaceSvmTypeDataProtocolPropEnum = append(fcInterfaceSvmTypeDataProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_interface_svm
	// FcInterfaceSvm
	// data_protocol
	// DataProtocol
	// fcp
	// END DEBUGGING
	// FcInterfaceSvmDataProtocolFcp captures enum value "fcp"
	FcInterfaceSvmDataProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// fc_interface_svm
	// FcInterfaceSvm
	// data_protocol
	// DataProtocol
	// fc_nvme
	// END DEBUGGING
	// FcInterfaceSvmDataProtocolFcNvme captures enum value "fc_nvme"
	FcInterfaceSvmDataProtocolFcNvme string = "fc_nvme"
)

// prop value enum
func (m *FcInterfaceSvm) validateDataProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcInterfaceSvmTypeDataProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcInterfaceSvm) validateDataProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.DataProtocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateDataProtocolEnum("data_protocol", "body", *m.DataProtocol); err != nil {
		return err
	}

	return nil
}

func (m *FcInterfaceSvm) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface svm based on the context it is used
func (m *FcInterfaceSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceSvm) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *FcInterfaceSvm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceSvm) UnmarshalBinary(b []byte) error {
	var res FcInterfaceSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceSvmInlineLinks fc interface svm inline links
//
// swagger:model fc_interface_svm_inline__links
type FcInterfaceSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc interface svm inline links
func (m *FcInterfaceSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface svm inline links based on the context it is used
func (m *FcInterfaceSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcInterfaceSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcInterfaceSvmInlineLocation The location of the Fibre Channel interface is defined by the location of its port.
//
// swagger:model fc_interface_svm_inline_location
type FcInterfaceSvmInlineLocation struct {

	// port
	Port *FcPortReference `json:"port,omitempty"`
}

// Validate validates this fc interface svm inline location
func (m *FcInterfaceSvmInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceSvmInlineLocation) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc interface svm inline location based on the context it is used
func (m *FcInterfaceSvmInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcInterfaceSvmInlineLocation) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcInterfaceSvmInlineLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcInterfaceSvmInlineLocation) UnmarshalBinary(b []byte) error {
	var res FcInterfaceSvmInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
