// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FcLogin A Fibre Channel (FC) login represents a connection formed by an FC initiator that has successfully logged in to ONTAP. This represents the FC login on which higher-level protocols such as Fibre Channel Protocol and NVMe over Fibre Channel (NVMe/FC) rely.
//
// swagger:model fc_login
type FcLogin struct {

	// links
	Links *FcLoginInlineLinks `json:"_links,omitempty"`

	// The initiator groups in which the initiator is a member.
	//
	// Read Only: true
	FcLoginInlineIgroups []*FcLoginInlineIgroupsInlineArrayItem `json:"igroups,omitempty"`

	// initiator
	Initiator *FcLoginInlineInitiator `json:"initiator,omitempty"`

	// interface
	Interface *FcLoginInlineInterface `json:"interface,omitempty"`

	// The data protocol used to perform the login.
	//
	// Read Only: true
	// Enum: ["fc_nvme","fcp"]
	Protocol *string `json:"protocol,omitempty"`

	// svm
	Svm *FcLoginInlineSvm `json:"svm,omitempty"`
}

// Validate validates this fc login
func (m *FcLogin) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFcLoginInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitiator(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLogin) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcLogin) validateFcLoginInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.FcLoginInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.FcLoginInlineIgroups); i++ {
		if swag.IsZero(m.FcLoginInlineIgroups[i]) { // not required
			continue
		}

		if m.FcLoginInlineIgroups[i] != nil {
			if err := m.FcLoginInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FcLogin) validateInitiator(formats strfmt.Registry) error {
	if swag.IsZero(m.Initiator) { // not required
		return nil
	}

	if m.Initiator != nil {
		if err := m.Initiator.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("initiator")
			}
			return err
		}
	}

	return nil
}

func (m *FcLogin) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.Interface) { // not required
		return nil
	}

	if m.Interface != nil {
		if err := m.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

var fcLoginTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc_nvme","fcp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcLoginTypeProtocolPropEnum = append(fcLoginTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_login
	// FcLogin
	// protocol
	// Protocol
	// fc_nvme
	// END DEBUGGING
	// FcLoginProtocolFcNvme captures enum value "fc_nvme"
	FcLoginProtocolFcNvme string = "fc_nvme"

	// BEGIN DEBUGGING
	// fc_login
	// FcLogin
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// FcLoginProtocolFcp captures enum value "fcp"
	FcLoginProtocolFcp string = "fcp"
)

// prop value enum
func (m *FcLogin) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcLoginTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcLogin) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *FcLogin) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc login based on the context it is used
func (m *FcLogin) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFcLoginInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInitiator(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLogin) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcLogin) contextValidateFcLoginInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroups", "body", []*FcLoginInlineIgroupsInlineArrayItem(m.FcLoginInlineIgroups)); err != nil {
		return err
	}

	for i := 0; i < len(m.FcLoginInlineIgroups); i++ {

		if m.FcLoginInlineIgroups[i] != nil {
			if err := m.FcLoginInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FcLogin) contextValidateInitiator(ctx context.Context, formats strfmt.Registry) error {

	if m.Initiator != nil {
		if err := m.Initiator.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("initiator")
			}
			return err
		}
	}

	return nil
}

func (m *FcLogin) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.Interface != nil {
		if err := m.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *FcLogin) contextValidateProtocol(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protocol", "body", m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *FcLogin) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLogin) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLogin) UnmarshalBinary(b []byte) error {
	var res FcLogin
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineIgroupsInlineArrayItem fc login inline igroups inline array item
//
// swagger:model fc_login_inline_igroups_inline_array_item
type FcLoginInlineIgroupsInlineArrayItem struct {

	// links
	Links *FcLoginInlineIgroupsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc login inline igroups inline array item
func (m *FcLoginInlineIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineIgroupsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcLoginInlineIgroupsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc login inline igroups inline array item based on the context it is used
func (m *FcLoginInlineIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineIgroupsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineIgroupsInlineArrayItemInlineLinks fc login inline igroups inline array item inline links
//
// swagger:model fc_login_inline_igroups_inline_array_item_inline__links
type FcLoginInlineIgroupsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc login inline igroups inline array item inline links
func (m *FcLoginInlineIgroupsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineIgroupsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc login inline igroups inline array item inline links based on the context it is used
func (m *FcLoginInlineIgroupsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineIgroupsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineIgroupsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineIgroupsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineIgroupsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineInitiator Information about the logged in FC initiator.
//
// swagger:model fc_login_inline_initiator
type FcLoginInlineInitiator struct {

	// The logged in initiator world wide port name (WWPN) aliases.
	//
	// Read Only: true
	Aliases []*string `json:"aliases,omitempty"`

	// A comment available for use by the administrator. This is modifiable from the initiator REST endpoint directly. See [`PATCH /protocols/san/igroups/{igroup.uuid}/initiators/{name}`](#/SAN/igroup_initiator_modify).
	//
	// Example: This is an FC initiator for host 5
	// Read Only: true
	Comment *string `json:"comment,omitempty"`

	// The port address of the initiator's FC port.<br/>
	// Each port in an FC switched fabric has its own unique port address for routing purposes. The port address is assigned by a switch in the fabric when that port logs in to the fabric. This property refers to the address given by a switch to the initiator port.<br/>
	// This is useful for obtaining statistics and diagnostic information from FC switches.<br/>
	// This is a hexadecimal encoded numeric value.
	//
	// Example: 5060A
	// Read Only: true
	PortAddress *string `json:"port_address,omitempty"`

	// The logged in initiator world wide node name (WWNN).
	//
	// Example: 2f:a0:00:a0:98:0b:56:13
	// Read Only: true
	Wwnn *string `json:"wwnn,omitempty"`

	// The logged in initiator WWPN.
	//
	// Example: 2f:a0:00:a0:98:0b:56:13
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this fc login inline initiator
func (m *FcLoginInlineInitiator) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc login inline initiator based on the context it is used
func (m *FcLoginInlineInitiator) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAliases(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateComment(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwnn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineInitiator) contextValidateAliases(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "initiator"+"."+"aliases", "body", []*string(m.Aliases)); err != nil {
		return err
	}

	for i := 0; i < len(m.Aliases); i++ {

		if err := validate.ReadOnly(ctx, "initiator"+"."+"aliases"+"."+strconv.Itoa(i), "body", m.Aliases[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *FcLoginInlineInitiator) contextValidateComment(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "initiator"+"."+"comment", "body", m.Comment); err != nil {
		return err
	}

	return nil
}

func (m *FcLoginInlineInitiator) contextValidatePortAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "initiator"+"."+"port_address", "body", m.PortAddress); err != nil {
		return err
	}

	return nil
}

func (m *FcLoginInlineInitiator) contextValidateWwnn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "initiator"+"."+"wwnn", "body", m.Wwnn); err != nil {
		return err
	}

	return nil
}

func (m *FcLoginInlineInitiator) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "initiator"+"."+"wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineInitiator) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineInitiator) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineInitiator
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineInterface An FC interface.
//
// swagger:model fc_login_inline_interface
type FcLoginInlineInterface struct {

	// links
	Links *FcLoginInlineInterfaceInlineLinks `json:"_links,omitempty"`

	// The name of the FC interface.
	//
	// Example: fc_lif1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the FC interface.
	//
	// Example: 3a09ab42-4da1-32cf-9d35-3385a6101a0b
	UUID *string `json:"uuid,omitempty"`

	// The WWPN of the FC interface.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this fc login inline interface
func (m *FcLoginInlineInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc login inline interface based on the context it is used
func (m *FcLoginInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcLoginInlineInterface) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineInterface) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineInterfaceInlineLinks fc login inline interface inline links
//
// swagger:model fc_login_inline_interface_inline__links
type FcLoginInlineInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc login inline interface inline links
func (m *FcLoginInlineInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc login inline interface inline links based on the context it is used
func (m *FcLoginInlineInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineLinks fc login inline links
//
// swagger:model fc_login_inline__links
type FcLoginInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc login inline links
func (m *FcLoginInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *FcLoginInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc login inline links based on the context it is used
func (m *FcLoginInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *FcLoginInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model fc_login_inline_svm
type FcLoginInlineSvm struct {

	// links
	Links *FcLoginInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc login inline svm
func (m *FcLoginInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc login inline svm based on the context it is used
func (m *FcLoginInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineSvm) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcLoginInlineSvmInlineLinks fc login inline svm inline links
//
// swagger:model fc_login_inline_svm_inline__links
type FcLoginInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc login inline svm inline links
func (m *FcLoginInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc login inline svm inline links based on the context it is used
func (m *FcLoginInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcLoginInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcLoginInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcLoginInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcLoginInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
