// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FcPort A Fibre Channel (FC) port is the physical port of an FC adapter on an ONTAP cluster node that can be connected to an FC network to provide FC network connectivity. An FC port defines the location of an FC interface within the ONTAP cluster.
//
// swagger:model fc_port
type FcPort struct {

	// links
	Links *FcPortInlineLinks `json:"_links,omitempty"`

	// A description of the FC port.
	//
	// Example: Fibre Channel Target Adapter 0a (ACME Fibre Channel Adapter, rev. 1.0.0, 8G)
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The administrative state of the FC port. If this property is set to _false_, all FC connectivity to FC interfaces are blocked. Optional in PATCH.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// fabric
	Fabric *FcPortInlineFabric `json:"fabric,omitempty"`

	// The number of FC interfaces currently provisioned on this port. This property is not supported in an SVM context.
	//
	// Read Only: true
	InterfaceCount *int64 `json:"interface_count,omitempty"`

	// metric
	Metric *FcPortInlineMetric `json:"metric,omitempty"`

	// The FC port name.
	//
	// Example: 0a
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *FcPortInlineNode `json:"node,omitempty"`

	// The physical network protocol of the FC port.
	//
	// Read Only: true
	// Enum: ["fibre_channel","ethernet"]
	PhysicalProtocol *string `json:"physical_protocol,omitempty"`

	// speed
	Speed *FcPortInlineSpeed `json:"speed,omitempty"`

	// The operational state of the FC port.
	// - startup - The port is booting up.
	// - link_not_connected - The port has finished initialization, but a link with the fabric is not established.
	// - online - The port is initialized and a link with the fabric has been established.
	// - link_disconnected - The link was present at one point on this port but is currently not established.
	// - offlined_by_user - The port is administratively disabled.
	// - offlined_by_system - The port is set to offline by the system. This happens when the port encounters too many errors.
	// - node_offline - The state information for the port cannot be retrieved. The node is offline or inaccessible.
	//
	// Example: online
	// Read Only: true
	// Enum: ["startup","link_not_connected","online","link_disconnected","offlined_by_user","offlined_by_system","node_offline","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *FcPortInlineStatistics `json:"statistics,omitempty"`

	// The network protocols supported by the FC port.
	//
	// Read Only: true
	SupportedProtocols []*string `json:"supported_protocols,omitempty"`

	// transceiver
	Transceiver *FcPortInlineTransceiver `json:"transceiver,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// The base world wide node name (WWNN) for the FC port.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwnn *string `json:"wwnn,omitempty"`

	// The base world wide port name (WWPN) for the FC port.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this fc port
func (m *FcPort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFabric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePhysicalProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpeed(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSupportedProtocols(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransceiver(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) validateFabric(formats strfmt.Registry) error {
	if swag.IsZero(m.Fabric) { // not required
		return nil
	}

	if m.Fabric != nil {
		if err := m.Fabric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var fcPortTypePhysicalProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fibre_channel","ethernet"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortTypePhysicalProtocolPropEnum = append(fcPortTypePhysicalProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// physical_protocol
	// PhysicalProtocol
	// fibre_channel
	// END DEBUGGING
	// FcPortPhysicalProtocolFibreChannel captures enum value "fibre_channel"
	FcPortPhysicalProtocolFibreChannel string = "fibre_channel"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// physical_protocol
	// PhysicalProtocol
	// ethernet
	// END DEBUGGING
	// FcPortPhysicalProtocolEthernet captures enum value "ethernet"
	FcPortPhysicalProtocolEthernet string = "ethernet"
)

// prop value enum
func (m *FcPort) validatePhysicalProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortTypePhysicalProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPort) validatePhysicalProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.PhysicalProtocol) { // not required
		return nil
	}

	// value enum
	if err := m.validatePhysicalProtocolEnum("physical_protocol", "body", *m.PhysicalProtocol); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) validateSpeed(formats strfmt.Registry) error {
	if swag.IsZero(m.Speed) { // not required
		return nil
	}

	if m.Speed != nil {
		if err := m.Speed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("speed")
			}
			return err
		}
	}

	return nil
}

var fcPortTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["startup","link_not_connected","online","link_disconnected","offlined_by_user","offlined_by_system","node_offline","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortTypeStatePropEnum = append(fcPortTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// startup
	// END DEBUGGING
	// FcPortStateStartup captures enum value "startup"
	FcPortStateStartup string = "startup"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// link_not_connected
	// END DEBUGGING
	// FcPortStateLinkNotConnected captures enum value "link_not_connected"
	FcPortStateLinkNotConnected string = "link_not_connected"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// online
	// END DEBUGGING
	// FcPortStateOnline captures enum value "online"
	FcPortStateOnline string = "online"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// link_disconnected
	// END DEBUGGING
	// FcPortStateLinkDisconnected captures enum value "link_disconnected"
	FcPortStateLinkDisconnected string = "link_disconnected"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// offlined_by_user
	// END DEBUGGING
	// FcPortStateOfflinedByUser captures enum value "offlined_by_user"
	FcPortStateOfflinedByUser string = "offlined_by_user"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// offlined_by_system
	// END DEBUGGING
	// FcPortStateOfflinedBySystem captures enum value "offlined_by_system"
	FcPortStateOfflinedBySystem string = "offlined_by_system"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// node_offline
	// END DEBUGGING
	// FcPortStateNodeOffline captures enum value "node_offline"
	FcPortStateNodeOffline string = "node_offline"

	// BEGIN DEBUGGING
	// fc_port
	// FcPort
	// state
	// State
	// unknown
	// END DEBUGGING
	// FcPortStateUnknown captures enum value "unknown"
	FcPortStateUnknown string = "unknown"
)

// prop value enum
func (m *FcPort) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPort) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

var fcPortSupportedProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","fc_nvme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortSupportedProtocolsItemsEnum = append(fcPortSupportedProtocolsItemsEnum, v)
	}
}

func (m *FcPort) validateSupportedProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortSupportedProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPort) validateSupportedProtocols(formats strfmt.Registry) error {
	if swag.IsZero(m.SupportedProtocols) { // not required
		return nil
	}

	for i := 0; i < len(m.SupportedProtocols); i++ {
		if swag.IsZero(m.SupportedProtocols[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateSupportedProtocolsItemsEnum("supported_protocols"+"."+strconv.Itoa(i), "body", *m.SupportedProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *FcPort) validateTransceiver(formats strfmt.Registry) error {
	if swag.IsZero(m.Transceiver) { // not required
		return nil
	}

	if m.Transceiver != nil {
		if err := m.Transceiver.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transceiver")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port based on the context it is used
func (m *FcPort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFabric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterfaceCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSupportedProtocols(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransceiver(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwnn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) contextValidateFabric(ctx context.Context, formats strfmt.Registry) error {

	if m.Fabric != nil {
		if err := m.Fabric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) contextValidateInterfaceCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface_count", "body", m.InterfaceCount); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) contextValidatePhysicalProtocol(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "physical_protocol", "body", m.PhysicalProtocol); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) contextValidateSpeed(ctx context.Context, formats strfmt.Registry) error {

	if m.Speed != nil {
		if err := m.Speed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("speed")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) contextValidateSupportedProtocols(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "supported_protocols", "body", []*string(m.SupportedProtocols)); err != nil {
		return err
	}

	for i := 0; i < len(m.SupportedProtocols); i++ {

		if err := validate.ReadOnly(ctx, "supported_protocols"+"."+strconv.Itoa(i), "body", m.SupportedProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *FcPort) contextValidateTransceiver(ctx context.Context, formats strfmt.Registry) error {

	if m.Transceiver != nil {
		if err := m.Transceiver.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transceiver")
			}
			return err
		}
	}

	return nil
}

func (m *FcPort) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) contextValidateWwnn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "wwnn", "body", m.Wwnn); err != nil {
		return err
	}

	return nil
}

func (m *FcPort) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPort) UnmarshalBinary(b []byte) error {
	var res FcPort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineFabric Properties of the fabric to which the FC port is attached.
//
// swagger:model fc_port_inline_fabric
type FcPortInlineFabric struct {

	// Reports if the physical port has established a connection with the FC fabric.
	//
	// Read Only: true
	Connected *bool `json:"connected,omitempty"`

	// The negotiated data rate between the target FC port and the fabric in gigabits per second.
	//
	// Example: 16
	// Read Only: true
	ConnectedSpeed *int64 `json:"connected_speed,omitempty"`

	// The name of the fabric to which the port is connected. This is only available when the FC port is connected to a fabric.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The FC port address of the host bus adapter (HBA) physical port.<br/>
	// Each FC port in an FC switched fabric has its own unique FC port address for routing purposes. The FC port address is assigned by a switch in the fabric when that port logs in to the fabric. This property refers to the FC port address given to the physical host bus adapter (HBA) port when the port performs a fabric login (FLOGI).<br/>
	// This is useful for obtaining statistics and diagnostic information from FC switches.<br/>
	// This is a six-digit hexadecimal encoded numeric value.
	//
	// Example: 52100A
	// Read Only: true
	PortAddress *string `json:"port_address,omitempty"`

	// The switch port to which the FC port is connected.
	//
	// Example: ssan-g620-03:33
	// Read Only: true
	SwitchPort *string `json:"switch_port,omitempty"`
}

// Validate validates this fc port inline fabric
func (m *FcPortInlineFabric) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline fabric based on the context it is used
func (m *FcPortInlineFabric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConnected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectedSpeed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSwitchPort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineFabric) contextValidateConnected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fabric"+"."+"connected", "body", m.Connected); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineFabric) contextValidateConnectedSpeed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fabric"+"."+"connected_speed", "body", m.ConnectedSpeed); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineFabric) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fabric"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineFabric) contextValidatePortAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fabric"+"."+"port_address", "body", m.PortAddress); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineFabric) contextValidateSwitchPort(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fabric"+"."+"switch_port", "body", m.SwitchPort); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineFabric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineFabric) UnmarshalBinary(b []byte) error {
	var res FcPortInlineFabric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineLinks fc port inline links
//
// swagger:model fc_port_inline__links
type FcPortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc port inline links
func (m *FcPortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline links based on the context it is used
func (m *FcPortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcPortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineMetric Performance numbers, such as IOPS latency and throughput
//
// swagger:model fc_port_inline_metric
type FcPortInlineMetric struct {

	// links
	Links *FcPortInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *FcPortInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *FcPortInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *FcPortInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc port inline metric
func (m *FcPortInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var fcPortInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineMetricTypeDurationPropEnum = append(fcPortInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// FcPortInlineMetricDurationPT15S captures enum value "PT15S"
	FcPortInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// FcPortInlineMetricDurationPT4M captures enum value "PT4M"
	FcPortInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// FcPortInlineMetricDurationPT30M captures enum value "PT30M"
	FcPortInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// FcPortInlineMetricDurationPT2H captures enum value "PT2H"
	FcPortInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// FcPortInlineMetricDurationP1D captures enum value "P1D"
	FcPortInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// FcPortInlineMetricDurationPT5M captures enum value "PT5M"
	FcPortInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *FcPortInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPortInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var fcPortInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineMetricTypeStatusPropEnum = append(fcPortInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcPortInlineMetricStatusOk captures enum value "ok"
	FcPortInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// FcPortInlineMetricStatusError captures enum value "error"
	FcPortInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	FcPortInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	FcPortInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	FcPortInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcPortInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	FcPortInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcPortInlineMetricStatusNotFound captures enum value "not_found"
	FcPortInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcPortInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	FcPortInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcPortInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcPortInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcPortInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcPortInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_port_inline_metric
	// FcPortInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcPortInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcPortInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *FcPortInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPortInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline metric based on the context it is used
func (m *FcPortInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineMetric) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model fc_port_inline_metric_inline_iops
type FcPortInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline metric inline iops
func (m *FcPortInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline metric inline iops based on the context it is used
func (m *FcPortInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model fc_port_inline_metric_inline_latency
type FcPortInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline metric inline latency
func (m *FcPortInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline metric inline latency based on the context it is used
func (m *FcPortInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineMetricInlineLinks fc port inline metric inline links
//
// swagger:model fc_port_inline_metric_inline__links
type FcPortInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc port inline metric inline links
func (m *FcPortInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline metric inline links based on the context it is used
func (m *FcPortInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model fc_port_inline_metric_inline_throughput
type FcPortInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline metric inline throughput
func (m *FcPortInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline metric inline throughput based on the context it is used
func (m *FcPortInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res FcPortInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineNode fc port inline node
//
// swagger:model fc_port_inline_node
type FcPortInlineNode struct {

	// links
	Links *FcPortInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fc port inline node
func (m *FcPortInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline node based on the context it is used
func (m *FcPortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineNode) UnmarshalBinary(b []byte) error {
	var res FcPortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineNodeInlineLinks fc port inline node inline links
//
// swagger:model fc_port_inline_node_inline__links
type FcPortInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc port inline node inline links
func (m *FcPortInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc port inline node inline links based on the context it is used
func (m *FcPortInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcPortInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineSpeed The physical device speed related properties of the FC port.
//
// swagger:model fc_port_inline_speed
type FcPortInlineSpeed struct {

	// The configured speed of the FC port in gigabits per second.
	//
	// Example: auto
	// Read Only: true
	// Enum: ["1","2","4","8","10","16","32","64","auto"]
	Configured *string `json:"configured,omitempty"`

	// The maximum speed supported by the FC port in gigabits per second.
	//
	// Example: 32
	// Read Only: true
	// Enum: ["1","2","4","8","10","16","32","64","auto"]
	Maximum *string `json:"maximum,omitempty"`
}

// Validate validates this fc port inline speed
func (m *FcPortInlineSpeed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfigured(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaximum(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fcPortInlineSpeedTypeConfiguredPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["1","2","4","8","10","16","32","64","auto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineSpeedTypeConfiguredPropEnum = append(fcPortInlineSpeedTypeConfiguredPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 1
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr1 captures enum value "1"
	FcPortInlineSpeedConfiguredNr1 string = "1"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 2
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr2 captures enum value "2"
	FcPortInlineSpeedConfiguredNr2 string = "2"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 4
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr4 captures enum value "4"
	FcPortInlineSpeedConfiguredNr4 string = "4"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 8
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr8 captures enum value "8"
	FcPortInlineSpeedConfiguredNr8 string = "8"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 10
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr10 captures enum value "10"
	FcPortInlineSpeedConfiguredNr10 string = "10"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 16
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr16 captures enum value "16"
	FcPortInlineSpeedConfiguredNr16 string = "16"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 32
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr32 captures enum value "32"
	FcPortInlineSpeedConfiguredNr32 string = "32"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// 64
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredNr64 captures enum value "64"
	FcPortInlineSpeedConfiguredNr64 string = "64"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// configured
	// Configured
	// auto
	// END DEBUGGING
	// FcPortInlineSpeedConfiguredAuto captures enum value "auto"
	FcPortInlineSpeedConfiguredAuto string = "auto"
)

// prop value enum
func (m *FcPortInlineSpeed) validateConfiguredEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineSpeedTypeConfiguredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPortInlineSpeed) validateConfigured(formats strfmt.Registry) error {
	if swag.IsZero(m.Configured) { // not required
		return nil
	}

	// value enum
	if err := m.validateConfiguredEnum("speed"+"."+"configured", "body", *m.Configured); err != nil {
		return err
	}

	return nil
}

var fcPortInlineSpeedTypeMaximumPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["1","2","4","8","10","16","32","64","auto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineSpeedTypeMaximumPropEnum = append(fcPortInlineSpeedTypeMaximumPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 1
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr1 captures enum value "1"
	FcPortInlineSpeedMaximumNr1 string = "1"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 2
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr2 captures enum value "2"
	FcPortInlineSpeedMaximumNr2 string = "2"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 4
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr4 captures enum value "4"
	FcPortInlineSpeedMaximumNr4 string = "4"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 8
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr8 captures enum value "8"
	FcPortInlineSpeedMaximumNr8 string = "8"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 10
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr10 captures enum value "10"
	FcPortInlineSpeedMaximumNr10 string = "10"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 16
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr16 captures enum value "16"
	FcPortInlineSpeedMaximumNr16 string = "16"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 32
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr32 captures enum value "32"
	FcPortInlineSpeedMaximumNr32 string = "32"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// 64
	// END DEBUGGING
	// FcPortInlineSpeedMaximumNr64 captures enum value "64"
	FcPortInlineSpeedMaximumNr64 string = "64"

	// BEGIN DEBUGGING
	// fc_port_inline_speed
	// FcPortInlineSpeed
	// maximum
	// Maximum
	// auto
	// END DEBUGGING
	// FcPortInlineSpeedMaximumAuto captures enum value "auto"
	FcPortInlineSpeedMaximumAuto string = "auto"
)

// prop value enum
func (m *FcPortInlineSpeed) validateMaximumEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineSpeedTypeMaximumPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPortInlineSpeed) validateMaximum(formats strfmt.Registry) error {
	if swag.IsZero(m.Maximum) { // not required
		return nil
	}

	// value enum
	if err := m.validateMaximumEnum("speed"+"."+"maximum", "body", *m.Maximum); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline speed based on the context it is used
func (m *FcPortInlineSpeed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaximum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineSpeed) contextValidateConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "speed"+"."+"configured", "body", m.Configured); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineSpeed) contextValidateMaximum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "speed"+"."+"maximum", "body", m.Maximum); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineSpeed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineSpeed) UnmarshalBinary(b []byte) error {
	var res FcPortInlineSpeed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model fc_port_inline_statistics
type FcPortInlineStatistics struct {

	// iops raw
	IopsRaw *FcPortInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *FcPortInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *FcPortInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fc port inline statistics
func (m *FcPortInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var fcPortInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineStatisticsTypeStatusPropEnum = append(fcPortInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcPortInlineStatisticsStatusOk captures enum value "ok"
	FcPortInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// FcPortInlineStatisticsStatusError captures enum value "error"
	FcPortInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	FcPortInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	FcPortInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	FcPortInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcPortInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	FcPortInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcPortInlineStatisticsStatusNotFound captures enum value "not_found"
	FcPortInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcPortInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	FcPortInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcPortInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcPortInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcPortInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcPortInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fc_port_inline_statistics
	// FcPortInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcPortInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcPortInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *FcPortInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPortInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline statistics based on the context it is used
func (m *FcPortInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcPortInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineStatistics) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model fc_port_inline_statistics_inline_iops_raw
type FcPortInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline statistics inline iops raw
func (m *FcPortInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline statistics inline iops raw based on the context it is used
func (m *FcPortInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model fc_port_inline_statistics_inline_latency_raw
type FcPortInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline statistics inline latency raw
func (m *FcPortInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline statistics inline latency raw based on the context it is used
func (m *FcPortInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model fc_port_inline_statistics_inline_throughput_raw
type FcPortInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fc port inline statistics inline throughput raw
func (m *FcPortInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fc port inline statistics inline throughput raw based on the context it is used
func (m *FcPortInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res FcPortInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcPortInlineTransceiver Properties of the transceiver connected to the FC port.
//
// swagger:model fc_port_inline_transceiver
type FcPortInlineTransceiver struct {

	// The speeds of which the transceiver is capable in gigabits per second.
	//
	// Read Only: true
	Capabilities []*int64 `json:"capabilities,omitempty"`

	// The form factor of the transceiver. Possible values are:
	// - _sfp_ - Small Form Factor - Pluggable
	// - _sff_ - Small Form Factor
	// - _unknown_ - Unknown
	//
	// Read Only: true
	// Enum: ["sfp","sff","unknown"]
	FormFactor *string `json:"form_factor,omitempty"`

	// The manufacturer of the transceiver.
	//
	// Example: Acme, Inc.
	// Read Only: true
	Manufacturer *string `json:"manufacturer,omitempty"`

	// The part number of the transceiver.
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`
}

// Validate validates this fc port inline transceiver
func (m *FcPortInlineTransceiver) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapabilities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFormFactor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fcPortInlineTransceiverCapabilitiesItemsEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1,2,4,8,10,16,32,64]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineTransceiverCapabilitiesItemsEnum = append(fcPortInlineTransceiverCapabilitiesItemsEnum, v)
	}
}

func (m *FcPortInlineTransceiver) validateCapabilitiesItemsEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineTransceiverCapabilitiesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPortInlineTransceiver) validateCapabilities(formats strfmt.Registry) error {
	if swag.IsZero(m.Capabilities) { // not required
		return nil
	}

	for i := 0; i < len(m.Capabilities); i++ {
		if swag.IsZero(m.Capabilities[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateCapabilitiesItemsEnum("transceiver"+"."+"capabilities"+"."+strconv.Itoa(i), "body", *m.Capabilities[i]); err != nil {
			return err
		}

	}

	return nil
}

var fcPortInlineTransceiverTypeFormFactorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sfp","sff","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcPortInlineTransceiverTypeFormFactorPropEnum = append(fcPortInlineTransceiverTypeFormFactorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_port_inline_transceiver
	// FcPortInlineTransceiver
	// form_factor
	// FormFactor
	// sfp
	// END DEBUGGING
	// FcPortInlineTransceiverFormFactorSfp captures enum value "sfp"
	FcPortInlineTransceiverFormFactorSfp string = "sfp"

	// BEGIN DEBUGGING
	// fc_port_inline_transceiver
	// FcPortInlineTransceiver
	// form_factor
	// FormFactor
	// sff
	// END DEBUGGING
	// FcPortInlineTransceiverFormFactorSff captures enum value "sff"
	FcPortInlineTransceiverFormFactorSff string = "sff"

	// BEGIN DEBUGGING
	// fc_port_inline_transceiver
	// FcPortInlineTransceiver
	// form_factor
	// FormFactor
	// unknown
	// END DEBUGGING
	// FcPortInlineTransceiverFormFactorUnknown captures enum value "unknown"
	FcPortInlineTransceiverFormFactorUnknown string = "unknown"
)

// prop value enum
func (m *FcPortInlineTransceiver) validateFormFactorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcPortInlineTransceiverTypeFormFactorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcPortInlineTransceiver) validateFormFactor(formats strfmt.Registry) error {
	if swag.IsZero(m.FormFactor) { // not required
		return nil
	}

	// value enum
	if err := m.validateFormFactorEnum("transceiver"+"."+"form_factor", "body", *m.FormFactor); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc port inline transceiver based on the context it is used
func (m *FcPortInlineTransceiver) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCapabilities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFormFactor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManufacturer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcPortInlineTransceiver) contextValidateCapabilities(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "transceiver"+"."+"capabilities", "body", []*int64(m.Capabilities)); err != nil {
		return err
	}

	for i := 0; i < len(m.Capabilities); i++ {

		if err := validate.ReadOnly(ctx, "transceiver"+"."+"capabilities"+"."+strconv.Itoa(i), "body", m.Capabilities[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *FcPortInlineTransceiver) contextValidateFormFactor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "transceiver"+"."+"form_factor", "body", m.FormFactor); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineTransceiver) contextValidateManufacturer(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "transceiver"+"."+"manufacturer", "body", m.Manufacturer); err != nil {
		return err
	}

	return nil
}

func (m *FcPortInlineTransceiver) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "transceiver"+"."+"part_number", "body", m.PartNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcPortInlineTransceiver) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcPortInlineTransceiver) UnmarshalBinary(b []byte) error {
	var res FcPortInlineTransceiver
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
