// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FcZone A Fibre Channel zone.
//
// swagger:model fc_zone
type FcZone struct {

	// links
	Links *FcZoneInlineLinks `json:"_links,omitempty"`

	// cache
	Cache *FcZoneInlineCache `json:"cache,omitempty"`

	// fabric
	Fabric *FcZoneInlineFabric `json:"fabric,omitempty"`

	// An array of Fibre Channel zone members.
	//
	// Read Only: true
	FcZoneInlineMembers []*FcZoneInlineMembersInlineArrayItem `json:"members,omitempty"`

	// The name of the Fibre Channel zone.
	//
	// Example: zone1
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this fc zone
func (m *FcZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFabric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFcZoneInlineMembers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcZone) validateCache(formats strfmt.Registry) error {
	if swag.IsZero(m.Cache) { // not required
		return nil
	}

	if m.Cache != nil {
		if err := m.Cache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cache")
			}
			return err
		}
	}

	return nil
}

func (m *FcZone) validateFabric(formats strfmt.Registry) error {
	if swag.IsZero(m.Fabric) { // not required
		return nil
	}

	if m.Fabric != nil {
		if err := m.Fabric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric")
			}
			return err
		}
	}

	return nil
}

func (m *FcZone) validateFcZoneInlineMembers(formats strfmt.Registry) error {
	if swag.IsZero(m.FcZoneInlineMembers) { // not required
		return nil
	}

	for i := 0; i < len(m.FcZoneInlineMembers); i++ {
		if swag.IsZero(m.FcZoneInlineMembers[i]) { // not required
			continue
		}

		if m.FcZoneInlineMembers[i] != nil {
			if err := m.FcZoneInlineMembers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("members" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this fc zone based on the context it is used
func (m *FcZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFabric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFcZoneInlineMembers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcZone) contextValidateCache(ctx context.Context, formats strfmt.Registry) error {

	if m.Cache != nil {
		if err := m.Cache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cache")
			}
			return err
		}
	}

	return nil
}

func (m *FcZone) contextValidateFabric(ctx context.Context, formats strfmt.Registry) error {

	if m.Fabric != nil {
		if err := m.Fabric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric")
			}
			return err
		}
	}

	return nil
}

func (m *FcZone) contextValidateFcZoneInlineMembers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "members", "body", []*FcZoneInlineMembersInlineArrayItem(m.FcZoneInlineMembers)); err != nil {
		return err
	}

	for i := 0; i < len(m.FcZoneInlineMembers); i++ {

		if m.FcZoneInlineMembers[i] != nil {
			if err := m.FcZoneInlineMembers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("members" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FcZone) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcZone) UnmarshalBinary(b []byte) error {
	var res FcZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcZoneInlineCache Properties of Fibre Chanel fabric cache.
//
// swagger:model fc_zone_inline_cache
type FcZoneInlineCache struct {

	// The age of the Fibre Channel fabric data cache retrieved. If the FC fabric data cache has not been fully updated for a newly discovered fabric, or a fabric that has been re-discovered after being purged, a value for this property will not be retrieved. The value is in ISO 8601 duration format.
	//
	// Example: PT3M30S
	// Read Only: true
	Age *string `json:"age,omitempty"`

	// A boolean that indicates if the retrieved data is current relative to the `cache.maximum_age` value of the request. A value of `true` indicates that the data is no older than the requested maximum age. A value of `false` indicates that the data is older than the requested maximum age; if more current data is required, the caller should wait for some time for the cache update to complete and query the data again.
	//
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// The date and time at which the Fibre Channel fabric data cache retrieved was last updated. If the FC fabric data cache has not been fully updated for a newly discovered fabric, or a fabric that has been re-discovered after being purged, a value for this property will not be retrieved.
	//
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`
}

// Validate validates this fc zone inline cache
func (m *FcZoneInlineCache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineCache) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("cache"+"."+"update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc zone inline cache based on the context it is used
func (m *FcZoneInlineCache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAge(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineCache) contextValidateAge(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cache"+"."+"age", "body", m.Age); err != nil {
		return err
	}

	return nil
}

func (m *FcZoneInlineCache) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cache"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *FcZoneInlineCache) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cache"+"."+"update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcZoneInlineCache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcZoneInlineCache) UnmarshalBinary(b []byte) error {
	var res FcZoneInlineCache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcZoneInlineFabric A reference to a Fibre Channel fabric.
//
// swagger:model fc_zone_inline_fabric
type FcZoneInlineFabric struct {

	// links
	Links *FcZoneInlineFabricInlineLinks `json:"_links,omitempty"`

	// The world wide name (WWN) of the primary switch of the Fibre Channel (FC) fabric. This is used as a unique identifier for the FC fabric.
	//
	// Example: 10:00:d1:d2:d3:d4:d5:d6
	Name *string `json:"name,omitempty"`
}

// Validate validates this fc zone inline fabric
func (m *FcZoneInlineFabric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineFabric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc zone inline fabric based on the context it is used
func (m *FcZoneInlineFabric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineFabric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcZoneInlineFabric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcZoneInlineFabric) UnmarshalBinary(b []byte) error {
	var res FcZoneInlineFabric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcZoneInlineFabricInlineLinks fc zone inline fabric inline links
//
// swagger:model fc_zone_inline_fabric_inline__links
type FcZoneInlineFabricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc zone inline fabric inline links
func (m *FcZoneInlineFabricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineFabricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc zone inline fabric inline links based on the context it is used
func (m *FcZoneInlineFabricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineFabricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fabric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcZoneInlineFabricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcZoneInlineFabricInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcZoneInlineFabricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcZoneInlineLinks fc zone inline links
//
// swagger:model fc_zone_inline__links
type FcZoneInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fc zone inline links
func (m *FcZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fc zone inline links based on the context it is used
func (m *FcZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcZoneInlineMembersInlineArrayItem A Fibre Channel zone member.
//
// swagger:model fc_zone_inline_members_inline_array_item
type FcZoneInlineMembersInlineArrayItem struct {

	// The identifying property value of the zone member. The format of this value depends on the member type:
	//   * `port_id`: A zero-filled 6-digit hexadecimal value with a 0x prefer. Example: 0x0000A0.
	//   * `port_name`: A world-wide name. Example: 10:00:12:34:56:78:9a:bc.
	//   * `domain_id_port`: A domain ID and a port ID as decimal integers separated by a slash. Example: 1/2.
	//   * `node_name`: A world-wide name. Example: 10:00:11:22:33:44:55:66.
	//   * `fabric_port_name`: A world-wide name. Example: 10:00:ab:cd:ef:12:34:56.
	// #####
	// The following types might not report a name:
	//   * `interface`
	//   * `domain_interface`
	//   * `ip_address`
	//   * `symbolic_node_name`
	//   * `device_alias`
	//
	// Example: 10:00:12:34:56:78:9a:bc
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The type of Fibre Channel zone member. This value should be used to interpret the contents of the `name` property.
	//
	// Example: port_name
	// Read Only: true
	// Enum: ["port_id","port_name","domain_id_port","node_name","fabric_port_name","interface","domain_interface","ip_address","symbolic_node_name","device_alias"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this fc zone inline members inline array item
func (m *FcZoneInlineMembersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fcZoneInlineMembersInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["port_id","port_name","domain_id_port","node_name","fabric_port_name","interface","domain_interface","ip_address","symbolic_node_name","device_alias"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcZoneInlineMembersInlineArrayItemTypeTypePropEnum = append(fcZoneInlineMembersInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// port_id
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypePortID captures enum value "port_id"
	FcZoneInlineMembersInlineArrayItemTypePortID string = "port_id"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// port_name
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypePortName captures enum value "port_name"
	FcZoneInlineMembersInlineArrayItemTypePortName string = "port_name"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// domain_id_port
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeDomainIDPort captures enum value "domain_id_port"
	FcZoneInlineMembersInlineArrayItemTypeDomainIDPort string = "domain_id_port"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// node_name
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeNodeName captures enum value "node_name"
	FcZoneInlineMembersInlineArrayItemTypeNodeName string = "node_name"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// fabric_port_name
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeFabricPortName captures enum value "fabric_port_name"
	FcZoneInlineMembersInlineArrayItemTypeFabricPortName string = "fabric_port_name"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// interface
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeInterface captures enum value "interface"
	FcZoneInlineMembersInlineArrayItemTypeInterface string = "interface"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// domain_interface
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeDomainInterface captures enum value "domain_interface"
	FcZoneInlineMembersInlineArrayItemTypeDomainInterface string = "domain_interface"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// ip_address
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeIPAddress captures enum value "ip_address"
	FcZoneInlineMembersInlineArrayItemTypeIPAddress string = "ip_address"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// symbolic_node_name
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeSymbolicNodeName captures enum value "symbolic_node_name"
	FcZoneInlineMembersInlineArrayItemTypeSymbolicNodeName string = "symbolic_node_name"

	// BEGIN DEBUGGING
	// fc_zone_inline_members_inline_array_item
	// FcZoneInlineMembersInlineArrayItem
	// type
	// Type
	// device_alias
	// END DEBUGGING
	// FcZoneInlineMembersInlineArrayItemTypeDeviceAlias captures enum value "device_alias"
	FcZoneInlineMembersInlineArrayItemTypeDeviceAlias string = "device_alias"
)

// prop value enum
func (m *FcZoneInlineMembersInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcZoneInlineMembersInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcZoneInlineMembersInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc zone inline members inline array item based on the context it is used
func (m *FcZoneInlineMembersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneInlineMembersInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *FcZoneInlineMembersInlineArrayItem) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcZoneInlineMembersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcZoneInlineMembersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res FcZoneInlineMembersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
