// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FcZoneMember A Fibre Channel zone member.
//
// swagger:model fc_zone_member
type FcZoneMember struct {

	// The identifying property value of the zone member. The format of this value depends on the member type:
	//   * `port_id`: A zero-filled 6-digit hexadecimal value with a 0x prefer. Example: 0x0000A0.
	//   * `port_name`: A world-wide name. Example: 10:00:12:34:56:78:9a:bc.
	//   * `domain_id_port`: A domain ID and a port ID as decimal integers separated by a slash. Example: 1/2.
	//   * `node_name`: A world-wide name. Example: 10:00:11:22:33:44:55:66.
	//   * `fabric_port_name`: A world-wide name. Example: 10:00:ab:cd:ef:12:34:56.
	// #####
	// The following types might not report a name:
	//   * `interface`
	//   * `domain_interface`
	//   * `ip_address`
	//   * `symbolic_node_name`
	//   * `device_alias`
	//
	// Example: 10:00:12:34:56:78:9a:bc
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The type of Fibre Channel zone member. This value should be used to interpret the contents of the `name` property.
	//
	// Example: port_name
	// Read Only: true
	// Enum: ["port_id","port_name","domain_id_port","node_name","fabric_port_name","interface","domain_interface","ip_address","symbolic_node_name","device_alias"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this fc zone member
func (m *FcZoneMember) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fcZoneMemberTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["port_id","port_name","domain_id_port","node_name","fabric_port_name","interface","domain_interface","ip_address","symbolic_node_name","device_alias"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcZoneMemberTypeTypePropEnum = append(fcZoneMemberTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// port_id
	// END DEBUGGING
	// FcZoneMemberTypePortID captures enum value "port_id"
	FcZoneMemberTypePortID string = "port_id"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// port_name
	// END DEBUGGING
	// FcZoneMemberTypePortName captures enum value "port_name"
	FcZoneMemberTypePortName string = "port_name"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// domain_id_port
	// END DEBUGGING
	// FcZoneMemberTypeDomainIDPort captures enum value "domain_id_port"
	FcZoneMemberTypeDomainIDPort string = "domain_id_port"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// node_name
	// END DEBUGGING
	// FcZoneMemberTypeNodeName captures enum value "node_name"
	FcZoneMemberTypeNodeName string = "node_name"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// fabric_port_name
	// END DEBUGGING
	// FcZoneMemberTypeFabricPortName captures enum value "fabric_port_name"
	FcZoneMemberTypeFabricPortName string = "fabric_port_name"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// interface
	// END DEBUGGING
	// FcZoneMemberTypeInterface captures enum value "interface"
	FcZoneMemberTypeInterface string = "interface"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// domain_interface
	// END DEBUGGING
	// FcZoneMemberTypeDomainInterface captures enum value "domain_interface"
	FcZoneMemberTypeDomainInterface string = "domain_interface"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// ip_address
	// END DEBUGGING
	// FcZoneMemberTypeIPAddress captures enum value "ip_address"
	FcZoneMemberTypeIPAddress string = "ip_address"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// symbolic_node_name
	// END DEBUGGING
	// FcZoneMemberTypeSymbolicNodeName captures enum value "symbolic_node_name"
	FcZoneMemberTypeSymbolicNodeName string = "symbolic_node_name"

	// BEGIN DEBUGGING
	// fc_zone_member
	// FcZoneMember
	// type
	// Type
	// device_alias
	// END DEBUGGING
	// FcZoneMemberTypeDeviceAlias captures enum value "device_alias"
	FcZoneMemberTypeDeviceAlias string = "device_alias"
)

// prop value enum
func (m *FcZoneMember) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcZoneMemberTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcZoneMember) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fc zone member based on the context it is used
func (m *FcZoneMember) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcZoneMember) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *FcZoneMember) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcZoneMember) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcZoneMember) UnmarshalBinary(b []byte) error {
	var res FcZoneMember
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
