// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FcpService A Fibre Channel (FC) Protocol service defines the properties of the FC Protocol target for an SVM. There can be at most one FC Protocol service for an SVM. An SVM's FC Protocol service must be created before FC Protocol initiators can login to the SVM.<br/>
// A FC Protocol service is identified by the UUID of its SVM.
//
// swagger:model fcp_service
type FcpService struct {

	// links
	Links *FcpServiceInlineLinks `json:"_links,omitempty"`

	// The administrative state of the FC Protocol service. The FC Protocol service can be disabled to block all FC Protocol connectivity to the SVM.<br/>
	// This is optional in POST and PATCH. The default setting is _true_ (enabled) in POST.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// metric
	Metric *FcpServiceInlineMetric `json:"metric,omitempty"`

	// statistics
	Statistics *FcpServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *FcpServiceInlineSvm `json:"svm,omitempty"`

	// target
	Target *FcpServiceInlineTarget `json:"target,omitempty"`
}

// Validate validates this fcp service
func (m *FcpService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpService) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(m.Target) { // not required
		return nil
	}

	if m.Target != nil {
		if err := m.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service based on the context it is used
func (m *FcpService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpService) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FcpService) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if m.Target != nil {
		if err := m.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpService) UnmarshalBinary(b []byte) error {
	var res FcpService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineLinks fcp service inline links
//
// swagger:model fcp_service_inline__links
type FcpServiceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fcp service inline links
func (m *FcpServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline links based on the context it is used
func (m *FcpServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model fcp_service_inline_metric
type FcpServiceInlineMetric struct {

	// links
	Links *FcpServiceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *FcpServiceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *FcpServiceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *FcpServiceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fcp service inline metric
func (m *FcpServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var fcpServiceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcpServiceInlineMetricTypeDurationPropEnum = append(fcpServiceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT15S captures enum value "PT15S"
	FcpServiceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT4M captures enum value "PT4M"
	FcpServiceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT30M captures enum value "PT30M"
	FcpServiceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT2H captures enum value "PT2H"
	FcpServiceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// FcpServiceInlineMetricDurationP1D captures enum value "P1D"
	FcpServiceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT5M captures enum value "PT5M"
	FcpServiceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *FcpServiceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcpServiceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcpServiceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *FcpServiceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var fcpServiceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcpServiceInlineMetricTypeStatusPropEnum = append(fcpServiceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcpServiceInlineMetricStatusOk captures enum value "ok"
	FcpServiceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// FcpServiceInlineMetricStatusError captures enum value "error"
	FcpServiceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	FcpServiceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	FcpServiceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	FcpServiceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcpServiceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	FcpServiceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcpServiceInlineMetricStatusNotFound captures enum value "not_found"
	FcpServiceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcpServiceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	FcpServiceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcpServiceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcpServiceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcpServiceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcpServiceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcpServiceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *FcpServiceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcpServiceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcpServiceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcpServiceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fcp service inline metric based on the context it is used
func (m *FcpServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *FcpServiceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcpServiceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model fcp_service_inline_metric_inline_iops
type FcpServiceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline metric inline iops
func (m *FcpServiceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline metric inline iops based on the context it is used
func (m *FcpServiceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model fcp_service_inline_metric_inline_latency
type FcpServiceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline metric inline latency
func (m *FcpServiceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline metric inline latency based on the context it is used
func (m *FcpServiceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineMetricInlineLinks fcp service inline metric inline links
//
// swagger:model fcp_service_inline_metric_inline__links
type FcpServiceInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fcp service inline metric inline links
func (m *FcpServiceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline metric inline links based on the context it is used
func (m *FcpServiceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model fcp_service_inline_metric_inline_throughput
type FcpServiceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline metric inline throughput
func (m *FcpServiceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline metric inline throughput based on the context it is used
func (m *FcpServiceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model fcp_service_inline_statistics
type FcpServiceInlineStatistics struct {

	// iops raw
	IopsRaw *FcpServiceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *FcpServiceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *FcpServiceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fcp service inline statistics
func (m *FcpServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var fcpServiceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcpServiceInlineStatisticsTypeStatusPropEnum = append(fcpServiceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusOk captures enum value "ok"
	FcpServiceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusError captures enum value "error"
	FcpServiceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	FcpServiceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	FcpServiceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	FcpServiceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	FcpServiceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusNotFound captures enum value "not_found"
	FcpServiceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	FcpServiceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcpServiceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcpServiceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcpServiceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *FcpServiceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcpServiceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FcpServiceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcpServiceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fcp service inline statistics based on the context it is used
func (m *FcpServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FcpServiceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *FcpServiceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model fcp_service_inline_statistics_inline_iops_raw
type FcpServiceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline statistics inline iops raw
func (m *FcpServiceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline statistics inline iops raw based on the context it is used
func (m *FcpServiceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model fcp_service_inline_statistics_inline_latency_raw
type FcpServiceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline statistics inline latency raw
func (m *FcpServiceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline statistics inline latency raw based on the context it is used
func (m *FcpServiceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model fcp_service_inline_statistics_inline_throughput_raw
type FcpServiceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline statistics inline throughput raw
func (m *FcpServiceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline statistics inline throughput raw based on the context it is used
func (m *FcpServiceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model fcp_service_inline_svm
type FcpServiceInlineSvm struct {

	// links
	Links *FcpServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fcp service inline svm
func (m *FcpServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline svm based on the context it is used
func (m *FcpServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineSvmInlineLinks fcp service inline svm inline links
//
// swagger:model fcp_service_inline_svm_inline__links
type FcpServiceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fcp service inline svm inline links
func (m *FcpServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline svm inline links based on the context it is used
func (m *FcpServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FcpServiceInlineTarget fcp service inline target
//
// swagger:model fcp_service_inline_target
type FcpServiceInlineTarget struct {

	// The target name of the FC Protocol service. This is generated for the SVM during POST.<br/>
	// The FC Protocol target name is a world wide node name (WWNN).<br/>
	// If required, the target name can be modified using the ONTAP command line.
	//
	// Example: 20:00:00:50:56:bb:b2:4b
	// Read Only: true
	// Max Length: 128
	// Min Length: 1
	Name *string `json:"name,omitempty"`
}

// Validate validates this fcp service inline target
func (m *FcpServiceInlineTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineTarget) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("target"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("target"+"."+"name", "body", *m.Name, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fcp service inline target based on the context it is used
func (m *FcpServiceInlineTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FcpServiceInlineTarget) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "target"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FcpServiceInlineTarget) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FcpServiceInlineTarget) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
