// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FileInfo Information about a single file.
//
// swagger:model file_info
type FileInfo struct {

	// links
	Links *FileInfoInlineLinks `json:"_links,omitempty"`

	// Last access time of the file in date-time format.
	// Example: 2019-06-12 11:00:16-04:00
	// Read Only: true
	// Format: date-time
	AccessedTime *strfmt.DateTime `json:"accessed_time,omitempty"`

	// analytics
	Analytics *FileInfoInlineAnalytics `json:"analytics,omitempty"`

	// The actual number of bytes used on disk by this file. If byte_offset and length parameters are specified, this will return the bytes used by the file within the given range.
	// Example: 4096
	// Read Only: true
	BytesUsed *int64 `json:"bytes_used,omitempty"`

	// Last time data or attributes changed on the file in date-time format.
	// Example: 2019-06-12 11:00:16-04:00
	// Read Only: true
	// Format: date-time
	ChangedTime *strfmt.DateTime `json:"changed_time,omitempty"`

	// constituent
	Constituent *FileInfoInlineConstituent `json:"constituent,omitempty"`

	// Creation time of the file in date-time format.
	// Example: 2019-06-12 11:00:16-04:00
	// Read Only: true
	// Format: date-time
	CreationTime *strfmt.DateTime `json:"creation_time,omitempty"`

	// Returns "true" if the space reservation is enabled. The field overwrite_enabled must also be set to the same value as this field.
	FillEnabled *bool `json:"fill_enabled,omitempty"`

	// The integer ID of the group of the file owner.
	// Example: 30
	// Read Only: true
	GroupID *int64 `json:"group_id,omitempty"`

	// The number of hard links to the file.
	// Example: 1
	// Read Only: true
	HardLinksCount *int64 `json:"hard_links_count,omitempty"`

	// Inode generation number.
	// Example: 214753547
	// Read Only: true
	InodeGeneration *int64 `json:"inode_generation,omitempty"`

	// The file inode number.
	// Example: 1695
	// Read Only: true
	InodeNumber *int64 `json:"inode_number,omitempty"`

	// Specifies whether or not a directory is empty. A directory is considered empty if it only contains entries for "." and "..". This element is present if the file is a directory. In some special error cases, such as when the volume goes offline or when the directory is moved while retrieving this info, this field might not get set.
	IsEmpty *bool `json:"is_empty,omitempty"`

	// Returns "true" if the directory is a junction.
	// Example: false
	// Read Only: true
	IsJunction *bool `json:"is_junction,omitempty"`

	// Returns "true" if the directory is a snapshot.
	// Example: false
	// Read Only: true
	IsSnapshot *bool `json:"is_snapshot,omitempty"`

	// Returns true if the file is vm-aligned. A vm-aligned file is a file that is initially padded with zero-filled data so that its actual data starts at an offset other than zero. The amount by which the start offset is adjusted depends on the vm-align setting of the hosting volume.
	// Example: false
	// Read Only: true
	IsVMAligned *bool `json:"is_vm_aligned,omitempty"`

	// Last data modification time of the file in date-time format.
	// Example: 2019-06-12 11:00:16-04:00
	// Read Only: true
	// Format: date-time
	ModifiedTime *strfmt.DateTime `json:"modified_time,omitempty"`

	// Name of the file.
	Name *string `json:"name,omitempty"`

	// Returns "true" if the space reservation for overwrites is enabled. The field fill_enabled must also be set to the same value as this field.
	OverwriteEnabled *bool `json:"overwrite_enabled,omitempty"`

	// The integer ID of the file owner.
	// Example: 54738
	// Read Only: true
	OwnerID *int64 `json:"owner_id,omitempty"`

	// Path of the file.
	Path *string `json:"path,omitempty"`

	// qos policy
	QosPolicy *FileInfoInlineQosPolicy `json:"qos_policy,omitempty"`

	// The size of the file, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The relative or absolute path contained in a symlink, in the form <some>/<path>.
	Target *string `json:"target,omitempty"`

	// Type of the file.
	// Example: file
	// Enum: ["file","directory","blockdev","chardev","symlink","socket","fifo","stream","lun"]
	Type *string `json:"type,omitempty"`

	// Number of bytes uniquely held by this file. If byte_offset and length parameters are specified, this will return bytes uniquely held by the file within the given range.
	// Example: 4096
	// Read Only: true
	UniqueBytes *int64 `json:"unique_bytes,omitempty"`

	// UNIX permissions to be viewed as an octal number. It consists of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). The first digit selects the set user ID(4), set group ID (2), and sticky (1) attributes. The second digit selects permissions for the owner of the file; the third selects permissions for other users in the same group; the fourth selects permissions for other users not in the group.
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`

	// volume
	Volume *FileInfoInlineVolume `json:"volume,omitempty"`
}

// Validate validates this file info
func (m *FileInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAnalytics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateChangedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConstituent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreationTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModifiedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfo) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfo) validateAccessedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("accessed_time", "body", "date-time", m.AccessedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) validateAnalytics(formats strfmt.Registry) error {
	if swag.IsZero(m.Analytics) { // not required
		return nil
	}

	if m.Analytics != nil {
		if err := m.Analytics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfo) validateChangedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ChangedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("changed_time", "body", "date-time", m.ChangedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) validateConstituent(formats strfmt.Registry) error {
	if swag.IsZero(m.Constituent) { // not required
		return nil
	}

	if m.Constituent != nil {
		if err := m.Constituent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("constituent")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfo) validateCreationTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("creation_time", "body", "date-time", m.CreationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) validateModifiedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ModifiedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("modified_time", "body", "date-time", m.ModifiedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

var fileInfoTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file","directory","blockdev","chardev","symlink","socket","fifo","stream","lun"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fileInfoTypeTypePropEnum = append(fileInfoTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// file
	// END DEBUGGING
	// FileInfoTypeFile captures enum value "file"
	FileInfoTypeFile string = "file"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// directory
	// END DEBUGGING
	// FileInfoTypeDirectory captures enum value "directory"
	FileInfoTypeDirectory string = "directory"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// blockdev
	// END DEBUGGING
	// FileInfoTypeBlockdev captures enum value "blockdev"
	FileInfoTypeBlockdev string = "blockdev"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// chardev
	// END DEBUGGING
	// FileInfoTypeChardev captures enum value "chardev"
	FileInfoTypeChardev string = "chardev"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// symlink
	// END DEBUGGING
	// FileInfoTypeSymlink captures enum value "symlink"
	FileInfoTypeSymlink string = "symlink"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// socket
	// END DEBUGGING
	// FileInfoTypeSocket captures enum value "socket"
	FileInfoTypeSocket string = "socket"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// fifo
	// END DEBUGGING
	// FileInfoTypeFifo captures enum value "fifo"
	FileInfoTypeFifo string = "fifo"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// stream
	// END DEBUGGING
	// FileInfoTypeStream captures enum value "stream"
	FileInfoTypeStream string = "stream"

	// BEGIN DEBUGGING
	// file_info
	// FileInfo
	// type
	// Type
	// lun
	// END DEBUGGING
	// FileInfoTypeLun captures enum value "lun"
	FileInfoTypeLun string = "lun"
)

// prop value enum
func (m *FileInfo) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fileInfoTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FileInfo) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info based on the context it is used
func (m *FileInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAnalytics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateChangedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConstituent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreationTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGroupID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHardLinksCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInodeGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInodeNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsJunction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsVMAligned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModifiedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwnerID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUniqueBytes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfo) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfo) contextValidateAccessedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "accessed_time", "body", m.AccessedTime); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateAnalytics(ctx context.Context, formats strfmt.Registry) error {

	if m.Analytics != nil {
		if err := m.Analytics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfo) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "bytes_used", "body", m.BytesUsed); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateChangedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "changed_time", "body", m.ChangedTime); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateConstituent(ctx context.Context, formats strfmt.Registry) error {

	if m.Constituent != nil {
		if err := m.Constituent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("constituent")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfo) contextValidateCreationTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "creation_time", "body", m.CreationTime); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateGroupID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "group_id", "body", m.GroupID); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateHardLinksCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "hard_links_count", "body", m.HardLinksCount); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateInodeGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "inode_generation", "body", m.InodeGeneration); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateInodeNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "inode_number", "body", m.InodeNumber); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateIsJunction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_junction", "body", m.IsJunction); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateIsSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_snapshot", "body", m.IsSnapshot); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateIsVMAligned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_vm_aligned", "body", m.IsVMAligned); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateModifiedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "modified_time", "body", m.ModifiedTime); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateOwnerID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner_id", "body", m.OwnerID); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfo) contextValidateUniqueBytes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "unique_bytes", "body", m.UniqueBytes); err != nil {
		return err
	}

	return nil
}

func (m *FileInfo) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfo) UnmarshalBinary(b []byte) error {
	var res FileInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineAnalytics Additional file system analytics information summarizing all descendants of a directory. <br/>
// This property is only populated if file system analytics is enabled on the containing volume. <br/>
// In the context of the `records` property of a [`file_info_response`](#model-file_info_response), analytics objects will only include properties that may vary between elements within the collection. For example, the analytics objects will not contain histogram labels, since the same histogram labels are used for all elements within the collection. The invariant information is instead available via the `analytics` property of the [`file_info_response`](#model-file_info_response). This avoids an excessive amount of duplicated information when a [`GET  /storage/volumes/{volume.uuid}/files/{path}`](#/storage/file_collection_get) call returns a large collection.
//
// swagger:model file_info_inline_analytics
type FileInfoInlineAnalytics struct {

	// by accessed time
	ByAccessedTime *FileInfoInlineAnalyticsInlineByAccessedTime `json:"by_accessed_time,omitempty"`

	// by modified time
	ByModifiedTime *FileInfoInlineAnalyticsInlineByModifiedTime `json:"by_modified_time,omitempty"`

	// Number of bytes used on-disk
	// Example: 15436648448
	BytesUsed *int64 `json:"bytes_used,omitempty"`

	// Number of descendants
	// Example: 21134
	FileCount *int64 `json:"file_count,omitempty"`

	// Returns true if data collection is incomplete for this directory tree.
	IncompleteData *bool `json:"incomplete_data,omitempty"`

	// The date and time analytics information was collected.
	// Format: date-time
	ReportTime *strfmt.DateTime `json:"report_time,omitempty"`

	// Number of sub directories
	// Example: 35
	SubdirCount *int64 `json:"subdir_count,omitempty"`
}

// Validate validates this file info inline analytics
func (m *FileInfoInlineAnalytics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateByAccessedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateByModifiedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReportTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalytics) validateByAccessedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ByAccessedTime) { // not required
		return nil
	}

	if m.ByAccessedTime != nil {
		if err := m.ByAccessedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineAnalytics) validateByModifiedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ByModifiedTime) { // not required
		return nil
	}

	if m.ByModifiedTime != nil {
		if err := m.ByModifiedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineAnalytics) validateReportTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ReportTime) { // not required
		return nil
	}

	if err := validate.FormatOf("analytics"+"."+"report_time", "body", "date-time", m.ReportTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this file info inline analytics based on the context it is used
func (m *FileInfoInlineAnalytics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateByAccessedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateByModifiedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalytics) contextValidateByAccessedTime(ctx context.Context, formats strfmt.Registry) error {

	if m.ByAccessedTime != nil {
		if err := m.ByAccessedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineAnalytics) contextValidateByModifiedTime(ctx context.Context, formats strfmt.Registry) error {

	if m.ByModifiedTime != nil {
		if err := m.ByModifiedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineAnalytics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineAnalytics) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineAnalytics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineAnalyticsInlineByAccessedTime File system analytics information, broken down by date of last access.
//
// swagger:model file_info_inline_analytics_inline_by_accessed_time
type FileInfoInlineAnalyticsInlineByAccessedTime struct {

	// bytes used
	BytesUsed *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this file info inline analytics inline by accessed time
func (m *FileInfoInlineAnalyticsInlineByAccessedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.BytesUsed) { // not required
		return nil
	}

	if m.BytesUsed != nil {
		if err := m.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline analytics inline by accessed time based on the context it is used
func (m *FileInfoInlineAnalyticsInlineByAccessedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.BytesUsed != nil {
		if err := m.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByAccessedTime) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByAccessedTime) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineAnalyticsInlineByAccessedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last access.
//
// swagger:model file_info_inline_analytics_inline_by_accessed_time_inline_bytes_used
type FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed struct {

	// A score summarizing how old the data is. A higher value means the data is older.
	// Example: 15.23
	AgedDataMetric *float64 `json:"aged_data_metric,omitempty"`

	// labels
	Labels AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`

	// The newest time label with a non-zero histogram value.
	NewestLabel *AnalyticsHistogramTimeLabel `json:"newest_label,omitempty"`

	// The oldest time label with a non-zero histogram value.
	OldestLabel *AnalyticsHistogramTimeLabel `json:"oldest_label,omitempty"`

	// Percentages for this histogram
	// Example: [0.1,11.24,0.18,15.75,0.75,83.5,0]
	Percentages []*float64 `json:"percentages,omitempty"`

	// Values for this histogram
	// Example: [15925248,1735569408,27672576,2430595072,116105216,12889948160,0]
	Values []*int64 `json:"values,omitempty"`
}

// Validate validates this file info inline analytics inline by accessed time inline bytes used
func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNewestLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOldestLabel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	if err := m.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateNewestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.NewestLabel) { // not required
		return nil
	}

	if m.NewestLabel != nil {
		if err := m.NewestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) validateOldestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.OldestLabel) { // not required
		return nil
	}

	if m.OldestLabel != nil {
		if err := m.OldestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline analytics inline by accessed time inline bytes used based on the context it is used
func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNewestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOldestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateNewestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.NewestLabel != nil {
		if err := m.NewestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) contextValidateOldestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.OldestLabel != nil {
		if err := m.OldestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_accessed_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineAnalyticsInlineByAccessedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineAnalyticsInlineByModifiedTime File system analytics information, broken down by date of last modification.
//
// swagger:model file_info_inline_analytics_inline_by_modified_time
type FileInfoInlineAnalyticsInlineByModifiedTime struct {

	// bytes used
	BytesUsed *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this file info inline analytics inline by modified time
func (m *FileInfoInlineAnalyticsInlineByModifiedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.BytesUsed) { // not required
		return nil
	}

	if m.BytesUsed != nil {
		if err := m.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline analytics inline by modified time based on the context it is used
func (m *FileInfoInlineAnalyticsInlineByModifiedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.BytesUsed != nil {
		if err := m.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByModifiedTime) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByModifiedTime) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineAnalyticsInlineByModifiedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last modification.
//
// swagger:model file_info_inline_analytics_inline_by_modified_time_inline_bytes_used
type FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed struct {

	// A score summarizing how old the data is. A higher value means the data is older.
	// Example: 15.23
	AgedDataMetric *float64 `json:"aged_data_metric,omitempty"`

	// labels
	Labels AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`

	// The newest time label with a non-zero histogram value.
	NewestLabel *AnalyticsHistogramTimeLabel `json:"newest_label,omitempty"`

	// The oldest time label with a non-zero histogram value.
	OldestLabel *AnalyticsHistogramTimeLabel `json:"oldest_label,omitempty"`

	// Percentages for this histogram
	// Example: [0.1,11.24,0.18,15.75,0.75,83.5,0]
	Percentages []*float64 `json:"percentages,omitempty"`

	// Values for this histogram
	// Example: [15925248,1735569408,27672576,2430595072,116105216,12889948160,0]
	Values []*int64 `json:"values,omitempty"`
}

// Validate validates this file info inline analytics inline by modified time inline bytes used
func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNewestLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOldestLabel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	if err := m.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateNewestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.NewestLabel) { // not required
		return nil
	}

	if m.NewestLabel != nil {
		if err := m.NewestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) validateOldestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.OldestLabel) { // not required
		return nil
	}

	if m.OldestLabel != nil {
		if err := m.OldestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline analytics inline by modified time inline bytes used based on the context it is used
func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNewestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOldestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateNewestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.NewestLabel != nil {
		if err := m.NewestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) contextValidateOldestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.OldestLabel != nil {
		if err := m.OldestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("analytics" + "." + "by_modified_time" + "." + "bytes_used" + "." + "oldest_label")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineAnalyticsInlineByModifiedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineConstituent file info inline constituent
//
// swagger:model file_info_inline_constituent
type FileInfoInlineConstituent struct {

	// FlexGroup volume constituent name.
	// Example: fg__0001
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// FlexGroup volume constituent UUID.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file info inline constituent
func (m *FileInfoInlineConstituent) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this file info inline constituent based on the context it is used
func (m *FileInfoInlineConstituent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineConstituent) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "constituent"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *FileInfoInlineConstituent) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "constituent"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineConstituent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineConstituent) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineConstituent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineLinks file info inline links
//
// swagger:model file_info_inline__links
type FileInfoInlineLinks struct {

	// metadata
	Metadata *Href `json:"metadata,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file info inline links
func (m *FileInfoInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMetadata(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineLinks) validateMetadata(formats strfmt.Registry) error {
	if swag.IsZero(m.Metadata) { // not required
		return nil
	}

	if m.Metadata != nil {
		if err := m.Metadata.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "metadata")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline links based on the context it is used
func (m *FileInfoInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineLinks) contextValidateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if m.Metadata != nil {
		if err := m.Metadata.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "metadata")
			}
			return err
		}
	}

	return nil
}

func (m *FileInfoInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineQosPolicy The QoS policy for the file. Both traditional and adaptive QoS policies are supported. If both `qos_policy.uuid` and `qos_policy.name` properties are specified in the same request, they must refer to the same QoS policy. To remove the file from a QoS policy, set the property `qos_policy.name` in a PATCH request to an empty string "" or "none". Note: Files which are in use as a LUN cannot be assigned to a QoS policy, instead use PATCH on /storage/luns to assign a QoS policy for such files. <br/>
// Note that a QoS policy can be set on a file, or a file's volume, but not on both.
//
// swagger:model file_info_inline_qos_policy
type FileInfoInlineQosPolicy struct {

	// links
	Links *FileInfoInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// The name of the QoS policy. To remove the file from a QoS policy, set this property to an empty string "" or set it to "none" in a PATCH request.
	//
	Name *string `json:"name,omitempty"`

	// The unique identifier of the QoS policy. Valid in PATCH.
	//
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file info inline qos policy
func (m *FileInfoInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline qos policy based on the context it is used
func (m *FileInfoInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineQosPolicyInlineLinks file info inline qos policy inline links
//
// swagger:model file_info_inline_qos_policy_inline__links
type FileInfoInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file info inline qos policy inline links
func (m *FileInfoInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline qos policy inline links based on the context it is used
func (m *FileInfoInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineVolume file info inline volume
//
// swagger:model file_info_inline_volume
type FileInfoInlineVolume struct {

	// links
	Links *FileInfoInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file info inline volume
func (m *FileInfoInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline volume based on the context it is used
func (m *FileInfoInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineVolume) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileInfoInlineVolumeInlineLinks file info inline volume inline links
//
// swagger:model file_info_inline_volume_inline__links
type FileInfoInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file info inline volume inline links
func (m *FileInfoInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file info inline volume inline links based on the context it is used
func (m *FileInfoInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileInfoInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileInfoInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileInfoInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileInfoInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
