// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FileMove Details of a file move operation.
//
// swagger:model file_move
type FileMove struct {

	// Time that the file move operation takes before cutover completes, in seconds.
	// Example: 8
	// Read Only: true
	CutoverTime *int64 `json:"cutover_time,omitempty"`

	// destination
	Destination *FileMoveInlineDestination `json:"destination,omitempty"`

	// Time elapsed since the start of the file move operation, in seconds.
	// Example: 100
	// Read Only: true
	ElapsedTime *int64 `json:"elapsed_time,omitempty"`

	// Contains the most recent failure reason for move operation.
	// Read Only: true
	Failure *Error `json:"failure,omitempty"`

	// files to move
	FilesToMove *FileMoveInlineFilesToMove `json:"files_to_move,omitempty"`

	// An additional unique element identifying one file among many that could possibly be moved as part of a job. File index is an identifier ordered by the file path arrays provided during create. For file move operations that involve only one file, the file-index value of zero is always correct.
	//
	// Example: 0
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// Indicates whether the destination file is ready for use.
	// Read Only: true
	IsDestinationReady *bool `json:"is_destination_ready,omitempty"`

	// Indicates whether this is a FlexGroup file move operation.
	// Read Only: true
	IsFlexgroup *bool `json:"is_flexgroup,omitempty"`

	// Indicates whether snapshots are fenced.
	// Read Only: true
	IsSnapshotFenced *bool `json:"is_snapshot_fenced,omitempty"`

	// The maximum amount of time, in seconds that the source can be quiesced before a destination file must be made available for read-write traffic. Not supported in FlexGroup volume file move operations.
	//
	// Example: 10
	MaxCutoverTime *int64 `json:"max_cutover_time,omitempty"`

	// Maximum amount of data, in bytes that can be transferred per second in support of this operation. A non-zero value less than 1 MB/s is set to 1 MB/s. A non-zero value greater than 1 MB/s is truncated to the nearest integral megabyte value. If unspecified, the default value is "0" which means no range is set for the data transfer.
	// Example: 250000
	MaxThroughput *int64 `json:"max_throughput,omitempty"`

	// node
	Node *FileMoveInlineNode `json:"node,omitempty"`

	// reference
	Reference *FileMoveInlineReference `json:"reference,omitempty"`

	// scanner
	Scanner *FileMoveInlineScanner `json:"scanner,omitempty"`

	// source
	Source *FileMoveInlineSource `json:"source,omitempty"`

	// svm
	Svm *FileMoveInlineSvm `json:"svm,omitempty"`

	// The UUID which uniquely identifies the job that started this move operation.
	// Example: 4fcb3159-a4ee-42b5-bb16-f752f2c430fc
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// volume
	Volume *FileMoveInlineVolume `json:"volume,omitempty"`
}

// Validate validates this file move
func (m *FileMove) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilesToMove(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReference(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMove) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(m.Destination) { // not required
		return nil
	}

	if m.Destination != nil {
		if err := m.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("failure")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateFilesToMove(formats strfmt.Registry) error {
	if swag.IsZero(m.FilesToMove) { // not required
		return nil
	}

	if m.FilesToMove != nil {
		if err := m.FilesToMove.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files_to_move")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateReference(formats strfmt.Registry) error {
	if swag.IsZero(m.Reference) { // not required
		return nil
	}

	if m.Reference != nil {
		if err := m.Reference.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateScanner(formats strfmt.Registry) error {
	if swag.IsZero(m.Scanner) { // not required
		return nil
	}

	if m.Scanner != nil {
		if err := m.Scanner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scanner")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move based on the context it is used
func (m *FileMove) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCutoverTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateElapsedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesToMove(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsDestinationReady(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsFlexgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSnapshotFenced(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReference(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScanner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMove) contextValidateCutoverTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cutover_time", "body", m.CutoverTime); err != nil {
		return err
	}

	return nil
}

func (m *FileMove) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if m.Destination != nil {
		if err := m.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateElapsedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "elapsed_time", "body", m.ElapsedTime); err != nil {
		return err
	}

	return nil
}

func (m *FileMove) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("failure")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateFilesToMove(ctx context.Context, formats strfmt.Registry) error {

	if m.FilesToMove != nil {
		if err := m.FilesToMove.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("files_to_move")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "index", "body", m.Index); err != nil {
		return err
	}

	return nil
}

func (m *FileMove) contextValidateIsDestinationReady(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_destination_ready", "body", m.IsDestinationReady); err != nil {
		return err
	}

	return nil
}

func (m *FileMove) contextValidateIsFlexgroup(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_flexgroup", "body", m.IsFlexgroup); err != nil {
		return err
	}

	return nil
}

func (m *FileMove) contextValidateIsSnapshotFenced(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_snapshot_fenced", "body", m.IsSnapshotFenced); err != nil {
		return err
	}

	return nil
}

func (m *FileMove) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateReference(ctx context.Context, formats strfmt.Registry) error {

	if m.Reference != nil {
		if err := m.Reference.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateScanner(ctx context.Context, formats strfmt.Registry) error {

	if m.Scanner != nil {
		if err := m.Scanner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scanner")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMove) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *FileMove) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMove) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMove) UnmarshalBinary(b []byte) error {
	var res FileMove
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineDestination Destination file information.
//
// swagger:model file_move_inline_destination
type FileMoveInlineDestination struct {

	// path
	// Example: d1/d2/file1
	Path *string `json:"path,omitempty"`

	// svm
	Svm *FileMoveInlineDestinationInlineSvm `json:"svm,omitempty"`

	// volume
	Volume *FileMoveInlineDestinationInlineVolume `json:"volume,omitempty"`
}

// Validate validates this file move inline destination
func (m *FileMoveInlineDestination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestination) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveInlineDestination) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline destination based on the context it is used
func (m *FileMoveInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestination) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveInlineDestination) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineDestination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineDestination) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineDestinationInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model file_move_inline_destination_inline_svm
type FileMoveInlineDestinationInlineSvm struct {

	// links
	Links *FileMoveInlineDestinationInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline destination inline svm
func (m *FileMoveInlineDestinationInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline destination inline svm based on the context it is used
func (m *FileMoveInlineDestinationInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineSvm) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineDestinationInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineDestinationInlineSvmInlineLinks file move inline destination inline svm inline links
//
// swagger:model file_move_inline_destination_inline_svm_inline__links
type FileMoveInlineDestinationInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline destination inline svm inline links
func (m *FileMoveInlineDestinationInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline destination inline svm inline links based on the context it is used
func (m *FileMoveInlineDestinationInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineDestinationInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineDestinationInlineVolume file move inline destination inline volume
//
// swagger:model file_move_inline_destination_inline_volume
type FileMoveInlineDestinationInlineVolume struct {

	// links
	Links *FileMoveInlineDestinationInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline destination inline volume
func (m *FileMoveInlineDestinationInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline destination inline volume based on the context it is used
func (m *FileMoveInlineDestinationInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineVolume) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineDestinationInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineDestinationInlineVolumeInlineLinks file move inline destination inline volume inline links
//
// swagger:model file_move_inline_destination_inline_volume_inline__links
type FileMoveInlineDestinationInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline destination inline volume inline links
func (m *FileMoveInlineDestinationInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline destination inline volume inline links based on the context it is used
func (m *FileMoveInlineDestinationInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineDestinationInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destination" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineDestinationInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineDestinationInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineFilesToMove A list of source files along with the destination file they are moved to. If the terminal path component of the destination is a directory, then the source file's basename is replicated in that directory. This is only used for FlexVol volume file move operations.
//
// swagger:model file_move_inline_files_to_move
type FileMoveInlineFilesToMove struct {

	// The destination file information.
	Destinations []*FileMoveFilesToMoveDestinationsItems0 `json:"destinations,omitempty"`

	// The source file information.
	Sources []*FileMoveFilesToMoveSourcesItems0 `json:"sources,omitempty"`
}

// Validate validates this file move inline files to move
func (m *FileMoveInlineFilesToMove) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestinations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSources(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineFilesToMove) validateDestinations(formats strfmt.Registry) error {
	if swag.IsZero(m.Destinations) { // not required
		return nil
	}

	for i := 0; i < len(m.Destinations); i++ {
		if swag.IsZero(m.Destinations[i]) { // not required
			continue
		}

		if m.Destinations[i] != nil {
			if err := m.Destinations[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("files_to_move" + "." + "destinations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FileMoveInlineFilesToMove) validateSources(formats strfmt.Registry) error {
	if swag.IsZero(m.Sources) { // not required
		return nil
	}

	for i := 0; i < len(m.Sources); i++ {
		if swag.IsZero(m.Sources[i]) { // not required
			continue
		}

		if m.Sources[i] != nil {
			if err := m.Sources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("files_to_move" + "." + "sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this file move inline files to move based on the context it is used
func (m *FileMoveInlineFilesToMove) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestinations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineFilesToMove) contextValidateDestinations(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Destinations); i++ {

		if m.Destinations[i] != nil {
			if err := m.Destinations[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("files_to_move" + "." + "destinations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FileMoveInlineFilesToMove) contextValidateSources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Sources); i++ {

		if m.Sources[i] != nil {
			if err := m.Sources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("files_to_move" + "." + "sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineFilesToMove) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineFilesToMove) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineFilesToMove
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveDestinationsItems0 Path for file move operation.
//
// swagger:model FileMoveFilesToMoveDestinationsItems0
type FileMoveFilesToMoveDestinationsItems0 struct {

	// path
	// Example: d1/d2/file1
	Path *string `json:"path,omitempty"`

	// svm
	Svm *FileMoveFilesToMoveDestinationsItems0Svm `json:"svm,omitempty"`

	// volume
	Volume *FileMoveFilesToMoveDestinationsItems0Volume `json:"volume,omitempty"`
}

// Validate validates this file move files to move destinations items0
func (m *FileMoveFilesToMoveDestinationsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move destinations items0 based on the context it is used
func (m *FileMoveFilesToMoveDestinationsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveDestinationsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveDestinationsItems0Svm SVM, applies only to SVM-scoped objects.
//
// swagger:model FileMoveFilesToMoveDestinationsItems0Svm
type FileMoveFilesToMoveDestinationsItems0Svm struct {

	// links
	Links *FileMoveFilesToMoveDestinationsItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move files to move destinations items0 svm
func (m *FileMoveFilesToMoveDestinationsItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move destinations items0 svm based on the context it is used
func (m *FileMoveFilesToMoveDestinationsItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0Svm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0Svm) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveDestinationsItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveDestinationsItems0SvmLinks file move files to move destinations items0 svm links
//
// swagger:model FileMoveFilesToMoveDestinationsItems0SvmLinks
type FileMoveFilesToMoveDestinationsItems0SvmLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move files to move destinations items0 svm links
func (m *FileMoveFilesToMoveDestinationsItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move destinations items0 svm links based on the context it is used
func (m *FileMoveFilesToMoveDestinationsItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveDestinationsItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveDestinationsItems0Volume file move files to move destinations items0 volume
//
// swagger:model FileMoveFilesToMoveDestinationsItems0Volume
type FileMoveFilesToMoveDestinationsItems0Volume struct {

	// links
	Links *FileMoveFilesToMoveDestinationsItems0VolumeLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move files to move destinations items0 volume
func (m *FileMoveFilesToMoveDestinationsItems0Volume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0Volume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move destinations items0 volume based on the context it is used
func (m *FileMoveFilesToMoveDestinationsItems0Volume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0Volume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0Volume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0Volume) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveDestinationsItems0Volume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveDestinationsItems0VolumeLinks file move files to move destinations items0 volume links
//
// swagger:model FileMoveFilesToMoveDestinationsItems0VolumeLinks
type FileMoveFilesToMoveDestinationsItems0VolumeLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move files to move destinations items0 volume links
func (m *FileMoveFilesToMoveDestinationsItems0VolumeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0VolumeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move destinations items0 volume links based on the context it is used
func (m *FileMoveFilesToMoveDestinationsItems0VolumeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveDestinationsItems0VolumeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0VolumeLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveDestinationsItems0VolumeLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveDestinationsItems0VolumeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveSourcesItems0 Path for file move operation.
//
// swagger:model FileMoveFilesToMoveSourcesItems0
type FileMoveFilesToMoveSourcesItems0 struct {

	// path
	// Example: d1/d2/file1
	Path *string `json:"path,omitempty"`

	// svm
	Svm *FileMoveFilesToMoveSourcesItems0Svm `json:"svm,omitempty"`

	// volume
	Volume *FileMoveFilesToMoveSourcesItems0Volume `json:"volume,omitempty"`
}

// Validate validates this file move files to move sources items0
func (m *FileMoveFilesToMoveSourcesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move sources items0 based on the context it is used
func (m *FileMoveFilesToMoveSourcesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveSourcesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveSourcesItems0Svm SVM, applies only to SVM-scoped objects.
//
// swagger:model FileMoveFilesToMoveSourcesItems0Svm
type FileMoveFilesToMoveSourcesItems0Svm struct {

	// links
	Links *FileMoveFilesToMoveSourcesItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move files to move sources items0 svm
func (m *FileMoveFilesToMoveSourcesItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move sources items0 svm based on the context it is used
func (m *FileMoveFilesToMoveSourcesItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0Svm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0Svm) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveSourcesItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveSourcesItems0SvmLinks file move files to move sources items0 svm links
//
// swagger:model FileMoveFilesToMoveSourcesItems0SvmLinks
type FileMoveFilesToMoveSourcesItems0SvmLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move files to move sources items0 svm links
func (m *FileMoveFilesToMoveSourcesItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move sources items0 svm links based on the context it is used
func (m *FileMoveFilesToMoveSourcesItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveSourcesItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveSourcesItems0Volume file move files to move sources items0 volume
//
// swagger:model FileMoveFilesToMoveSourcesItems0Volume
type FileMoveFilesToMoveSourcesItems0Volume struct {

	// links
	Links *FileMoveFilesToMoveSourcesItems0VolumeLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move files to move sources items0 volume
func (m *FileMoveFilesToMoveSourcesItems0Volume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0Volume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move sources items0 volume based on the context it is used
func (m *FileMoveFilesToMoveSourcesItems0Volume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0Volume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0Volume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0Volume) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveSourcesItems0Volume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveFilesToMoveSourcesItems0VolumeLinks file move files to move sources items0 volume links
//
// swagger:model FileMoveFilesToMoveSourcesItems0VolumeLinks
type FileMoveFilesToMoveSourcesItems0VolumeLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move files to move sources items0 volume links
func (m *FileMoveFilesToMoveSourcesItems0VolumeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0VolumeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move files to move sources items0 volume links based on the context it is used
func (m *FileMoveFilesToMoveSourcesItems0VolumeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveFilesToMoveSourcesItems0VolumeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0VolumeLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveFilesToMoveSourcesItems0VolumeLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveFilesToMoveSourcesItems0VolumeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineNode Node hosting the destination of this move operation.
//
// swagger:model file_move_inline_node
type FileMoveInlineNode struct {

	// links
	Links *FileMoveInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline node
func (m *FileMoveInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline node based on the context it is used
func (m *FileMoveInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineNode) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineNodeInlineLinks file move inline node inline links
//
// swagger:model file_move_inline_node_inline__links
type FileMoveInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline node inline links
func (m *FileMoveInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline node inline links based on the context it is used
func (m *FileMoveInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineReference Reference file information.
//
// swagger:model file_move_inline_reference
type FileMoveInlineReference struct {

	// The maximum amount of time, in seconds that the source reference file can be quiesced before the corresponding destination file must be made available for read-write traffic. Not supported in FlexGroup volume file move operations.
	//
	// Example: 5
	MaxCutoverTime *int64 `json:"max_cutover_time,omitempty"`

	// The source reference file. If a reference file is specified, data for other files being moved will be transferred as a difference from the reference file. This can save bandwidth and destination storage if the specified source files share blocks. If provided, this input must match one of the source file paths. This input need not be provided if only one source file is specified. Not supported in FlexGroup volume file move operations.
	//
	Path *string `json:"path,omitempty"`

	// svm
	Svm *FileMoveInlineReferenceInlineSvm `json:"svm,omitempty"`

	// volume
	Volume *FileMoveInlineReferenceInlineVolume `json:"volume,omitempty"`
}

// Validate validates this file move inline reference
func (m *FileMoveInlineReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReference) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveInlineReference) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline reference based on the context it is used
func (m *FileMoveInlineReference) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReference) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveInlineReference) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineReference) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineReferenceInlineSvm SVM of the source reference file.
//
// swagger:model file_move_inline_reference_inline_svm
type FileMoveInlineReferenceInlineSvm struct {

	// links
	Links *FileMoveInlineReferenceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline reference inline svm
func (m *FileMoveInlineReferenceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline reference inline svm based on the context it is used
func (m *FileMoveInlineReferenceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineSvm) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineReferenceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineReferenceInlineSvmInlineLinks file move inline reference inline svm inline links
//
// swagger:model file_move_inline_reference_inline_svm_inline__links
type FileMoveInlineReferenceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline reference inline svm inline links
func (m *FileMoveInlineReferenceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline reference inline svm inline links based on the context it is used
func (m *FileMoveInlineReferenceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineReferenceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineReferenceInlineVolume Volume of the source reference file.
//
// swagger:model file_move_inline_reference_inline_volume
type FileMoveInlineReferenceInlineVolume struct {

	// links
	Links *FileMoveInlineReferenceInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline reference inline volume
func (m *FileMoveInlineReferenceInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline reference inline volume based on the context it is used
func (m *FileMoveInlineReferenceInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineVolume) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineReferenceInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineReferenceInlineVolumeInlineLinks file move inline reference inline volume inline links
//
// swagger:model file_move_inline_reference_inline_volume_inline__links
type FileMoveInlineReferenceInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline reference inline volume inline links
func (m *FileMoveInlineReferenceInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline reference inline volume inline links based on the context it is used
func (m *FileMoveInlineReferenceInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineReferenceInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reference" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineReferenceInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineReferenceInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineScanner file move inline scanner
//
// swagger:model file_move_inline_scanner
type FileMoveInlineScanner struct {

	// Scanner progress, as a percentage.
	// Example: 80
	// Read Only: true
	Percent *int64 `json:"percent,omitempty"`

	// Scanner progress, in bytes scanned.
	// Example: 80000
	// Read Only: true
	Progress *int64 `json:"progress,omitempty"`

	// Status of the file move scanner.
	// Read Only: true
	// Enum: ["allocation_map","complete","data","destroyed","destroying","paused_admin","paused_error","preparing"]
	State *string `json:"state,omitempty"`

	// Total bytes to be scanned.
	// Example: 100000
	// Read Only: true
	Total *int64 `json:"total,omitempty"`
}

// Validate validates this file move inline scanner
func (m *FileMoveInlineScanner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fileMoveInlineScannerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allocation_map","complete","data","destroyed","destroying","paused_admin","paused_error","preparing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fileMoveInlineScannerTypeStatePropEnum = append(fileMoveInlineScannerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// allocation_map
	// END DEBUGGING
	// FileMoveInlineScannerStateAllocationMap captures enum value "allocation_map"
	FileMoveInlineScannerStateAllocationMap string = "allocation_map"

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// complete
	// END DEBUGGING
	// FileMoveInlineScannerStateComplete captures enum value "complete"
	FileMoveInlineScannerStateComplete string = "complete"

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// data
	// END DEBUGGING
	// FileMoveInlineScannerStateData captures enum value "data"
	FileMoveInlineScannerStateData string = "data"

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// destroyed
	// END DEBUGGING
	// FileMoveInlineScannerStateDestroyed captures enum value "destroyed"
	FileMoveInlineScannerStateDestroyed string = "destroyed"

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// destroying
	// END DEBUGGING
	// FileMoveInlineScannerStateDestroying captures enum value "destroying"
	FileMoveInlineScannerStateDestroying string = "destroying"

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// paused_admin
	// END DEBUGGING
	// FileMoveInlineScannerStatePausedAdmin captures enum value "paused_admin"
	FileMoveInlineScannerStatePausedAdmin string = "paused_admin"

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// paused_error
	// END DEBUGGING
	// FileMoveInlineScannerStatePausedError captures enum value "paused_error"
	FileMoveInlineScannerStatePausedError string = "paused_error"

	// BEGIN DEBUGGING
	// file_move_inline_scanner
	// FileMoveInlineScanner
	// state
	// State
	// preparing
	// END DEBUGGING
	// FileMoveInlineScannerStatePreparing captures enum value "preparing"
	FileMoveInlineScannerStatePreparing string = "preparing"
)

// prop value enum
func (m *FileMoveInlineScanner) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fileMoveInlineScannerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FileMoveInlineScanner) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("scanner"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this file move inline scanner based on the context it is used
func (m *FileMoveInlineScanner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineScanner) contextValidatePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scanner"+"."+"percent", "body", m.Percent); err != nil {
		return err
	}

	return nil
}

func (m *FileMoveInlineScanner) contextValidateProgress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scanner"+"."+"progress", "body", m.Progress); err != nil {
		return err
	}

	return nil
}

func (m *FileMoveInlineScanner) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scanner"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *FileMoveInlineScanner) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scanner"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineScanner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineScanner) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineScanner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineSource Source file information.
//
// swagger:model file_move_inline_source
type FileMoveInlineSource struct {

	// path
	// Example: d1/d2/file1
	Path *string `json:"path,omitempty"`

	// svm
	Svm *FileMoveInlineSourceInlineSvm `json:"svm,omitempty"`

	// volume
	Volume *FileMoveInlineSourceInlineVolume `json:"volume,omitempty"`
}

// Validate validates this file move inline source
func (m *FileMoveInlineSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSource) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveInlineSource) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline source based on the context it is used
func (m *FileMoveInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSource) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (m *FileMoveInlineSource) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineSource) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineSourceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model file_move_inline_source_inline_svm
type FileMoveInlineSourceInlineSvm struct {

	// links
	Links *FileMoveInlineSourceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline source inline svm
func (m *FileMoveInlineSourceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline source inline svm based on the context it is used
func (m *FileMoveInlineSourceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineSvm) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineSourceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineSourceInlineSvmInlineLinks file move inline source inline svm inline links
//
// swagger:model file_move_inline_source_inline_svm_inline__links
type FileMoveInlineSourceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline source inline svm inline links
func (m *FileMoveInlineSourceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline source inline svm inline links based on the context it is used
func (m *FileMoveInlineSourceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineSourceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineSourceInlineVolume file move inline source inline volume
//
// swagger:model file_move_inline_source_inline_volume
type FileMoveInlineSourceInlineVolume struct {

	// links
	Links *FileMoveInlineSourceInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline source inline volume
func (m *FileMoveInlineSourceInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline source inline volume based on the context it is used
func (m *FileMoveInlineSourceInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineVolume) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineSourceInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineSourceInlineVolumeInlineLinks file move inline source inline volume inline links
//
// swagger:model file_move_inline_source_inline_volume_inline__links
type FileMoveInlineSourceInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline source inline volume inline links
func (m *FileMoveInlineSourceInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline source inline volume inline links based on the context it is used
func (m *FileMoveInlineSourceInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSourceInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineSourceInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineSourceInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineSvm SVM of the FlexGroup volume in file move operation. Only used in a FlexGroup volume file move operation.
//
// swagger:model file_move_inline_svm
type FileMoveInlineSvm struct {

	// links
	Links *FileMoveInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline svm
func (m *FileMoveInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline svm based on the context it is used
func (m *FileMoveInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineSvm) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineSvmInlineLinks file move inline svm inline links
//
// swagger:model file_move_inline_svm_inline__links
type FileMoveInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline svm inline links
func (m *FileMoveInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline svm inline links based on the context it is used
func (m *FileMoveInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineVolume FlexGroup volume in file move operation. Only used in a FlexGroup volume file move operation.
//
// swagger:model file_move_inline_volume
type FileMoveInlineVolume struct {

	// links
	Links *FileMoveInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this file move inline volume
func (m *FileMoveInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline volume based on the context it is used
func (m *FileMoveInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineVolume) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FileMoveInlineVolumeInlineLinks file move inline volume inline links
//
// swagger:model file_move_inline_volume_inline__links
type FileMoveInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this file move inline volume inline links
func (m *FileMoveInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this file move inline volume inline links based on the context it is used
func (m *FileMoveInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FileMoveInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FileMoveInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FileMoveInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FileMoveInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
