// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FirmwareDisk firmware disk
//
// swagger:model firmware_disk
type FirmwareDisk struct {

	// Average firmware update duration per disk (in seconds).
	// Example: 120
	// Read Only: true
	AverageDurationPerDisk *int64 `json:"average_duration_per_disk,omitempty"`

	// The number of disks waiting to download the firmware update.
	// Example: 0
	// Read Only: true
	NumWaitingDownload *int64 `json:"num_waiting_download,omitempty"`

	// Estimated firmware update duration to completion (in minutes).
	// Example: 0
	// Read Only: true
	TotalCompletionEstimate *int64 `json:"total_completion_estimate,omitempty"`

	// Status of the background disk firmware update.
	// Read Only: true
	// Enum: ["running","idle"]
	UpdateStatus interface{} `json:"update_status,omitempty"`
}

// Validate validates this firmware disk
func (m *FirmwareDisk) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this firmware disk based on the context it is used
func (m *FirmwareDisk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAverageDurationPerDisk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumWaitingDownload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalCompletionEstimate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareDisk) contextValidateAverageDurationPerDisk(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "average_duration_per_disk", "body", m.AverageDurationPerDisk); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareDisk) contextValidateNumWaitingDownload(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_waiting_download", "body", m.NumWaitingDownload); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareDisk) contextValidateTotalCompletionEstimate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_completion_estimate", "body", m.TotalCompletionEstimate); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareDisk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareDisk) UnmarshalBinary(b []byte) error {
	var res FirmwareDisk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
