// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FirmwareHistoryUpdateState firmware history update state
//
// swagger:model firmware_history_update_state
type FirmwareHistoryUpdateState struct {

	// worker
	Worker *FirmwareHistoryUpdateStateInlineWorker `json:"worker,omitempty"`
}

// Validate validates this firmware history update state
func (m *FirmwareHistoryUpdateState) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateWorker(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateState) validateWorker(formats strfmt.Registry) error {
	if swag.IsZero(m.Worker) { // not required
		return nil
	}

	if m.Worker != nil {
		if err := m.Worker.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this firmware history update state based on the context it is used
func (m *FirmwareHistoryUpdateState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateWorker(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateState) contextValidateWorker(ctx context.Context, formats strfmt.Registry) error {

	if m.Worker != nil {
		if err := m.Worker.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareHistoryUpdateState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareHistoryUpdateState) UnmarshalBinary(b []byte) error {
	var res FirmwareHistoryUpdateState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FirmwareHistoryUpdateStateInlineWorker firmware history update state inline worker
//
// swagger:model firmware_history_update_state_inline_worker
type FirmwareHistoryUpdateStateInlineWorker struct {

	// error
	Error *FirmwareHistoryUpdateStateError `json:"error,omitempty"`

	// node
	Node *FirmwareHistoryUpdateStateInlineWorkerInlineNode `json:"node,omitempty"`

	// The state of each worker that a node is controlling.
	// Example: waiting_to_retry
	// Enum: ["idle","working","complete","failed","waiting_to_retry"]
	State *string `json:"state,omitempty"`
}

// Validate validates this firmware history update state inline worker
func (m *FirmwareHistoryUpdateStateInlineWorker) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorker) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorker) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "node")
			}
			return err
		}
	}

	return nil
}

var firmwareHistoryUpdateStateInlineWorkerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","working","complete","failed","waiting_to_retry"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		firmwareHistoryUpdateStateInlineWorkerTypeStatePropEnum = append(firmwareHistoryUpdateStateInlineWorkerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// firmware_history_update_state_inline_worker
	// FirmwareHistoryUpdateStateInlineWorker
	// state
	// State
	// idle
	// END DEBUGGING
	// FirmwareHistoryUpdateStateInlineWorkerStateIdle captures enum value "idle"
	FirmwareHistoryUpdateStateInlineWorkerStateIdle string = "idle"

	// BEGIN DEBUGGING
	// firmware_history_update_state_inline_worker
	// FirmwareHistoryUpdateStateInlineWorker
	// state
	// State
	// working
	// END DEBUGGING
	// FirmwareHistoryUpdateStateInlineWorkerStateWorking captures enum value "working"
	FirmwareHistoryUpdateStateInlineWorkerStateWorking string = "working"

	// BEGIN DEBUGGING
	// firmware_history_update_state_inline_worker
	// FirmwareHistoryUpdateStateInlineWorker
	// state
	// State
	// complete
	// END DEBUGGING
	// FirmwareHistoryUpdateStateInlineWorkerStateComplete captures enum value "complete"
	FirmwareHistoryUpdateStateInlineWorkerStateComplete string = "complete"

	// BEGIN DEBUGGING
	// firmware_history_update_state_inline_worker
	// FirmwareHistoryUpdateStateInlineWorker
	// state
	// State
	// failed
	// END DEBUGGING
	// FirmwareHistoryUpdateStateInlineWorkerStateFailed captures enum value "failed"
	FirmwareHistoryUpdateStateInlineWorkerStateFailed string = "failed"

	// BEGIN DEBUGGING
	// firmware_history_update_state_inline_worker
	// FirmwareHistoryUpdateStateInlineWorker
	// state
	// State
	// waiting_to_retry
	// END DEBUGGING
	// FirmwareHistoryUpdateStateInlineWorkerStateWaitingToRetry captures enum value "waiting_to_retry"
	FirmwareHistoryUpdateStateInlineWorkerStateWaitingToRetry string = "waiting_to_retry"
)

// prop value enum
func (m *FirmwareHistoryUpdateStateInlineWorker) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, firmwareHistoryUpdateStateInlineWorkerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorker) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("worker"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this firmware history update state inline worker based on the context it is used
func (m *FirmwareHistoryUpdateStateInlineWorker) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorker) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorker) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareHistoryUpdateStateInlineWorker) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareHistoryUpdateStateInlineWorker) UnmarshalBinary(b []byte) error {
	var res FirmwareHistoryUpdateStateInlineWorker
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FirmwareHistoryUpdateStateInlineWorkerInlineNode firmware history update state inline worker inline node
//
// swagger:model firmware_history_update_state_inline_worker_inline_node
type FirmwareHistoryUpdateStateInlineWorkerInlineNode struct {

	// links
	Links *FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this firmware history update state inline worker inline node
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this firmware history update state inline worker inline node based on the context it is used
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNode) UnmarshalBinary(b []byte) error {
	var res FirmwareHistoryUpdateStateInlineWorkerInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks firmware history update state inline worker inline node inline links
//
// swagger:model firmware_history_update_state_inline_worker_inline_node_inline__links
type FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this firmware history update state inline worker inline node inline links
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this firmware history update state inline worker inline node inline links based on the context it is used
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FirmwareHistoryUpdateStateInlineWorkerInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
