// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FirmwareSpBmc firmware sp bmc
//
// swagger:model firmware_sp_bmc
type FirmwareSpBmc struct {

	// autoupdate
	// Example: false
	Autoupdate *bool `json:"autoupdate,omitempty"`

	// end time
	// Example: 2020-05-17 20:00:00+00:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// fw type
	// Example: SP
	// Read Only: true
	// Enum: ["SP","BMC"]
	FwType *string `json:"fw_type,omitempty"`

	// image
	// Example: primary
	// Read Only: true
	// Enum: ["primary","backup"]
	Image *string `json:"image,omitempty"`

	// in progress
	// Read Only: true
	InProgress *bool `json:"in_progress,omitempty"`

	// is current
	// Example: true
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// last update state
	// Example: passed
	// Read Only: true
	// Enum: ["passed","failed"]
	LastUpdateState *string `json:"last_update_state,omitempty"`

	// percent done
	// Example: 100
	// Read Only: true
	// Maximum: 100
	// Minimum: 0
	PercentDone *int64 `json:"percent_done,omitempty"`

	// running version
	// Example: 1.2.3.4
	// Read Only: true
	RunningVersion *string `json:"running_version,omitempty"`

	// start time
	// Example: 2020-05-17 20:00:00+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// state
	// Example: installed
	// Read Only: true
	// Enum: ["installed","corrupt","updating","autoupdating","none"]
	State *string `json:"state,omitempty"`
}

// Validate validates this firmware sp bmc
func (m *FirmwareSpBmc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFwType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateImage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePercentDone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareSpBmc) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var firmwareSpBmcTypeFwTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SP","BMC"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		firmwareSpBmcTypeFwTypePropEnum = append(firmwareSpBmcTypeFwTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// fw_type
	// FwType
	// SP
	// END DEBUGGING
	// FirmwareSpBmcFwTypeSP captures enum value "SP"
	FirmwareSpBmcFwTypeSP string = "SP"

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// fw_type
	// FwType
	// BMC
	// END DEBUGGING
	// FirmwareSpBmcFwTypeBMC captures enum value "BMC"
	FirmwareSpBmcFwTypeBMC string = "BMC"
)

// prop value enum
func (m *FirmwareSpBmc) validateFwTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, firmwareSpBmcTypeFwTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FirmwareSpBmc) validateFwType(formats strfmt.Registry) error {
	if swag.IsZero(m.FwType) { // not required
		return nil
	}

	// value enum
	if err := m.validateFwTypeEnum("fw_type", "body", *m.FwType); err != nil {
		return err
	}

	return nil
}

var firmwareSpBmcTypeImagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["primary","backup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		firmwareSpBmcTypeImagePropEnum = append(firmwareSpBmcTypeImagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// image
	// Image
	// primary
	// END DEBUGGING
	// FirmwareSpBmcImagePrimary captures enum value "primary"
	FirmwareSpBmcImagePrimary string = "primary"

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// image
	// Image
	// backup
	// END DEBUGGING
	// FirmwareSpBmcImageBackup captures enum value "backup"
	FirmwareSpBmcImageBackup string = "backup"
)

// prop value enum
func (m *FirmwareSpBmc) validateImageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, firmwareSpBmcTypeImagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FirmwareSpBmc) validateImage(formats strfmt.Registry) error {
	if swag.IsZero(m.Image) { // not required
		return nil
	}

	// value enum
	if err := m.validateImageEnum("image", "body", *m.Image); err != nil {
		return err
	}

	return nil
}

var firmwareSpBmcTypeLastUpdateStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["passed","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		firmwareSpBmcTypeLastUpdateStatePropEnum = append(firmwareSpBmcTypeLastUpdateStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// last_update_state
	// LastUpdateState
	// passed
	// END DEBUGGING
	// FirmwareSpBmcLastUpdateStatePassed captures enum value "passed"
	FirmwareSpBmcLastUpdateStatePassed string = "passed"

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// last_update_state
	// LastUpdateState
	// failed
	// END DEBUGGING
	// FirmwareSpBmcLastUpdateStateFailed captures enum value "failed"
	FirmwareSpBmcLastUpdateStateFailed string = "failed"
)

// prop value enum
func (m *FirmwareSpBmc) validateLastUpdateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, firmwareSpBmcTypeLastUpdateStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FirmwareSpBmc) validateLastUpdateState(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdateState) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastUpdateStateEnum("last_update_state", "body", *m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) validatePercentDone(formats strfmt.Registry) error {
	if swag.IsZero(m.PercentDone) { // not required
		return nil
	}

	if err := validate.MinimumInt("percent_done", "body", *m.PercentDone, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("percent_done", "body", *m.PercentDone, 100, false); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var firmwareSpBmcTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","autoupdating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		firmwareSpBmcTypeStatePropEnum = append(firmwareSpBmcTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// state
	// State
	// installed
	// END DEBUGGING
	// FirmwareSpBmcStateInstalled captures enum value "installed"
	FirmwareSpBmcStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// state
	// State
	// corrupt
	// END DEBUGGING
	// FirmwareSpBmcStateCorrupt captures enum value "corrupt"
	FirmwareSpBmcStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// state
	// State
	// updating
	// END DEBUGGING
	// FirmwareSpBmcStateUpdating captures enum value "updating"
	FirmwareSpBmcStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// state
	// State
	// autoupdating
	// END DEBUGGING
	// FirmwareSpBmcStateAutoupdating captures enum value "autoupdating"
	FirmwareSpBmcStateAutoupdating string = "autoupdating"

	// BEGIN DEBUGGING
	// firmware_sp_bmc
	// FirmwareSpBmc
	// state
	// State
	// none
	// END DEBUGGING
	// FirmwareSpBmcStateNone captures enum value "none"
	FirmwareSpBmcStateNone string = "none"
)

// prop value enum
func (m *FirmwareSpBmc) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, firmwareSpBmcTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FirmwareSpBmc) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this firmware sp bmc based on the context it is used
func (m *FirmwareSpBmc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFwType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentDone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRunningVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareSpBmc) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "end_time", "body", m.EndTime); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateFwType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fw_type", "body", m.FwType); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateImage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "image", "body", m.Image); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateInProgress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "in_progress", "body", m.InProgress); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateLastUpdateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_update_state", "body", m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidatePercentDone(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "percent_done", "body", m.PercentDone); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateRunningVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "running_version", "body", m.RunningVersion); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareSpBmc) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareSpBmc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareSpBmc) UnmarshalBinary(b []byte) error {
	var res FirmwareSpBmc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
