// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FirmwareUpdateProgressState firmware update progress state
//
// swagger:model firmware_update_progress_state
type FirmwareUpdateProgressState struct {

	// attempts
	// Example: 3
	// Read Only: true
	Attempts *int64 `json:"attempts,omitempty"`

	// Code corresponding to the status message.
	// Example: 2228325
	Code *int64 `json:"code,omitempty"`

	// Error message returned when a cluster firmware update job fails.
	// Example: Cannot open local staging ZIP file disk_firmware.zip
	Message *string `json:"message,omitempty"`

	// status
	// Read Only: true
	// Enum: ["idle","working","complete","failed","waiting_to_retry"]
	Status *string `json:"status,omitempty"`

	// worker node
	WorkerNode *FirmwareUpdateProgressStateInlineWorkerNode `json:"worker_node,omitempty"`
}

// Validate validates this firmware update progress state
func (m *FirmwareUpdateProgressState) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkerNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var firmwareUpdateProgressStateTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["idle","working","complete","failed","waiting_to_retry"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		firmwareUpdateProgressStateTypeStatusPropEnum = append(firmwareUpdateProgressStateTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// firmware_update_progress_state
	// FirmwareUpdateProgressState
	// status
	// Status
	// idle
	// END DEBUGGING
	// FirmwareUpdateProgressStateStatusIdle captures enum value "idle"
	FirmwareUpdateProgressStateStatusIdle string = "idle"

	// BEGIN DEBUGGING
	// firmware_update_progress_state
	// FirmwareUpdateProgressState
	// status
	// Status
	// working
	// END DEBUGGING
	// FirmwareUpdateProgressStateStatusWorking captures enum value "working"
	FirmwareUpdateProgressStateStatusWorking string = "working"

	// BEGIN DEBUGGING
	// firmware_update_progress_state
	// FirmwareUpdateProgressState
	// status
	// Status
	// complete
	// END DEBUGGING
	// FirmwareUpdateProgressStateStatusComplete captures enum value "complete"
	FirmwareUpdateProgressStateStatusComplete string = "complete"

	// BEGIN DEBUGGING
	// firmware_update_progress_state
	// FirmwareUpdateProgressState
	// status
	// Status
	// failed
	// END DEBUGGING
	// FirmwareUpdateProgressStateStatusFailed captures enum value "failed"
	FirmwareUpdateProgressStateStatusFailed string = "failed"

	// BEGIN DEBUGGING
	// firmware_update_progress_state
	// FirmwareUpdateProgressState
	// status
	// Status
	// waiting_to_retry
	// END DEBUGGING
	// FirmwareUpdateProgressStateStatusWaitingToRetry captures enum value "waiting_to_retry"
	FirmwareUpdateProgressStateStatusWaitingToRetry string = "waiting_to_retry"
)

// prop value enum
func (m *FirmwareUpdateProgressState) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, firmwareUpdateProgressStateTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FirmwareUpdateProgressState) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareUpdateProgressState) validateWorkerNode(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkerNode) { // not required
		return nil
	}

	if m.WorkerNode != nil {
		if err := m.WorkerNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker_node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this firmware update progress state based on the context it is used
func (m *FirmwareUpdateProgressState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAttempts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkerNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareUpdateProgressState) contextValidateAttempts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "attempts", "body", m.Attempts); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareUpdateProgressState) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *FirmwareUpdateProgressState) contextValidateWorkerNode(ctx context.Context, formats strfmt.Registry) error {

	if m.WorkerNode != nil {
		if err := m.WorkerNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker_node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareUpdateProgressState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareUpdateProgressState) UnmarshalBinary(b []byte) error {
	var res FirmwareUpdateProgressState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FirmwareUpdateProgressStateInlineWorkerNode firmware update progress state inline worker node
//
// swagger:model firmware_update_progress_state_inline_worker_node
type FirmwareUpdateProgressStateInlineWorkerNode struct {

	// links
	Links *FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this firmware update progress state inline worker node
func (m *FirmwareUpdateProgressStateInlineWorkerNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareUpdateProgressStateInlineWorkerNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this firmware update progress state inline worker node based on the context it is used
func (m *FirmwareUpdateProgressStateInlineWorkerNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareUpdateProgressStateInlineWorkerNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareUpdateProgressStateInlineWorkerNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareUpdateProgressStateInlineWorkerNode) UnmarshalBinary(b []byte) error {
	var res FirmwareUpdateProgressStateInlineWorkerNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks firmware update progress state inline worker node inline links
//
// swagger:model firmware_update_progress_state_inline_worker_node_inline__links
type FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this firmware update progress state inline worker node inline links
func (m *FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this firmware update progress state inline worker node inline links based on the context it is used
func (m *FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("worker_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res FirmwareUpdateProgressStateInlineWorkerNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
