// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Flexcache Defines the cache endpoint of FlexCache.
//
// swagger:model flexcache
type Flexcache struct {

	// links
	Links *FlexcacheInlineLinks `json:"_links,omitempty"`

	// atime scrub
	AtimeScrub *FlexcacheInlineAtimeScrub `json:"atime_scrub,omitempty"`

	// cifs
	Cifs *FlexcacheInlineCifs `json:"cifs,omitempty"`

	// cifs change notify
	CifsChangeNotify *FlexcacheInlineCifsChangeNotify `json:"cifs_change_notify,omitempty"`

	// Specifies the number of constituents in the FlexGroup volume upon FlexCache create (POST).
	// Example: 8
	// Minimum: 1
	ConstituentCount *int64 `json:"constituent_count,omitempty"`

	// Number of FlexCache constituents per aggregate when the 'aggregates' field is mentioned.
	// Example: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// If set to true, a DR cache is created.
	DrCache *bool `json:"dr_cache,omitempty"`

	// flexcache inline aggregates
	FlexcacheInlineAggregates []*FlexcacheInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// flexcache inline origins
	FlexcacheInlineOrigins []*FlexcacheRelationship `json:"origins,omitempty"`

	// Specifies whether or not a FlexCache volume has global file locking mode enabled. Global file locking mode is a mode where protocol read locking semantics are enforced across all FlexCaches and origins of a FlexCache volume. When global file locking mode is enabled, the "is_disconnected_mode_off_for_locks" flag is always set to "true".
	GlobalFileLockingEnabled *bool `json:"global_file_locking_enabled,omitempty"`

	// guarantee
	Guarantee *FlexcacheInlineGuarantee `json:"guarantee,omitempty"`

	// FlexCache name
	// Example: vol1
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nfsv4
	Nfsv4 *FlexcacheInlineNfsv4 `json:"nfsv4,omitempty"`

	// If set to true, a plaintext FlexCache volume for an encrypted origin volume is created.
	OverrideEncryption *bool `json:"override_encryption,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the FlexCache is mounted. The path is case insensitive and must be unique within a SVM's namespace. Path must begin with '/' and must not end with '/'. Only one FlexCache be mounted at any given junction path.
	// Example: /user/my_fc
	Path *string `json:"path,omitempty"`

	// prepopulate
	Prepopulate *FlexcacheInlinePrepopulate `json:"prepopulate,omitempty"`

	// relative size
	RelativeSize *FlexcacheInlineRelativeSize `json:"relative_size,omitempty"`

	// s3
	S3 *FlexcacheInlineS3 `json:"s3,omitempty"`

	// Physical size of the FlexCache. The recommended size for a FlexCache is 10% of the origin volume. The minimum FlexCache constituent size is 1GB.
	Size *int64 `json:"size,omitempty"`

	// svm
	Svm *FlexcacheInlineSvm `json:"svm,omitempty"`

	// Specifies whether or not a Fabricpool-enabled aggregate can be used in FlexCache creation. The use_tiered_aggregate is only used when auto-provisioning a FlexCache volume.
	UseTieredAggregate *bool `json:"use_tiered_aggregate,omitempty"`

	// FlexCache UUID. Unique identifier for the FlexCache.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// writeback
	Writeback *FlexcacheInlineWriteback `json:"writeback,omitempty"`
}

// Validate validates this flexcache
func (m *Flexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAtimeScrub(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCifsChangeNotify(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConstituentCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcacheInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcacheInlineOrigins(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNfsv4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrepopulate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelativeSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWriteback(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Flexcache) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateAtimeScrub(formats strfmt.Registry) error {
	if swag.IsZero(m.AtimeScrub) { // not required
		return nil
	}

	if m.AtimeScrub != nil {
		if err := m.AtimeScrub.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("atime_scrub")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateCifsChangeNotify(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsChangeNotify) { // not required
		return nil
	}

	if m.CifsChangeNotify != nil {
		if err := m.CifsChangeNotify.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_change_notify")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateConstituentCount(formats strfmt.Registry) error {
	if swag.IsZero(m.ConstituentCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("constituent_count", "body", *m.ConstituentCount, 1, false); err != nil {
		return err
	}

	return nil
}

func (m *Flexcache) validateFlexcacheInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.FlexcacheInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.FlexcacheInlineAggregates); i++ {
		if swag.IsZero(m.FlexcacheInlineAggregates[i]) { // not required
			continue
		}

		if m.FlexcacheInlineAggregates[i] != nil {
			if err := m.FlexcacheInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Flexcache) validateFlexcacheInlineOrigins(formats strfmt.Registry) error {
	if swag.IsZero(m.FlexcacheInlineOrigins) { // not required
		return nil
	}

	for i := 0; i < len(m.FlexcacheInlineOrigins); i++ {
		if swag.IsZero(m.FlexcacheInlineOrigins[i]) { // not required
			continue
		}

		if m.FlexcacheInlineOrigins[i] != nil {
			if err := m.FlexcacheInlineOrigins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Flexcache) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *Flexcache) validateNfsv4(formats strfmt.Registry) error {
	if swag.IsZero(m.Nfsv4) { // not required
		return nil
	}

	if m.Nfsv4 != nil {
		if err := m.Nfsv4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfsv4")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validatePrepopulate(formats strfmt.Registry) error {
	if swag.IsZero(m.Prepopulate) { // not required
		return nil
	}

	if m.Prepopulate != nil {
		if err := m.Prepopulate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("prepopulate")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateRelativeSize(formats strfmt.Registry) error {
	if swag.IsZero(m.RelativeSize) { // not required
		return nil
	}

	if m.RelativeSize != nil {
		if err := m.RelativeSize.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relative_size")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateS3(formats strfmt.Registry) error {
	if swag.IsZero(m.S3) { // not required
		return nil
	}

	if m.S3 != nil {
		if err := m.S3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) validateWriteback(formats strfmt.Registry) error {
	if swag.IsZero(m.Writeback) { // not required
		return nil
	}

	if m.Writeback != nil {
		if err := m.Writeback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("writeback")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache based on the context it is used
func (m *Flexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAtimeScrub(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCifsChangeNotify(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcacheInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcacheInlineOrigins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNfsv4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePrepopulate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelativeSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Flexcache) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateAtimeScrub(ctx context.Context, formats strfmt.Registry) error {

	if m.AtimeScrub != nil {
		if err := m.AtimeScrub.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("atime_scrub")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateCifsChangeNotify(ctx context.Context, formats strfmt.Registry) error {

	if m.CifsChangeNotify != nil {
		if err := m.CifsChangeNotify.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cifs_change_notify")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateFlexcacheInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FlexcacheInlineAggregates); i++ {

		if m.FlexcacheInlineAggregates[i] != nil {
			if err := m.FlexcacheInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Flexcache) contextValidateFlexcacheInlineOrigins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FlexcacheInlineOrigins); i++ {

		if m.FlexcacheInlineOrigins[i] != nil {
			if err := m.FlexcacheInlineOrigins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Flexcache) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateNfsv4(ctx context.Context, formats strfmt.Registry) error {

	if m.Nfsv4 != nil {
		if err := m.Nfsv4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nfsv4")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidatePrepopulate(ctx context.Context, formats strfmt.Registry) error {

	if m.Prepopulate != nil {
		if err := m.Prepopulate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("prepopulate")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateRelativeSize(ctx context.Context, formats strfmt.Registry) error {

	if m.RelativeSize != nil {
		if err := m.RelativeSize.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relative_size")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateS3(ctx context.Context, formats strfmt.Registry) error {

	if m.S3 != nil {
		if err := m.S3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Flexcache) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Flexcache) contextValidateWriteback(ctx context.Context, formats strfmt.Registry) error {

	if m.Writeback != nil {
		if err := m.Writeback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("writeback")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Flexcache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Flexcache) UnmarshalBinary(b []byte) error {
	var res Flexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineAggregatesInlineArrayItem Aggregate
//
// swagger:model flexcache_inline_aggregates_inline_array_item
type FlexcacheInlineAggregatesInlineArrayItem struct {

	// links
	Links *FlexcacheInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this flexcache inline aggregates inline array item
func (m *FlexcacheInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline aggregates inline array item based on the context it is used
func (m *FlexcacheInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineAggregatesInlineArrayItemInlineLinks flexcache inline aggregates inline array item inline links
//
// swagger:model flexcache_inline_aggregates_inline_array_item_inline__links
type FlexcacheInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this flexcache inline aggregates inline array item inline links
func (m *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline aggregates inline array item inline links based on the context it is used
func (m *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineAtimeScrub FlexCache volume atime-based scrub
//
// swagger:model flexcache_inline_atime_scrub
type FlexcacheInlineAtimeScrub struct {

	// Specifies whether scrubbing of inactive files based on atime is enabled for the FlexCache volume. When scrubbing is enabled, files whose atime is older than the specified duration are evicted from the cache volume. The scrubber runs once a day and looks for files whose atime has exceeded the provisioned value.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the atime duration in days after which a cached file is considered inactive. Inactive files are purged from the FlexCache volumes when the scrubber runs once a day.
	Period *int16 `json:"period,omitempty"`
}

// Validate validates this flexcache inline atime scrub
func (m *FlexcacheInlineAtimeScrub) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline atime scrub based on context it is used
func (m *FlexcacheInlineAtimeScrub) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineAtimeScrub) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineAtimeScrub) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineAtimeScrub
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineCifs FlexCache CIFS
//
// swagger:model flexcache_inline_cifs
type FlexcacheInlineCifs struct {

	// Specifies whether CIFS access is enabled on the FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline cifs
func (m *FlexcacheInlineCifs) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline cifs based on context it is used
func (m *FlexcacheInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineCifs) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineCifsChangeNotify Notifies that a change has been made to the FlexCache volume CIFS.
//
// swagger:model flexcache_inline_cifs_change_notify
type FlexcacheInlineCifsChangeNotify struct {

	// Specifies whether a CIFS change notification is enabled for the FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline cifs change notify
func (m *FlexcacheInlineCifsChangeNotify) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline cifs change notify based on context it is used
func (m *FlexcacheInlineCifsChangeNotify) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineCifsChangeNotify) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineCifsChangeNotify) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineCifsChangeNotify
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineGuarantee flexcache inline guarantee
//
// swagger:model flexcache_inline_guarantee
type FlexcacheInlineGuarantee struct {

	// The type of space guarantee of this volume in the aggregate.
	// Enum: ["volume","none"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this flexcache inline guarantee
func (m *FlexcacheInlineGuarantee) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var flexcacheInlineGuaranteeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		flexcacheInlineGuaranteeTypeTypePropEnum = append(flexcacheInlineGuaranteeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// flexcache_inline_guarantee
	// FlexcacheInlineGuarantee
	// type
	// Type
	// volume
	// END DEBUGGING
	// FlexcacheInlineGuaranteeTypeVolume captures enum value "volume"
	FlexcacheInlineGuaranteeTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// flexcache_inline_guarantee
	// FlexcacheInlineGuarantee
	// type
	// Type
	// none
	// END DEBUGGING
	// FlexcacheInlineGuaranteeTypeNone captures enum value "none"
	FlexcacheInlineGuaranteeTypeNone string = "none"
)

// prop value enum
func (m *FlexcacheInlineGuarantee) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, flexcacheInlineGuaranteeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FlexcacheInlineGuarantee) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("guarantee"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this flexcache inline guarantee based on context it is used
func (m *FlexcacheInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineLinks flexcache inline links
//
// swagger:model flexcache_inline__links
type FlexcacheInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this flexcache inline links
func (m *FlexcacheInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline links based on the context it is used
func (m *FlexcacheInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineNfsv4 FlexCache NFSv4
//
// swagger:model flexcache_inline_nfsv4
type FlexcacheInlineNfsv4 struct {

	// Specifies whether NFSv4 access is enabled on the FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline nfsv4
func (m *FlexcacheInlineNfsv4) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline nfsv4 based on context it is used
func (m *FlexcacheInlineNfsv4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineNfsv4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineNfsv4) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineNfsv4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlinePrepopulate FlexCache prepopulate
//
// swagger:model flexcache_inline_prepopulate
type FlexcacheInlinePrepopulate struct {

	// dir paths
	DirPaths []*string `json:"dir_paths,omitempty"`

	// exclude dir paths
	ExcludeDirPaths []*string `json:"exclude_dir_paths,omitempty"`

	// Specifies whether or not the prepopulate action should search through the `dir_paths` recursively. If not set, the default value _true_ is used.
	Recurse *bool `json:"recurse,omitempty"`
}

// Validate validates this flexcache inline prepopulate
func (m *FlexcacheInlinePrepopulate) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline prepopulate based on context it is used
func (m *FlexcacheInlinePrepopulate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlinePrepopulate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlinePrepopulate) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlinePrepopulate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineRelativeSize FlexCache Relative Size
//
// swagger:model flexcache_inline_relative_size
type FlexcacheInlineRelativeSize struct {

	// Specifies whether the relative sizing is enabled for the FlexCache volume. Relative sizing is introduced as a part of follow the origin feature. When relative sizing is enabled, it blocks any modifications done manually in the absolute size of the FlexCache volume. The size of the FlexCache volume is calculated and entered automatically based on the size of the origin volume.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the percent size the FlexCache volume should have relative to the total size of the origin volume. This property is only relevant to a FlexCache volume that has the relative size property enabled.
	Percentage *int16 `json:"percentage,omitempty"`
}

// Validate validates this flexcache inline relative size
func (m *FlexcacheInlineRelativeSize) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline relative size based on context it is used
func (m *FlexcacheInlineRelativeSize) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineRelativeSize) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineRelativeSize) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineRelativeSize
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineS3 Flexcache S3
//
// swagger:model flexcache_inline_s3
type FlexcacheInlineS3 struct {

	// Indicates whether S3 access is enabled on the Flexcache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline s3
func (m *FlexcacheInlineS3) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline s3 based on context it is used
func (m *FlexcacheInlineS3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineS3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineS3) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineS3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineSvm FlexCache SVM
//
// swagger:model flexcache_inline_svm
type FlexcacheInlineSvm struct {

	// links
	Links *FlexcacheInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this flexcache inline svm
func (m *FlexcacheInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline svm based on the context it is used
func (m *FlexcacheInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineSvm) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineSvmInlineLinks flexcache inline svm inline links
//
// swagger:model flexcache_inline_svm_inline__links
type FlexcacheInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this flexcache inline svm inline links
func (m *FlexcacheInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline svm inline links based on the context it is used
func (m *FlexcacheInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FlexcacheInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FlexcacheInlineWriteback FlexCache Writeback
//
// swagger:model flexcache_inline_writeback
type FlexcacheInlineWriteback struct {

	// Indicates whether or not writeback is enabled for the FlexCache volume. Writeback is a storage method where data is first written to the FlexCache volume and then written to the origin of a FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline writeback
func (m *FlexcacheInlineWriteback) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline writeback based on context it is used
func (m *FlexcacheInlineWriteback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FlexcacheInlineWriteback) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FlexcacheInlineWriteback) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineWriteback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
