// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Fpolicy FPolicy is an infrastructure component of ONTAP that enables partner applications connected to your storage systems to monitor and set file access permissions. Every time a client accesses a file from a storage system, based on the configuration of FPolicy, the partner application is notified about file access.
//
// swagger:model fpolicy
type Fpolicy struct {

	// links
	Links *FpolicyInlineLinks `json:"_links,omitempty"`

	// fpolicy inline engines
	FpolicyInlineEngines []*FpolicyEngines `json:"engines,omitempty"`

	// fpolicy inline events
	FpolicyInlineEvents []*FpolicyEvents `json:"events,omitempty"`

	// fpolicy inline persistent stores
	FpolicyInlinePersistentStores []*FpolicyPersistentStores `json:"persistent_stores,omitempty"`

	// fpolicy inline policies
	FpolicyInlinePolicies []*FpolicyPolicies `json:"policies,omitempty"`

	// svm
	Svm *FpolicyInlineSvm `json:"svm,omitempty"`
}

// Validate validates this fpolicy
func (m *Fpolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFpolicyInlineEngines(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFpolicyInlineEvents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFpolicyInlinePersistentStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFpolicyInlinePolicies(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Fpolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Fpolicy) validateFpolicyInlineEngines(formats strfmt.Registry) error {
	if swag.IsZero(m.FpolicyInlineEngines) { // not required
		return nil
	}

	for i := 0; i < len(m.FpolicyInlineEngines); i++ {
		if swag.IsZero(m.FpolicyInlineEngines[i]) { // not required
			continue
		}

		if m.FpolicyInlineEngines[i] != nil {
			if err := m.FpolicyInlineEngines[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("engines" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) validateFpolicyInlineEvents(formats strfmt.Registry) error {
	if swag.IsZero(m.FpolicyInlineEvents) { // not required
		return nil
	}

	for i := 0; i < len(m.FpolicyInlineEvents); i++ {
		if swag.IsZero(m.FpolicyInlineEvents[i]) { // not required
			continue
		}

		if m.FpolicyInlineEvents[i] != nil {
			if err := m.FpolicyInlineEvents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("events" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) validateFpolicyInlinePersistentStores(formats strfmt.Registry) error {
	if swag.IsZero(m.FpolicyInlinePersistentStores) { // not required
		return nil
	}

	for i := 0; i < len(m.FpolicyInlinePersistentStores); i++ {
		if swag.IsZero(m.FpolicyInlinePersistentStores[i]) { // not required
			continue
		}

		if m.FpolicyInlinePersistentStores[i] != nil {
			if err := m.FpolicyInlinePersistentStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("persistent_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) validateFpolicyInlinePolicies(formats strfmt.Registry) error {
	if swag.IsZero(m.FpolicyInlinePolicies) { // not required
		return nil
	}

	for i := 0; i < len(m.FpolicyInlinePolicies); i++ {
		if swag.IsZero(m.FpolicyInlinePolicies[i]) { // not required
			continue
		}

		if m.FpolicyInlinePolicies[i] != nil {
			if err := m.FpolicyInlinePolicies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy based on the context it is used
func (m *Fpolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFpolicyInlineEngines(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFpolicyInlineEvents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFpolicyInlinePersistentStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFpolicyInlinePolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Fpolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Fpolicy) contextValidateFpolicyInlineEngines(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FpolicyInlineEngines); i++ {

		if m.FpolicyInlineEngines[i] != nil {
			if err := m.FpolicyInlineEngines[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("engines" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) contextValidateFpolicyInlineEvents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FpolicyInlineEvents); i++ {

		if m.FpolicyInlineEvents[i] != nil {
			if err := m.FpolicyInlineEvents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("events" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) contextValidateFpolicyInlinePersistentStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FpolicyInlinePersistentStores); i++ {

		if m.FpolicyInlinePersistentStores[i] != nil {
			if err := m.FpolicyInlinePersistentStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("persistent_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) contextValidateFpolicyInlinePolicies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FpolicyInlinePolicies); i++ {

		if m.FpolicyInlinePolicies[i] != nil {
			if err := m.FpolicyInlinePolicies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Fpolicy) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Fpolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Fpolicy) UnmarshalBinary(b []byte) error {
	var res Fpolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FpolicyInlineLinks fpolicy inline links
//
// swagger:model fpolicy_inline__links
type FpolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fpolicy inline links
func (m *FpolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy inline links based on the context it is used
func (m *FpolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res FpolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FpolicyInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model fpolicy_inline_svm
type FpolicyInlineSvm struct {

	// links
	Links *FpolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fpolicy inline svm
func (m *FpolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy inline svm based on the context it is used
func (m *FpolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res FpolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FpolicyInlineSvmInlineLinks fpolicy inline svm inline links
//
// swagger:model fpolicy_inline_svm_inline__links
type FpolicyInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this fpolicy inline svm inline links
func (m *FpolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy inline svm inline links based on the context it is used
func (m *FpolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FpolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
