// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FpolicyEvents The information that a FPolicy process needs to determine what file access operations to monitor and for which of the monitored events notifications should be sent to the external FPolicy server.
//
// swagger:model fpolicy_events
type FpolicyEvents struct {

	// file operations
	FileOperations *FpolicyEventsInlineFileOperations `json:"file_operations,omitempty"`

	// filters
	Filters *FpolicyEventsInlineFilters `json:"filters,omitempty"`

	// Specifies whether failed file operations monitoring is required.
	MonitorFileopFailure *bool `json:"monitor_fileop_failure,omitempty"`

	// Specifies the name of the FPolicy event.
	// Example: event_cifs
	Name *string `json:"name,omitempty"`

	// Protocol for which event is created. If you specify protocol, then you
	// must also specify a valid value for the file operation parameters.
	//   The value of this parameter must be one of the following:
	//     * cifs  - for the CIFS protocol.
	//     * nfsv3 - for the NFSv3 protocol.
	//     * nfsv4 - for the NFSv4 protocol.
	//
	// Enum: ["cifs","nfsv3","nfsv4"]
	Protocol *string `json:"protocol,omitempty"`

	// Specifies whether volume operation monitoring is required.
	VolumeMonitoring *bool `json:"volume_monitoring,omitempty"`
}

// Validate validates this fpolicy events
func (m *FpolicyEvents) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFileOperations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilters(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyEvents) validateFileOperations(formats strfmt.Registry) error {
	if swag.IsZero(m.FileOperations) { // not required
		return nil
	}

	if m.FileOperations != nil {
		if err := m.FileOperations.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file_operations")
			}
			return err
		}
	}

	return nil
}

func (m *FpolicyEvents) validateFilters(formats strfmt.Registry) error {
	if swag.IsZero(m.Filters) { // not required
		return nil
	}

	if m.Filters != nil {
		if err := m.Filters.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters")
			}
			return err
		}
	}

	return nil
}

var fpolicyEventsTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cifs","nfsv3","nfsv4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyEventsTypeProtocolPropEnum = append(fpolicyEventsTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fpolicy_events
	// FpolicyEvents
	// protocol
	// Protocol
	// cifs
	// END DEBUGGING
	// FpolicyEventsProtocolCifs captures enum value "cifs"
	FpolicyEventsProtocolCifs string = "cifs"

	// BEGIN DEBUGGING
	// fpolicy_events
	// FpolicyEvents
	// protocol
	// Protocol
	// nfsv3
	// END DEBUGGING
	// FpolicyEventsProtocolNfsv3 captures enum value "nfsv3"
	FpolicyEventsProtocolNfsv3 string = "nfsv3"

	// BEGIN DEBUGGING
	// fpolicy_events
	// FpolicyEvents
	// protocol
	// Protocol
	// nfsv4
	// END DEBUGGING
	// FpolicyEventsProtocolNfsv4 captures enum value "nfsv4"
	FpolicyEventsProtocolNfsv4 string = "nfsv4"
)

// prop value enum
func (m *FpolicyEvents) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyEventsTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FpolicyEvents) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fpolicy events based on the context it is used
func (m *FpolicyEvents) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFileOperations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyEvents) contextValidateFileOperations(ctx context.Context, formats strfmt.Registry) error {

	if m.FileOperations != nil {
		if err := m.FileOperations.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file_operations")
			}
			return err
		}
	}

	return nil
}

func (m *FpolicyEvents) contextValidateFilters(ctx context.Context, formats strfmt.Registry) error {

	if m.Filters != nil {
		if err := m.Filters.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyEvents) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyEvents) UnmarshalBinary(b []byte) error {
	var res FpolicyEvents
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FpolicyEventsInlineFileOperations Specifies the file operations for the FPolicy event. You must specify a valid protocol in the protocol parameter.
// The event will check the operations specified from all client requests using the protocol.
//
// swagger:model fpolicy_events_inline_file_operations
type FpolicyEventsInlineFileOperations struct {

	// Access operations
	Access *bool `json:"access,omitempty"`

	// File close operations
	Close *bool `json:"close,omitempty"`

	// File create operations
	Create *bool `json:"create,omitempty"`

	// Directory create operations
	CreateDir *bool `json:"create_dir,omitempty"`

	// File delete operations
	Delete *bool `json:"delete,omitempty"`

	// Directory delete operations
	DeleteDir *bool `json:"delete_dir,omitempty"`

	// Get attribute operations
	Getattr *bool `json:"getattr,omitempty"`

	// Link operations
	Link *bool `json:"link,omitempty"`

	// Lookup operations
	Lookup *bool `json:"lookup,omitempty"`

	// File open operations
	Open *bool `json:"open,omitempty"`

	// File read operations
	Read *bool `json:"read,omitempty"`

	// File rename operations
	Rename *bool `json:"rename,omitempty"`

	// Directory rename operations
	RenameDir *bool `json:"rename_dir,omitempty"`

	// Set attribute operations
	Setattr *bool `json:"setattr,omitempty"`

	// Symbolic link operations
	Symlink *bool `json:"symlink,omitempty"`

	// File write operations
	Write *bool `json:"write,omitempty"`
}

// Validate validates this fpolicy events inline file operations
func (m *FpolicyEventsInlineFileOperations) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fpolicy events inline file operations based on context it is used
func (m *FpolicyEventsInlineFileOperations) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyEventsInlineFileOperations) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyEventsInlineFileOperations) UnmarshalBinary(b []byte) error {
	var res FpolicyEventsInlineFileOperations
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FpolicyEventsInlineFilters Specifies the list of filters for a given file operation for the specified protocol.
// When you specify the filters, you must specify the valid protocols and a valid file operations.
//
// swagger:model fpolicy_events_inline_filters
type FpolicyEventsInlineFilters struct {

	// Filter the client request for close with modification.
	CloseWithModification *bool `json:"close_with_modification,omitempty"`

	// Filter the client request for close with read.
	CloseWithRead *bool `json:"close_with_read,omitempty"`

	// Filter the client request for close without modification.
	CloseWithoutModification *bool `json:"close_without_modification,omitempty"`

	// Filter the client requests for directory operations. When this filter is specified directory operations are not monitored.
	ExcludeDirectory *bool `json:"exclude_directory,omitempty"`

	// Filter the client requests for the first-read.
	FirstRead *bool `json:"first_read,omitempty"`

	// Filter the client requests for the first-write.
	FirstWrite *bool `json:"first_write,omitempty"`

	// Filter the client request for alternate data stream.
	MonitorAds *bool `json:"monitor_ads,omitempty"`

	// Filter the client request for offline bit set. FPolicy server receives notification only when offline files are accessed.
	OfflineBit *bool `json:"offline_bit,omitempty"`

	// Filter the client request for open with delete intent.
	OpenWithDeleteIntent *bool `json:"open_with_delete_intent,omitempty"`

	// Filter the client request for open with write intent.
	OpenWithWriteIntent *bool `json:"open_with_write_intent,omitempty"`

	// Filter the client setattr requests for changing the access time of a file or directory.
	SetattrWithAccessTimeChange *bool `json:"setattr_with_access_time_change,omitempty"`

	// Filter the client setattr requests for changing the allocation size of a file.
	SetattrWithAllocationSizeChange *bool `json:"setattr_with_allocation_size_change,omitempty"`

	// Filter the client setattr requests for changing the creation time of a file or directory.
	SetattrWithCreationTimeChange *bool `json:"setattr_with_creation_time_change,omitempty"`

	// Filter the client setattr requests for changing dacl on a file or directory.
	SetattrWithDaclChange *bool `json:"setattr_with_dacl_change,omitempty"`

	// Filter the client setattr requests for changing group of a file or directory.
	SetattrWithGroupChange *bool `json:"setattr_with_group_change,omitempty"`

	// Filter the client setattr requests for changing the mode bits on a file or directory.
	SetattrWithModeChange *bool `json:"setattr_with_mode_change,omitempty"`

	// Filter the client setattr requests for changing the modification time of a file or directory.
	SetattrWithModifyTimeChange *bool `json:"setattr_with_modify_time_change,omitempty"`

	// Filter the client setattr requests for changing owner of a file or directory.
	SetattrWithOwnerChange *bool `json:"setattr_with_owner_change,omitempty"`

	// Filter the client setattr requests for changing sacl on a file or directory.
	SetattrWithSaclChange *bool `json:"setattr_with_sacl_change,omitempty"`

	// Filter the client setattr requests for changing the size of a file.
	SetattrWithSizeChange *bool `json:"setattr_with_size_change,omitempty"`

	// Filter the client request for write with size change.
	WriteWithSizeChange *bool `json:"write_with_size_change,omitempty"`
}

// Validate validates this fpolicy events inline filters
func (m *FpolicyEventsInlineFilters) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this fpolicy events inline filters based on context it is used
func (m *FpolicyEventsInlineFilters) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyEventsInlineFilters) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyEventsInlineFilters) UnmarshalBinary(b []byte) error {
	var res FpolicyEventsInlineFilters
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
