// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FpolicyPersistentStore The information that an FPolicy process needs in order to configure a Persistent Store.
//
// swagger:model fpolicy_persistent_store
type FpolicyPersistentStore struct {

	// Autosize mode for the volume.<br>grow &dash; Volume automatically grows in response to the amount of space used.<br>grow_shrink &dash; Volume grows or shrinks in response to the amount of space used.<br>off &dash; Autosizing of the volume is disabled.
	// Enum: ["grow","grow_shrink","off"]
	AutosizeMode *string `json:"autosize_mode,omitempty"`

	// The name specified for the FPolicy Persistent Store.
	// Example: ps1
	Name *string `json:"name,omitempty"`

	// The size of the Persistent Store volume, in bytes.
	// Example: 100M
	Size *int64 `json:"size,omitempty"`

	// svm
	Svm *FpolicyPersistentStoreInlineSvm `json:"svm,omitempty"`

	// The specified volume to store the events for the FPolicy Persistent Store.
	// Example: psvol
	Volume *string `json:"volume,omitempty"`
}

// Validate validates this fpolicy persistent store
func (m *FpolicyPersistentStore) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutosizeMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fpolicyPersistentStoreTypeAutosizeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["grow","grow_shrink","off"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyPersistentStoreTypeAutosizeModePropEnum = append(fpolicyPersistentStoreTypeAutosizeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fpolicy_persistent_store
	// FpolicyPersistentStore
	// autosize_mode
	// AutosizeMode
	// grow
	// END DEBUGGING
	// FpolicyPersistentStoreAutosizeModeGrow captures enum value "grow"
	FpolicyPersistentStoreAutosizeModeGrow string = "grow"

	// BEGIN DEBUGGING
	// fpolicy_persistent_store
	// FpolicyPersistentStore
	// autosize_mode
	// AutosizeMode
	// grow_shrink
	// END DEBUGGING
	// FpolicyPersistentStoreAutosizeModeGrowShrink captures enum value "grow_shrink"
	FpolicyPersistentStoreAutosizeModeGrowShrink string = "grow_shrink"

	// BEGIN DEBUGGING
	// fpolicy_persistent_store
	// FpolicyPersistentStore
	// autosize_mode
	// AutosizeMode
	// off
	// END DEBUGGING
	// FpolicyPersistentStoreAutosizeModeOff captures enum value "off"
	FpolicyPersistentStoreAutosizeModeOff string = "off"
)

// prop value enum
func (m *FpolicyPersistentStore) validateAutosizeModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyPersistentStoreTypeAutosizeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FpolicyPersistentStore) validateAutosizeMode(formats strfmt.Registry) error {
	if swag.IsZero(m.AutosizeMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateAutosizeModeEnum("autosize_mode", "body", *m.AutosizeMode); err != nil {
		return err
	}

	return nil
}

func (m *FpolicyPersistentStore) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fpolicy persistent store based on the context it is used
func (m *FpolicyPersistentStore) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyPersistentStore) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyPersistentStore) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyPersistentStore) UnmarshalBinary(b []byte) error {
	var res FpolicyPersistentStore
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FpolicyPersistentStoreInlineSvm fpolicy persistent store inline svm
//
// swagger:model fpolicy_persistent_store_inline_svm
type FpolicyPersistentStoreInlineSvm struct {

	// SVM UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fpolicy persistent store inline svm
func (m *FpolicyPersistentStoreInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fpolicy persistent store inline svm based on the context it is used
func (m *FpolicyPersistentStoreInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FpolicyPersistentStoreInlineSvm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "svm"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyPersistentStoreInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyPersistentStoreInlineSvm) UnmarshalBinary(b []byte) error {
	var res FpolicyPersistentStoreInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
