// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FpolicyPersistentStores The information that an FPolicy process needs in order to configure a Persistent Store.
//
// swagger:model fpolicy_persistent_stores
type FpolicyPersistentStores struct {

	// Autosize mode for the volume.<br>grow &dash; Volume automatically grows in response to the amount of space used.<br>grow_shrink &dash; Volume grows or shrinks in response to the amount of space used.<br>off &dash; Autosizing of the volume is disabled.
	// Enum: ["grow","grow_shrink","off"]
	AutosizeMode *string `json:"autosize_mode,omitempty"`

	// The name specified for the FPolicy Persistent Store.
	// Example: ps1
	Name *string `json:"name,omitempty"`

	// The size of the Persistent Store volume, in bytes.
	// Example: 100M
	Size *int64 `json:"size,omitempty"`

	// The specified volume to store the events for the FPolicy Persistent Store.
	// Example: psvol
	Volume *string `json:"volume,omitempty"`
}

// Validate validates this fpolicy persistent stores
func (m *FpolicyPersistentStores) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutosizeMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var fpolicyPersistentStoresTypeAutosizeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["grow","grow_shrink","off"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fpolicyPersistentStoresTypeAutosizeModePropEnum = append(fpolicyPersistentStoresTypeAutosizeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fpolicy_persistent_stores
	// FpolicyPersistentStores
	// autosize_mode
	// AutosizeMode
	// grow
	// END DEBUGGING
	// FpolicyPersistentStoresAutosizeModeGrow captures enum value "grow"
	FpolicyPersistentStoresAutosizeModeGrow string = "grow"

	// BEGIN DEBUGGING
	// fpolicy_persistent_stores
	// FpolicyPersistentStores
	// autosize_mode
	// AutosizeMode
	// grow_shrink
	// END DEBUGGING
	// FpolicyPersistentStoresAutosizeModeGrowShrink captures enum value "grow_shrink"
	FpolicyPersistentStoresAutosizeModeGrowShrink string = "grow_shrink"

	// BEGIN DEBUGGING
	// fpolicy_persistent_stores
	// FpolicyPersistentStores
	// autosize_mode
	// AutosizeMode
	// off
	// END DEBUGGING
	// FpolicyPersistentStoresAutosizeModeOff captures enum value "off"
	FpolicyPersistentStoresAutosizeModeOff string = "off"
)

// prop value enum
func (m *FpolicyPersistentStores) validateAutosizeModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fpolicyPersistentStoresTypeAutosizeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FpolicyPersistentStores) validateAutosizeMode(formats strfmt.Registry) error {
	if swag.IsZero(m.AutosizeMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateAutosizeModeEnum("autosize_mode", "body", *m.AutosizeMode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this fpolicy persistent stores based on context it is used
func (m *FpolicyPersistentStores) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FpolicyPersistentStores) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FpolicyPersistentStores) UnmarshalBinary(b []byte) error {
	var res FpolicyPersistentStores
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
