// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GcpKms gcp kms
//
// swagger:model gcp_kms
type GcpKms struct {

	// links
	Links *GcpKmsInlineLinks `json:"_links,omitempty"`

	// The Google Cloud application's service account credentials required to access the specified KMS. The client_email and private_key fields of the service account holder are required. The credentials are required if the `authentication_method` is set to `application_credentials_key`.
	// Example: {\"private_key\":\"ValidPrivateKey\",\"client_email\":\"my@account.email.com\"}
	// Format: password
	ApplicationCredentials *strfmt.Password `json:"application_credentials,omitempty"`

	// Google Cloud KMS authentication method.
	// Example: application_credentials_key
	// Enum: ["application_credentials_key","sa_credentials_attachment"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// Google Cloud KMS caller account email
	// Example: myaccount@myproject.com
	// Read Only: true
	CallerAccount *string `json:"caller_account,omitempty"`

	// Google Cloud KMS host subdomain.
	// Example: cloudkms.googleapis.com
	CloudkmsHost *string `json:"cloudkms_host,omitempty"`

	// A custom metadata server URL used for retrieving short lived authentication tokens if the default service account is not used. This is only applicable when the `authentication_method` is set to `sa_credentials_attachment`.
	// Example: http://169.254.169.254/computeMetadata/v1/instance/service-accounts/default/token
	// Format: uri
	GceMetadataServer *strfmt.URI `json:"gce_metadata_server,omitempty"`

	// gcp kms inline ekmip reachability
	// Read Only: true
	GcpKmsInlineEkmipReachability []*GcpKmsInlineEkmipReachabilityInlineArrayItem `json:"ekmip_reachability,omitempty"`

	// google reachability
	GoogleReachability *GcpKmsInlineGoogleReachability `json:"google_reachability,omitempty"`

	// Key Identifier of Google Cloud KMS key encryption key.
	// Example: cryptokey1
	KeyName *string `json:"key_name,omitempty"`

	// Google Cloud KMS key ring location.
	// Example: global
	KeyRingLocation *string `json:"key_ring_location,omitempty"`

	// Google Cloud KMS key ring name of the deployed Google Cloud application.
	// Example: gcpapp1-keyring
	KeyRingName *string `json:"key_ring_name,omitempty"`

	// Open authorization server host name.
	// Example: oauth2.googleapis.com
	OauthHost *string `json:"oauth_host,omitempty"`

	// Open authorization URL for the access token.
	// Example: https://oauth2.googleapis.com/token
	OauthURL *string `json:"oauth_url,omitempty"`

	// Authorization server and Google Cloud KMS port number.
	// Example: 443
	Port *int64 `json:"port,omitempty"`

	// Google Cloud KMS account to impersonate.
	// Example: myserviceaccount@myproject.iam.gserviceaccount.com
	PrivilegedAccount *string `json:"privileged_account,omitempty"`

	// Google Cloud project (application) ID of the deployed Google Cloud application that has appropriate access to the Google Cloud KMS.
	// Example: gcpapp1
	ProjectID *string `json:"project_id,omitempty"`

	// Proxy host name.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy port number.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Type of proxy.
	// Example: http
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// state
	State *GcpKmsInlineState `json:"state,omitempty"`

	// svm
	Svm *GcpKmsInlineSvm `json:"svm,omitempty"`

	// A unique identifier for the Google Cloud KMS.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Verify the identity of the Google Cloud KMS host name.
	VerifyHost *bool `json:"verify_host,omitempty"`

	// Verify the identity of the Google Cloud KMS IP address.
	VerifyIP *bool `json:"verify_ip,omitempty"`
}

// Validate validates this gcp kms
func (m *GcpKms) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationCredentials(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGceMetadataServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGcpKmsInlineEkmipReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGoogleReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKms) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *GcpKms) validateApplicationCredentials(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationCredentials) { // not required
		return nil
	}

	if err := validate.FormatOf("application_credentials", "body", "password", m.ApplicationCredentials.String(), formats); err != nil {
		return err
	}

	return nil
}

var gcpKmsTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["application_credentials_key","sa_credentials_attachment"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gcpKmsTypeAuthenticationMethodPropEnum = append(gcpKmsTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// gcp_kms
	// GcpKms
	// authentication_method
	// AuthenticationMethod
	// application_credentials_key
	// END DEBUGGING
	// GcpKmsAuthenticationMethodApplicationCredentialsKey captures enum value "application_credentials_key"
	GcpKmsAuthenticationMethodApplicationCredentialsKey string = "application_credentials_key"

	// BEGIN DEBUGGING
	// gcp_kms
	// GcpKms
	// authentication_method
	// AuthenticationMethod
	// sa_credentials_attachment
	// END DEBUGGING
	// GcpKmsAuthenticationMethodSaCredentialsAttachment captures enum value "sa_credentials_attachment"
	GcpKmsAuthenticationMethodSaCredentialsAttachment string = "sa_credentials_attachment"
)

// prop value enum
func (m *GcpKms) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gcpKmsTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GcpKms) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationMethodEnum("authentication_method", "body", *m.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (m *GcpKms) validateGceMetadataServer(formats strfmt.Registry) error {
	if swag.IsZero(m.GceMetadataServer) { // not required
		return nil
	}

	if err := validate.FormatOf("gce_metadata_server", "body", "uri", m.GceMetadataServer.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *GcpKms) validateGcpKmsInlineEkmipReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.GcpKmsInlineEkmipReachability) { // not required
		return nil
	}

	for i := 0; i < len(m.GcpKmsInlineEkmipReachability); i++ {
		if swag.IsZero(m.GcpKmsInlineEkmipReachability[i]) { // not required
			continue
		}

		if m.GcpKmsInlineEkmipReachability[i] != nil {
			if err := m.GcpKmsInlineEkmipReachability[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GcpKms) validateGoogleReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.GoogleReachability) { // not required
		return nil
	}

	if m.GoogleReachability != nil {
		if err := m.GoogleReachability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("google_reachability")
			}
			return err
		}
	}

	return nil
}

var gcpKmsTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gcpKmsTypeProxyTypePropEnum = append(gcpKmsTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// gcp_kms
	// GcpKms
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// GcpKmsProxyTypeHTTP captures enum value "http"
	GcpKmsProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// gcp_kms
	// GcpKms
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// GcpKmsProxyTypeHTTPS captures enum value "https"
	GcpKmsProxyTypeHTTPS string = "https"
)

// prop value enum
func (m *GcpKms) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gcpKmsTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GcpKms) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProxyTypeEnum("proxy_type", "body", *m.ProxyType); err != nil {
		return err
	}

	return nil
}

var gcpKmsTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gcpKmsTypeScopePropEnum = append(gcpKmsTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// gcp_kms
	// GcpKms
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// GcpKmsScopeSvm captures enum value "svm"
	GcpKmsScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// gcp_kms
	// GcpKms
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// GcpKmsScopeCluster captures enum value "cluster"
	GcpKmsScopeCluster string = "cluster"
)

// prop value enum
func (m *GcpKms) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gcpKmsTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GcpKms) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *GcpKms) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *GcpKms) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms based on the context it is used
func (m *GcpKms) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCallerAccount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGcpKmsInlineEkmipReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGoogleReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKms) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *GcpKms) contextValidateCallerAccount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "caller_account", "body", m.CallerAccount); err != nil {
		return err
	}

	return nil
}

func (m *GcpKms) contextValidateGcpKmsInlineEkmipReachability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ekmip_reachability", "body", []*GcpKmsInlineEkmipReachabilityInlineArrayItem(m.GcpKmsInlineEkmipReachability)); err != nil {
		return err
	}

	for i := 0; i < len(m.GcpKmsInlineEkmipReachability); i++ {

		if m.GcpKmsInlineEkmipReachability[i] != nil {
			if err := m.GcpKmsInlineEkmipReachability[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GcpKms) contextValidateGoogleReachability(ctx context.Context, formats strfmt.Registry) error {

	if m.GoogleReachability != nil {
		if err := m.GoogleReachability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("google_reachability")
			}
			return err
		}
	}

	return nil
}

func (m *GcpKms) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *GcpKms) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *GcpKms) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *GcpKms) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GcpKms) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKms) UnmarshalBinary(b []byte) error {
	var res GcpKms
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineEkmipReachabilityInlineArrayItem Provides the connectivity status for the given SVM on the given node to all EKMIP servers configured on all nodes of the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model gcp_kms_inline_ekmip_reachability_inline_array_item
type GcpKmsInlineEkmipReachabilityInlineArrayItem struct {

	// Code corresponding to the error message. Returns a 0 if a given SVM is able to communicate to the EKMIP servers of all of the nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when cluster-wide EKMIP server availability from the given SVM and node is false.
	// Example: embedded KMIP server status unavailable on node.
	Message *string `json:"message,omitempty"`

	// node
	Node *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode `json:"node,omitempty"`

	// Set to true if the given SVM on the given node is able to communicate to all EKMIP servers configured on all nodes in the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this gcp kms inline ekmip reachability inline array item
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineEkmipReachabilityInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline ekmip reachability inline array item based on the context it is used
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineEkmipReachabilityInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineEkmipReachabilityInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode gcp kms inline ekmip reachability inline array item inline node
//
// swagger:model gcp_kms_inline_ekmip_reachability_inline_array_item_inline_node
type GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode struct {

	// links
	Links *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this gcp kms inline ekmip reachability inline array item inline node
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline ekmip reachability inline array item inline node based on the context it is used
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks gcp kms inline ekmip reachability inline array item inline node inline links
//
// swagger:model gcp_kms_inline_ekmip_reachability_inline_array_item_inline_node_inline__links
type GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this gcp kms inline ekmip reachability inline array item inline node inline links
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline ekmip reachability inline array item inline node inline links based on the context it is used
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineGoogleReachability Indicates whether or not the Google Cloud KMS is reachable from all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model gcp_kms_inline_google_reachability
type GcpKmsInlineGoogleReachability struct {

	// Code corresponding to the error message. Returns a 0 if Google Cloud KMS is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Set to the error message when 'reachable' is false.
	// Example: Google Cloud KMS is not reachable from all nodes - \u003creason\u003e.
	Message *string `json:"message,omitempty"`

	// Set to true if the Google Cloud KMS is reachable from all nodes of the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this gcp kms inline google reachability
func (m *GcpKmsInlineGoogleReachability) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this gcp kms inline google reachability based on the context it is used
func (m *GcpKmsInlineGoogleReachability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineGoogleReachability) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineGoogleReachability) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineGoogleReachability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineLinks gcp kms inline links
//
// swagger:model gcp_kms_inline__links
type GcpKmsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this gcp kms inline links
func (m *GcpKmsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline links based on the context it is used
func (m *GcpKmsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineLinks) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineState Google Cloud Key Management Services is a cloud key management service (KMS) that provides a secure store for encryption keys. This object indicates whether or not the Google Cloud KMS key protection is available on all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model gcp_kms_inline_state
type GcpKmsInlineState struct {

	// Set to true when Google Cloud KMS key protection is available on all nodes of the cluster.
	ClusterState *bool `json:"cluster_state,omitempty"`

	// Error code corresponding to the status message. Returns 0 if Google Cloud KMS key protection is available in all nodes of the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when top-level internal key protection key (KEK) availability on cluster is false.
	// Example: Top-level internal key protection key (KEK) is unavailable on the following nodes with the associated reasons: Node: node1. Reason: No volumes created yet for the SVM. Wrapped KEK status will be available after creating encrypted volumes.
	Message *string `json:"message,omitempty"`
}

// Validate validates this gcp kms inline state
func (m *GcpKmsInlineState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this gcp kms inline state based on the context it is used
func (m *GcpKmsInlineState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineState) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model gcp_kms_inline_svm
type GcpKmsInlineSvm struct {

	// links
	Links *GcpKmsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this gcp kms inline svm
func (m *GcpKmsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline svm based on the context it is used
func (m *GcpKmsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineSvm) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GcpKmsInlineSvmInlineLinks gcp kms inline svm inline links
//
// swagger:model gcp_kms_inline_svm_inline__links
type GcpKmsInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this gcp kms inline svm inline links
func (m *GcpKmsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline svm inline links based on the context it is used
func (m *GcpKmsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GcpKmsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GcpKmsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GcpKmsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
