// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// GovernanceAggregations governance aggregations
//
// swagger:model governance_aggregations
type GovernanceAggregations struct {

	// Total number of classifier categories across all workspaces.
	// Example: 4
	ClassifierCategoryCount *int64 `json:"classifier_category_count,omitempty"`

	// Number of classifiers matched in the last 30 days.
	// Example: 4
	ClassifierMatchedInLast30DaysCount *int64 `json:"classifier_matched_in_last30_days_count,omitempty"`

	// Total number of data collections across all workspaces.
	// Example: 7
	DataCollectionCount *int64 `json:"data_collection_count,omitempty"`

	// Total number of data containers across all workspaces.
	// Example: 8
	DataContainerCount *int64 `json:"data_container_count,omitempty"`

	// Total number of enabled classifiers across all workspaces.
	// Example: 6
	EnabledClassifierCount *int64 `json:"enabled_classifier_count,omitempty"`

	// Total number of enabled guardrails across all workspaces.
	// Example: 3
	EnabledGuardrailCount *int64 `json:"enabled_guardrail_count,omitempty"`

	// Number of guardrails that have disabled classifiers.
	// Example: 5
	GuardrailWithDisabledClassifierCount *int64 `json:"guardrail_with_disabled_classifier_count,omitempty"`

	// Number of workspaces with guardrails.
	// Example: 2
	GuardrailWorkspaceCount *int64 `json:"guardrail_workspace_count,omitempty"`

	// Total number of entities impacted by guardrails across all workspaces.
	// Example: 2
	ImpactedEntitiesByGuardrailsCount *int64 `json:"impacted_entities_by_guardrails_count,omitempty"`

	// Number of workspaces without guardrails.
	// Example: 4
	NonGuardrailWorkspaceCount *int64 `json:"non_guardrail_workspace_count,omitempty"`

	// recent workspaces
	RecentWorkspaces RecentWorkspacesArrayInline `json:"recent_workspaces,omitempty"`

	// Total scanned content size across all workspaces.
	// Example: 8776552
	ScannedContentSize *int64 `json:"scanned_content_size,omitempty"`

	// Number of guardrails that are in testing.
	// Example: 2
	SimulatedGuardrailCount *int64 `json:"simulated_guardrail_count,omitempty"`

	// Total number of workspaces.
	// Example: 2
	WorkspaceCount *int64 `json:"workspace_count,omitempty"`
}

// Validate validates this governance aggregations
func (m *GovernanceAggregations) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRecentWorkspaces(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GovernanceAggregations) validateRecentWorkspaces(formats strfmt.Registry) error {
	if swag.IsZero(m.RecentWorkspaces) { // not required
		return nil
	}

	if err := m.RecentWorkspaces.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("recent_workspaces")
		}
		return err
	}

	return nil
}

// ContextValidate validate this governance aggregations based on the context it is used
func (m *GovernanceAggregations) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRecentWorkspaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GovernanceAggregations) contextValidateRecentWorkspaces(ctx context.Context, formats strfmt.Registry) error {

	if err := m.RecentWorkspaces.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("recent_workspaces")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GovernanceAggregations) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GovernanceAggregations) UnmarshalBinary(b []byte) error {
	var res GovernanceAggregations
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
