// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GovernanceWorkspaceAggregations governance workspace aggregations
//
// swagger:model governance_workspace_aggregations
type GovernanceWorkspaceAggregations struct {

	// age of data
	AgeOfData AgeOfDataArrayInline `json:"age_of_data,omitempty"`

	// Number of files anonymized.
	// Example: 226526256
	AnonymizedEntityCount *int64 `json:"anonymized_entity_count,omitempty"`

	// data classifier
	DataClassifier DataClassifierArrayInline `json:"data_classifier,omitempty"`

	// data classifier categories
	DataClassifierCategories DataClassifierCategoriesArrayInline `json:"data_classifier_categories,omitempty"`

	// Number of data collections in the workspace.
	// Example: 3
	DataCollectionCount *int64 `json:"data_collection_count,omitempty"`

	// Number of entities used in data collections.
	// Example: 100
	DataCollectionEntityCount *int64 `json:"data_collection_entity_count,omitempty"`

	// Number of data containers in the workspace.
	// Example: 5
	DataContainerCount *int64 `json:"data_container_count,omitempty"`

	// data sources
	DataSources DataSourcesAggregationsArrayInline `json:"data_sources,omitempty"`

	// Number of document categories in the workspace.
	// Example: 2
	DocumentCategoryCount *int64 `json:"document_category_count,omitempty"`

	// document classifier
	DocumentClassifier DocumentClassifierArrayInline `json:"document_classifier,omitempty"`

	// document classifier categories
	DocumentClassifierCategories DocumentClassifierCategoriesArrayInline `json:"document_classifier_categories,omitempty"`

	// Total number of entities in the workspace.
	// Example: 200
	EntityCount *int64 `json:"entity_count,omitempty"`

	// Number of entities excluded from data collections.
	// Example: 283863685
	ExcludedEntityCount *int64 `json:"excluded_entity_count,omitempty"`

	// Number of guardrails in the workspace.
	// Example: 2
	GuardrailCount *int64 `json:"guardrail_count,omitempty"`

	// Number of entities impacted by guardrails in the workspace.
	// Example: 3
	GuardrailImpactedEntityCount *int64 `json:"guardrail_impacted_entity_count,omitempty"`

	// Name of the workspace.
	// Example: gov_workspace
	Name *string `json:"name,omitempty"`

	// PII percentage for the workspace.
	// Example: 50
	PiiPercent *int64 `json:"pii_percent,omitempty"`

	// Total size of scanned content in the workspace.
	// Example: 1656564
	ScannedContent *int64 `json:"scanned_content,omitempty"`

	// Sensitive entities count in the workspace.
	// Example: 50
	SensitiveEntityCount *int64 `json:"sensitive_entity_count,omitempty"`

	// size of data
	SizeOfData SizeOfDataArrayInline `json:"size_of_data,omitempty"`

	// Number of stale entities in the workspace.
	// Example: 1
	StaleEntityCount *int64 `json:"stale_entity_count,omitempty"`

	// State of the workspace.
	// Example: Active
	State *string `json:"state,omitempty"`

	// top enforced guardrails
	TopEnforcedGuardrails TopEnforcedGuardrailsArrayInline `json:"top_enforced_guardrails,omitempty"`

	// UUID of the workspace.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this governance workspace aggregations
func (m *GovernanceWorkspaceAggregations) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAgeOfData(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataClassifier(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataClassifierCategories(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDocumentClassifier(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDocumentClassifierCategories(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSizeOfData(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopEnforcedGuardrails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GovernanceWorkspaceAggregations) validateAgeOfData(formats strfmt.Registry) error {
	if swag.IsZero(m.AgeOfData) { // not required
		return nil
	}

	if err := m.AgeOfData.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("age_of_data")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateDataClassifier(formats strfmt.Registry) error {
	if swag.IsZero(m.DataClassifier) { // not required
		return nil
	}

	if err := m.DataClassifier.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("data_classifier")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateDataClassifierCategories(formats strfmt.Registry) error {
	if swag.IsZero(m.DataClassifierCategories) { // not required
		return nil
	}

	if err := m.DataClassifierCategories.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("data_classifier_categories")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateDataSources(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSources) { // not required
		return nil
	}

	if err := m.DataSources.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("data_sources")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateDocumentClassifier(formats strfmt.Registry) error {
	if swag.IsZero(m.DocumentClassifier) { // not required
		return nil
	}

	if err := m.DocumentClassifier.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("document_classifier")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateDocumentClassifierCategories(formats strfmt.Registry) error {
	if swag.IsZero(m.DocumentClassifierCategories) { // not required
		return nil
	}

	if err := m.DocumentClassifierCategories.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("document_classifier_categories")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateSizeOfData(formats strfmt.Registry) error {
	if swag.IsZero(m.SizeOfData) { // not required
		return nil
	}

	if err := m.SizeOfData.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("size_of_data")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateTopEnforcedGuardrails(formats strfmt.Registry) error {
	if swag.IsZero(m.TopEnforcedGuardrails) { // not required
		return nil
	}

	if err := m.TopEnforcedGuardrails.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("top_enforced_guardrails")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this governance workspace aggregations based on the context it is used
func (m *GovernanceWorkspaceAggregations) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAgeOfData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataClassifier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataClassifierCategories(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDocumentClassifier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDocumentClassifierCategories(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSizeOfData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopEnforcedGuardrails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateAgeOfData(ctx context.Context, formats strfmt.Registry) error {

	if err := m.AgeOfData.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("age_of_data")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateDataClassifier(ctx context.Context, formats strfmt.Registry) error {

	if err := m.DataClassifier.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("data_classifier")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateDataClassifierCategories(ctx context.Context, formats strfmt.Registry) error {

	if err := m.DataClassifierCategories.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("data_classifier_categories")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateDataSources(ctx context.Context, formats strfmt.Registry) error {

	if err := m.DataSources.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("data_sources")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateDocumentClassifier(ctx context.Context, formats strfmt.Registry) error {

	if err := m.DocumentClassifier.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("document_classifier")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateDocumentClassifierCategories(ctx context.Context, formats strfmt.Registry) error {

	if err := m.DocumentClassifierCategories.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("document_classifier_categories")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateSizeOfData(ctx context.Context, formats strfmt.Registry) error {

	if err := m.SizeOfData.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("size_of_data")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateTopEnforcedGuardrails(ctx context.Context, formats strfmt.Registry) error {

	if err := m.TopEnforcedGuardrails.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("top_enforced_guardrails")
		}
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregations) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GovernanceWorkspaceAggregations) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GovernanceWorkspaceAggregations) UnmarshalBinary(b []byte) error {
	var res GovernanceWorkspaceAggregations
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
