// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GovernanceWorkspaceAggregationsResponse Defines the structure of the response governance aggregations.
//
// swagger:model governance_workspace_aggregations_response
type GovernanceWorkspaceAggregationsResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// governance workspace aggregations response inline records
	GovernanceWorkspaceAggregationsResponseInlineRecords []*GovernanceWorkspaceAggregations `json:"records,omitempty"`

	// The number of records returned in the response.
	// Example: 10
	// Read Only: true
	NumRecords *int64 `json:"num_records,omitempty"`

	// The total number of aggregation records available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this governance workspace aggregations response
func (m *GovernanceWorkspaceAggregationsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGovernanceWorkspaceAggregationsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GovernanceWorkspaceAggregationsResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *GovernanceWorkspaceAggregationsResponse) validateGovernanceWorkspaceAggregationsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.GovernanceWorkspaceAggregationsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.GovernanceWorkspaceAggregationsResponseInlineRecords); i++ {
		if swag.IsZero(m.GovernanceWorkspaceAggregationsResponseInlineRecords[i]) { // not required
			continue
		}

		if m.GovernanceWorkspaceAggregationsResponseInlineRecords[i] != nil {
			if err := m.GovernanceWorkspaceAggregationsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this governance workspace aggregations response based on the context it is used
func (m *GovernanceWorkspaceAggregationsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGovernanceWorkspaceAggregationsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GovernanceWorkspaceAggregationsResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *GovernanceWorkspaceAggregationsResponse) contextValidateGovernanceWorkspaceAggregationsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.GovernanceWorkspaceAggregationsResponseInlineRecords); i++ {

		if m.GovernanceWorkspaceAggregationsResponseInlineRecords[i] != nil {
			if err := m.GovernanceWorkspaceAggregationsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GovernanceWorkspaceAggregationsResponse) contextValidateNumRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_records", "body", m.NumRecords); err != nil {
		return err
	}

	return nil
}

func (m *GovernanceWorkspaceAggregationsResponse) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_records", "body", m.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GovernanceWorkspaceAggregationsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GovernanceWorkspaceAggregationsResponse) UnmarshalBinary(b []byte) error {
	var res GovernanceWorkspaceAggregationsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
