// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// GroupPolicyObjectCentralAccessRuleResponse group policy object central access rule response
//
// swagger:model group_policy_object_central_access_rule_response
type GroupPolicyObjectCentralAccessRuleResponse struct {

	// links
	Links *GroupPolicyObjectCentralAccessRuleResponseInlineLinks `json:"_links,omitempty"`

	// group policy object central access rule response inline records
	GroupPolicyObjectCentralAccessRuleResponseInlineRecords []*GroupPolicyObjectCentralAccessRule `json:"records,omitempty"`

	// Number of central access rules.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this group policy object central access rule response
func (m *GroupPolicyObjectCentralAccessRuleResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroupPolicyObjectCentralAccessRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponse) validateGroupPolicyObjectCentralAccessRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords); i++ {
		if swag.IsZero(m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords[i] != nil {
			if err := m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this group policy object central access rule response based on the context it is used
func (m *GroupPolicyObjectCentralAccessRuleResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGroupPolicyObjectCentralAccessRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponse) contextValidateGroupPolicyObjectCentralAccessRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords); i++ {

		if m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords[i] != nil {
			if err := m.GroupPolicyObjectCentralAccessRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *GroupPolicyObjectCentralAccessRuleResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GroupPolicyObjectCentralAccessRuleResponse) UnmarshalBinary(b []byte) error {
	var res GroupPolicyObjectCentralAccessRuleResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GroupPolicyObjectCentralAccessRuleResponseInlineLinks group policy object central access rule response inline links
//
// swagger:model group_policy_object_central_access_rule_response_inline__links
type GroupPolicyObjectCentralAccessRuleResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this group policy object central access rule response inline links
func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group policy object central access rule response inline links based on the context it is used
func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GroupPolicyObjectCentralAccessRuleResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res GroupPolicyObjectCentralAccessRuleResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
