// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GroupPolicyObjectEventLog group policy object event log
//
// swagger:model group_policy_object_event_log
type GroupPolicyObjectEventLog struct {

	// Maximum size of security log, in kilobytes.
	// Example: 2048
	MaxSize *int64 `json:"max_size,omitempty"`

	// Audit log retention method.
	// Example: do_not_overwrite
	// Enum: ["overwrite_as_needed","overwrite_by_days","do_not_overwrite"]
	RetentionMethod *string `json:"retention_method,omitempty"`
}

// Validate validates this group policy object event log
func (m *GroupPolicyObjectEventLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRetentionMethod(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var groupPolicyObjectEventLogTypeRetentionMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["overwrite_as_needed","overwrite_by_days","do_not_overwrite"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		groupPolicyObjectEventLogTypeRetentionMethodPropEnum = append(groupPolicyObjectEventLogTypeRetentionMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// group_policy_object_event_log
	// GroupPolicyObjectEventLog
	// retention_method
	// RetentionMethod
	// overwrite_as_needed
	// END DEBUGGING
	// GroupPolicyObjectEventLogRetentionMethodOverwriteAsNeeded captures enum value "overwrite_as_needed"
	GroupPolicyObjectEventLogRetentionMethodOverwriteAsNeeded string = "overwrite_as_needed"

	// BEGIN DEBUGGING
	// group_policy_object_event_log
	// GroupPolicyObjectEventLog
	// retention_method
	// RetentionMethod
	// overwrite_by_days
	// END DEBUGGING
	// GroupPolicyObjectEventLogRetentionMethodOverwriteByDays captures enum value "overwrite_by_days"
	GroupPolicyObjectEventLogRetentionMethodOverwriteByDays string = "overwrite_by_days"

	// BEGIN DEBUGGING
	// group_policy_object_event_log
	// GroupPolicyObjectEventLog
	// retention_method
	// RetentionMethod
	// do_not_overwrite
	// END DEBUGGING
	// GroupPolicyObjectEventLogRetentionMethodDoNotOverwrite captures enum value "do_not_overwrite"
	GroupPolicyObjectEventLogRetentionMethodDoNotOverwrite string = "do_not_overwrite"
)

// prop value enum
func (m *GroupPolicyObjectEventLog) validateRetentionMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, groupPolicyObjectEventLogTypeRetentionMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GroupPolicyObjectEventLog) validateRetentionMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.RetentionMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateRetentionMethodEnum("retention_method", "body", *m.RetentionMethod); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this group policy object event log based on context it is used
func (m *GroupPolicyObjectEventLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *GroupPolicyObjectEventLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GroupPolicyObjectEventLog) UnmarshalBinary(b []byte) error {
	var res GroupPolicyObjectEventLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
