// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GroupPolicyObjectRestrictedGroup group policy object restricted group
//
// swagger:model group_policy_object_restricted_group
type GroupPolicyObjectRestrictedGroup struct {

	// group name
	// Example: test_group
	// Min Length: 1
	GroupName *string `json:"group_name,omitempty"`

	// Members of the group.
	// Example: ["DOMAIN/test_user","DOMAIN/user2"]
	GroupPolicyObjectRestrictedGroupInlineMembers []*string `json:"members,omitempty"`

	// Group is member of Group/OU.
	// Example: ["DOMAIN/AdministratorGrp","DOMAIN/deptMark"]
	GroupPolicyObjectRestrictedGroupInlineMemberships []*string `json:"memberships,omitempty"`

	// Link info.
	// Example: domain
	// Enum: ["local","site","domain","organizational_unit","rsop"]
	Link *string `json:"link,omitempty"`

	// policy name
	// Example: test_policy
	// Min Length: 1
	PolicyName *string `json:"policy_name,omitempty"`

	// svm
	Svm *GroupPolicyObjectRestrictedGroupInlineSvm `json:"svm,omitempty"`

	// Group policy object version.
	// Example: 7
	Version *int64 `json:"version,omitempty"`
}

// Validate validates this group policy object restricted group
func (m *GroupPolicyObjectRestrictedGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroupName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicyName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectRestrictedGroup) validateGroupName(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupName) { // not required
		return nil
	}

	if err := validate.MinLength("group_name", "body", *m.GroupName, 1); err != nil {
		return err
	}

	return nil
}

var groupPolicyObjectRestrictedGroupTypeLinkPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["local","site","domain","organizational_unit","rsop"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		groupPolicyObjectRestrictedGroupTypeLinkPropEnum = append(groupPolicyObjectRestrictedGroupTypeLinkPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// group_policy_object_restricted_group
	// GroupPolicyObjectRestrictedGroup
	// link
	// Link
	// local
	// END DEBUGGING
	// GroupPolicyObjectRestrictedGroupLinkLocal captures enum value "local"
	GroupPolicyObjectRestrictedGroupLinkLocal string = "local"

	// BEGIN DEBUGGING
	// group_policy_object_restricted_group
	// GroupPolicyObjectRestrictedGroup
	// link
	// Link
	// site
	// END DEBUGGING
	// GroupPolicyObjectRestrictedGroupLinkSite captures enum value "site"
	GroupPolicyObjectRestrictedGroupLinkSite string = "site"

	// BEGIN DEBUGGING
	// group_policy_object_restricted_group
	// GroupPolicyObjectRestrictedGroup
	// link
	// Link
	// domain
	// END DEBUGGING
	// GroupPolicyObjectRestrictedGroupLinkDomain captures enum value "domain"
	GroupPolicyObjectRestrictedGroupLinkDomain string = "domain"

	// BEGIN DEBUGGING
	// group_policy_object_restricted_group
	// GroupPolicyObjectRestrictedGroup
	// link
	// Link
	// organizational_unit
	// END DEBUGGING
	// GroupPolicyObjectRestrictedGroupLinkOrganizationalUnit captures enum value "organizational_unit"
	GroupPolicyObjectRestrictedGroupLinkOrganizationalUnit string = "organizational_unit"

	// BEGIN DEBUGGING
	// group_policy_object_restricted_group
	// GroupPolicyObjectRestrictedGroup
	// link
	// Link
	// rsop
	// END DEBUGGING
	// GroupPolicyObjectRestrictedGroupLinkRsop captures enum value "rsop"
	GroupPolicyObjectRestrictedGroupLinkRsop string = "rsop"
)

// prop value enum
func (m *GroupPolicyObjectRestrictedGroup) validateLinkEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, groupPolicyObjectRestrictedGroupTypeLinkPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GroupPolicyObjectRestrictedGroup) validateLink(formats strfmt.Registry) error {
	if swag.IsZero(m.Link) { // not required
		return nil
	}

	// value enum
	if err := m.validateLinkEnum("link", "body", *m.Link); err != nil {
		return err
	}

	return nil
}

func (m *GroupPolicyObjectRestrictedGroup) validatePolicyName(formats strfmt.Registry) error {
	if swag.IsZero(m.PolicyName) { // not required
		return nil
	}

	if err := validate.MinLength("policy_name", "body", *m.PolicyName, 1); err != nil {
		return err
	}

	return nil
}

func (m *GroupPolicyObjectRestrictedGroup) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group policy object restricted group based on the context it is used
func (m *GroupPolicyObjectRestrictedGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectRestrictedGroup) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GroupPolicyObjectRestrictedGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GroupPolicyObjectRestrictedGroup) UnmarshalBinary(b []byte) error {
	var res GroupPolicyObjectRestrictedGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GroupPolicyObjectRestrictedGroupInlineSvm Will not be populated for objects that are yet to be applied.
//
// swagger:model group_policy_object_restricted_group_inline_svm
type GroupPolicyObjectRestrictedGroupInlineSvm struct {

	// links
	Links *GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this group policy object restricted group inline svm
func (m *GroupPolicyObjectRestrictedGroupInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectRestrictedGroupInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group policy object restricted group inline svm based on the context it is used
func (m *GroupPolicyObjectRestrictedGroupInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectRestrictedGroupInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GroupPolicyObjectRestrictedGroupInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GroupPolicyObjectRestrictedGroupInlineSvm) UnmarshalBinary(b []byte) error {
	var res GroupPolicyObjectRestrictedGroupInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks group policy object restricted group inline svm inline links
//
// swagger:model group_policy_object_restricted_group_inline_svm_inline__links
type GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this group policy object restricted group inline svm inline links
func (m *GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group policy object restricted group inline svm inline links based on the context it is used
func (m *GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res GroupPolicyObjectRestrictedGroupInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
