// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// HostKeyAlgorithm Host key algorithm. The host key algorithms 'ssh_ed25519' and 'ssh_rsa' can be configured only in non-FIPS mode.
// Example: ecdsa_sha2_nistp256
//
// swagger:model host_key_algorithm
type HostKeyAlgorithm string

func NewHostKeyAlgorithm(value HostKeyAlgorithm) *HostKeyAlgorithm {
	return &value
}

// Pointer returns a pointer to a freshly-allocated HostKeyAlgorithm.
func (m HostKeyAlgorithm) Pointer() *HostKeyAlgorithm {
	return &m
}

const (

	// HostKeyAlgorithmEcdsaSha2Nistp256 captures enum value "ecdsa_sha2_nistp256"
	HostKeyAlgorithmEcdsaSha2Nistp256 HostKeyAlgorithm = "ecdsa_sha2_nistp256"

	// HostKeyAlgorithmSSHEd25519 captures enum value "ssh_ed25519"
	HostKeyAlgorithmSSHEd25519 HostKeyAlgorithm = "ssh_ed25519"

	// HostKeyAlgorithmSSHRsa captures enum value "ssh_rsa"
	HostKeyAlgorithmSSHRsa HostKeyAlgorithm = "ssh_rsa"

	// HostKeyAlgorithmRsaSha2256 captures enum value "rsa_sha2_256"
	HostKeyAlgorithmRsaSha2256 HostKeyAlgorithm = "rsa_sha2_256"

	// HostKeyAlgorithmRsaSha2512 captures enum value "rsa_sha2_512"
	HostKeyAlgorithmRsaSha2512 HostKeyAlgorithm = "rsa_sha2_512"
)

// for schema
var hostKeyAlgorithmEnum []interface{}

func init() {
	var res []HostKeyAlgorithm
	if err := json.Unmarshal([]byte(`["ecdsa_sha2_nistp256","ssh_ed25519","ssh_rsa","rsa_sha2_256","rsa_sha2_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hostKeyAlgorithmEnum = append(hostKeyAlgorithmEnum, v)
	}
}

func (m HostKeyAlgorithm) validateHostKeyAlgorithmEnum(path, location string, value HostKeyAlgorithm) error {
	if err := validate.EnumCase(path, location, value, hostKeyAlgorithmEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this host key algorithm
func (m HostKeyAlgorithm) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateHostKeyAlgorithmEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this host key algorithm based on context it is used
func (m HostKeyAlgorithm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
