// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HwAssistStatus hw assist status
//
// swagger:model hw_assist_status
type HwAssistStatus struct {

	// The hardware assist IP address.
	IP *string `json:"ip,omitempty"`

	// The hardware assist port.
	Port *int64 `json:"port,omitempty"`

	// The hardware assist monitor status.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this hw assist status
func (m *HwAssistStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var hwAssistStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hwAssistStatusTypeStatePropEnum = append(hwAssistStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// hw_assist_status
	// HwAssistStatus
	// state
	// State
	// active
	// END DEBUGGING
	// HwAssistStatusStateActive captures enum value "active"
	HwAssistStatusStateActive string = "active"

	// BEGIN DEBUGGING
	// hw_assist_status
	// HwAssistStatus
	// state
	// State
	// inactive
	// END DEBUGGING
	// HwAssistStatusStateInactive captures enum value "inactive"
	HwAssistStatusStateInactive string = "inactive"
)

// prop value enum
func (m *HwAssistStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, hwAssistStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HwAssistStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this hw assist status based on context it is used
func (m *HwAssistStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HwAssistStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HwAssistStatus) UnmarshalBinary(b []byte) error {
	var res HwAssistStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
