// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Igroup An initiator group (igroup) is a collection of Fibre Channel (FC) world wide port names (WWPNs), and/or iSCSI Qualified Names (IQNs), and/or iSCSI EUIs (Extended Unique Identifiers) that identify host endpoints.<br/>
// Initiator groups are used to control which hosts can access specific LUNs. To grant access to a LUN from one or more hosts, create an initiator group containing the host initiator names, then create a LUN map that associates the initiator group with the LUN.<br/>
// An initiator group may contain either initiators or other initiator groups, but not both simultaneously. When a parent initiator group is mapped, it inherits all of the initiators of any initiator groups nested below it. If any nested initiator group is modified to contain different initiators, the parent initiator groups inherit the change. A parent can have many nested initiator groups and an initiator group can be nested under multiple parents. Initiators can only be added or removed from the initiator group that directly contains them. The maximum supported depth of nesting is three layers.<br/>
// Best practice when using nested initiator groups is to match host hierarchies. A single initiator group should correspond to a single host. If a LUN needs to be mapped to multiple hosts, the initiator groups representing those hosts should be aggregated into a parent initiator group and the LUN should be mapped to that initiator group. For multi-ported hosts, initiators have a comment property where the port corresponding to the initiator can be documented.<br/>
// An initiator can appear in multiple initiator groups. An initiator group can be mapped to multiple LUNs. A specific initiator can be mapped to a specific LUN only once. With the introduction of nestable initiator groups, best practice is to use the hierarchy such that an initiator is only a direct member of a single initiator group, and that initiator group can then be referenced by other initiator groups.<br/>
// All initiators or nested initiator groups in an initiator group must be from the same operating system. The initiator group's operating system is specified when the initiator group is created.<br/>
// When an initiator group is created, the `protocol` property is used to restrict member initiators to Fibre Channel (_fcp_), iSCSI (_iscsi_), or both (_mixed_). Initiator groups within a nested hierarchy may not have conflicting protocols.<br/>
// Zero or more initiators or nested initiator groups can be supplied when the initiator group is created. After creation, initiators can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/initiators` endpoint. Initiator groups containing other initiator groups report the aggregated list of initiators from all nested initiator groups, but modifications of the initiator list must be performed on the initiator group that directly contains the initiators. See [`POST /protocols/san/igroups/{igroup.uuid}/initiators`](#/SAN/igroup_initiator_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}`](#/SAN/igroup_initiator_delete) for more details.<br/>
//
// swagger:model igroup
type Igroup struct {

	// links
	Links *IgroupInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// connectivity tracking
	ConnectivityTracking *IgroupInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// An option that causes the initiator group to be deleted when the last LUN map associated with it is deleted. Optional in POST and PATCH. This property defaults to _false_ when the initiator group is created.
	//
	DeleteOnUnmap *bool `json:"delete_on_unmap,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	IgroupInlineIgroups []*IgroupChild `json:"igroups,omitempty"`

	// The initiators that are members of the group or any group nested below this group. Optional in POST.<br/>
	// This property is mutually exclusive with the _igroups_ property during POST.<br/>
	// During GET, this array contains initiators that are members of this group or any nested initiator groups below this group. When initiators of nested groups are returned, they include links to the initiator group that directly contains the initiator.<br/>
	// Zero or more initiators can be supplied when the initiator group is created. After creation, initiators can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/initiators` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/initiators`](#/SAN/igroup_initiator_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}`](#/SAN/igroup_initiator_delete) for more details.
	//
	IgroupInlineInitiators []*IgroupInlineInitiatorsInlineArrayItem `json:"initiators,omitempty"`

	// All LUN maps with which the initiator is associated.<br/>
	// If the requested igroup is part of a remote, non-local, MetroCluster SVM, the LUN maps are not retrieved.<br/>
	// There is an added computational cost to retrieving property values for `lun_maps`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	IgroupInlineLunMaps []*IgroupInlineLunMapsInlineArrayItem `json:"lun_maps,omitempty"`

	// The initiator groups that contain this initiator group as a member.
	//
	// Read Only: true
	IgroupInlineParentIgroups []*IgroupParent `json:"parent_igroups,omitempty"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// portset
	Portset *IgroupInlinePortset `json:"portset,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// replication
	Replication *IgroupInlineReplication `json:"replication,omitempty"`

	// An initiator group may contain either initiators or other initiator groups, but not both simultaneously. This property is _true_ when initiator groups can be added to this initiator group. The `initiators.name` property cannot be used to determine this via a query because it reports initiators inherited from nested igroups.
	//
	// Read Only: true
	SupportsIgroups *bool `json:"supports_igroups,omitempty"`

	// svm
	Svm *IgroupInlineSvm `json:"svm,omitempty"`

	// target
	Target *IgroupInlineTarget `json:"target,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup
func (m *Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroupInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroupInlineInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroupInlineLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroupInlineParentIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortset(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Igroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *Igroup) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectivityTracking) { // not required
		return nil
	}

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) validateIgroupInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.IgroupInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.IgroupInlineIgroups); i++ {
		if swag.IsZero(m.IgroupInlineIgroups[i]) { // not required
			continue
		}

		if m.IgroupInlineIgroups[i] != nil {
			if err := m.IgroupInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) validateIgroupInlineInitiators(formats strfmt.Registry) error {
	if swag.IsZero(m.IgroupInlineInitiators) { // not required
		return nil
	}

	for i := 0; i < len(m.IgroupInlineInitiators); i++ {
		if swag.IsZero(m.IgroupInlineInitiators[i]) { // not required
			continue
		}

		if m.IgroupInlineInitiators[i] != nil {
			if err := m.IgroupInlineInitiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) validateIgroupInlineLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.IgroupInlineLunMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.IgroupInlineLunMaps); i++ {
		if swag.IsZero(m.IgroupInlineLunMaps[i]) { // not required
			continue
		}

		if m.IgroupInlineLunMaps[i] != nil {
			if err := m.IgroupInlineLunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) validateIgroupInlineParentIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.IgroupInlineParentIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.IgroupInlineParentIgroups); i++ {
		if swag.IsZero(m.IgroupInlineParentIgroups[i]) { // not required
			continue
		}

		if m.IgroupInlineParentIgroups[i] != nil {
			if err := m.IgroupInlineParentIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parent_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var igroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupTypeOsTypePropEnum = append(igroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// IgroupOsTypeAix captures enum value "aix"
	IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// IgroupOsTypeHpux captures enum value "hpux"
	IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// IgroupOsTypeHyperv captures enum value "hyper_v"
	IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// IgroupOsTypeLinux captures enum value "linux"
	IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// IgroupOsTypeNetware captures enum value "netware"
	IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// IgroupOsTypeOpenvms captures enum value "openvms"
	IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// IgroupOsTypeSolaris captures enum value "solaris"
	IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// IgroupOsTypeVmware captures enum value "vmware"
	IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// IgroupOsTypeWindows captures enum value "windows"
	IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// IgroupOsTypeXen captures enum value "xen"
	IgroupOsTypeXen string = "xen"
)

// prop value enum
func (m *Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *Igroup) validatePortset(formats strfmt.Registry) error {
	if swag.IsZero(m.Portset) { // not required
		return nil
	}

	if m.Portset != nil {
		if err := m.Portset.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset")
			}
			return err
		}
	}

	return nil
}

var igroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupTypeProtocolPropEnum = append(igroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// IgroupProtocolFcp captures enum value "fcp"
	IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// IgroupProtocolIscsi captures enum value "iscsi"
	IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// igroup
	// Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// IgroupProtocolMixed captures enum value "mixed"
	IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (m *Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *Igroup) validateReplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Replication) { // not required
		return nil
	}

	if m.Replication != nil {
		if err := m.Replication.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(m.Target) { // not required
		return nil
	}

	if m.Target != nil {
		if err := m.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup based on the context it is used
func (m *Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroupInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroupInlineInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroupInlineLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroupInlineParentIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortset(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSupportsIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Igroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) contextValidateIgroupInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IgroupInlineIgroups); i++ {

		if m.IgroupInlineIgroups[i] != nil {
			if err := m.IgroupInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) contextValidateIgroupInlineInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IgroupInlineInitiators); i++ {

		if m.IgroupInlineInitiators[i] != nil {
			if err := m.IgroupInlineInitiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) contextValidateIgroupInlineLunMaps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun_maps", "body", []*IgroupInlineLunMapsInlineArrayItem(m.IgroupInlineLunMaps)); err != nil {
		return err
	}

	for i := 0; i < len(m.IgroupInlineLunMaps); i++ {

		if m.IgroupInlineLunMaps[i] != nil {
			if err := m.IgroupInlineLunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) contextValidateIgroupInlineParentIgroups(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "parent_igroups", "body", []*IgroupParent(m.IgroupInlineParentIgroups)); err != nil {
		return err
	}

	for i := 0; i < len(m.IgroupInlineParentIgroups); i++ {

		if m.IgroupInlineParentIgroups[i] != nil {
			if err := m.IgroupInlineParentIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parent_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Igroup) contextValidatePortset(ctx context.Context, formats strfmt.Registry) error {

	if m.Portset != nil {
		if err := m.Portset.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) contextValidateReplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Replication != nil {
		if err := m.Replication.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) contextValidateSupportsIgroups(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "supports_igroups", "body", m.SupportsIgroups); err != nil {
		return err
	}

	return nil
}

func (m *Igroup) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if m.Target != nil {
		if err := m.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

func (m *Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Igroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Igroup) UnmarshalBinary(b []byte) error {
	var res Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineConnectivityTracking An overview of the connections to ONTAP by the initiators in this group.
//
// swagger:model igroup_inline_connectivity_tracking
type IgroupInlineConnectivityTracking struct {

	// alerts
	// Read Only: true
	Alerts []*IgroupConnectivityTrackingAlertsItems0 `json:"alerts,omitempty"`

	// Connection state.
	//
	// Read Only: true
	// Enum: ["full","none","partial","no_initiators","no_lun_maps"]
	ConnectionState *string `json:"connection_state,omitempty"`

	// Nodes to which the initiators in this group should be connected to ensure reliable service. This is the collection of any node hosting a LUN mapped to this igroup as well as the HA partners of those nodes.
	//
	// Read Only: true
	RequiredNodes []*IgroupConnectivityTrackingRequiredNodesItems0 `json:"required_nodes,omitempty"`
}

// Validate validates this igroup inline connectivity tracking
func (m *IgroupInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlerts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRequiredNodes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineConnectivityTracking) validateAlerts(formats strfmt.Registry) error {
	if swag.IsZero(m.Alerts) { // not required
		return nil
	}

	for i := 0; i < len(m.Alerts); i++ {
		if swag.IsZero(m.Alerts[i]) { // not required
			continue
		}

		if m.Alerts[i] != nil {
			if err := m.Alerts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var igroupInlineConnectivityTrackingTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","none","partial","no_initiators","no_lun_maps"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInlineConnectivityTrackingTypeConnectionStatePropEnum = append(igroupInlineConnectivityTrackingTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// full
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateFull captures enum value "full"
	IgroupInlineConnectivityTrackingConnectionStateFull string = "full"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// none
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateNone captures enum value "none"
	IgroupInlineConnectivityTrackingConnectionStateNone string = "none"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// partial
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStatePartial captures enum value "partial"
	IgroupInlineConnectivityTrackingConnectionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_initiators
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateNoInitiators captures enum value "no_initiators"
	IgroupInlineConnectivityTrackingConnectionStateNoInitiators string = "no_initiators"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_lun_maps
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateNoLunMaps captures enum value "no_lun_maps"
	IgroupInlineConnectivityTrackingConnectionStateNoLunMaps string = "no_lun_maps"
)

// prop value enum
func (m *IgroupInlineConnectivityTracking) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInlineConnectivityTrackingTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IgroupInlineConnectivityTracking) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnectionStateEnum("connectivity_tracking"+"."+"connection_state", "body", *m.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineConnectivityTracking) validateRequiredNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.RequiredNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.RequiredNodes); i++ {
		if swag.IsZero(m.RequiredNodes[i]) { // not required
			continue
		}

		if m.RequiredNodes[i] != nil {
			if err := m.RequiredNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "required_nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup inline connectivity tracking based on the context it is used
func (m *IgroupInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAlerts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRequiredNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineConnectivityTracking) contextValidateAlerts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity_tracking"+"."+"alerts", "body", []*IgroupConnectivityTrackingAlertsItems0(m.Alerts)); err != nil {
		return err
	}

	for i := 0; i < len(m.Alerts); i++ {

		if m.Alerts[i] != nil {
			if err := m.Alerts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInlineConnectivityTracking) contextValidateConnectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity_tracking"+"."+"connection_state", "body", m.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineConnectivityTracking) contextValidateRequiredNodes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity_tracking"+"."+"required_nodes", "body", []*IgroupConnectivityTrackingRequiredNodesItems0(m.RequiredNodes)); err != nil {
		return err
	}

	for i := 0; i < len(m.RequiredNodes); i++ {

		if m.RequiredNodes[i] != nil {
			if err := m.RequiredNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "required_nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupConnectivityTrackingAlertsItems0 igroup connectivity tracking alerts items0
//
// swagger:model IgroupConnectivityTrackingAlertsItems0
type IgroupConnectivityTrackingAlertsItems0 struct {

	// summary
	Summary *IgroupConnectivityTrackingAlertsItems0Summary `json:"summary,omitempty"`
}

// Validate validates this igroup connectivity tracking alerts items0
func (m *IgroupConnectivityTrackingAlertsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingAlertsItems0) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup connectivity tracking alerts items0 based on the context it is used
func (m *IgroupConnectivityTrackingAlertsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingAlertsItems0) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupConnectivityTrackingAlertsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupConnectivityTrackingAlertsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupConnectivityTrackingAlertsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupConnectivityTrackingAlertsItems0Summary A user friendly message describing the connection state of the initiator group.
//
// swagger:model IgroupConnectivityTrackingAlertsItems0Summary
type IgroupConnectivityTrackingAlertsItems0Summary struct {

	// Message arguments
	// Read Only: true
	Arguments []*ErrorArguments `json:"arguments"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this igroup connectivity tracking alerts items0 summary
func (m *IgroupConnectivityTrackingAlertsItems0Summary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingAlertsItems0Summary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup connectivity tracking alerts items0 summary based on the context it is used
func (m *IgroupConnectivityTrackingAlertsItems0Summary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingAlertsItems0Summary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"arguments", "body", []*ErrorArguments(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupConnectivityTrackingAlertsItems0Summary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *IgroupConnectivityTrackingAlertsItems0Summary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupConnectivityTrackingAlertsItems0Summary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupConnectivityTrackingAlertsItems0Summary) UnmarshalBinary(b []byte) error {
	var res IgroupConnectivityTrackingAlertsItems0Summary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupConnectivityTrackingRequiredNodesItems0 igroup connectivity tracking required nodes items0
//
// swagger:model IgroupConnectivityTrackingRequiredNodesItems0
type IgroupConnectivityTrackingRequiredNodesItems0 struct {

	// links
	Links *IgroupConnectivityTrackingRequiredNodesItems0Links `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup connectivity tracking required nodes items0
func (m *IgroupConnectivityTrackingRequiredNodesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingRequiredNodesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup connectivity tracking required nodes items0 based on the context it is used
func (m *IgroupConnectivityTrackingRequiredNodesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingRequiredNodesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupConnectivityTrackingRequiredNodesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupConnectivityTrackingRequiredNodesItems0) UnmarshalBinary(b []byte) error {
	var res IgroupConnectivityTrackingRequiredNodesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupConnectivityTrackingRequiredNodesItems0Links igroup connectivity tracking required nodes items0 links
//
// swagger:model IgroupConnectivityTrackingRequiredNodesItems0Links
type IgroupConnectivityTrackingRequiredNodesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup connectivity tracking required nodes items0 links
func (m *IgroupConnectivityTrackingRequiredNodesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingRequiredNodesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup connectivity tracking required nodes items0 links based on the context it is used
func (m *IgroupConnectivityTrackingRequiredNodesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupConnectivityTrackingRequiredNodesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupConnectivityTrackingRequiredNodesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupConnectivityTrackingRequiredNodesItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupConnectivityTrackingRequiredNodesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItem igroup inline initiators inline array item
//
// swagger:model igroup_inline_initiators_inline_array_item
type IgroupInlineInitiatorsInlineArrayItem struct {

	// links
	Links *IgroupInlineInitiatorsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// connectivity tracking
	ConnectivityTracking *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// igroup
	Igroup *IgroupInlineInitiatorsInlineArrayItemInlineIgroup `json:"igroup,omitempty"`

	// The FC WWPN, iSCSI IQN, or iSCSI EUI that identifies the host initiator. Valid in POST only and not allowed when the `records` property is used.<br/>
	// An FC WWPN consists of 16 hexadecimal digits grouped as 8 pairs separated by colons. The format for an iSCSI IQN is _iqn.yyyy-mm.reverse_domain_name:any_. The iSCSI EUI format consists of the _eui._ prefix followed by 16 hexadecimal characters.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// proximity
	Proximity *IgroupInlineInitiatorsInlineArrayItemInlineProximity `json:"proximity,omitempty"`
}

// Validate validates this igroup inline initiators inline array item
func (m *IgroupInlineInitiatorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectivityTracking) { // not required
		return nil
	}

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(m.Proximity) { // not required
		return nil
	}

	if m.Proximity != nil {
		if err := m.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItem) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if m.Proximity != nil {
		if err := m.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking Overview of the initiator's connections to ONTAP.
//
// swagger:model igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
type IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking struct {

	// Connection state.
	//
	// Read Only: true
	// Enum: ["full","none","partial","no_lun_maps"]
	ConnectionState *string `json:"connection_state,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline connectivity tracking
func (m *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","none","partial","no_lun_maps"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum = append(igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// full
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateFull captures enum value "full"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateFull string = "full"

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// none
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNone captures enum value "none"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNone string = "none"

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// partial
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStatePartial captures enum value "partial"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_lun_maps
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNoLunMaps captures enum value "no_lun_maps"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNoLunMaps string = "no_lun_maps"
)

// prop value enum
func (m *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnectionStateEnum("connectivity_tracking"+"."+"connection_state", "body", *m.ConnectionState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline connectivity tracking based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConnectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) contextValidateConnectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity_tracking"+"."+"connection_state", "body", m.ConnectionState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItemInlineIgroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
// swagger:model igroup_inline_initiators_inline_array_item_inline_igroup
type IgroupInlineInitiatorsInlineArrayItemInlineIgroup struct {

	// links
	Links *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline igroup
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline igroup based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks igroup inline initiators inline array item inline igroup inline links
//
// swagger:model igroup_inline_initiators_inline_array_item_inline_igroup_inline__links
type IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline igroup inline links
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline igroup inline links based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItemInlineLinks igroup inline initiators inline array item inline links
//
// swagger:model igroup_inline_initiators_inline_array_item_inline__links
type IgroupInlineInitiatorsInlineArrayItemInlineLinks struct {

	// connectivity tracking
	ConnectivityTracking *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// self
	Self *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf `json:"self,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline links
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectivityTracking) { // not required
		return nil
	}

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline links based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking A link to the initiator with connectivity information relevant to its membership of this initiator group.
//
// swagger:model igroup_inline_initiators_inline_array_item_inline__links_inline_connectivity_tracking
type IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking struct {

	// href
	// Example: /api/resourcelink
	// Read Only: true
	Href *string `json:"href,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline links inline connectivity tracking
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline links inline connectivity tracking based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHref(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) contextValidateHref(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "_links"+"."+"connectivity_tracking"+"."+"href", "body", m.Href); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf A link to the initiator where mutations can be made. If the initiator is inherited from a nested initiator group, the link refers to the initiator in the nested initiator group. In this case, mutations of the initiator will be applied to all initiator groups referencing the same nested initiator group.
//
// swagger:model igroup_inline_initiators_inline_array_item_inline__links_inline_self
type IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf struct {

	// href
	// Example: /api/resourcelink
	// Read Only: true
	Href *string `json:"href,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline links inline self
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline links inline self based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHref(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) contextValidateHref(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "_links"+"."+"self"+"."+"href", "body", m.Href); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineInitiatorsInlineArrayItemInlineProximity Properties that define to what SVMs the initiator is proximal. This information is used to properly report active optimized and active non-optimized network paths via ALUA. If no configuration has been specified for an initiator, the sub-object will not be present in GET.<br/>
// These properties can be set via initiator group POST and PATCH and apply to all instances of the initiator in all initiator groups in the SVM and its peers. The `proximity` sub-object for an initiator is set in POST and PATCH in its entirety and replaces any previously set proximity for the initiator within the SVM for the initiator within the SVM. The `local_svm` property must always be set to `true` or `false` when setting the `proximity` property. To clear any previously set proximity, POST or PATCH the `proximity` object to `null`.
//
// swagger:model igroup_inline_initiators_inline_array_item_inline_proximity
type IgroupInlineInitiatorsInlineArrayItemInlineProximity struct {

	// A boolean that indicates if the initiator is proximal to the SVM of the containing initiator group. This is required for any POST or PATCH that includes the `proximity` sub-object.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the initiator is proximal.
	//
	PeerSvms []*IgroupInitiatorsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this igroup inline initiators inline array item inline proximity
func (m *IgroupInlineInitiatorsInlineArrayItemInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.PeerSvms); i++ {
		if swag.IsZero(m.PeerSvms[i]) { // not required
			continue
		}

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline proximity based on the context it is used
func (m *IgroupInlineInitiatorsInlineArrayItemInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineInitiatorsInlineArrayItemInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PeerSvms); i++ {

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineProximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineInitiatorsInlineArrayItemInlineProximity) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
//
// swagger:model IgroupInitiatorsItems0ProximityPeerSvmsItems0
type IgroupInitiatorsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *IgroupInitiatorsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiators items0 proximity peer svms items0
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiators items0 proximity peer svms items0 based on the context it is used
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorsItems0ProximityPeerSvmsItems0Links igroup initiators items0 proximity peer svms items0 links
//
// swagger:model IgroupInitiatorsItems0ProximityPeerSvmsItems0Links
type IgroupInitiatorsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiators items0 proximity peer svms items0 links
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiators items0 proximity peer svms items0 links based on the context it is used
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineLinks igroup inline links
//
// swagger:model igroup_inline__links
type IgroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline links
func (m *IgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline links based on the context it is used
func (m *IgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineLunMapsInlineArrayItem A LUN map with which the initiator group is associated.
//
// swagger:model igroup_inline_lun_maps_inline_array_item
type IgroupInlineLunMapsInlineArrayItem struct {

	// links
	Links *IgroupInlineLunMapsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The logical unit number assigned to the LUN for initiators in the initiator group.
	//
	// Read Only: true
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`

	// lun
	Lun *IgroupInlineLunMapsInlineArrayItemInlineLun `json:"lun,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item
func (m *IgroupInlineLunMapsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLun(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItem) validateLun(formats strfmt.Registry) error {
	if swag.IsZero(m.Lun) { // not required
		return nil
	}

	if m.Lun != nil {
		if err := m.Lun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item based on the context it is used
func (m *IgroupInlineLunMapsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUnitNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItem) contextValidateLogicalUnitNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_unit_number", "body", m.LogicalUnitNumber); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItem) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if m.Lun != nil {
		if err := m.Lun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineLunMapsInlineArrayItemInlineLinks igroup inline lun maps inline array item inline links
//
// swagger:model igroup_inline_lun_maps_inline_array_item_inline__links
type IgroupInlineLunMapsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline links
func (m *IgroupInlineLunMapsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline links based on the context it is used
func (m *IgroupInlineLunMapsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineLunMapsInlineArrayItemInlineLun The LUN to which the initiator group is mapped.
//
// swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun
type IgroupInlineLunMapsInlineArrayItemInlineLun struct {

	// links
	Links *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks `json:"_links,omitempty"`

	// The name of the LUN.
	//
	// Example: lun1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode `json:"node,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun
func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun based on the context it is used
func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLun) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks igroup inline lun maps inline array item inline lun inline links
//
// swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun_inline__links
type IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun inline links
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun inline links based on the context it is used
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode igroup inline lun maps inline array item inline lun inline node
//
// swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun_inline_node
type IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode struct {

	// links
	Links *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun inline node
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun inline node based on the context it is used
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks igroup inline lun maps inline array item inline lun inline node inline links
//
// swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun_inline_node_inline__links
type IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun inline node inline links
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun inline node inline links based on the context it is used
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlinePortset The portset to which the initiator group is bound. Binding the initiator group to a portset restricts the initiators of the group to accessing mapped LUNs only through network interfaces in the portset.<br/>
// In a nested initiator group hierarchy, only a portset bound to the initiator group at the same level at which it is mapped, applies; portsets bound to parent or child initiator groups are ignored.<br/>
// Optional in POST and PATCH. To unbind a portset from the initiator group, PATCH the `portset` object to  `null`, or PATCH `portset.name` to an empty string ("").
//
// swagger:model igroup_inline_portset
type IgroupInlinePortset struct {

	// links
	Links *IgroupInlinePortsetInlineLinks `json:"_links,omitempty"`

	// The name of the portset.
	//
	// Example: portset1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the portset.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline portset
func (m *IgroupInlinePortset) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlinePortset) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlinePortset) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("portset"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("portset"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline portset based on the context it is used
func (m *IgroupInlinePortset) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlinePortset) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlinePortset) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlinePortset) UnmarshalBinary(b []byte) error {
	var res IgroupInlinePortset
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlinePortsetInlineLinks igroup inline portset inline links
//
// swagger:model igroup_inline_portset_inline__links
type IgroupInlinePortsetInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline portset inline links
func (m *IgroupInlinePortsetInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlinePortsetInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline portset inline links based on the context it is used
func (m *IgroupInlinePortsetInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlinePortsetInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("portset" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlinePortsetInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlinePortsetInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlinePortsetInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineReplication Properties related to initiator group replication.
//
// swagger:model igroup_inline_replication
type IgroupInlineReplication struct {

	// error
	Error *IgroupInlineReplicationInlineError `json:"error,omitempty"`

	// peer svm
	PeerSvm *IgroupInlineReplicationInlinePeerSvm `json:"peer_svm,omitempty"`

	// The state of the replication queue associated with this igroup. If this igroup is not in the replication queue, the state is reported as _ok_. If this igroup is in the replication queue, but no errors have been encountered, the state is reported as _replicating_. If this igroup is in the replication queue and the queue is blocked by an error, the state is reported as _error_. When in the _error_ state, additional context is provided by the `replication.error` property.
	//
	// Read Only: true
	// Enum: ["ok","replicating","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this igroup inline replication
func (m *IgroupInlineReplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeerSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplication) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineReplication) validatePeerSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvm) { // not required
		return nil
	}

	if m.PeerSvm != nil {
		if err := m.PeerSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

var igroupInlineReplicationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","replicating","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInlineReplicationTypeStatePropEnum = append(igroupInlineReplicationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_inline_replication
	// IgroupInlineReplication
	// state
	// State
	// ok
	// END DEBUGGING
	// IgroupInlineReplicationStateOk captures enum value "ok"
	IgroupInlineReplicationStateOk string = "ok"

	// BEGIN DEBUGGING
	// igroup_inline_replication
	// IgroupInlineReplication
	// state
	// State
	// replicating
	// END DEBUGGING
	// IgroupInlineReplicationStateReplicating captures enum value "replicating"
	IgroupInlineReplicationStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// igroup_inline_replication
	// IgroupInlineReplication
	// state
	// State
	// error
	// END DEBUGGING
	// IgroupInlineReplicationStateError captures enum value "error"
	IgroupInlineReplicationStateError string = "error"
)

// prop value enum
func (m *IgroupInlineReplication) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInlineReplicationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IgroupInlineReplication) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("replication"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline replication based on the context it is used
func (m *IgroupInlineReplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeerSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplication) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineReplication) contextValidatePeerSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.PeerSvm != nil {
		if err := m.PeerSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineReplication) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineReplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineReplication) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineReplicationInlineError Information about asynchronous errors encountered while replicating this igroup. Igroups within a peering relationship are replicated in the same stream, so the error reported here might be related to this igroup or a prior replicated igroup that is now blocking the replication of this igroup. Both the error information and the igroup encountering the error are reported. If the error is configuration related, it can be corrected on the referenced igroup. The replication is retried using exponential backoff up to a maximum of one retry every 5 minutes. Every operation on the same stream triggers an immediate retry and restarts the exponential backoff starting with a 1 second delay. If the error is system related, the retries should correct the error when the system enters a healthy state.
//
// swagger:model igroup_inline_replication_inline_error
type IgroupInlineReplicationInlineError struct {

	// igroup
	Igroup *IgroupInlineReplicationInlineErrorInlineIgroup `json:"igroup,omitempty"`

	// summary
	Summary *IgroupInlineReplicationInlineErrorInlineSummary `json:"summary,omitempty"`
}

// Validate validates this igroup inline replication inline error
func (m *IgroupInlineReplicationInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlineError) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineReplicationInlineError) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline error based on the context it is used
func (m *IgroupInlineReplicationInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlineError) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInlineReplicationInlineError) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineReplicationInlineError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineReplicationInlineError) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineReplicationInlineErrorInlineIgroup igroup inline replication inline error inline igroup
//
// swagger:model igroup_inline_replication_inline_error_inline_igroup
type IgroupInlineReplicationInlineErrorInlineIgroup struct {

	// Indicates whether the reported igroup is on the local SVM or the peer SVM. When deleting a replicated igroup, the local copy is deleted first and then the peer copy is deleted. If the error is encountered between these two operations and only the peer igroup remains, the peer igroup is reported and the problem might need to be corrected on the peer cluster.
	//
	// Read Only: true
	LocalSvm *bool `json:"local_svm,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline replication inline error inline igroup
func (m *IgroupInlineReplicationInlineErrorInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlineErrorInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("replication"+"."+"error"+"."+"igroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("replication"+"."+"error"+"."+"igroup"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline error inline igroup based on the context it is used
func (m *IgroupInlineReplicationInlineErrorInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocalSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlineErrorInlineIgroup) contextValidateLocalSvm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"igroup"+"."+"local_svm", "body", m.LocalSvm); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineReplicationInlineErrorInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineReplicationInlineErrorInlineIgroup) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlineErrorInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineReplicationInlineErrorInlineSummary A user friendly message describing the error.
//
// swagger:model igroup_inline_replication_inline_error_inline_summary
type IgroupInlineReplicationInlineErrorInlineSummary struct {

	// Message arguments
	// Read Only: true
	Arguments []*ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this igroup inline replication inline error inline summary
func (m *IgroupInlineReplicationInlineErrorInlineSummary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlineErrorInlineSummary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup inline replication inline error inline summary based on the context it is used
func (m *IgroupInlineReplicationInlineErrorInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlineErrorInlineSummary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"summary"+"."+"arguments", "body", []*ErrorArguments(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInlineReplicationInlineErrorInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineReplicationInlineErrorInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineReplicationInlineErrorInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineReplicationInlineErrorInlineSummary) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlineErrorInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineReplicationInlinePeerSvm The peered SVM to which the initiator group should be replicated. Optional in POST and PATCH. To clear any previously set replication peer, PATCH the `replication.peer_svm` object to `null`.
//
// swagger:model igroup_inline_replication_inline_peer_svm
type IgroupInlineReplicationInlinePeerSvm struct {

	// links
	Links *IgroupInlineReplicationInlinePeerSvmInlineLinks `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline replication inline peer svm
func (m *IgroupInlineReplicationInlinePeerSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlinePeerSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline peer svm based on the context it is used
func (m *IgroupInlineReplicationInlinePeerSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlinePeerSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineReplicationInlinePeerSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineReplicationInlinePeerSvm) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlinePeerSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineReplicationInlinePeerSvmInlineLinks igroup inline replication inline peer svm inline links
//
// swagger:model igroup_inline_replication_inline_peer_svm_inline__links
type IgroupInlineReplicationInlinePeerSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline replication inline peer svm inline links
func (m *IgroupInlineReplicationInlinePeerSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlinePeerSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline peer svm inline links based on the context it is used
func (m *IgroupInlineReplicationInlinePeerSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineReplicationInlinePeerSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineReplicationInlinePeerSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineReplicationInlinePeerSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlinePeerSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model igroup_inline_svm
type IgroupInlineSvm struct {

	// links
	Links *IgroupInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline svm
func (m *IgroupInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline svm based on the context it is used
func (m *IgroupInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineSvm) UnmarshalBinary(b []byte) error {
	var res IgroupInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineSvmInlineLinks igroup inline svm inline links
//
// swagger:model igroup_inline_svm_inline__links
type IgroupInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup inline svm inline links
func (m *IgroupInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline svm inline links based on the context it is used
func (m *IgroupInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInlineTarget Properties of the SCSI target to which the initiator group provides access.
//
// swagger:model igroup_inline_target
type IgroupInlineTarget struct {

	// The firmware revision of the SCSI target specific to the OS type of the initiator group.
	//
	// Example: 9111
	// Read Only: true
	FirmwareRevision *string `json:"firmware_revision,omitempty"`

	// The product ID of the SCSI target.
	//
	// Example: LUN C-Mode
	// Read Only: true
	ProductID *string `json:"product_id,omitempty"`

	// The vendor ID of the SCSI target.
	//
	// Example: NETAPP
	// Read Only: true
	VendorID *string `json:"vendor_id,omitempty"`
}

// Validate validates this igroup inline target
func (m *IgroupInlineTarget) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this igroup inline target based on the context it is used
func (m *IgroupInlineTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFirmwareRevision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProductID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVendorID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInlineTarget) contextValidateFirmwareRevision(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "target"+"."+"firmware_revision", "body", m.FirmwareRevision); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineTarget) contextValidateProductID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "target"+"."+"product_id", "body", m.ProductID); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInlineTarget) contextValidateVendorID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "target"+"."+"vendor_id", "body", m.VendorID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInlineTarget) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInlineTarget) UnmarshalBinary(b []byte) error {
	var res IgroupInlineTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
