// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IgroupInitiator igroup initiator
//
// swagger:model igroup_initiator
type IgroupInitiator struct {

	// links
	Links *IgroupInitiatorInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// connectivity tracking
	ConnectivityTracking *IgroupInitiatorInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// igroup
	Igroup *IgroupInitiatorInlineIgroup `json:"igroup,omitempty"`

	// An array of initiators specified to add multiple initiators to an initiator group in a single API call. Not allowed when the `name` property is used.
	//
	IgroupInitiatorInlineRecords []*IgroupInitiatorInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// The FC WWPN, iSCSI IQN, or iSCSI EUI that identifies the host initiator. Valid in POST only and not allowed when the `records` property is used.<br/>
	// An FC WWPN consists of 16 hexadecimal digits grouped as 8 pairs separated by colons. The format for an iSCSI IQN is _iqn.yyyy-mm.reverse_domain_name:any_. The iSCSI EUI format consists of the _eui._ prefix followed by 16 hexadecimal characters.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// proximity
	Proximity *IgroupInitiatorInlineProximity `json:"proximity,omitempty"`
}

// Validate validates this igroup initiator
func (m *IgroupInitiator) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroupInitiatorInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiator) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiator) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiator) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectivityTracking) { // not required
		return nil
	}

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiator) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiator) validateIgroupInitiatorInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.IgroupInitiatorInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.IgroupInitiatorInlineRecords); i++ {
		if swag.IsZero(m.IgroupInitiatorInlineRecords[i]) { // not required
			continue
		}

		if m.IgroupInitiatorInlineRecords[i] != nil {
			if err := m.IgroupInitiatorInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInitiator) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiator) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(m.Proximity) { // not required
		return nil
	}

	if m.Proximity != nil {
		if err := m.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator based on the context it is used
func (m *IgroupInitiator) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroupInitiatorInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiator) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiator) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if m.ConnectivityTracking != nil {
		if err := m.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiator) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiator) contextValidateIgroupInitiatorInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IgroupInitiatorInlineRecords); i++ {

		if m.IgroupInitiatorInlineRecords[i] != nil {
			if err := m.IgroupInitiatorInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInitiator) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if m.Proximity != nil {
		if err := m.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiator) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiator) UnmarshalBinary(b []byte) error {
	var res IgroupInitiator
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineConnectivityTracking Overview of the initiator's connections to ONTAP.
//
// swagger:model igroup_initiator_inline_connectivity_tracking
type IgroupInitiatorInlineConnectivityTracking struct {

	// alerts
	// Read Only: true
	Alerts []*IgroupInitiatorConnectivityTrackingAlertsItems0 `json:"alerts,omitempty"`

	// Connection state.
	//
	// Read Only: true
	// Enum: ["full","none","partial","no_lun_maps"]
	ConnectionState *string `json:"connection_state,omitempty"`

	// connections
	Connections []*IgroupInitiatorConnectivityTrackingConnectionsItems0 `json:"connections,omitempty"`
}

// Validate validates this igroup initiator inline connectivity tracking
func (m *IgroupInitiatorInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlerts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnections(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineConnectivityTracking) validateAlerts(formats strfmt.Registry) error {
	if swag.IsZero(m.Alerts) { // not required
		return nil
	}

	for i := 0; i < len(m.Alerts); i++ {
		if swag.IsZero(m.Alerts[i]) { // not required
			continue
		}

		if m.Alerts[i] != nil {
			if err := m.Alerts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","none","partial","no_lun_maps"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum = append(igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// full
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStateFull captures enum value "full"
	IgroupInitiatorInlineConnectivityTrackingConnectionStateFull string = "full"

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// none
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStateNone captures enum value "none"
	IgroupInitiatorInlineConnectivityTrackingConnectionStateNone string = "none"

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// partial
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStatePartial captures enum value "partial"
	IgroupInitiatorInlineConnectivityTrackingConnectionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_lun_maps
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStateNoLunMaps captures enum value "no_lun_maps"
	IgroupInitiatorInlineConnectivityTrackingConnectionStateNoLunMaps string = "no_lun_maps"
)

// prop value enum
func (m *IgroupInitiatorInlineConnectivityTracking) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IgroupInitiatorInlineConnectivityTracking) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnectionStateEnum("connectivity_tracking"+"."+"connection_state", "body", *m.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorInlineConnectivityTracking) validateConnections(formats strfmt.Registry) error {
	if swag.IsZero(m.Connections) { // not required
		return nil
	}

	for i := 0; i < len(m.Connections); i++ {
		if swag.IsZero(m.Connections[i]) { // not required
			continue
		}

		if m.Connections[i] != nil {
			if err := m.Connections[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "connections" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator inline connectivity tracking based on the context it is used
func (m *IgroupInitiatorInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAlerts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnections(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineConnectivityTracking) contextValidateAlerts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity_tracking"+"."+"alerts", "body", []*IgroupInitiatorConnectivityTrackingAlertsItems0(m.Alerts)); err != nil {
		return err
	}

	for i := 0; i < len(m.Alerts); i++ {

		if m.Alerts[i] != nil {
			if err := m.Alerts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInitiatorInlineConnectivityTracking) contextValidateConnectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity_tracking"+"."+"connection_state", "body", m.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorInlineConnectivityTracking) contextValidateConnections(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Connections); i++ {

		if m.Connections[i] != nil {
			if err := m.Connections[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity_tracking" + "." + "connections" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingAlertsItems0 igroup initiator connectivity tracking alerts items0
//
// swagger:model IgroupInitiatorConnectivityTrackingAlertsItems0
type IgroupInitiatorConnectivityTrackingAlertsItems0 struct {

	// summary
	Summary *IgroupInitiatorConnectivityTrackingAlertsItems0Summary `json:"summary,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking alerts items0
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingAlertsItems0) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking alerts items0 based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingAlertsItems0) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingAlertsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingAlertsItems0Summary A user friendly message describing the connection state.
//
// swagger:model IgroupInitiatorConnectivityTrackingAlertsItems0Summary
type IgroupInitiatorConnectivityTrackingAlertsItems0Summary struct {

	// Message arguments
	// Read Only: true
	Arguments []*ErrorArguments `json:"arguments"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking alerts items0 summary
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking alerts items0 summary based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"arguments", "body", []*ErrorArguments(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingAlertsItems0Summary) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingAlertsItems0Summary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0 igroup initiator connectivity tracking connections items0
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0
type IgroupInitiatorConnectivityTrackingConnectionsItems0 struct {

	// logins
	Logins []*IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0 `json:"logins"`

	// node
	Node *IgroupInitiatorConnectivityTrackingConnectionsItems0Node `json:"node,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLogins(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) validateLogins(formats strfmt.Registry) error {
	if swag.IsZero(m.Logins) { // not required
		return nil
	}

	for i := 0; i < len(m.Logins); i++ {
		if swag.IsZero(m.Logins[i]) { // not required
			continue
		}

		if m.Logins[i] != nil {
			if err := m.Logins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("logins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) contextValidateLogins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Logins); i++ {

		if m.Logins[i] != nil {
			if err := m.Logins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("logins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0 igroup initiator connectivity tracking connections items0 logins items0
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0
type IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0 struct {

	// True if the initiator is currently logged in to this connection's interface.
	//
	// Read Only: true
	Connected *bool `json:"connected,omitempty"`

	// interface
	Interface *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface `json:"interface,omitempty"`

	// The last time this initiator logged in. Logins not seen for 48 hours are cleared and not reported.
	//
	// Example: 2021-03-14 05:19:00+00:00
	// Read Only: true
	// Format: date-time
	LastSeenTime *strfmt.DateTime `json:"last_seen_time,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 logins items0
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastSeenTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.Interface) { // not required
		return nil
	}

	if m.Interface != nil {
		if err := m.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) validateLastSeenTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastSeenTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_seen_time", "body", "date-time", m.LastSeenTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 logins items0 based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConnected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastSeenTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) contextValidateConnected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connected", "body", m.Connected); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.Interface != nil {
		if err := m.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) contextValidateLastSeenTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_seen_time", "body", m.LastSeenTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface igroup initiator connectivity tracking connections items0 logins items0 interface
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface
type IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface struct {

	// fc
	Fc *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc `json:"fc,omitempty"`

	// ip
	IP *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP `json:"ip,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 logins items0 interface
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 logins items0 interface based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc An FC interface.
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc
type IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc struct {

	// links
	Links *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks `json:"_links,omitempty"`

	// The name of the FC interface.
	//
	// Example: fc_lif1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the FC interface.
	//
	// Example: 3a09ab42-4da1-32cf-9d35-3385a6101a0b
	UUID *string `json:"uuid,omitempty"`

	// The WWPN of the FC interface.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 logins items0 interface fc
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 logins items0 interface fc based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"fc"+"."+"wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks igroup initiator connectivity tracking connections items0 logins items0 interface fc links
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks
type IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 logins items0 interface fc links
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 logins items0 interface fc links based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP A network interface. Either UUID or name may be supplied on input.
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP
type IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP struct {

	// links
	Links *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks `json:"_links,omitempty"`

	// ip
	IP *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 logins items0 interface IP
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 logins items0 interface IP based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP IP information
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP
type IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 logins items0 interface IP IP
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 logins items0 interface IP IP based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks igroup initiator connectivity tracking connections items0 logins items0 interface IP links
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks
type IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 logins items0 interface IP links
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 logins items0 interface IP links based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0Node igroup initiator connectivity tracking connections items0 node
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0Node
type IgroupInitiatorConnectivityTrackingConnectionsItems0Node struct {

	// links
	Links *IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 node
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 node based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0Node) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0Node) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks igroup initiator connectivity tracking connections items0 node links
//
// swagger:model IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks
type IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator connectivity tracking connections items0 node links
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator connectivity tracking connections items0 node links based on the context it is used
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorConnectivityTrackingConnectionsItems0NodeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineIgroup The initiator group in which the initiator is found.<br/>
// Note that this does not mean that the initiator cannot also be found in other initiator groups.
//
// swagger:model igroup_initiator_inline_igroup
type IgroupInitiatorInlineIgroup struct {

	// links
	Links *IgroupInitiatorInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator inline igroup
func (m *IgroupInitiatorInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup initiator inline igroup based on the context it is used
func (m *IgroupInitiatorInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineIgroup) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineIgroupInlineLinks igroup initiator inline igroup inline links
//
// swagger:model igroup_initiator_inline_igroup_inline__links
type IgroupInitiatorInlineIgroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator inline igroup inline links
func (m *IgroupInitiatorInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline igroup inline links based on the context it is used
func (m *IgroupInitiatorInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineLinks igroup initiator inline links
//
// swagger:model igroup_initiator_inline__links
type IgroupInitiatorInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator inline links
func (m *IgroupInitiatorInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline links based on the context it is used
func (m *IgroupInitiatorInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineProximity Properties that define to what SVMs the initiator is proximal. This information is used to properly report active optimized and active non-optimized network paths via ALUA. If no configuration has been specified for an initiator, the sub-object will not be present in GET.<br/>
// These properties can be set via initiator group POST and PATCH and apply to all instances of the initiator in all initiator groups in the SVM and its peers. The `proximity` sub-object for an initiator is set in POST and PATCH in its entirety and replaces any previously set proximity for the initiator within the SVM for the initiator within the SVM. The `local_svm` property must always be set to `true` or `false` when setting the `proximity` property. To clear any previously set proximity, POST or PATCH the `proximity` object to `null`.
//
// swagger:model igroup_initiator_inline_proximity
type IgroupInitiatorInlineProximity struct {

	// A boolean that indicates if the initiator is proximal to the SVM of the containing initiator group. This is required for any POST or PATCH that includes the `proximity` sub-object.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the initiator is proximal.
	//
	PeerSvms []*IgroupInitiatorProximityPeerSvmsItems0 `json:"peer_svms,omitempty"`
}

// Validate validates this igroup initiator inline proximity
func (m *IgroupInitiatorInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.PeerSvms); i++ {
		if swag.IsZero(m.PeerSvms[i]) { // not required
			continue
		}

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator inline proximity based on the context it is used
func (m *IgroupInitiatorInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PeerSvms); i++ {

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineProximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineProximity) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorProximityPeerSvmsItems0 A reference to an SVM peer relationship.
//
// swagger:model IgroupInitiatorProximityPeerSvmsItems0
type IgroupInitiatorProximityPeerSvmsItems0 struct {

	// links
	Links *IgroupInitiatorProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator proximity peer svms items0
func (m *IgroupInitiatorProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator proximity peer svms items0 based on the context it is used
func (m *IgroupInitiatorProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorProximityPeerSvmsItems0Links igroup initiator proximity peer svms items0 links
//
// swagger:model IgroupInitiatorProximityPeerSvmsItems0Links
type IgroupInitiatorProximityPeerSvmsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator proximity peer svms items0 links
func (m *IgroupInitiatorProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator proximity peer svms items0 links based on the context it is used
func (m *IgroupInitiatorProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineRecordsInlineArrayItem igroup initiator inline records inline array item
//
// swagger:model igroup_initiator_inline_records_inline_array_item
type IgroupInitiatorInlineRecordsInlineArrayItem struct {

	// links
	Links *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The FC WWPN, iSCSI IQN, or iSCSI EUI that identifies the host initiator. Valid in POST only and not allowed when the `records` property is used.<br/>
	// An FC WWPN consists of 16 hexadecimal digits grouped as 8 pairs separated by colons. The format for an iSCSI IQN is _iqn.yyyy-mm.reverse_domain_name:any_. The iSCSI EUI format consists of the _eui._ prefix followed by 16 hexadecimal characters.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// proximity
	Proximity *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity `json:"proximity,omitempty"`
}

// Validate validates this igroup initiator inline records inline array item
func (m *IgroupInitiatorInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItem) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(m.Proximity) { // not required
		return nil
	}

	if m.Proximity != nil {
		if err := m.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline records inline array item based on the context it is used
func (m *IgroupInitiatorInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItem) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if m.Proximity != nil {
		if err := m.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks igroup initiator inline records inline array item inline links
//
// swagger:model igroup_initiator_inline_records_inline_array_item_inline__links
type IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator inline records inline array item inline links
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline records inline array item inline links based on the context it is used
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity Properties that define to what SVMs the initiator is proximal. This information is used to properly report active optimized and active non-optimized network paths via ALUA. If no configuration has been specified for an initiator, the sub-object will not be present in GET.<br/>
// These properties can be set via initiator group POST and PATCH and apply to all instances of the initiator in all initiator groups in the SVM and its peers. The `proximity` sub-object for an initiator is set in POST and PATCH in its entirety and replaces any previously set proximity for the initiator within the SVM for the initiator within the SVM. The `local_svm` property must always be set to `true` or `false` when setting the `proximity` property. To clear any previously set proximity, POST or PATCH the `proximity` object to `null`.
//
// swagger:model igroup_initiator_inline_records_inline_array_item_inline_proximity
type IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity struct {

	// A boolean that indicates if the initiator is proximal to the SVM of the containing initiator group. This is required for any POST or PATCH that includes the `proximity` sub-object.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the initiator is proximal.
	//
	PeerSvms []*IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this igroup initiator inline records inline array item inline proximity
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.PeerSvms); i++ {
		if swag.IsZero(m.PeerSvms[i]) { // not required
			continue
		}

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator inline records inline array item inline proximity based on the context it is used
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PeerSvms); i++ {

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
//
// swagger:model IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0
type IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator records items0 proximity peer svms items0
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator records items0 proximity peer svms items0 based on the context it is used
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links igroup initiator records items0 proximity peer svms items0 links
//
// swagger:model IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links
type IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator records items0 proximity peer svms items0 links
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator records items0 proximity peer svms items0 links based on the context it is used
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorRecordsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
