// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IgroupInitiatorNoRecords igroup initiator no records
//
// swagger:model igroup_initiator_no_records
type IgroupInitiatorNoRecords struct {

	// links
	Links *IgroupInitiatorNoRecordsInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The FC WWPN, iSCSI IQN, or iSCSI EUI that identifies the host initiator. Valid in POST only and not allowed when the `records` property is used.<br/>
	// An FC WWPN consists of 16 hexadecimal digits grouped as 8 pairs separated by colons. The format for an iSCSI IQN is _iqn.yyyy-mm.reverse_domain_name:any_. The iSCSI EUI format consists of the _eui._ prefix followed by 16 hexadecimal characters.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// proximity
	Proximity *IgroupInitiatorNoRecordsInlineProximity `json:"proximity,omitempty"`
}

// Validate validates this igroup initiator no records
func (m *IgroupInitiatorNoRecords) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecords) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorNoRecords) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorNoRecords) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

func (m *IgroupInitiatorNoRecords) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(m.Proximity) { // not required
		return nil
	}

	if m.Proximity != nil {
		if err := m.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator no records based on the context it is used
func (m *IgroupInitiatorNoRecords) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecords) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IgroupInitiatorNoRecords) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if m.Proximity != nil {
		if err := m.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorNoRecords) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorNoRecords) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorNoRecords
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorNoRecordsInlineLinks igroup initiator no records inline links
//
// swagger:model igroup_initiator_no_records_inline__links
type IgroupInitiatorNoRecordsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator no records inline links
func (m *IgroupInitiatorNoRecordsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator no records inline links based on the context it is used
func (m *IgroupInitiatorNoRecordsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorNoRecordsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorNoRecordsInlineProximity Properties that define to what SVMs the initiator is proximal. This information is used to properly report active optimized and active non-optimized network paths via ALUA. If no configuration has been specified for an initiator, the sub-object will not be present in GET.<br/>
// These properties can be set via initiator group POST and PATCH and apply to all instances of the initiator in all initiator groups in the SVM and its peers. The `proximity` sub-object for an initiator is set in POST and PATCH in its entirety and replaces any previously set proximity for the initiator within the SVM for the initiator within the SVM. The `local_svm` property must always be set to `true` or `false` when setting the `proximity` property. To clear any previously set proximity, POST or PATCH the `proximity` object to `null`.
//
// swagger:model igroup_initiator_no_records_inline_proximity
type IgroupInitiatorNoRecordsInlineProximity struct {

	// A boolean that indicates if the initiator is proximal to the SVM of the containing initiator group. This is required for any POST or PATCH that includes the `proximity` sub-object.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the initiator is proximal.
	//
	PeerSvms []*IgroupInitiatorNoRecordsProximityPeerSvmsItems0 `json:"peer_svms,omitempty"`
}

// Validate validates this igroup initiator no records inline proximity
func (m *IgroupInitiatorNoRecordsInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.PeerSvms); i++ {
		if swag.IsZero(m.PeerSvms[i]) { // not required
			continue
		}

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator no records inline proximity based on the context it is used
func (m *IgroupInitiatorNoRecordsInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PeerSvms); i++ {

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsInlineProximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsInlineProximity) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorNoRecordsInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorNoRecordsProximityPeerSvmsItems0 A reference to an SVM peer relationship.
//
// swagger:model IgroupInitiatorNoRecordsProximityPeerSvmsItems0
type IgroupInitiatorNoRecordsProximityPeerSvmsItems0 struct {

	// links
	Links *IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator no records proximity peer svms items0
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator no records proximity peer svms items0 based on the context it is used
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorNoRecordsProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links igroup initiator no records proximity peer svms items0 links
//
// swagger:model IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links
type IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator no records proximity peer svms items0 links
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator no records proximity peer svms items0 links based on the context it is used
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorNoRecordsProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
