// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IPInterface ip interface
//
// swagger:model ip_interface
type IPInterface struct {

	// links
	Links *IPInterfaceInlineLinks `json:"_links,omitempty"`

	// Indicates whether or not dynamic DNS updates are enabled. Defaults to true if the interface supports "data_nfs" or "data_cifs" services, otherwise false.
	DdnsEnabled *bool `json:"ddns_enabled,omitempty"`

	// Fully qualified DNS zone name
	// Example: storage.company.com
	DNSZone *string `json:"dns_zone,omitempty"`

	// The administrative state of the interface.
	Enabled *bool `json:"enabled,omitempty"`

	// This command fails if the specified IP address falls within the address range of a named subnet. Set this value to false to use the specified IP address and to assign the subnet owning that address to the interface.
	FailIfSubnetConflicts *bool `json:"fail_if_subnet_conflicts,omitempty"`

	// ip
	IP *IPInfo `json:"ip,omitempty"`

	// The services associated with the interface.
	// Read Only: true
	IPInterfaceInlineServices []*IPService `json:"services,omitempty"`

	// ipspace
	Ipspace *IPInterfaceInlineIpspace `json:"ipspace,omitempty"`

	// location
	Location *IPInterfaceInlineLocation `json:"location,omitempty"`

	// metric
	Metric *IPInterfaceInlineMetric `json:"metric,omitempty"`

	// Interface name
	// Example: dataLif1
	Name *string `json:"name,omitempty"`

	// Probe port for Cloud load balancer
	// Example: 64001
	ProbePort *int64 `json:"probe_port,omitempty"`

	// Supported RDMA offload protocols
	RdmaProtocols []*string `json:"rdma_protocols,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// service policy
	ServicePolicy *IPInterfaceInlineServicePolicy `json:"service_policy,omitempty"`

	// The operational state of the interface.
	// Read Only: true
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *IPInterfaceInlineStatistics `json:"statistics,omitempty"`

	// Use this field to allocate an interface address from a subnet. If needed, a default route is created for this subnet.
	Subnet *IPSubnetReference `json:"subnet,omitempty"`

	// svm
	Svm *IPInterfaceInlineSvm `json:"svm,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// True for a VIP interface, whose location is announced via BGP.
	Vip *bool `json:"vip,omitempty"`
}

// Validate validates this ip interface
func (m *IPInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPInterfaceInlineServices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRdmaProtocols(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServicePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubnet(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) validateIPInterfaceInlineServices(formats strfmt.Registry) error {
	if swag.IsZero(m.IPInterfaceInlineServices) { // not required
		return nil
	}

	for i := 0; i < len(m.IPInterfaceInlineServices); i++ {
		if swag.IsZero(m.IPInterfaceInlineServices[i]) { // not required
			continue
		}

		if m.IPInterfaceInlineServices[i] != nil {
			if err := m.IPInterfaceInlineServices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("services" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IPInterface) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

var ipInterfaceRdmaProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["roce"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceRdmaProtocolsItemsEnum = append(ipInterfaceRdmaProtocolsItemsEnum, v)
	}
}

func (m *IPInterface) validateRdmaProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceRdmaProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPInterface) validateRdmaProtocols(formats strfmt.Registry) error {
	if swag.IsZero(m.RdmaProtocols) { // not required
		return nil
	}

	for i := 0; i < len(m.RdmaProtocols); i++ {
		if swag.IsZero(m.RdmaProtocols[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateRdmaProtocolsItemsEnum("rdma_protocols"+"."+strconv.Itoa(i), "body", *m.RdmaProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

var ipInterfaceTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceTypeScopePropEnum = append(ipInterfaceTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface
	// IPInterface
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// IPInterfaceScopeSvm captures enum value "svm"
	IPInterfaceScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// ip_interface
	// IPInterface
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// IPInterfaceScopeCluster captures enum value "cluster"
	IPInterfaceScopeCluster string = "cluster"
)

// prop value enum
func (m *IPInterface) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPInterface) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *IPInterface) validateServicePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ServicePolicy) { // not required
		return nil
	}

	if m.ServicePolicy != nil {
		if err := m.ServicePolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_policy")
			}
			return err
		}
	}

	return nil
}

var ipInterfaceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceTypeStatePropEnum = append(ipInterfaceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface
	// IPInterface
	// state
	// State
	// up
	// END DEBUGGING
	// IPInterfaceStateUp captures enum value "up"
	IPInterfaceStateUp string = "up"

	// BEGIN DEBUGGING
	// ip_interface
	// IPInterface
	// state
	// State
	// down
	// END DEBUGGING
	// IPInterfaceStateDown captures enum value "down"
	IPInterfaceStateDown string = "down"
)

// prop value enum
func (m *IPInterface) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPInterface) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *IPInterface) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) validateSubnet(formats strfmt.Registry) error {
	if swag.IsZero(m.Subnet) { // not required
		return nil
	}

	if m.Subnet != nil {
		if err := m.Subnet.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subnet")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface based on the context it is used
func (m *IPInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPInterfaceInlineServices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServicePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubnet(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateIPInterfaceInlineServices(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "services", "body", []*IPService(m.IPInterfaceInlineServices)); err != nil {
		return err
	}

	for i := 0; i < len(m.IPInterfaceInlineServices); i++ {

		if m.IPInterfaceInlineServices[i] != nil {
			if err := m.IPInterfaceInlineServices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("services" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IPInterface) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateServicePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ServicePolicy != nil {
		if err := m.ServicePolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_policy")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *IPInterface) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateSubnet(ctx context.Context, formats strfmt.Registry) error {

	if m.Subnet != nil {
		if err := m.Subnet.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subnet")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterface) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterface) UnmarshalBinary(b []byte) error {
	var res IPInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineIpspace Either the UUID or name must be supplied on POST for cluster-scoped objects.
//
// swagger:model ip_interface_inline_ipspace
type IPInterfaceInlineIpspace struct {

	// links
	Links *IPInterfaceInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline ipspace
func (m *IPInterfaceInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline ipspace based on the context it is used
func (m *IPInterfaceInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineIpspace) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineIpspaceInlineLinks ip interface inline ipspace inline links
//
// swagger:model ip_interface_inline_ipspace_inline__links
type IPInterfaceInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline ipspace inline links
func (m *IPInterfaceInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline ipspace inline links based on the context it is used
func (m *IPInterfaceInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLinks ip interface inline links
//
// swagger:model ip_interface_inline__links
type IPInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline links
func (m *IPInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline links based on the context it is used
func (m *IPInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocation Current or home location can be modified. Specifying a port implies a node. Specifying a node allows an appropriate port to be automatically selected. Ports are not valid and not shown for VIP interfaces. For POST, broadcast_domain can be specified alone or with home_node.  For PATCH, set is_home to true to revert a LIF back to its home port.
//
// swagger:model ip_interface_inline_location
type IPInterfaceInlineLocation struct {

	// auto revert
	AutoRevert *bool `json:"auto_revert,omitempty"`

	// broadcast domain
	BroadcastDomain *IPInterfaceInlineLocationInlineBroadcastDomain `json:"broadcast_domain,omitempty"`

	// failover
	Failover *FailoverScope `json:"failover,omitempty"`

	// home node
	HomeNode *IPInterfaceInlineLocationInlineHomeNode `json:"home_node,omitempty"`

	// home port
	HomePort *IPInterfaceInlineLocationInlineHomePort `json:"home_port,omitempty"`

	// is home
	IsHome *bool `json:"is_home,omitempty"`

	// node
	Node *IPInterfaceInlineLocationInlineNode `json:"node,omitempty"`

	// port
	Port *IPInterfaceInlineLocationInlinePort `json:"port,omitempty"`
}

// Validate validates this ip interface inline location
func (m *IPInterfaceInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBroadcastDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailover(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHomePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocation) validateBroadcastDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.BroadcastDomain) { // not required
		return nil
	}

	if m.BroadcastDomain != nil {
		if err := m.BroadcastDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) validateFailover(formats strfmt.Registry) error {
	if swag.IsZero(m.Failover) { // not required
		return nil
	}

	if m.Failover != nil {
		if err := m.Failover.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "failover")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) validateHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(m.HomeNode) { // not required
		return nil
	}

	if m.HomeNode != nil {
		if err := m.HomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) validateHomePort(formats strfmt.Registry) error {
	if swag.IsZero(m.HomePort) { // not required
		return nil
	}

	if m.HomePort != nil {
		if err := m.HomePort.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location based on the context it is used
func (m *IPInterfaceInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBroadcastDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailover(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHomePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocation) contextValidateBroadcastDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.BroadcastDomain != nil {
		if err := m.BroadcastDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "broadcast_domain")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) contextValidateFailover(ctx context.Context, formats strfmt.Registry) error {

	if m.Failover != nil {
		if err := m.Failover.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "failover")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) contextValidateHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if m.HomeNode != nil {
		if err := m.HomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) contextValidateHomePort(ctx context.Context, formats strfmt.Registry) error {

	if m.HomePort != nil {
		if err := m.HomePort.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocation) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocation) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineBroadcastDomain Broadcast domain UUID along with a readable name.
//
// swagger:model ip_interface_inline_location_inline_broadcast_domain
type IPInterfaceInlineLocationInlineBroadcastDomain struct {

	// links
	Links *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks `json:"_links,omitempty"`

	// Name of the broadcast domain, scoped to its IPspace
	// Example: bd1
	Name *string `json:"name,omitempty"`

	// Broadcast domain UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline broadcast domain
func (m *IPInterfaceInlineLocationInlineBroadcastDomain) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineBroadcastDomain) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline broadcast domain based on the context it is used
func (m *IPInterfaceInlineLocationInlineBroadcastDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineBroadcastDomain) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "broadcast_domain" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineBroadcastDomain) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineBroadcastDomain) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineBroadcastDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks ip interface inline location inline broadcast domain inline links
//
// swagger:model ip_interface_inline_location_inline_broadcast_domain_inline__links
type IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline broadcast domain inline links
func (m *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline broadcast domain inline links based on the context it is used
func (m *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "broadcast_domain" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineBroadcastDomainInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineHomeNode ip interface inline location inline home node
//
// swagger:model ip_interface_inline_location_inline_home_node
type IPInterfaceInlineLocationInlineHomeNode struct {

	// links
	Links *IPInterfaceInlineLocationInlineHomeNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline home node
func (m *IPInterfaceInlineLocationInlineHomeNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomeNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home node based on the context it is used
func (m *IPInterfaceInlineLocationInlineHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomeNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomeNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomeNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineHomeNodeInlineLinks ip interface inline location inline home node inline links
//
// swagger:model ip_interface_inline_location_inline_home_node_inline__links
type IPInterfaceInlineLocationInlineHomeNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline home node inline links
func (m *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home node inline links based on the context it is used
func (m *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomeNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomeNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineHomePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
//
// swagger:model ip_interface_inline_location_inline_home_port
type IPInterfaceInlineLocationInlineHomePort struct {

	// links
	Links *IPInterfaceInlineLocationInlineHomePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *IPInterfaceInlineLocationInlineHomePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline home port
func (m *IPInterfaceInlineLocationInlineHomePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocationInlineHomePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home port based on the context it is used
func (m *IPInterfaceInlineLocationInlineHomePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocationInlineHomePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomePort) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineHomePortInlineLinks ip interface inline location inline home port inline links
//
// swagger:model ip_interface_inline_location_inline_home_port_inline__links
type IPInterfaceInlineLocationInlineHomePortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline home port inline links
func (m *IPInterfaceInlineLocationInlineHomePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline home port inline links based on the context it is used
func (m *IPInterfaceInlineLocationInlineHomePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineHomePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "home_port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomePortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineHomePortInlineNode ip interface inline location inline home port inline node
//
// swagger:model ip_interface_inline_location_inline_home_port_inline_node
type IPInterfaceInlineLocationInlineHomePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this ip interface inline location inline home port inline node
func (m *IPInterfaceInlineLocationInlineHomePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline location inline home port inline node based on context it is used
func (m *IPInterfaceInlineLocationInlineHomePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomePortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineHomePortInlineNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineHomePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineNode ip interface inline location inline node
//
// swagger:model ip_interface_inline_location_inline_node
type IPInterfaceInlineLocationInlineNode struct {

	// links
	Links *IPInterfaceInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline node
func (m *IPInterfaceInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline node based on the context it is used
func (m *IPInterfaceInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlineNodeInlineLinks ip interface inline location inline node inline links
//
// swagger:model ip_interface_inline_location_inline_node_inline__links
type IPInterfaceInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline node inline links
func (m *IPInterfaceInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline node inline links based on the context it is used
func (m *IPInterfaceInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlinePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
//
// swagger:model ip_interface_inline_location_inline_port
type IPInterfaceInlineLocationInlinePort struct {

	// links
	Links *IPInterfaceInlineLocationInlinePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *IPInterfaceInlineLocationInlinePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline location inline port
func (m *IPInterfaceInlineLocationInlinePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlinePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocationInlinePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline port based on the context it is used
func (m *IPInterfaceInlineLocationInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlinePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineLocationInlinePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlinePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlinePort) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlinePortInlineLinks ip interface inline location inline port inline links
//
// swagger:model ip_interface_inline_location_inline_port_inline__links
type IPInterfaceInlineLocationInlinePortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline location inline port inline links
func (m *IPInterfaceInlineLocationInlinePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlinePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline location inline port inline links based on the context it is used
func (m *IPInterfaceInlineLocationInlinePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineLocationInlinePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlinePortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlinePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlinePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineLocationInlinePortInlineNode ip interface inline location inline port inline node
//
// swagger:model ip_interface_inline_location_inline_port_inline_node
type IPInterfaceInlineLocationInlinePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this ip interface inline location inline port inline node
func (m *IPInterfaceInlineLocationInlinePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline location inline port inline node based on context it is used
func (m *IPInterfaceInlineLocationInlinePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlinePortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineLocationInlinePortInlineNode) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineLocationInlinePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineMetric The most recent sample of I/O metrics for the interface.
//
// swagger:model ip_interface_inline_metric
type IPInterfaceInlineMetric struct {

	// links
	Links *IPInterfaceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *IPInterfaceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this ip interface inline metric
func (m *IPInterfaceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var ipInterfaceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceInlineMetricTypeDurationPropEnum = append(ipInterfaceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT15S captures enum value "PT15S"
	IPInterfaceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT4M captures enum value "PT4M"
	IPInterfaceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT30M captures enum value "PT30M"
	IPInterfaceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT2H captures enum value "PT2H"
	IPInterfaceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationP1D captures enum value "P1D"
	IPInterfaceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// IPInterfaceInlineMetricDurationPT5M captures enum value "PT5M"
	IPInterfaceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *IPInterfaceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPInterfaceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var ipInterfaceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceInlineMetricTypeStatusPropEnum = append(ipInterfaceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusOk captures enum value "ok"
	IPInterfaceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusError captures enum value "error"
	IPInterfaceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	IPInterfaceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	IPInterfaceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	IPInterfaceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	IPInterfaceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	IPInterfaceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	IPInterfaceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	IPInterfaceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// ip_interface_inline_metric
	// IPInterfaceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// IPInterfaceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	IPInterfaceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *IPInterfaceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPInterfaceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *IPInterfaceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ip interface inline metric based on the context it is used
func (m *IPInterfaceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineMetric) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineMetricInlineLinks ip interface inline metric inline links
//
// swagger:model ip_interface_inline_metric_inline__links
type IPInterfaceInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline metric inline links
func (m *IPInterfaceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline metric inline links based on the context it is used
func (m *IPInterfaceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the interface.
//
// swagger:model ip_interface_inline_metric_inline_throughput
type IPInterfaceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this ip interface inline metric inline throughput
func (m *IPInterfaceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline metric inline throughput based on context it is used
func (m *IPInterfaceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineServicePolicy ip interface inline service policy
//
// swagger:model ip_interface_inline_service_policy
type IPInterfaceInlineServicePolicy struct {

	// links
	Links *IPInterfaceInlineServicePolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default-intercluster
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline service policy
func (m *IPInterfaceInlineServicePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineServicePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline service policy based on the context it is used
func (m *IPInterfaceInlineServicePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineServicePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineServicePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineServicePolicy) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineServicePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineServicePolicyInlineLinks ip interface inline service policy inline links
//
// swagger:model ip_interface_inline_service_policy_inline__links
type IPInterfaceInlineServicePolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline service policy inline links
func (m *IPInterfaceInlineServicePolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineServicePolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline service policy inline links based on the context it is used
func (m *IPInterfaceInlineServicePolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineServicePolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineServicePolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineServicePolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineServicePolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineStatistics The real time I/O statistics for the interface.
//
// swagger:model ip_interface_inline_statistics
type IPInterfaceInlineStatistics struct {

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *IPInterfaceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this ip interface inline statistics
func (m *IPInterfaceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipInterfaceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipInterfaceInlineStatisticsTypeStatusPropEnum = append(ipInterfaceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusOk captures enum value "ok"
	IPInterfaceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusError captures enum value "error"
	IPInterfaceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	IPInterfaceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	IPInterfaceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	IPInterfaceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	IPInterfaceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	IPInterfaceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	IPInterfaceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	IPInterfaceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// ip_interface_inline_statistics
	// IPInterfaceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// IPInterfaceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	IPInterfaceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *IPInterfaceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipInterfaceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPInterfaceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *IPInterfaceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ip interface inline statistics based on the context it is used
func (m *IPInterfaceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the interface. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model ip_interface_inline_statistics_inline_throughput_raw
type IPInterfaceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this ip interface inline statistics inline throughput raw
func (m *IPInterfaceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ip interface inline statistics inline throughput raw based on context it is used
func (m *IPInterfaceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineSvm Applies only to SVM-scoped objects. Either the UUID or name must be supplied on POST.
//
// swagger:model ip_interface_inline_svm
type IPInterfaceInlineSvm struct {

	// links
	Links *IPInterfaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ip interface inline svm
func (m *IPInterfaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline svm based on the context it is used
func (m *IPInterfaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceInlineSvmInlineLinks ip interface inline svm inline links
//
// swagger:model ip_interface_inline_svm_inline__links
type IPInterfaceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface inline svm inline links
func (m *IPInterfaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface inline svm inline links based on the context it is used
func (m *IPInterfaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
