// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IPInterfaceResponse ip interface response
//
// swagger:model ip_interface_response
type IPInterfaceResponse struct {

	// links
	Links *IPInterfaceResponseInlineLinks `json:"_links,omitempty"`

	// ip interface response inline records
	IPInterfaceResponseInlineRecords []*IPInterface `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// recommend
	Recommend *IPInterfaceResponseInlineRecommend `json:"recommend,omitempty"`
}

// Validate validates this ip interface response
func (m *IPInterfaceResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPInterfaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRecommend(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceResponse) validateIPInterfaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.IPInterfaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.IPInterfaceResponseInlineRecords); i++ {
		if swag.IsZero(m.IPInterfaceResponseInlineRecords[i]) { // not required
			continue
		}

		if m.IPInterfaceResponseInlineRecords[i] != nil {
			if err := m.IPInterfaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IPInterfaceResponse) validateRecommend(formats strfmt.Registry) error {
	if swag.IsZero(m.Recommend) { // not required
		return nil
	}

	if m.Recommend != nil {
		if err := m.Recommend.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("recommend")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface response based on the context it is used
func (m *IPInterfaceResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPInterfaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRecommend(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceResponse) contextValidateIPInterfaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IPInterfaceResponseInlineRecords); i++ {

		if m.IPInterfaceResponseInlineRecords[i] != nil {
			if err := m.IPInterfaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IPInterfaceResponse) contextValidateRecommend(ctx context.Context, formats strfmt.Registry) error {

	if m.Recommend != nil {
		if err := m.Recommend.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("recommend")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceResponse) UnmarshalBinary(b []byte) error {
	var res IPInterfaceResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceResponseInlineLinks ip interface response inline links
//
// swagger:model ip_interface_response_inline__links
type IPInterfaceResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ip interface response inline links
func (m *IPInterfaceResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ip interface response inline links based on the context it is used
func (m *IPInterfaceResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *IPInterfaceResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res IPInterfaceResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IPInterfaceResponseInlineRecommend Response properties specific to the LIF recommendation functionality.
//
// swagger:model ip_interface_response_inline_recommend
type IPInterfaceResponseInlineRecommend struct {

	// Messages describing the results of a LIF recommendation request.
	//
	// Read Only: true
	Messages []IPInterfaceRecommendMessage `json:"messages,omitempty"`
}

// Validate validates this ip interface response inline recommend
func (m *IPInterfaceResponseInlineRecommend) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ip interface response inline recommend based on the context it is used
func (m *IPInterfaceResponseInlineRecommend) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMessages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPInterfaceResponseInlineRecommend) contextValidateMessages(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "recommend"+"."+"messages", "body", []IPInterfaceRecommendMessage(m.Messages)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPInterfaceResponseInlineRecommend) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPInterfaceResponseInlineRecommend) UnmarshalBinary(b []byte) error {
	var res IPInterfaceResponseInlineRecommend
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
