// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IPV4Interface Object to set up an interface along with its default router.
//
// swagger:model ipv4_interface
type IPV4Interface struct {

	// IPv4 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv4 interfaces is enabled. It expects dhcp_enabled as "true" or values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv4 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// Input as IPv4 mask (255.255.0.0). Output is always the netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this ipv4 interface
func (m *IPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipv4InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipv4InterfaceTypeSetupStatePropEnum = append(ipv4InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipv4_interface
	// IPV4Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// IPV4InterfaceSetupStateNotSetup captures enum value "not_setup"
	IPV4InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// ipv4_interface
	// IPV4Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// IPV4InterfaceSetupStateSucceeded captures enum value "succeeded"
	IPV4InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// ipv4_interface
	// IPV4Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// IPV4InterfaceSetupStateInProgress captures enum value "in_progress"
	IPV4InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// ipv4_interface
	// IPV4Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// IPV4InterfaceSetupStateFailed captures enum value "failed"
	IPV4InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *IPV4Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipv4InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPV4Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ipv4 interface based on the context it is used
func (m *IPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPV4Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPV4Interface) UnmarshalBinary(b []byte) error {
	var res IPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
