// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IPV6Interface Object to setup an interface along with its default router.
//
// swagger:model ipv6_interface
type IPV6Interface struct {

	// IPv6 address
	// Example: fd20:8b1e:b255:5011:10:141:4:97
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv6 interfaces is enabled. It expects values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv6 address of the default router.
	// Example: fd20:8b1e:b255:5011:10::1
	Gateway *string `json:"gateway,omitempty"`

	// Indicates whether IPv6 RA is enabled.
	IsIPV6RaEnabled *bool `json:"is_ipv6_ra_enabled,omitempty"`

	// Link local IP address.
	// Example: FE80::/10
	LinkLocalIP *string `json:"link_local_ip,omitempty"`

	// The IPv6 netmask/prefix length. The default value is 64 with a valid range of 1 to 127.
	// Example: 64
	Netmask *int64 `json:"netmask,omitempty"`

	// Router assigned IP address.
	// Example: 2001:0db8:85a3:0000:0000:8a2e:0370:7334
	RouterIP *string `json:"router_ip,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this ipv6 interface
func (m *IPV6Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipv6InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipv6InterfaceTypeSetupStatePropEnum = append(ipv6InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipv6_interface
	// IPV6Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// IPV6InterfaceSetupStateNotSetup captures enum value "not_setup"
	IPV6InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// ipv6_interface
	// IPV6Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// IPV6InterfaceSetupStateSucceeded captures enum value "succeeded"
	IPV6InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// ipv6_interface
	// IPV6Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// IPV6InterfaceSetupStateInProgress captures enum value "in_progress"
	IPV6InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// ipv6_interface
	// IPV6Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// IPV6InterfaceSetupStateFailed captures enum value "failed"
	IPV6InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *IPV6Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipv6InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IPV6Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ipv6 interface based on the context it is used
func (m *IPV6Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPV6Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPV6Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPV6Interface) UnmarshalBinary(b []byte) error {
	var res IPV6Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
