// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IpsecPolicy IPsec policy object.
//
// swagger:model ipsec_policy
type IpsecPolicy struct {

	// Action for the IPsec policy.
	// Enum: ["bypass","discard","esp_transport","esp_udp"]
	Action *string `json:"action,omitempty"`

	// Authentication method for the IPsec policy.
	// Enum: ["none","psk","pki"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// certificate
	Certificate *IpsecPolicyInlineCertificate `json:"certificate,omitempty"`

	// Indicates whether old security associations are kept upon certificate modification.
	CertificateModifyKeepsa *bool `json:"certificate_modify_keepsa,omitempty"`

	// Indicates whether or not the policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// ipspace
	Ipspace *IpsecPolicyInlineIpspace `json:"ipspace,omitempty"`

	// local endpoint
	LocalEndpoint *IpsecPolicyInlineLocalEndpoint `json:"local_endpoint,omitempty"`

	// Local Identity
	LocalIdentity *string `json:"local_identity,omitempty"`

	// IPsec policy name.
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// ppk
	Ppk *IpsecPolicyInlinePpk `json:"ppk,omitempty"`

	// Lower layer protocol to be covered by the IPsec policy.
	// Example: 17
	Protocol *string `json:"protocol,omitempty"`

	// remote endpoint
	RemoteEndpoint *IpsecPolicyInlineRemoteEndpoint `json:"remote_endpoint,omitempty"`

	// Remote Identity
	RemoteIdentity *string `json:"remote_identity,omitempty"`

	// scope
	Scope *NetworkScopeReadonly `json:"scope,omitempty"`

	// Pre-shared key for IKE negotiation.
	// Max Length: 128
	// Min Length: 18
	SecretKey *string `json:"secret_key,omitempty"`

	// svm
	Svm *IpsecPolicyInlineSvm `json:"svm,omitempty"`

	// Unique identifier of the IPsec policy.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy
func (m *IpsecPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePpk(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecretKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipsecPolicyTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bypass","discard","esp_transport","esp_udp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyTypeActionPropEnum = append(ipsecPolicyTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipsec_policy
	// IpsecPolicy
	// action
	// Action
	// bypass
	// END DEBUGGING
	// IpsecPolicyActionBypass captures enum value "bypass"
	IpsecPolicyActionBypass string = "bypass"

	// BEGIN DEBUGGING
	// ipsec_policy
	// IpsecPolicy
	// action
	// Action
	// discard
	// END DEBUGGING
	// IpsecPolicyActionDiscard captures enum value "discard"
	IpsecPolicyActionDiscard string = "discard"

	// BEGIN DEBUGGING
	// ipsec_policy
	// IpsecPolicy
	// action
	// Action
	// esp_transport
	// END DEBUGGING
	// IpsecPolicyActionEspTransport captures enum value "esp_transport"
	IpsecPolicyActionEspTransport string = "esp_transport"

	// BEGIN DEBUGGING
	// ipsec_policy
	// IpsecPolicy
	// action
	// Action
	// esp_udp
	// END DEBUGGING
	// IpsecPolicyActionEspUDP captures enum value "esp_udp"
	IpsecPolicyActionEspUDP string = "esp_udp"
)

// prop value enum
func (m *IpsecPolicy) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IpsecPolicy) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

var ipsecPolicyTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","psk","pki"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyTypeAuthenticationMethodPropEnum = append(ipsecPolicyTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipsec_policy
	// IpsecPolicy
	// authentication_method
	// AuthenticationMethod
	// none
	// END DEBUGGING
	// IpsecPolicyAuthenticationMethodNone captures enum value "none"
	IpsecPolicyAuthenticationMethodNone string = "none"

	// BEGIN DEBUGGING
	// ipsec_policy
	// IpsecPolicy
	// authentication_method
	// AuthenticationMethod
	// psk
	// END DEBUGGING
	// IpsecPolicyAuthenticationMethodPsk captures enum value "psk"
	IpsecPolicyAuthenticationMethodPsk string = "psk"

	// BEGIN DEBUGGING
	// ipsec_policy
	// IpsecPolicy
	// authentication_method
	// AuthenticationMethod
	// pki
	// END DEBUGGING
	// IpsecPolicyAuthenticationMethodPki captures enum value "pki"
	IpsecPolicyAuthenticationMethodPki string = "pki"
)

// prop value enum
func (m *IpsecPolicy) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IpsecPolicy) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationMethodEnum("authentication_method", "body", *m.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicy) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) validateLocalEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalEndpoint) { // not required
		return nil
	}

	if m.LocalEndpoint != nil {
		if err := m.LocalEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicy) validatePpk(formats strfmt.Registry) error {
	if swag.IsZero(m.Ppk) { // not required
		return nil
	}

	if m.Ppk != nil {
		if err := m.Ppk.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ppk")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) validateRemoteEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteEndpoint) { // not required
		return nil
	}

	if m.RemoteEndpoint != nil {
		if err := m.RemoteEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	if m.Scope != nil {
		if err := m.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) validateSecretKey(formats strfmt.Registry) error {
	if swag.IsZero(m.SecretKey) { // not required
		return nil
	}

	if err := validate.MinLength("secret_key", "body", *m.SecretKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("secret_key", "body", *m.SecretKey, 128); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicy) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy based on the context it is used
func (m *IpsecPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePpk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicy) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) contextValidateLocalEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if m.LocalEndpoint != nil {
		if err := m.LocalEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) contextValidatePpk(ctx context.Context, formats strfmt.Registry) error {

	if m.Ppk != nil {
		if err := m.Ppk.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ppk")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) contextValidateRemoteEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if m.RemoteEndpoint != nil {
		if err := m.RemoteEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if m.Scope != nil {
		if err := m.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicy) UnmarshalBinary(b []byte) error {
	var res IpsecPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineCertificate Certificate for the IPsec policy.
//
// swagger:model ipsec_policy_inline_certificate
type IpsecPolicyInlineCertificate struct {

	// links
	Links *IpsecPolicyInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy inline certificate
func (m *IpsecPolicyInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline certificate based on the context it is used
func (m *IpsecPolicyInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineCertificate) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineCertificateInlineLinks ipsec policy inline certificate inline links
//
// swagger:model ipsec_policy_inline_certificate_inline__links
type IpsecPolicyInlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy inline certificate inline links
func (m *IpsecPolicyInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline certificate inline links based on the context it is used
func (m *IpsecPolicyInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineIpspace Applies to both SVM and cluster-scoped objects. Either the UUID or name may be supplied on input.
//
// swagger:model ipsec_policy_inline_ipspace
type IpsecPolicyInlineIpspace struct {

	// links
	Links *IpsecPolicyInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy inline ipspace
func (m *IpsecPolicyInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline ipspace based on the context it is used
func (m *IpsecPolicyInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineIpspace) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineIpspaceInlineLinks ipsec policy inline ipspace inline links
//
// swagger:model ipsec_policy_inline_ipspace_inline__links
type IpsecPolicyInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy inline ipspace inline links
func (m *IpsecPolicyInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline ipspace inline links based on the context it is used
func (m *IpsecPolicyInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineLocalEndpoint Local endpoint for the IPsec policy.
//
// swagger:model ipsec_policy_inline_local_endpoint
type IpsecPolicyInlineLocalEndpoint struct {

	// address
	Address *IPAddress `json:"address,omitempty"`

	// family
	Family *IPAddressFamily `json:"family,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`

	// Application port to be covered by the IPsec policy
	// Example: 23
	Port *string `json:"port,omitempty"`
}

// Validate validates this ipsec policy inline local endpoint
func (m *IpsecPolicyInlineLocalEndpoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFamily(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineLocalEndpoint) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineLocalEndpoint) validateFamily(formats strfmt.Registry) error {
	if swag.IsZero(m.Family) { // not required
		return nil
	}

	if m.Family != nil {
		if err := m.Family.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineLocalEndpoint) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline local endpoint based on the context it is used
func (m *IpsecPolicyInlineLocalEndpoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFamily(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineLocalEndpoint) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineLocalEndpoint) contextValidateFamily(ctx context.Context, formats strfmt.Registry) error {

	if m.Family != nil {
		if err := m.Family.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineLocalEndpoint) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineLocalEndpoint) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineLocalEndpoint) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineLocalEndpoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlinePpk Post-quantum pre-shared key information.
//
// swagger:model ipsec_policy_inline_ppk
type IpsecPolicyInlinePpk struct {

	// Post-quantum pre-shared key identity.
	// Max Length: 64
	// Min Length: 6
	Identity *string `json:"identity,omitempty"`

	// Post-quantum pre-shared key.
	// Max Length: 128
	// Min Length: 18
	SharedKey *string `json:"shared_key,omitempty"`
}

// Validate validates this ipsec policy inline ppk
func (m *IpsecPolicyInlinePpk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIdentity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSharedKey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlinePpk) validateIdentity(formats strfmt.Registry) error {
	if swag.IsZero(m.Identity) { // not required
		return nil
	}

	if err := validate.MinLength("ppk"+"."+"identity", "body", *m.Identity, 6); err != nil {
		return err
	}

	if err := validate.MaxLength("ppk"+"."+"identity", "body", *m.Identity, 64); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicyInlinePpk) validateSharedKey(formats strfmt.Registry) error {
	if swag.IsZero(m.SharedKey) { // not required
		return nil
	}

	if err := validate.MinLength("ppk"+"."+"shared_key", "body", *m.SharedKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("ppk"+"."+"shared_key", "body", *m.SharedKey, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ipsec policy inline ppk based on context it is used
func (m *IpsecPolicyInlinePpk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlinePpk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlinePpk) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlinePpk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineRemoteEndpoint Remote endpoint for the IPsec policy.
//
// swagger:model ipsec_policy_inline_remote_endpoint
type IpsecPolicyInlineRemoteEndpoint struct {

	// address
	Address *IPAddress `json:"address,omitempty"`

	// family
	Family *IPAddressFamily `json:"family,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`

	// Application port to be covered by the IPsec policy
	// Example: 23
	Port *string `json:"port,omitempty"`
}

// Validate validates this ipsec policy inline remote endpoint
func (m *IpsecPolicyInlineRemoteEndpoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFamily(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineRemoteEndpoint) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineRemoteEndpoint) validateFamily(formats strfmt.Registry) error {
	if swag.IsZero(m.Family) { // not required
		return nil
	}

	if m.Family != nil {
		if err := m.Family.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineRemoteEndpoint) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline remote endpoint based on the context it is used
func (m *IpsecPolicyInlineRemoteEndpoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFamily(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineRemoteEndpoint) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineRemoteEndpoint) contextValidateFamily(ctx context.Context, formats strfmt.Registry) error {

	if m.Family != nil {
		if err := m.Family.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyInlineRemoteEndpoint) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineRemoteEndpoint) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineRemoteEndpoint) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineRemoteEndpoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model ipsec_policy_inline_svm
type IpsecPolicyInlineSvm struct {

	// links
	Links *IpsecPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy inline svm
func (m *IpsecPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline svm based on the context it is used
func (m *IpsecPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyInlineSvmInlineLinks ipsec policy inline svm inline links
//
// swagger:model ipsec_policy_inline_svm_inline__links
type IpsecPolicyInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy inline svm inline links
func (m *IpsecPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy inline svm inline links based on the context it is used
func (m *IpsecPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
