// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IpsecPolicyResponse ipsec policy response
//
// swagger:model ipsec_policy_response
type IpsecPolicyResponse struct {

	// links
	Links *IpsecPolicyResponseInlineLinks `json:"_links,omitempty"`

	// error
	Error *IpsecPolicyResponseInlineError `json:"error,omitempty"`

	// ipsec policy response inline records
	IpsecPolicyResponseInlineRecords []*IpsecPolicyResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this ipsec policy response
func (m *IpsecPolicyResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpsecPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponse) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponse) validateIpsecPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.IpsecPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.IpsecPolicyResponseInlineRecords); i++ {
		if swag.IsZero(m.IpsecPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if m.IpsecPolicyResponseInlineRecords[i] != nil {
			if err := m.IpsecPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ipsec policy response based on the context it is used
func (m *IpsecPolicyResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpsecPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponse) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponse) contextValidateIpsecPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IpsecPolicyResponseInlineRecords); i++ {

		if m.IpsecPolicyResponseInlineRecords[i] != nil {
			if err := m.IpsecPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponse) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineError ipsec policy response inline error
//
// swagger:model ipsec_policy_response_inline_error
type IpsecPolicyResponseInlineError struct {

	// Message arguments
	// Read Only: true
	Arguments []*ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ipsec policy response inline error
func (m *IpsecPolicyResponseInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineError) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ipsec policy response inline error based on the context it is used
func (m *IpsecPolicyResponseInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineError) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"arguments", "body", []*ErrorArguments(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *IpsecPolicyResponseInlineError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicyResponseInlineError) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineError) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineLinks ipsec policy response inline links
//
// swagger:model ipsec_policy_response_inline__links
type IpsecPolicyResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy response inline links
func (m *IpsecPolicyResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline links based on the context it is used
func (m *IpsecPolicyResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItem IPsec policy object.
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item
type IpsecPolicyResponseInlineRecordsInlineArrayItem struct {

	// Action for the IPsec policy.
	// Enum: ["bypass","discard","esp_transport","esp_udp"]
	Action *string `json:"action,omitempty"`

	// Authentication method for the IPsec policy.
	// Enum: ["none","psk","pki"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// certificate
	Certificate *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate `json:"certificate,omitempty"`

	// Indicates whether old security associations are kept upon certificate modification.
	CertificateModifyKeepsa *bool `json:"certificate_modify_keepsa,omitempty"`

	// Indicates whether or not the policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// ipspace
	Ipspace *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace `json:"ipspace,omitempty"`

	// local endpoint
	LocalEndpoint *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint `json:"local_endpoint,omitempty"`

	// Local Identity
	LocalIdentity *string `json:"local_identity,omitempty"`

	// IPsec policy name.
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// ppk
	Ppk *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk `json:"ppk,omitempty"`

	// Lower layer protocol to be covered by the IPsec policy.
	// Example: 17
	Protocol *string `json:"protocol,omitempty"`

	// remote endpoint
	RemoteEndpoint *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint `json:"remote_endpoint,omitempty"`

	// Remote Identity
	RemoteIdentity *string `json:"remote_identity,omitempty"`

	// scope
	Scope *NetworkScopeReadonly `json:"scope,omitempty"`

	// Pre-shared key for IKE negotiation.
	// Max Length: 128
	// Min Length: 18
	SecretKey *string `json:"secret_key,omitempty"`

	// svm
	Svm *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// Unique identifier of the IPsec policy.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePpk(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecretKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bypass","discard","esp_transport","esp_udp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum = append(ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// bypass
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionBypass captures enum value "bypass"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionBypass string = "bypass"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// discard
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionDiscard captures enum value "discard"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionDiscard string = "discard"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// esp_transport
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspTransport captures enum value "esp_transport"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspTransport string = "esp_transport"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// esp_udp
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspUDP captures enum value "esp_udp"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspUDP string = "esp_udp"
)

// prop value enum
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

var ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","psk","pki"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum = append(ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// authentication_method
	// AuthenticationMethod
	// none
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodNone captures enum value "none"
	IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodNone string = "none"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// authentication_method
	// AuthenticationMethod
	// psk
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPsk captures enum value "psk"
	IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPsk string = "psk"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// authentication_method
	// AuthenticationMethod
	// pki
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPki captures enum value "pki"
	IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPki string = "pki"
)

// prop value enum
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationMethodEnum("authentication_method", "body", *m.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateLocalEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalEndpoint) { // not required
		return nil
	}

	if m.LocalEndpoint != nil {
		if err := m.LocalEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validatePpk(formats strfmt.Registry) error {
	if swag.IsZero(m.Ppk) { // not required
		return nil
	}

	if m.Ppk != nil {
		if err := m.Ppk.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ppk")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateRemoteEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteEndpoint) { // not required
		return nil
	}

	if m.RemoteEndpoint != nil {
		if err := m.RemoteEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	if m.Scope != nil {
		if err := m.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateSecretKey(formats strfmt.Registry) error {
	if swag.IsZero(m.SecretKey) { // not required
		return nil
	}

	if err := validate.MinLength("secret_key", "body", *m.SecretKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("secret_key", "body", *m.SecretKey, 128); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePpk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateLocalEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if m.LocalEndpoint != nil {
		if err := m.LocalEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidatePpk(ctx context.Context, formats strfmt.Registry) error {

	if m.Ppk != nil {
		if err := m.Ppk.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ppk")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateRemoteEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if m.RemoteEndpoint != nil {
		if err := m.RemoteEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if m.Scope != nil {
		if err := m.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate Certificate for the IPsec policy.
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_certificate
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate struct {

	// links
	Links *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline certificate
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline certificate based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks ipsec policy response inline records inline array item inline certificate inline links
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_certificate_inline__links
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline certificate inline links
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline certificate inline links based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace Applies to both SVM and cluster-scoped objects. Either the UUID or name may be supplied on input.
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_ipspace
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace struct {

	// links
	Links *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline ipspace
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline ipspace based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks ipsec policy response inline records inline array item inline ipspace inline links
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_ipspace_inline__links
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline ipspace inline links
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline ipspace inline links based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint Local endpoint for the IPsec policy.
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_local_endpoint
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint struct {

	// address
	Address *IPAddress `json:"address,omitempty"`

	// family
	Family *IPAddressFamily `json:"family,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`

	// Application port to be covered by the IPsec policy
	// Example: 23
	Port *string `json:"port,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline local endpoint
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFamily(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) validateFamily(formats strfmt.Registry) error {
	if swag.IsZero(m.Family) { // not required
		return nil
	}

	if m.Family != nil {
		if err := m.Family.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline local endpoint based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFamily(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) contextValidateFamily(ctx context.Context, formats strfmt.Registry) error {

	if m.Family != nil {
		if err := m.Family.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk Post-quantum pre-shared key information.
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_ppk
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk struct {

	// Post-quantum pre-shared key identity.
	// Max Length: 64
	// Min Length: 6
	Identity *string `json:"identity,omitempty"`

	// Post-quantum pre-shared key.
	// Max Length: 128
	// Min Length: 18
	SharedKey *string `json:"shared_key,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline ppk
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIdentity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSharedKey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) validateIdentity(formats strfmt.Registry) error {
	if swag.IsZero(m.Identity) { // not required
		return nil
	}

	if err := validate.MinLength("ppk"+"."+"identity", "body", *m.Identity, 6); err != nil {
		return err
	}

	if err := validate.MaxLength("ppk"+"."+"identity", "body", *m.Identity, 64); err != nil {
		return err
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) validateSharedKey(formats strfmt.Registry) error {
	if swag.IsZero(m.SharedKey) { // not required
		return nil
	}

	if err := validate.MinLength("ppk"+"."+"shared_key", "body", *m.SharedKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("ppk"+"."+"shared_key", "body", *m.SharedKey, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ipsec policy response inline records inline array item inline ppk based on context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint Remote endpoint for the IPsec policy.
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_remote_endpoint
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint struct {

	// address
	Address *IPAddress `json:"address,omitempty"`

	// family
	Family *IPAddressFamily `json:"family,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`

	// Application port to be covered by the IPsec policy
	// Example: 23
	Port *string `json:"port,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline remote endpoint
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFamily(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) validateFamily(formats strfmt.Registry) error {
	if swag.IsZero(m.Family) { // not required
		return nil
	}

	if m.Family != nil {
		if err := m.Family.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline remote endpoint based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFamily(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) contextValidateFamily(ctx context.Context, formats strfmt.Registry) error {

	if m.Family != nil {
		if err := m.Family.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_svm
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm struct {

	// links
	Links *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline svm
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline svm based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks ipsec policy response inline records inline array item inline svm inline links
//
// swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_svm_inline__links
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline svm inline links
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline svm inline links based on the context it is used
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
