// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// KeyManagerKeys Displays the keys stored in a key manager.
//
// swagger:model key_manager_keys
type KeyManagerKeys struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Cloud resource name.
	// Example: CRN=v1:bluemix:public:containers-kubernetes
	Crn *string `json:"crn,omitempty"`

	// Encryption algorithm for the key
	// Example: XTS-AES-256
	EncryptionAlgorithm *string `json:"encryption_algorithm,omitempty"`

	// Key identifier.
	// Example: 000000000000000002000000000001008963c9213194c59555c1bec8db3603c800000000
	KeyID *string `json:"key_id,omitempty"`

	// Key manager key server managing the key. Indicates the external key server when external key manager is configured.
	// Example: keyserver1.local:5696
	KeyManager *string `json:"key_manager,omitempty"`

	// External key server for key management.
	// Example: keyserver1.com:5698
	KeyServer *string `json:"key_server,omitempty"`

	// Security key manager configured for the given key manager UUID. Key manager keystore value can be onboard or external.
	// Enum: ["onboard","external"]
	KeyStore *string `json:"key_store,omitempty"`

	// Security key manager keystore type. Keystore type can be onboard, external, or supported cloud key manager.
	// Enum: ["okm","kmip","akv","unset","gcp","aws","ikp","barbican"]
	KeyStoreType *string `json:"key_store_type,omitempty"`

	// Additional information associated with the key.
	// Example: key#
	KeyTag *string `json:"key_tag,omitempty"`

	// Encryption Key type.
	// Enum: ["nse_ak","aek","vek","nek","svm_kek","mroot_ak"]
	KeyType *string `json:"key_type,omitempty"`

	// SVM associated with the key.
	// Example: vs1
	KeyUser *string `json:"key_user,omitempty"`

	// node
	Node *KeyManagerKeysInlineNode `json:"node,omitempty"`

	// Key store policy.
	// Example: IBM_Key_Lore
	Policy *string `json:"policy,omitempty"`

	// Indicates whether the key is present locally on the node.
	// Example: true
	Restored *bool `json:"restored,omitempty"`

	// scope
	Scope *NetworkScopeReadonly `json:"scope,omitempty"`

	// security key manager
	SecurityKeyManager *KeyManagerKeysInlineSecurityKeyManager `json:"security_key_manager,omitempty"`

	// svm
	Svm *KeyManagerKeysInlineSvm `json:"svm,omitempty"`
}

// Validate validates this key manager keys
func (m *KeyManagerKeys) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyStore(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyStoreType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityKeyManager(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeys) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var keyManagerKeysTypeKeyStorePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["onboard","external"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		keyManagerKeysTypeKeyStorePropEnum = append(keyManagerKeysTypeKeyStorePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store
	// KeyStore
	// onboard
	// END DEBUGGING
	// KeyManagerKeysKeyStoreOnboard captures enum value "onboard"
	KeyManagerKeysKeyStoreOnboard string = "onboard"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store
	// KeyStore
	// external
	// END DEBUGGING
	// KeyManagerKeysKeyStoreExternal captures enum value "external"
	KeyManagerKeysKeyStoreExternal string = "external"
)

// prop value enum
func (m *KeyManagerKeys) validateKeyStoreEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, keyManagerKeysTypeKeyStorePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *KeyManagerKeys) validateKeyStore(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyStore) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyStoreEnum("key_store", "body", *m.KeyStore); err != nil {
		return err
	}

	return nil
}

var keyManagerKeysTypeKeyStoreTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["okm","kmip","akv","unset","gcp","aws","ikp","barbican"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		keyManagerKeysTypeKeyStoreTypePropEnum = append(keyManagerKeysTypeKeyStoreTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// okm
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeOkm captures enum value "okm"
	KeyManagerKeysKeyStoreTypeOkm string = "okm"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// kmip
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeKmip captures enum value "kmip"
	KeyManagerKeysKeyStoreTypeKmip string = "kmip"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// akv
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeAkv captures enum value "akv"
	KeyManagerKeysKeyStoreTypeAkv string = "akv"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// unset
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeUnset captures enum value "unset"
	KeyManagerKeysKeyStoreTypeUnset string = "unset"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// gcp
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeGcp captures enum value "gcp"
	KeyManagerKeysKeyStoreTypeGcp string = "gcp"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// aws
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeAws captures enum value "aws"
	KeyManagerKeysKeyStoreTypeAws string = "aws"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// ikp
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeIkp captures enum value "ikp"
	KeyManagerKeysKeyStoreTypeIkp string = "ikp"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_store_type
	// KeyStoreType
	// barbican
	// END DEBUGGING
	// KeyManagerKeysKeyStoreTypeBarbican captures enum value "barbican"
	KeyManagerKeysKeyStoreTypeBarbican string = "barbican"
)

// prop value enum
func (m *KeyManagerKeys) validateKeyStoreTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, keyManagerKeysTypeKeyStoreTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *KeyManagerKeys) validateKeyStoreType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyStoreType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyStoreTypeEnum("key_store_type", "body", *m.KeyStoreType); err != nil {
		return err
	}

	return nil
}

var keyManagerKeysTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nse_ak","aek","vek","nek","svm_kek","mroot_ak"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		keyManagerKeysTypeKeyTypePropEnum = append(keyManagerKeysTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_type
	// KeyType
	// nse_ak
	// END DEBUGGING
	// KeyManagerKeysKeyTypeNseAk captures enum value "nse_ak"
	KeyManagerKeysKeyTypeNseAk string = "nse_ak"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_type
	// KeyType
	// aek
	// END DEBUGGING
	// KeyManagerKeysKeyTypeAek captures enum value "aek"
	KeyManagerKeysKeyTypeAek string = "aek"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_type
	// KeyType
	// vek
	// END DEBUGGING
	// KeyManagerKeysKeyTypeVek captures enum value "vek"
	KeyManagerKeysKeyTypeVek string = "vek"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_type
	// KeyType
	// nek
	// END DEBUGGING
	// KeyManagerKeysKeyTypeNek captures enum value "nek"
	KeyManagerKeysKeyTypeNek string = "nek"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_type
	// KeyType
	// svm_kek
	// END DEBUGGING
	// KeyManagerKeysKeyTypeSvmKek captures enum value "svm_kek"
	KeyManagerKeysKeyTypeSvmKek string = "svm_kek"

	// BEGIN DEBUGGING
	// key_manager_keys
	// KeyManagerKeys
	// key_type
	// KeyType
	// mroot_ak
	// END DEBUGGING
	// KeyManagerKeysKeyTypeMrootAk captures enum value "mroot_ak"
	KeyManagerKeysKeyTypeMrootAk string = "mroot_ak"
)

// prop value enum
func (m *KeyManagerKeys) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, keyManagerKeysTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *KeyManagerKeys) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyTypeEnum("key_type", "body", *m.KeyType); err != nil {
		return err
	}

	return nil
}

func (m *KeyManagerKeys) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *KeyManagerKeys) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	if m.Scope != nil {
		if err := m.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *KeyManagerKeys) validateSecurityKeyManager(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityKeyManager) { // not required
		return nil
	}

	if m.SecurityKeyManager != nil {
		if err := m.SecurityKeyManager.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_key_manager")
			}
			return err
		}
	}

	return nil
}

func (m *KeyManagerKeys) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key manager keys based on the context it is used
func (m *KeyManagerKeys) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurityKeyManager(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeys) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *KeyManagerKeys) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *KeyManagerKeys) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if m.Scope != nil {
		if err := m.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (m *KeyManagerKeys) contextValidateSecurityKeyManager(ctx context.Context, formats strfmt.Registry) error {

	if m.SecurityKeyManager != nil {
		if err := m.SecurityKeyManager.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_key_manager")
			}
			return err
		}
	}

	return nil
}

func (m *KeyManagerKeys) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyManagerKeys) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyManagerKeys) UnmarshalBinary(b []byte) error {
	var res KeyManagerKeys
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyManagerKeysInlineNode key manager keys inline node
//
// swagger:model key_manager_keys_inline_node
type KeyManagerKeysInlineNode struct {

	// links
	Links *KeyManagerKeysInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this key manager keys inline node
func (m *KeyManagerKeysInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key manager keys inline node based on the context it is used
func (m *KeyManagerKeysInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyManagerKeysInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyManagerKeysInlineNode) UnmarshalBinary(b []byte) error {
	var res KeyManagerKeysInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyManagerKeysInlineNodeInlineLinks key manager keys inline node inline links
//
// swagger:model key_manager_keys_inline_node_inline__links
type KeyManagerKeysInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this key manager keys inline node inline links
func (m *KeyManagerKeysInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key manager keys inline node inline links based on the context it is used
func (m *KeyManagerKeysInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyManagerKeysInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyManagerKeysInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res KeyManagerKeysInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyManagerKeysInlineSecurityKeyManager Security key manager object reference.
//
// swagger:model key_manager_keys_inline_security_key_manager
type KeyManagerKeysInlineSecurityKeyManager struct {

	// links
	Links *KeyManagerKeysInlineSecurityKeyManagerInlineLinks `json:"_links,omitempty"`

	// Key manager UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this key manager keys inline security key manager
func (m *KeyManagerKeysInlineSecurityKeyManager) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSecurityKeyManager) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_key_manager" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key manager keys inline security key manager based on the context it is used
func (m *KeyManagerKeysInlineSecurityKeyManager) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSecurityKeyManager) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_key_manager" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyManagerKeysInlineSecurityKeyManager) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyManagerKeysInlineSecurityKeyManager) UnmarshalBinary(b []byte) error {
	var res KeyManagerKeysInlineSecurityKeyManager
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyManagerKeysInlineSecurityKeyManagerInlineLinks key manager keys inline security key manager inline links
//
// swagger:model key_manager_keys_inline_security_key_manager_inline__links
type KeyManagerKeysInlineSecurityKeyManagerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this key manager keys inline security key manager inline links
func (m *KeyManagerKeysInlineSecurityKeyManagerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSecurityKeyManagerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_key_manager" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key manager keys inline security key manager inline links based on the context it is used
func (m *KeyManagerKeysInlineSecurityKeyManagerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSecurityKeyManagerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security_key_manager" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyManagerKeysInlineSecurityKeyManagerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyManagerKeysInlineSecurityKeyManagerInlineLinks) UnmarshalBinary(b []byte) error {
	var res KeyManagerKeysInlineSecurityKeyManagerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyManagerKeysInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model key_manager_keys_inline_svm
type KeyManagerKeysInlineSvm struct {

	// links
	Links *KeyManagerKeysInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this key manager keys inline svm
func (m *KeyManagerKeysInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key manager keys inline svm based on the context it is used
func (m *KeyManagerKeysInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyManagerKeysInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyManagerKeysInlineSvm) UnmarshalBinary(b []byte) error {
	var res KeyManagerKeysInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyManagerKeysInlineSvmInlineLinks key manager keys inline svm inline links
//
// swagger:model key_manager_keys_inline_svm_inline__links
type KeyManagerKeysInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this key manager keys inline svm inline links
func (m *KeyManagerKeysInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key manager keys inline svm inline links based on the context it is used
func (m *KeyManagerKeysInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyManagerKeysInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyManagerKeysInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyManagerKeysInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res KeyManagerKeysInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
