// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// KeyServer key server
//
// swagger:model key_server
type KeyServer struct {

	// links
	Links *KeyServerInlineLinks `json:"_links,omitempty"`

	// connectivity
	Connectivity *KeyServerInlineConnectivity `json:"connectivity,omitempty"`

	// The key server timeout for create and remove operations.
	// -1 indicates that the server will wait indefinitely for the event to occur. 0 indicates that the server will not wait and will immediately timeout if it does not receive a response.
	//
	// Example: 60
	// Maximum: 60
	// Minimum: -1
	CreateRemoveTimeout *int64 `json:"create_remove_timeout,omitempty"`

	// An array of key servers specified to add multiple key servers to a key manager in a single API call. Valid in POST only and not valid if `server` is provided.
	//
	// Max Items: 4
	KeyServerInlineRecords []*KeyServerInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// A list of the secondary key servers associated with the primary key server.
	// Example: ["secondary1.com","10.1.2.3"]
	KeyServerInlineSecondaryKeyServers []*string `json:"secondary_key_servers,omitempty"`

	// Password credentials for connecting with the key server. This is not audited.
	// Example: password
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// External key server for key management. If no port is provided, a default port of 5696 is used. Not valid in POST if `records` is provided.
	// Example: keyserver1.com:5698
	Server *string `json:"server,omitempty"`

	// I/O timeout in seconds for communicating with the key server.
	// -1 indicates that the server will wait indefinitely for the event to occur. 0 indicates that the server will not wait and will immediately timeout if it does not receive a response.
	//
	// Example: 60
	// Maximum: 60
	// Minimum: -1
	Timeout *int64 `json:"timeout,omitempty"`

	// KMIP username credentials for connecting with the key server.
	// Example: username
	Username *string `json:"username,omitempty"`
}

// Validate validates this key server
func (m *KeyServer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateRemoveTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyServerInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServer) validateConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(m.Connectivity) { // not required
		return nil
	}

	if m.Connectivity != nil {
		if err := m.Connectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServer) validateCreateRemoveTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateRemoveTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("create_remove_timeout", "body", *m.CreateRemoveTimeout, -1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("create_remove_timeout", "body", *m.CreateRemoveTimeout, 60, false); err != nil {
		return err
	}

	return nil
}

func (m *KeyServer) validateKeyServerInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyServerInlineRecords) { // not required
		return nil
	}

	iKeyServerInlineRecordsSize := int64(len(m.KeyServerInlineRecords))

	if err := validate.MaxItems("records", "body", iKeyServerInlineRecordsSize, 4); err != nil {
		return err
	}

	for i := 0; i < len(m.KeyServerInlineRecords); i++ {
		if swag.IsZero(m.KeyServerInlineRecords[i]) { // not required
			continue
		}

		if m.KeyServerInlineRecords[i] != nil {
			if err := m.KeyServerInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *KeyServer) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *KeyServer) validateTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.Timeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("timeout", "body", *m.Timeout, -1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("timeout", "body", *m.Timeout, 60, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this key server based on the context it is used
func (m *KeyServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKeyServerInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServer) contextValidateConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if m.Connectivity != nil {
		if err := m.Connectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServer) contextValidateKeyServerInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.KeyServerInlineRecords); i++ {

		if m.KeyServerInlineRecords[i] != nil {
			if err := m.KeyServerInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServer) UnmarshalBinary(b []byte) error {
	var res KeyServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyServerInlineConnectivity This property contains the key server connectivity state of all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model key_server_inline_connectivity
type KeyServerInlineConnectivity struct {

	// Set to true when key server connectivity state is available on all nodes of the cluster.
	// Read Only: true
	ClusterAvailability *bool `json:"cluster_availability,omitempty"`

	// An array of key server connectivity states for each node.
	//
	// Read Only: true
	NodeStates []*KeyServerState `json:"node_states,omitempty"`
}

// Validate validates this key server inline connectivity
func (m *KeyServerInlineConnectivity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNodeStates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineConnectivity) validateNodeStates(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeStates) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeStates); i++ {
		if swag.IsZero(m.NodeStates[i]) { // not required
			continue
		}

		if m.NodeStates[i] != nil {
			if err := m.NodeStates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "node_states" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this key server inline connectivity based on the context it is used
func (m *KeyServerInlineConnectivity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClusterAvailability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeStates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineConnectivity) contextValidateClusterAvailability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"cluster_availability", "body", m.ClusterAvailability); err != nil {
		return err
	}

	return nil
}

func (m *KeyServerInlineConnectivity) contextValidateNodeStates(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"node_states", "body", []*KeyServerState(m.NodeStates)); err != nil {
		return err
	}

	for i := 0; i < len(m.NodeStates); i++ {

		if m.NodeStates[i] != nil {
			if err := m.NodeStates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "node_states" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServerInlineConnectivity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServerInlineConnectivity) UnmarshalBinary(b []byte) error {
	var res KeyServerInlineConnectivity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyServerInlineLinks key server inline links
//
// swagger:model key_server_inline__links
type KeyServerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this key server inline links
func (m *KeyServerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key server inline links based on the context it is used
func (m *KeyServerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServerInlineLinks) UnmarshalBinary(b []byte) error {
	var res KeyServerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyServerInlineRecordsInlineArrayItem key server inline records inline array item
//
// swagger:model key_server_inline_records_inline_array_item
type KeyServerInlineRecordsInlineArrayItem struct {

	// links
	Links *KeyServerInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// connectivity
	Connectivity *KeyServerInlineRecordsInlineArrayItemInlineConnectivity `json:"connectivity,omitempty"`

	// Password credentials for connecting with the key server. This is not audited.
	// Example: password
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// External key server for key management. If no port is provided, a default port of 5696 is used. Not valid in POST if `records` is provided.
	// Example: bulkkeyserver.com:5698
	Server *string `json:"server,omitempty"`

	// I/O timeout in seconds for communicating with the key server.
	// Example: 60
	// Maximum: 60
	// Minimum: 1
	Timeout *int64 `json:"timeout,omitempty"`

	// KMIP username credentials for connecting with the key server.
	// Example: username
	Username *string `json:"username,omitempty"`
}

// Validate validates this key server inline records inline array item
func (m *KeyServerInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItem) validateConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(m.Connectivity) { // not required
		return nil
	}

	if m.Connectivity != nil {
		if err := m.Connectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItem) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItem) validateTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.Timeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("timeout", "body", *m.Timeout, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("timeout", "body", *m.Timeout, 60, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this key server inline records inline array item based on the context it is used
func (m *KeyServerInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItem) contextValidateConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if m.Connectivity != nil {
		if err := m.Connectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServerInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServerInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res KeyServerInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyServerInlineRecordsInlineArrayItemInlineConnectivity This property contains the key server connectivity state of all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model key_server_inline_records_inline_array_item_inline_connectivity
type KeyServerInlineRecordsInlineArrayItemInlineConnectivity struct {

	// Set to true when key server connectivity state is available on all nodes of the cluster.
	// Read Only: true
	ClusterAvailability *bool `json:"cluster_availability,omitempty"`

	// An array of key server connectivity states for each node.
	//
	// Read Only: true
	NodeStates []*KeyServerState `json:"node_states"`
}

// Validate validates this key server inline records inline array item inline connectivity
func (m *KeyServerInlineRecordsInlineArrayItemInlineConnectivity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNodeStates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItemInlineConnectivity) validateNodeStates(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeStates) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeStates); i++ {
		if swag.IsZero(m.NodeStates[i]) { // not required
			continue
		}

		if m.NodeStates[i] != nil {
			if err := m.NodeStates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "node_states" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this key server inline records inline array item inline connectivity based on the context it is used
func (m *KeyServerInlineRecordsInlineArrayItemInlineConnectivity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClusterAvailability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeStates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItemInlineConnectivity) contextValidateClusterAvailability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"cluster_availability", "body", m.ClusterAvailability); err != nil {
		return err
	}

	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItemInlineConnectivity) contextValidateNodeStates(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"node_states", "body", []*KeyServerState(m.NodeStates)); err != nil {
		return err
	}

	for i := 0; i < len(m.NodeStates); i++ {

		if m.NodeStates[i] != nil {
			if err := m.NodeStates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "node_states" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServerInlineRecordsInlineArrayItemInlineConnectivity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServerInlineRecordsInlineArrayItemInlineConnectivity) UnmarshalBinary(b []byte) error {
	var res KeyServerInlineRecordsInlineArrayItemInlineConnectivity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyServerInlineRecordsInlineArrayItemInlineLinks key server inline records inline array item inline links
//
// swagger:model key_server_inline_records_inline_array_item_inline__links
type KeyServerInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this key server inline records inline array item inline links
func (m *KeyServerInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this key server inline records inline array item inline links based on the context it is used
func (m *KeyServerInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServerInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServerInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res KeyServerInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
