// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// KeyServerReadcreate key server readcreate
//
// swagger:model key_server_readcreate
type KeyServerReadcreate struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// connectivity
	Connectivity *KeyServerReadcreateInlineConnectivity `json:"connectivity,omitempty"`

	// A comma delimited string of the secondary key servers associated with the primary key server.
	// Example: secondary1.com, 10.2.3.4
	// Read Only: true
	SecondaryKeyServers *string `json:"secondary_key_servers,omitempty"`

	// External key server for key management. If no port is provided, a default port of 5696 is used.
	// Example: keyserver1.com:5698
	Server *string `json:"server,omitempty"`

	// I/O timeout in seconds for communicating with the key server.
	// Example: 60
	// Read Only: true
	// Maximum: 60
	// Minimum: 1
	Timeout *int64 `json:"timeout,omitempty"`

	// Username credentials for connecting with the key server.
	// Example: admin
	// Read Only: true
	Username *string `json:"username,omitempty"`
}

// Validate validates this key server readcreate
func (m *KeyServerReadcreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerReadcreate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServerReadcreate) validateConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(m.Connectivity) { // not required
		return nil
	}

	if m.Connectivity != nil {
		if err := m.Connectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServerReadcreate) validateTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.Timeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("timeout", "body", *m.Timeout, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("timeout", "body", *m.Timeout, 60, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this key server readcreate based on the context it is used
func (m *KeyServerReadcreate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecondaryKeyServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeout(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsername(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerReadcreate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServerReadcreate) contextValidateConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if m.Connectivity != nil {
		if err := m.Connectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *KeyServerReadcreate) contextValidateSecondaryKeyServers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "secondary_key_servers", "body", m.SecondaryKeyServers); err != nil {
		return err
	}

	return nil
}

func (m *KeyServerReadcreate) contextValidateTimeout(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timeout", "body", m.Timeout); err != nil {
		return err
	}

	return nil
}

func (m *KeyServerReadcreate) contextValidateUsername(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "username", "body", m.Username); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServerReadcreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServerReadcreate) UnmarshalBinary(b []byte) error {
	var res KeyServerReadcreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// KeyServerReadcreateInlineConnectivity This property contains the key server connectivity state of all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model key_server_readcreate_inline_connectivity
type KeyServerReadcreateInlineConnectivity struct {

	// Set to true when key server connectivity state is available on all nodes of the cluster.
	// Read Only: true
	ClusterAvailability *bool `json:"cluster_availability,omitempty"`

	// An array of key server connectivity states for each node.
	//
	// Read Only: true
	NodeStates []*KeyServerState `json:"node_states,omitempty"`
}

// Validate validates this key server readcreate inline connectivity
func (m *KeyServerReadcreateInlineConnectivity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNodeStates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerReadcreateInlineConnectivity) validateNodeStates(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeStates) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeStates); i++ {
		if swag.IsZero(m.NodeStates[i]) { // not required
			continue
		}

		if m.NodeStates[i] != nil {
			if err := m.NodeStates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "node_states" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this key server readcreate inline connectivity based on the context it is used
func (m *KeyServerReadcreateInlineConnectivity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClusterAvailability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeStates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *KeyServerReadcreateInlineConnectivity) contextValidateClusterAvailability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"cluster_availability", "body", m.ClusterAvailability); err != nil {
		return err
	}

	return nil
}

func (m *KeyServerReadcreateInlineConnectivity) contextValidateNodeStates(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"node_states", "body", []*KeyServerState(m.NodeStates)); err != nil {
		return err
	}

	for i := 0; i < len(m.NodeStates); i++ {

		if m.NodeStates[i] != nil {
			if err := m.NodeStates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "node_states" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *KeyServerReadcreateInlineConnectivity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *KeyServerReadcreateInlineConnectivity) UnmarshalBinary(b []byte) error {
	var res KeyServerReadcreateInlineConnectivity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
