// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LdapSchemaNameMapping ldap schema name mapping
//
// swagger:model ldap_schema_name_mapping
type LdapSchemaNameMapping struct {

	// account
	Account *LdapSchemaAccount `json:"account,omitempty"`

	// windows to unix
	WindowsToUnix *WindowsToUnix `json:"windows_to_unix,omitempty"`
}

// Validate validates this ldap schema name mapping
func (m *LdapSchemaNameMapping) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWindowsToUnix(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapSchemaNameMapping) validateAccount(formats strfmt.Registry) error {
	if swag.IsZero(m.Account) { // not required
		return nil
	}

	if m.Account != nil {
		if err := m.Account.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

func (m *LdapSchemaNameMapping) validateWindowsToUnix(formats strfmt.Registry) error {
	if swag.IsZero(m.WindowsToUnix) { // not required
		return nil
	}

	if m.WindowsToUnix != nil {
		if err := m.WindowsToUnix.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("windows_to_unix")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ldap schema name mapping based on the context it is used
func (m *LdapSchemaNameMapping) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWindowsToUnix(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapSchemaNameMapping) contextValidateAccount(ctx context.Context, formats strfmt.Registry) error {

	if m.Account != nil {
		if err := m.Account.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("account")
			}
			return err
		}
	}

	return nil
}

func (m *LdapSchemaNameMapping) contextValidateWindowsToUnix(ctx context.Context, formats strfmt.Registry) error {

	if m.WindowsToUnix != nil {
		if err := m.WindowsToUnix.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("windows_to_unix")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LdapSchemaNameMapping) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapSchemaNameMapping) UnmarshalBinary(b []byte) error {
	var res LdapSchemaNameMapping
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
