// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LdapService ldap service
//
// swagger:model ldap_service
type LdapService struct {

	// links
	Links *LdapServiceInlineLinks `json:"_links,omitempty"`

	// This parameter specifies the name of the Active Directory domain
	// used to discover LDAP servers for use by this client.
	// This is mutually exclusive with `servers` during POST and PATCH.
	//
	// Example: example.com
	AdDomain *string `json:"ad_domain,omitempty"`

	// Specifies the default base DN for all searches.
	// Example: dc=domainB,dc=example,dc=com
	BaseDn *string `json:"base_dn,omitempty"`

	// Specifies the default search scope for LDAP queries:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	BaseScope *string `json:"base_scope,omitempty"`

	// Specifies whether or not CIFS server's credentials are used to bind to the LDAP server.
	//
	BindAsCifsServer *bool `json:"bind_as_cifs_server,omitempty"`

	// Specifies the user that binds to the LDAP servers.
	// Example: cn=Administrators,cn=users,dc=domainB,dc=example,dc=com
	BindDn *string `json:"bind_dn,omitempty"`

	// Specifies the bind password for the LDAP servers.
	// Example: abc
	BindPassword *string `json:"bind_password,omitempty"`

	// Specifies the group Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for group lookups.
	// Example: cn=abc,users,dc=com
	GroupDn *string `json:"group_dn,omitempty"`

	// Specifies the custom filter used for group membership lookups from an LDAP server.
	//
	GroupMembershipFilter *string `json:"group_membership_filter,omitempty"`

	// Specifies the default search scope for LDAP for group lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	GroupScope *string `json:"group_scope,omitempty"`

	// Specifies whether or not netgroup by host querying is enabled.
	//
	IsNetgroupByhostEnabled *bool `json:"is_netgroup_byhost_enabled,omitempty"`

	// Specifies whether or not the SVM owns the LDAP client configuration.
	//
	// Read Only: true
	IsOwner *bool `json:"is_owner,omitempty"`

	// ldap service inline preferred ad servers
	LdapServiceInlinePreferredAdServers []*string `json:"preferred_ad_servers,omitempty"`

	// ldap service inline servers
	LdapServiceInlineServers []*string `json:"servers,omitempty"`

	// Specifies whether or not LDAPS is enabled.
	//
	LdapsEnabled *bool `json:"ldaps_enabled,omitempty"`

	// The minimum bind authentication level. Possible values are:
	// * anonymous - anonymous bind
	// * simple - simple bind
	// * sasl - Simple Authentication and Security Layer (SASL) bind
	//
	// Enum: ["anonymous","simple","sasl"]
	MinBindLevel *string `json:"min_bind_level,omitempty"`

	// Specifies the netgroup Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for netgroup by host lookups.
	// Example: cn=abc,users,dc=com
	NetgroupByhostDn *string `json:"netgroup_byhost_dn,omitempty"`

	// Specifies the default search scope for LDAP for netgroup by host lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	NetgroupByhostScope *string `json:"netgroup_byhost_scope,omitempty"`

	// Specifies the netgroup Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for netgroup lookups.
	// Example: cn=abc,users,dc=com
	NetgroupDn *string `json:"netgroup_dn,omitempty"`

	// Specifies the default search scope for LDAP for netgroup lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	NetgroupScope *string `json:"netgroup_scope,omitempty"`

	// The port used to connect to the LDAP Servers.
	// Example: 389
	// Maximum: 65535
	// Minimum: 1
	Port *int64 `json:"port,omitempty"`

	// Specifies the maximum time to wait for a query response from the LDAP server, in seconds.
	//
	QueryTimeout *int64 `json:"query_timeout,omitempty"`

	// Specifies whether or not LDAP referral is enabled.
	//
	ReferralEnabled *bool `json:"referral_enabled,omitempty"`

	// Specifies whether or not LDAP server discovery is restricted to site-scope.
	//
	RestrictDiscoveryToSite *bool `json:"restrict_discovery_to_site,omitempty"`

	// The name of the schema template used by the SVM.
	// * AD-IDMU - Active Directory Identity Management for UNIX
	// * AD-SFU - Active Directory Services for UNIX
	// * MS-AD-BIS - Active Directory Identity Management for UNIX
	// * RFC-2307 - Schema based on RFC 2307
	// * Custom schema
	//
	// Example: ad_idmu
	Schema *string `json:"schema,omitempty"`

	// Specifies the level of security to be used for LDAP communications:
	// * none - no signing or sealing
	// * sign - sign LDAP traffic
	// * seal - seal and sign LDAP traffic
	//
	// Enum: ["none","sign","seal"]
	SessionSecurity *string `json:"session_security,omitempty"`

	// Indicates whether or not the validation for the specified LDAP configuration is disabled.
	//
	SkipConfigValidation *bool `json:"skip_config_validation,omitempty"`

	// status
	Status *LdapServiceInlineStatus `json:"status,omitempty"`

	// svm
	Svm *LdapServiceInlineSvm `json:"svm,omitempty"`

	// Specifies whether or not channel binding is attempted in the case of TLS/LDAPS.
	//
	TryChannelBinding *bool `json:"try_channel_binding,omitempty"`

	// Specifies whether or not to use Start TLS over LDAP connections.
	//
	UseStartTLS *bool `json:"use_start_tls,omitempty"`

	// Specifies the user Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for user lookups.
	// Example: cn=abc,users,dc=com
	UserDn *string `json:"user_dn,omitempty"`

	// Specifies the default search scope for LDAP for user lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	UserScope *string `json:"user_scope,omitempty"`
}

// Validate validates this ldap service
func (m *LdapService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBaseScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroupScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinBindLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetgroupByhostScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetgroupScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSessionSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapService) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var ldapServiceTypeBaseScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceTypeBaseScopePropEnum = append(ldapServiceTypeBaseScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// base_scope
	// BaseScope
	// base
	// END DEBUGGING
	// LdapServiceBaseScopeBase captures enum value "base"
	LdapServiceBaseScopeBase string = "base"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// base_scope
	// BaseScope
	// onelevel
	// END DEBUGGING
	// LdapServiceBaseScopeOnelevel captures enum value "onelevel"
	LdapServiceBaseScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// base_scope
	// BaseScope
	// subtree
	// END DEBUGGING
	// LdapServiceBaseScopeSubtree captures enum value "subtree"
	LdapServiceBaseScopeSubtree string = "subtree"
)

// prop value enum
func (m *LdapService) validateBaseScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceTypeBaseScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapService) validateBaseScope(formats strfmt.Registry) error {
	if swag.IsZero(m.BaseScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateBaseScopeEnum("base_scope", "body", *m.BaseScope); err != nil {
		return err
	}

	return nil
}

var ldapServiceTypeGroupScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceTypeGroupScopePropEnum = append(ldapServiceTypeGroupScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// group_scope
	// GroupScope
	// base
	// END DEBUGGING
	// LdapServiceGroupScopeBase captures enum value "base"
	LdapServiceGroupScopeBase string = "base"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// group_scope
	// GroupScope
	// onelevel
	// END DEBUGGING
	// LdapServiceGroupScopeOnelevel captures enum value "onelevel"
	LdapServiceGroupScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// group_scope
	// GroupScope
	// subtree
	// END DEBUGGING
	// LdapServiceGroupScopeSubtree captures enum value "subtree"
	LdapServiceGroupScopeSubtree string = "subtree"
)

// prop value enum
func (m *LdapService) validateGroupScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceTypeGroupScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapService) validateGroupScope(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateGroupScopeEnum("group_scope", "body", *m.GroupScope); err != nil {
		return err
	}

	return nil
}

var ldapServiceTypeMinBindLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["anonymous","simple","sasl"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceTypeMinBindLevelPropEnum = append(ldapServiceTypeMinBindLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// min_bind_level
	// MinBindLevel
	// anonymous
	// END DEBUGGING
	// LdapServiceMinBindLevelAnonymous captures enum value "anonymous"
	LdapServiceMinBindLevelAnonymous string = "anonymous"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// min_bind_level
	// MinBindLevel
	// simple
	// END DEBUGGING
	// LdapServiceMinBindLevelSimple captures enum value "simple"
	LdapServiceMinBindLevelSimple string = "simple"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// min_bind_level
	// MinBindLevel
	// sasl
	// END DEBUGGING
	// LdapServiceMinBindLevelSasl captures enum value "sasl"
	LdapServiceMinBindLevelSasl string = "sasl"
)

// prop value enum
func (m *LdapService) validateMinBindLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceTypeMinBindLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapService) validateMinBindLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.MinBindLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateMinBindLevelEnum("min_bind_level", "body", *m.MinBindLevel); err != nil {
		return err
	}

	return nil
}

var ldapServiceTypeNetgroupByhostScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceTypeNetgroupByhostScopePropEnum = append(ldapServiceTypeNetgroupByhostScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// base
	// END DEBUGGING
	// LdapServiceNetgroupByhostScopeBase captures enum value "base"
	LdapServiceNetgroupByhostScopeBase string = "base"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// onelevel
	// END DEBUGGING
	// LdapServiceNetgroupByhostScopeOnelevel captures enum value "onelevel"
	LdapServiceNetgroupByhostScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// subtree
	// END DEBUGGING
	// LdapServiceNetgroupByhostScopeSubtree captures enum value "subtree"
	LdapServiceNetgroupByhostScopeSubtree string = "subtree"
)

// prop value enum
func (m *LdapService) validateNetgroupByhostScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceTypeNetgroupByhostScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapService) validateNetgroupByhostScope(formats strfmt.Registry) error {
	if swag.IsZero(m.NetgroupByhostScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateNetgroupByhostScopeEnum("netgroup_byhost_scope", "body", *m.NetgroupByhostScope); err != nil {
		return err
	}

	return nil
}

var ldapServiceTypeNetgroupScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceTypeNetgroupScopePropEnum = append(ldapServiceTypeNetgroupScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// netgroup_scope
	// NetgroupScope
	// base
	// END DEBUGGING
	// LdapServiceNetgroupScopeBase captures enum value "base"
	LdapServiceNetgroupScopeBase string = "base"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// netgroup_scope
	// NetgroupScope
	// onelevel
	// END DEBUGGING
	// LdapServiceNetgroupScopeOnelevel captures enum value "onelevel"
	LdapServiceNetgroupScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// netgroup_scope
	// NetgroupScope
	// subtree
	// END DEBUGGING
	// LdapServiceNetgroupScopeSubtree captures enum value "subtree"
	LdapServiceNetgroupScopeSubtree string = "subtree"
)

// prop value enum
func (m *LdapService) validateNetgroupScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceTypeNetgroupScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapService) validateNetgroupScope(formats strfmt.Registry) error {
	if swag.IsZero(m.NetgroupScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateNetgroupScopeEnum("netgroup_scope", "body", *m.NetgroupScope); err != nil {
		return err
	}

	return nil
}

func (m *LdapService) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("port", "body", *m.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port", "body", *m.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

var ldapServiceTypeSessionSecurityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","sign","seal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceTypeSessionSecurityPropEnum = append(ldapServiceTypeSessionSecurityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// session_security
	// SessionSecurity
	// none
	// END DEBUGGING
	// LdapServiceSessionSecurityNone captures enum value "none"
	LdapServiceSessionSecurityNone string = "none"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// session_security
	// SessionSecurity
	// sign
	// END DEBUGGING
	// LdapServiceSessionSecuritySign captures enum value "sign"
	LdapServiceSessionSecuritySign string = "sign"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// session_security
	// SessionSecurity
	// seal
	// END DEBUGGING
	// LdapServiceSessionSecuritySeal captures enum value "seal"
	LdapServiceSessionSecuritySeal string = "seal"
)

// prop value enum
func (m *LdapService) validateSessionSecurityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceTypeSessionSecurityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapService) validateSessionSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.SessionSecurity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSessionSecurityEnum("session_security", "body", *m.SessionSecurity); err != nil {
		return err
	}

	return nil
}

func (m *LdapService) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *LdapService) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var ldapServiceTypeUserScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceTypeUserScopePropEnum = append(ldapServiceTypeUserScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// user_scope
	// UserScope
	// base
	// END DEBUGGING
	// LdapServiceUserScopeBase captures enum value "base"
	LdapServiceUserScopeBase string = "base"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// user_scope
	// UserScope
	// onelevel
	// END DEBUGGING
	// LdapServiceUserScopeOnelevel captures enum value "onelevel"
	LdapServiceUserScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// ldap_service
	// LdapService
	// user_scope
	// UserScope
	// subtree
	// END DEBUGGING
	// LdapServiceUserScopeSubtree captures enum value "subtree"
	LdapServiceUserScopeSubtree string = "subtree"
)

// prop value enum
func (m *LdapService) validateUserScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceTypeUserScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapService) validateUserScope(formats strfmt.Registry) error {
	if swag.IsZero(m.UserScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateUserScopeEnum("user_scope", "body", *m.UserScope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ldap service based on the context it is used
func (m *LdapService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapService) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LdapService) contextValidateIsOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_owner", "body", m.IsOwner); err != nil {
		return err
	}

	return nil
}

func (m *LdapService) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *LdapService) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LdapService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapService) UnmarshalBinary(b []byte) error {
	var res LdapService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LdapServiceInlineLinks ldap service inline links
//
// swagger:model ldap_service_inline__links
type LdapServiceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ldap service inline links
func (m *LdapServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ldap service inline links based on the context it is used
func (m *LdapServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LdapServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LdapServiceInlineStatus ldap service inline status
//
// swagger:model ldap_service_inline_status
type LdapServiceInlineStatus struct {

	// This field is no longer supported. Use ipv4.code or ipv6.code instead.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn message
	DnMessage []*string `json:"dn_message,omitempty"`

	// ipv4
	IPV4 *LdapServiceInlineStatusInlineIPV4 `json:"ipv4,omitempty"`

	// This field is no longer supported. Use ipv4.state instead.
	//
	// Enum: ["up","down"]
	IPV4State *string `json:"ipv4_state,omitempty"`

	// ipv6
	IPV6 *LdapServiceInlineStatusInlineIPV6 `json:"ipv6,omitempty"`

	// This field is no longer supported. Use ipv6.state instead.
	//
	// Enum: ["up","down"]
	IPV6State *string `json:"ipv6_state,omitempty"`

	// This field is no longer supported. Use ipv4.message or ipv6.message instead.
	//
	Message *string `json:"message,omitempty"`

	// The status of the LDAP service for the SVM. The LDAP service is up if either `ipv4_state` or `ipv6_state` is up.
	// The LDAP service is down if both `ipv4_state` and `ipv6_state` are down.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ldap service inline status
func (m *LdapServiceInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV4State(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6State(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineStatus) validateIPV4(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4) { // not required
		return nil
	}

	if m.IPV4 != nil {
		if err := m.IPV4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv4")
			}
			return err
		}
	}

	return nil
}

var ldapServiceInlineStatusTypeIPV4StatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusTypeIPV4StatePropEnum = append(ldapServiceInlineStatusTypeIPV4StatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv4_state
	// IPV4State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusIPV4StateUp captures enum value "up"
	LdapServiceInlineStatusIPV4StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv4_state
	// IPV4State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusIPV4StateDown captures enum value "down"
	LdapServiceInlineStatusIPV4StateDown string = "down"
)

// prop value enum
func (m *LdapServiceInlineStatus) validateIPV4StateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusTypeIPV4StatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapServiceInlineStatus) validateIPV4State(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4State) { // not required
		return nil
	}

	// value enum
	if err := m.validateIPV4StateEnum("status"+"."+"ipv4_state", "body", *m.IPV4State); err != nil {
		return err
	}

	return nil
}

func (m *LdapServiceInlineStatus) validateIPV6(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6) { // not required
		return nil
	}

	if m.IPV6 != nil {
		if err := m.IPV6.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv6")
			}
			return err
		}
	}

	return nil
}

var ldapServiceInlineStatusTypeIPV6StatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusTypeIPV6StatePropEnum = append(ldapServiceInlineStatusTypeIPV6StatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv6_state
	// IPV6State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusIPV6StateUp captures enum value "up"
	LdapServiceInlineStatusIPV6StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv6_state
	// IPV6State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusIPV6StateDown captures enum value "down"
	LdapServiceInlineStatusIPV6StateDown string = "down"
)

// prop value enum
func (m *LdapServiceInlineStatus) validateIPV6StateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusTypeIPV6StatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapServiceInlineStatus) validateIPV6State(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6State) { // not required
		return nil
	}

	// value enum
	if err := m.validateIPV6StateEnum("status"+"."+"ipv6_state", "body", *m.IPV6State); err != nil {
		return err
	}

	return nil
}

var ldapServiceInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusTypeStatePropEnum = append(ldapServiceInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// state
	// State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusStateUp captures enum value "up"
	LdapServiceInlineStatusStateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// state
	// State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusStateDown captures enum value "down"
	LdapServiceInlineStatusStateDown string = "down"
)

// prop value enum
func (m *LdapServiceInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapServiceInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ldap service inline status based on the context it is used
func (m *LdapServiceInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV6(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineStatus) contextValidateIPV4(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4 != nil {
		if err := m.IPV4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv4")
			}
			return err
		}
	}

	return nil
}

func (m *LdapServiceInlineStatus) contextValidateIPV6(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV6 != nil {
		if err := m.IPV6.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv6")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LdapServiceInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapServiceInlineStatus) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LdapServiceInlineStatusInlineIPV4 ldap service inline status inline ipv4
//
// swagger:model ldap_service_inline_status_inline_ipv4
type LdapServiceInlineStatusInlineIPV4 struct {

	// Code corresponding to the error message. If there is no error, it is 0 to indicate success.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn messages
	DnMessages []*string `json:"dn_messages,omitempty"`

	// Provides additional details on the error.
	//
	Message *string `json:"message,omitempty"`

	// Status of the LDAP service.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ldap service inline status inline ipv4
func (m *LdapServiceInlineStatusInlineIPV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ldapServiceInlineStatusInlineIpv4TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusInlineIpv4TypeStatePropEnum = append(ldapServiceInlineStatusInlineIpv4TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv4
	// LdapServiceInlineStatusInlineIPV4
	// state
	// State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV4StateUp captures enum value "up"
	LdapServiceInlineStatusInlineIPV4StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv4
	// LdapServiceInlineStatusInlineIPV4
	// state
	// State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV4StateDown captures enum value "down"
	LdapServiceInlineStatusInlineIPV4StateDown string = "down"
)

// prop value enum
func (m *LdapServiceInlineStatusInlineIPV4) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusInlineIpv4TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapServiceInlineStatusInlineIPV4) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"ipv4"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ldap service inline status inline ipv4 based on context it is used
func (m *LdapServiceInlineStatusInlineIPV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LdapServiceInlineStatusInlineIPV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapServiceInlineStatusInlineIPV4) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineStatusInlineIPV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LdapServiceInlineStatusInlineIPV6 ldap service inline status inline ipv6
//
// swagger:model ldap_service_inline_status_inline_ipv6
type LdapServiceInlineStatusInlineIPV6 struct {

	// Code corresponding to the error message. If there is no error, it is 0 to indicate success.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn messages
	DnMessages []*string `json:"dn_messages,omitempty"`

	// Provides additional details on the error.
	//
	Message *string `json:"message,omitempty"`

	// Status of the LDAP service.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ldap service inline status inline ipv6
func (m *LdapServiceInlineStatusInlineIPV6) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ldapServiceInlineStatusInlineIpv6TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusInlineIpv6TypeStatePropEnum = append(ldapServiceInlineStatusInlineIpv6TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv6
	// LdapServiceInlineStatusInlineIPV6
	// state
	// State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV6StateUp captures enum value "up"
	LdapServiceInlineStatusInlineIPV6StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv6
	// LdapServiceInlineStatusInlineIPV6
	// state
	// State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV6StateDown captures enum value "down"
	LdapServiceInlineStatusInlineIPV6StateDown string = "down"
)

// prop value enum
func (m *LdapServiceInlineStatusInlineIPV6) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusInlineIpv6TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LdapServiceInlineStatusInlineIPV6) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"ipv6"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ldap service inline status inline ipv6 based on context it is used
func (m *LdapServiceInlineStatusInlineIPV6) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LdapServiceInlineStatusInlineIPV6) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapServiceInlineStatusInlineIPV6) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineStatusInlineIPV6
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LdapServiceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model ldap_service_inline_svm
type LdapServiceInlineSvm struct {

	// links
	Links *LdapServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ldap service inline svm
func (m *LdapServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ldap service inline svm based on the context it is used
func (m *LdapServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LdapServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LdapServiceInlineSvmInlineLinks ldap service inline svm inline links
//
// swagger:model ldap_service_inline_svm_inline__links
type LdapServiceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ldap service inline svm inline links
func (m *LdapServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ldap service inline svm inline links based on the context it is used
func (m *LdapServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LdapServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LdapServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LdapServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
