// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LicensePackage license package
//
// swagger:model license_package
type LicensePackage struct {

	// links
	Links *LicensePackageInlineLinks `json:"_links,omitempty"`

	// License description
	// Example: NFS License
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// entitlement
	Entitlement *LicensePackageInlineEntitlement `json:"entitlement,omitempty"`

	// license package inline keys
	LicensePackageInlineKeys []*string `json:"keys,omitempty"`

	// Installed licenses of the package.
	// Read Only: true
	LicensePackageInlineLicenses []*LicensePackageInlineLicensesInlineArrayItem `json:"licenses,omitempty"`

	// Name of the license.
	// Example: NFS
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Scope of the license.
	// Read Only: true
	// Enum: ["not_available","site","cluster","node"]
	Scope *string `json:"scope,omitempty"`

	// Summary state of package based on all installed licenses.
	// Example: compliant
	// Read Only: true
	// Enum: ["compliant","noncompliant","unlicensed","unknown"]
	State *string `json:"state,omitempty"`
}

// Validate validates this license package
func (m *LicensePackage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntitlement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLicensePackageInlineLicenses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackage) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackage) validateEntitlement(formats strfmt.Registry) error {
	if swag.IsZero(m.Entitlement) { // not required
		return nil
	}

	if m.Entitlement != nil {
		if err := m.Entitlement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entitlement")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackage) validateLicensePackageInlineLicenses(formats strfmt.Registry) error {
	if swag.IsZero(m.LicensePackageInlineLicenses) { // not required
		return nil
	}

	for i := 0; i < len(m.LicensePackageInlineLicenses); i++ {
		if swag.IsZero(m.LicensePackageInlineLicenses[i]) { // not required
			continue
		}

		if m.LicensePackageInlineLicenses[i] != nil {
			if err := m.LicensePackageInlineLicenses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("licenses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var licensePackageTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_available","site","cluster","node"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageTypeScopePropEnum = append(licensePackageTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// scope
	// Scope
	// not_available
	// END DEBUGGING
	// LicensePackageScopeNotAvailable captures enum value "not_available"
	LicensePackageScopeNotAvailable string = "not_available"

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// scope
	// Scope
	// site
	// END DEBUGGING
	// LicensePackageScopeSite captures enum value "site"
	LicensePackageScopeSite string = "site"

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// LicensePackageScopeCluster captures enum value "cluster"
	LicensePackageScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// scope
	// Scope
	// node
	// END DEBUGGING
	// LicensePackageScopeNode captures enum value "node"
	LicensePackageScopeNode string = "node"
)

// prop value enum
func (m *LicensePackage) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackage) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

var licensePackageTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliant","noncompliant","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageTypeStatePropEnum = append(licensePackageTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// state
	// State
	// compliant
	// END DEBUGGING
	// LicensePackageStateCompliant captures enum value "compliant"
	LicensePackageStateCompliant string = "compliant"

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// state
	// State
	// noncompliant
	// END DEBUGGING
	// LicensePackageStateNoncompliant captures enum value "noncompliant"
	LicensePackageStateNoncompliant string = "noncompliant"

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// state
	// State
	// unlicensed
	// END DEBUGGING
	// LicensePackageStateUnlicensed captures enum value "unlicensed"
	LicensePackageStateUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// license_package
	// LicensePackage
	// state
	// State
	// unknown
	// END DEBUGGING
	// LicensePackageStateUnknown captures enum value "unknown"
	LicensePackageStateUnknown string = "unknown"
)

// prop value enum
func (m *LicensePackage) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackage) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package based on the context it is used
func (m *LicensePackage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntitlement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLicensePackageInlineLicenses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackage) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackage) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackage) contextValidateEntitlement(ctx context.Context, formats strfmt.Registry) error {

	if m.Entitlement != nil {
		if err := m.Entitlement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entitlement")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackage) contextValidateLicensePackageInlineLicenses(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "licenses", "body", []*LicensePackageInlineLicensesInlineArrayItem(m.LicensePackageInlineLicenses)); err != nil {
		return err
	}

	for i := 0; i < len(m.LicensePackageInlineLicenses); i++ {

		if m.LicensePackageInlineLicenses[i] != nil {
			if err := m.LicensePackageInlineLicenses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("licenses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LicensePackage) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackage) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackage) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackage) UnmarshalBinary(b []byte) error {
	var res LicensePackage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageInlineEntitlement license package inline entitlement
//
// swagger:model license_package_inline_entitlement
type LicensePackageInlineEntitlement struct {

	// Entitlement action to be taken to mitigate the risk
	// Read Only: true
	// Enum: ["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]
	Action *string `json:"action,omitempty"`

	// Entitlement risk of the package
	// Read Only: true
	// Enum: ["high","medium","low","unlicensed","unknown"]
	Risk *string `json:"risk,omitempty"`
}

// Validate validates this license package inline entitlement
func (m *LicensePackageInlineEntitlement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRisk(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licensePackageInlineEntitlementTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageInlineEntitlementTypeActionPropEnum = append(licensePackageInlineEntitlementTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// action
	// Action
	// acquire_license
	// END DEBUGGING
	// LicensePackageInlineEntitlementActionAcquireLicense captures enum value "acquire_license"
	LicensePackageInlineEntitlementActionAcquireLicense string = "acquire_license"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// action
	// Action
	// adjust_capacity
	// END DEBUGGING
	// LicensePackageInlineEntitlementActionAdjustCapacity captures enum value "adjust_capacity"
	LicensePackageInlineEntitlementActionAdjustCapacity string = "adjust_capacity"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// action
	// Action
	// verify_entitlement
	// END DEBUGGING
	// LicensePackageInlineEntitlementActionVerifyEntitlement captures enum value "verify_entitlement"
	LicensePackageInlineEntitlementActionVerifyEntitlement string = "verify_entitlement"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// action
	// Action
	// verify_system_health
	// END DEBUGGING
	// LicensePackageInlineEntitlementActionVerifySystemHealth captures enum value "verify_system_health"
	LicensePackageInlineEntitlementActionVerifySystemHealth string = "verify_system_health"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// action
	// Action
	// none
	// END DEBUGGING
	// LicensePackageInlineEntitlementActionNone captures enum value "none"
	LicensePackageInlineEntitlementActionNone string = "none"
)

// prop value enum
func (m *LicensePackageInlineEntitlement) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageInlineEntitlementTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageInlineEntitlement) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("entitlement"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

var licensePackageInlineEntitlementTypeRiskPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["high","medium","low","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageInlineEntitlementTypeRiskPropEnum = append(licensePackageInlineEntitlementTypeRiskPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// risk
	// Risk
	// high
	// END DEBUGGING
	// LicensePackageInlineEntitlementRiskHigh captures enum value "high"
	LicensePackageInlineEntitlementRiskHigh string = "high"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// risk
	// Risk
	// medium
	// END DEBUGGING
	// LicensePackageInlineEntitlementRiskMedium captures enum value "medium"
	LicensePackageInlineEntitlementRiskMedium string = "medium"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// risk
	// Risk
	// low
	// END DEBUGGING
	// LicensePackageInlineEntitlementRiskLow captures enum value "low"
	LicensePackageInlineEntitlementRiskLow string = "low"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// risk
	// Risk
	// unlicensed
	// END DEBUGGING
	// LicensePackageInlineEntitlementRiskUnlicensed captures enum value "unlicensed"
	LicensePackageInlineEntitlementRiskUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// license_package_inline_entitlement
	// LicensePackageInlineEntitlement
	// risk
	// Risk
	// unknown
	// END DEBUGGING
	// LicensePackageInlineEntitlementRiskUnknown captures enum value "unknown"
	LicensePackageInlineEntitlementRiskUnknown string = "unknown"
)

// prop value enum
func (m *LicensePackageInlineEntitlement) validateRiskEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageInlineEntitlementTypeRiskPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageInlineEntitlement) validateRisk(formats strfmt.Registry) error {
	if swag.IsZero(m.Risk) { // not required
		return nil
	}

	// value enum
	if err := m.validateRiskEnum("entitlement"+"."+"risk", "body", *m.Risk); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package inline entitlement based on the context it is used
func (m *LicensePackageInlineEntitlement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRisk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageInlineEntitlement) contextValidateAction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entitlement"+"."+"action", "body", m.Action); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineEntitlement) contextValidateRisk(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entitlement"+"."+"risk", "body", m.Risk); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageInlineEntitlement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageInlineEntitlement) UnmarshalBinary(b []byte) error {
	var res LicensePackageInlineEntitlement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageInlineLicensesInlineArrayItem license package inline licenses inline array item
//
// swagger:model license_package_inline_licenses_inline_array_item
type LicensePackageInlineLicensesInlineArrayItem struct {

	// A flag indicating whether the license is currently being enforced.
	// Read Only: true
	Active *bool `json:"active,omitempty"`

	// capacity
	Capacity *LicensePackageInlineLicensesInlineArrayItemInlineCapacity `json:"capacity,omitempty"`

	// compliance
	Compliance *LicensePackageInlineLicensesInlineArrayItemInlineCompliance `json:"compliance,omitempty"`

	// A flag indicating whether the license is in evaluation mode.
	// Read Only: true
	Evaluation *bool `json:"evaluation,omitempty"`

	// Date and time when the license expires.
	// Example: 2019-03-02 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// A string that associates the license with a node or cluster.
	// Example: 456-44-1234
	// Read Only: true
	HostID *string `json:"host_id,omitempty"`

	// Name of license that enabled the feature.
	// Example: Core Bundle
	// Read Only: true
	InstalledLicense *string `json:"installed_license,omitempty"`

	// Cluster, node or license manager that owns the license.
	// Example: cluster1
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// Serial number of the license.
	// Example: 123456789
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// A flag indicating whether the Cloud ONTAP system is going to shutdown as the Cloud platform license has already expired.
	// Read Only: true
	ShutdownImminent *bool `json:"shutdown_imminent,omitempty"`

	// Date and time when the license starts.
	// Example: 2019-02-02 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this license package inline licenses inline array item
func (m *LicensePackageInlineLicensesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapacity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompliance(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) validateCapacity(formats strfmt.Registry) error {
	if swag.IsZero(m.Capacity) { // not required
		return nil
	}

	if m.Capacity != nil {
		if err := m.Capacity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) validateCompliance(formats strfmt.Registry) error {
	if swag.IsZero(m.Compliance) { // not required
		return nil
	}

	if m.Compliance != nil {
		if err := m.Compliance.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compliance")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package inline licenses inline array item based on the context it is used
func (m *LicensePackageInlineLicensesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompliance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEvaluation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHostID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInstalledLicense(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShutdownImminent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateActive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if m.Capacity != nil {
		if err := m.Capacity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateCompliance(ctx context.Context, formats strfmt.Registry) error {

	if m.Compliance != nil {
		if err := m.Compliance.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compliance")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateEvaluation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "evaluation", "body", m.Evaluation); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "expiry_time", "body", m.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateHostID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_id", "body", m.HostID); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateInstalledLicense(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "installed_license", "body", m.InstalledLicense); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner", "body", m.Owner); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateShutdownImminent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "shutdown_imminent", "body", m.ShutdownImminent); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItem) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageInlineLicensesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageInlineLicensesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LicensePackageInlineLicensesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageInlineLicensesInlineArrayItemInlineCapacity license package inline licenses inline array item inline capacity
//
// swagger:model license_package_inline_licenses_inline_array_item_inline_capacity
type LicensePackageInlineLicensesInlineArrayItemInlineCapacity struct {

	// Capacity that is currently disabled due to license limits. Its unit of measure is specified in the measurement_unit field.
	// Read Only: true
	DisabledSize *int64 `json:"disabled_size,omitempty"`

	// Licensed capacity size that can be used. Its unit of measure is specified in the measurement_unit field.
	// Read Only: true
	MaximumSize *int64 `json:"maximum_size,omitempty"`

	// Unit of measure for capacity based licenses.
	// Read Only: true
	// Enum: ["bytes","gpu_count"]
	MeasurementUnit *string `json:"measurement_unit,omitempty"`

	// Specifies the total number of GPUs in the system when measurement_unit is GPUs, else specifies the bytes used.
	// Read Only: true
	UsedSize *int64 `json:"used_size,omitempty"`
}

// Validate validates this license package inline licenses inline array item inline capacity
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMeasurementUnit(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licensePackageInlineLicensesInlineArrayItemInlineCapacityTypeMeasurementUnitPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bytes","gpu_count"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageInlineLicensesInlineArrayItemInlineCapacityTypeMeasurementUnitPropEnum = append(licensePackageInlineLicensesInlineArrayItemInlineCapacityTypeMeasurementUnitPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_inline_licenses_inline_array_item_inline_capacity
	// LicensePackageInlineLicensesInlineArrayItemInlineCapacity
	// measurement_unit
	// MeasurementUnit
	// bytes
	// END DEBUGGING
	// LicensePackageInlineLicensesInlineArrayItemInlineCapacityMeasurementUnitBytes captures enum value "bytes"
	LicensePackageInlineLicensesInlineArrayItemInlineCapacityMeasurementUnitBytes string = "bytes"

	// BEGIN DEBUGGING
	// license_package_inline_licenses_inline_array_item_inline_capacity
	// LicensePackageInlineLicensesInlineArrayItemInlineCapacity
	// measurement_unit
	// MeasurementUnit
	// gpu_count
	// END DEBUGGING
	// LicensePackageInlineLicensesInlineArrayItemInlineCapacityMeasurementUnitGpuCount captures enum value "gpu_count"
	LicensePackageInlineLicensesInlineArrayItemInlineCapacityMeasurementUnitGpuCount string = "gpu_count"
)

// prop value enum
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) validateMeasurementUnitEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageInlineLicensesInlineArrayItemInlineCapacityTypeMeasurementUnitPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) validateMeasurementUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.MeasurementUnit) { // not required
		return nil
	}

	// value enum
	if err := m.validateMeasurementUnitEnum("capacity"+"."+"measurement_unit", "body", *m.MeasurementUnit); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package inline licenses inline array item inline capacity based on the context it is used
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDisabledSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaximumSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMeasurementUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) contextValidateDisabledSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"disabled_size", "body", m.DisabledSize); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) contextValidateMaximumSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"maximum_size", "body", m.MaximumSize); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) contextValidateMeasurementUnit(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"measurement_unit", "body", m.MeasurementUnit); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) contextValidateUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"used_size", "body", m.UsedSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCapacity) UnmarshalBinary(b []byte) error {
	var res LicensePackageInlineLicensesInlineArrayItemInlineCapacity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageInlineLicensesInlineArrayItemInlineCompliance license package inline licenses inline array item inline compliance
//
// swagger:model license_package_inline_licenses_inline_array_item_inline_compliance
type LicensePackageInlineLicensesInlineArrayItemInlineCompliance struct {

	// Compliance state of the license.
	// Example: compliant
	// Read Only: true
	// Enum: ["compliant","noncompliant","unlicensed","unknown"]
	State *string `json:"state,omitempty"`
}

// Validate validates this license package inline licenses inline array item inline compliance
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCompliance) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licensePackageInlineLicensesInlineArrayItemInlineComplianceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliant","noncompliant","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageInlineLicensesInlineArrayItemInlineComplianceTypeStatePropEnum = append(licensePackageInlineLicensesInlineArrayItemInlineComplianceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_inline_licenses_inline_array_item_inline_compliance
	// LicensePackageInlineLicensesInlineArrayItemInlineCompliance
	// state
	// State
	// compliant
	// END DEBUGGING
	// LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateCompliant captures enum value "compliant"
	LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateCompliant string = "compliant"

	// BEGIN DEBUGGING
	// license_package_inline_licenses_inline_array_item_inline_compliance
	// LicensePackageInlineLicensesInlineArrayItemInlineCompliance
	// state
	// State
	// noncompliant
	// END DEBUGGING
	// LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateNoncompliant captures enum value "noncompliant"
	LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateNoncompliant string = "noncompliant"

	// BEGIN DEBUGGING
	// license_package_inline_licenses_inline_array_item_inline_compliance
	// LicensePackageInlineLicensesInlineArrayItemInlineCompliance
	// state
	// State
	// unlicensed
	// END DEBUGGING
	// LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateUnlicensed captures enum value "unlicensed"
	LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// license_package_inline_licenses_inline_array_item_inline_compliance
	// LicensePackageInlineLicensesInlineArrayItemInlineCompliance
	// state
	// State
	// unknown
	// END DEBUGGING
	// LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateUnknown captures enum value "unknown"
	LicensePackageInlineLicensesInlineArrayItemInlineComplianceStateUnknown string = "unknown"
)

// prop value enum
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCompliance) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageInlineLicensesInlineArrayItemInlineComplianceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItemInlineCompliance) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("compliance"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package inline licenses inline array item inline compliance based on the context it is used
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCompliance) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageInlineLicensesInlineArrayItemInlineCompliance) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "compliance"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCompliance) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageInlineLicensesInlineArrayItemInlineCompliance) UnmarshalBinary(b []byte) error {
	var res LicensePackageInlineLicensesInlineArrayItemInlineCompliance
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageInlineLinks license package inline links
//
// swagger:model license_package_inline__links
type LicensePackageInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this license package inline links
func (m *LicensePackageInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this license package inline links based on the context it is used
func (m *LicensePackageInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageInlineLinks) UnmarshalBinary(b []byte) error {
	var res LicensePackageInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
