// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LicensePackageResponse license package response
//
// swagger:model license_package_response
type LicensePackageResponse struct {

	// links
	Links *LicensePackageResponseInlineLinks `json:"_links,omitempty"`

	// license package response inline records
	LicensePackageResponseInlineRecords []*LicensePackageResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this license package response
func (m *LicensePackageResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLicensePackageResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponse) validateLicensePackageResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.LicensePackageResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.LicensePackageResponseInlineRecords); i++ {
		if swag.IsZero(m.LicensePackageResponseInlineRecords[i]) { // not required
			continue
		}

		if m.LicensePackageResponseInlineRecords[i] != nil {
			if err := m.LicensePackageResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this license package response based on the context it is used
func (m *LicensePackageResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLicensePackageResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponse) contextValidateLicensePackageResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LicensePackageResponseInlineRecords); i++ {

		if m.LicensePackageResponseInlineRecords[i] != nil {
			if err := m.LicensePackageResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponse) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageResponseInlineLinks license package response inline links
//
// swagger:model license_package_response_inline__links
type LicensePackageResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this license package response inline links
func (m *LicensePackageResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this license package response inline links based on the context it is used
func (m *LicensePackageResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageResponseInlineRecordsInlineArrayItem license package response inline records inline array item
//
// swagger:model license_package_response_inline_records_inline_array_item
type LicensePackageResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// License description
	// Example: NFS License
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// entitlement
	Entitlement *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement `json:"entitlement,omitempty"`

	// keys
	Keys []*string `json:"keys"`

	// Installed licenses of the package.
	// Read Only: true
	Licenses []*LicensePackageResponseRecordsItems0LicensesItems0 `json:"licenses"`

	// Name of the license.
	// Example: NFS
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Scope of the license.
	// Read Only: true
	// Enum: ["not_available","site","cluster","node"]
	Scope *string `json:"scope,omitempty"`

	// Summary state of package based on all installed licenses.
	// Example: compliant
	// Read Only: true
	// Enum: ["compliant","noncompliant","unlicensed","unknown"]
	State *string `json:"state,omitempty"`
}

// Validate validates this license package response inline records inline array item
func (m *LicensePackageResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntitlement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLicenses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) validateEntitlement(formats strfmt.Registry) error {
	if swag.IsZero(m.Entitlement) { // not required
		return nil
	}

	if m.Entitlement != nil {
		if err := m.Entitlement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entitlement")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) validateLicenses(formats strfmt.Registry) error {
	if swag.IsZero(m.Licenses) { // not required
		return nil
	}

	for i := 0; i < len(m.Licenses); i++ {
		if swag.IsZero(m.Licenses[i]) { // not required
			continue
		}

		if m.Licenses[i] != nil {
			if err := m.Licenses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("licenses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_available","site","cluster","node"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// not_available
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeNotAvailable captures enum value "not_available"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeNotAvailable string = "not_available"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// site
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeSite captures enum value "site"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeSite string = "site"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeCluster captures enum value "cluster"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// scope
	// Scope
	// node
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemScopeNode captures enum value "node"
	LicensePackageResponseInlineRecordsInlineArrayItemScopeNode string = "node"
)

// prop value enum
func (m *LicensePackageResponseInlineRecordsInlineArrayItem) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliant","noncompliant","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// compliant
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateCompliant captures enum value "compliant"
	LicensePackageResponseInlineRecordsInlineArrayItemStateCompliant string = "compliant"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// noncompliant
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateNoncompliant captures enum value "noncompliant"
	LicensePackageResponseInlineRecordsInlineArrayItemStateNoncompliant string = "noncompliant"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// unlicensed
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateUnlicensed captures enum value "unlicensed"
	LicensePackageResponseInlineRecordsInlineArrayItemStateUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item
	// LicensePackageResponseInlineRecordsInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemStateUnknown captures enum value "unknown"
	LicensePackageResponseInlineRecordsInlineArrayItemStateUnknown string = "unknown"
)

// prop value enum
func (m *LicensePackageResponseInlineRecordsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package response inline records inline array item based on the context it is used
func (m *LicensePackageResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntitlement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLicenses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateEntitlement(ctx context.Context, formats strfmt.Registry) error {

	if m.Entitlement != nil {
		if err := m.Entitlement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("entitlement")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateLicenses(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "licenses", "body", []*LicensePackageResponseRecordsItems0LicensesItems0(m.Licenses)); err != nil {
		return err
	}

	for i := 0; i < len(m.Licenses); i++ {

		if m.Licenses[i] != nil {
			if err := m.Licenses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("licenses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItem) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement license package response inline records inline array item inline entitlement
//
// swagger:model license_package_response_inline_records_inline_array_item_inline_entitlement
type LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement struct {

	// Entitlement action to be taken to mitigate the risk
	// Read Only: true
	// Enum: ["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]
	Action *string `json:"action,omitempty"`

	// Entitlement risk of the package
	// Read Only: true
	// Enum: ["high","medium","low","unlicensed","unknown"]
	Risk *string `json:"risk,omitempty"`
}

// Validate validates this license package response inline records inline array item inline entitlement
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRisk(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["acquire_license","adjust_capacity","verify_entitlement","verify_system_health","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// acquire_license
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAcquireLicense captures enum value "acquire_license"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAcquireLicense string = "acquire_license"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// adjust_capacity
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAdjustCapacity captures enum value "adjust_capacity"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionAdjustCapacity string = "adjust_capacity"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// verify_entitlement
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifyEntitlement captures enum value "verify_entitlement"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifyEntitlement string = "verify_entitlement"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// verify_system_health
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifySystemHealth captures enum value "verify_system_health"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionVerifySystemHealth string = "verify_system_health"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// action
	// Action
	// none
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionNone captures enum value "none"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementActionNone string = "none"
)

// prop value enum
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("entitlement"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

var licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["high","medium","low","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum = append(licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// high
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskHigh captures enum value "high"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskHigh string = "high"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// medium
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskMedium captures enum value "medium"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskMedium string = "medium"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// low
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskLow captures enum value "low"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskLow string = "low"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// unlicensed
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnlicensed captures enum value "unlicensed"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// license_package_response_inline_records_inline_array_item_inline_entitlement
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	// risk
	// Risk
	// unknown
	// END DEBUGGING
	// LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnknown captures enum value "unknown"
	LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementRiskUnknown string = "unknown"
)

// prop value enum
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateRiskEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseInlineRecordsInlineArrayItemInlineEntitlementTypeRiskPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) validateRisk(formats strfmt.Registry) error {
	if swag.IsZero(m.Risk) { // not required
		return nil
	}

	// value enum
	if err := m.validateRiskEnum("entitlement"+"."+"risk", "body", *m.Risk); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package response inline records inline array item inline entitlement based on the context it is used
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRisk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) contextValidateAction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entitlement"+"."+"action", "body", m.Action); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) contextValidateRisk(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "entitlement"+"."+"risk", "body", m.Risk); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseInlineRecordsInlineArrayItemInlineEntitlement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageResponseRecordsItems0LicensesItems0 license package response records items0 licenses items0
//
// swagger:model LicensePackageResponseRecordsItems0LicensesItems0
type LicensePackageResponseRecordsItems0LicensesItems0 struct {

	// A flag indicating whether the license is currently being enforced.
	// Read Only: true
	Active *bool `json:"active,omitempty"`

	// capacity
	Capacity *LicensePackageResponseRecordsItems0LicensesItems0Capacity `json:"capacity,omitempty"`

	// compliance
	Compliance *LicensePackageResponseRecordsItems0LicensesItems0Compliance `json:"compliance,omitempty"`

	// A flag indicating whether the license is in evaluation mode.
	// Read Only: true
	Evaluation *bool `json:"evaluation,omitempty"`

	// Date and time when the license expires.
	// Example: 2019-03-02 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// A string that associates the license with a node or cluster.
	// Example: 456-44-1234
	// Read Only: true
	HostID *string `json:"host_id,omitempty"`

	// Name of license that enabled the feature.
	// Example: Core Bundle
	// Read Only: true
	InstalledLicense *string `json:"installed_license,omitempty"`

	// Cluster, node or license manager that owns the license.
	// Example: cluster1
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// Serial number of the license.
	// Example: 123456789
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// A flag indicating whether the Cloud ONTAP system is going to shutdown as the Cloud platform license has already expired.
	// Read Only: true
	ShutdownImminent *bool `json:"shutdown_imminent,omitempty"`

	// Date and time when the license starts.
	// Example: 2019-02-02 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this license package response records items0 licenses items0
func (m *LicensePackageResponseRecordsItems0LicensesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapacity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompliance(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) validateCapacity(formats strfmt.Registry) error {
	if swag.IsZero(m.Capacity) { // not required
		return nil
	}

	if m.Capacity != nil {
		if err := m.Capacity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) validateCompliance(formats strfmt.Registry) error {
	if swag.IsZero(m.Compliance) { // not required
		return nil
	}

	if m.Compliance != nil {
		if err := m.Compliance.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compliance")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package response records items0 licenses items0 based on the context it is used
func (m *LicensePackageResponseRecordsItems0LicensesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompliance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEvaluation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHostID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInstalledLicense(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShutdownImminent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateActive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if m.Capacity != nil {
		if err := m.Capacity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capacity")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateCompliance(ctx context.Context, formats strfmt.Registry) error {

	if m.Compliance != nil {
		if err := m.Compliance.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compliance")
			}
			return err
		}
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateEvaluation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "evaluation", "body", m.Evaluation); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "expiry_time", "body", m.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateHostID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_id", "body", m.HostID); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateInstalledLicense(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "installed_license", "body", m.InstalledLicense); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner", "body", m.Owner); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateShutdownImminent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "shutdown_imminent", "body", m.ShutdownImminent); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponseRecordsItems0LicensesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponseRecordsItems0LicensesItems0) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseRecordsItems0LicensesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageResponseRecordsItems0LicensesItems0Capacity license package response records items0 licenses items0 capacity
//
// swagger:model LicensePackageResponseRecordsItems0LicensesItems0Capacity
type LicensePackageResponseRecordsItems0LicensesItems0Capacity struct {

	// Capacity that is currently disabled due to license limits. Its unit of measure is specified in the measurement_unit field.
	// Read Only: true
	DisabledSize *int64 `json:"disabled_size,omitempty"`

	// Licensed capacity size that can be used. Its unit of measure is specified in the measurement_unit field.
	// Read Only: true
	MaximumSize *int64 `json:"maximum_size,omitempty"`

	// Unit of measure for capacity based licenses.
	// Read Only: true
	// Enum: ["bytes","gpu_count"]
	MeasurementUnit *string `json:"measurement_unit,omitempty"`

	// Specifies the total number of GPUs in the system when measurement_unit is GPUs, else specifies the bytes used.
	// Read Only: true
	UsedSize *int64 `json:"used_size,omitempty"`
}

// Validate validates this license package response records items0 licenses items0 capacity
func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMeasurementUnit(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licensePackageResponseRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bytes","gpu_count"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum = append(licensePackageResponseRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0Capacity
	// LicensePackageResponseRecordsItems0LicensesItems0Capacity
	// measurement_unit
	// MeasurementUnit
	// bytes
	// END DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0CapacityMeasurementUnitBytes captures enum value "bytes"
	LicensePackageResponseRecordsItems0LicensesItems0CapacityMeasurementUnitBytes string = "bytes"

	// BEGIN DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0Capacity
	// LicensePackageResponseRecordsItems0LicensesItems0Capacity
	// measurement_unit
	// MeasurementUnit
	// gpu_count
	// END DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0CapacityMeasurementUnitGpuCount captures enum value "gpu_count"
	LicensePackageResponseRecordsItems0LicensesItems0CapacityMeasurementUnitGpuCount string = "gpu_count"
)

// prop value enum
func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) validateMeasurementUnitEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseRecordsItems0LicensesItems0CapacityTypeMeasurementUnitPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) validateMeasurementUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.MeasurementUnit) { // not required
		return nil
	}

	// value enum
	if err := m.validateMeasurementUnitEnum("capacity"+"."+"measurement_unit", "body", *m.MeasurementUnit); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package response records items0 licenses items0 capacity based on the context it is used
func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDisabledSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaximumSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMeasurementUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) contextValidateDisabledSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"disabled_size", "body", m.DisabledSize); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) contextValidateMaximumSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"maximum_size", "body", m.MaximumSize); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) contextValidateMeasurementUnit(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"measurement_unit", "body", m.MeasurementUnit); err != nil {
		return err
	}

	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) contextValidateUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity"+"."+"used_size", "body", m.UsedSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponseRecordsItems0LicensesItems0Capacity) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseRecordsItems0LicensesItems0Capacity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageResponseRecordsItems0LicensesItems0Compliance license package response records items0 licenses items0 compliance
//
// swagger:model LicensePackageResponseRecordsItems0LicensesItems0Compliance
type LicensePackageResponseRecordsItems0LicensesItems0Compliance struct {

	// Compliance state of the license.
	// Example: compliant
	// Read Only: true
	// Enum: ["compliant","noncompliant","unlicensed","unknown"]
	State *string `json:"state,omitempty"`
}

// Validate validates this license package response records items0 licenses items0 compliance
func (m *LicensePackageResponseRecordsItems0LicensesItems0Compliance) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var licensePackageResponseRecordsItems0LicensesItems0ComplianceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliant","noncompliant","unlicensed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		licensePackageResponseRecordsItems0LicensesItems0ComplianceTypeStatePropEnum = append(licensePackageResponseRecordsItems0LicensesItems0ComplianceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// state
	// State
	// compliant
	// END DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateCompliant captures enum value "compliant"
	LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateCompliant string = "compliant"

	// BEGIN DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// state
	// State
	// noncompliant
	// END DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateNoncompliant captures enum value "noncompliant"
	LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateNoncompliant string = "noncompliant"

	// BEGIN DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// state
	// State
	// unlicensed
	// END DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateUnlicensed captures enum value "unlicensed"
	LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateUnlicensed string = "unlicensed"

	// BEGIN DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// LicensePackageResponseRecordsItems0LicensesItems0Compliance
	// state
	// State
	// unknown
	// END DEBUGGING
	// LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateUnknown captures enum value "unknown"
	LicensePackageResponseRecordsItems0LicensesItems0ComplianceStateUnknown string = "unknown"
)

// prop value enum
func (m *LicensePackageResponseRecordsItems0LicensesItems0Compliance) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, licensePackageResponseRecordsItems0LicensesItems0ComplianceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0Compliance) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("compliance"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this license package response records items0 licenses items0 compliance based on the context it is used
func (m *LicensePackageResponseRecordsItems0LicensesItems0Compliance) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseRecordsItems0LicensesItems0Compliance) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "compliance"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponseRecordsItems0LicensesItems0Compliance) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponseRecordsItems0LicensesItems0Compliance) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseRecordsItems0LicensesItems0Compliance
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks license package response inline records inline array item inline links
//
// swagger:model license_package_response_inline_records_inline_array_item_inline__links
type LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this license package response inline records inline array item inline links
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this license package response inline records inline array item inline links based on the context it is used
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res LicensePackageResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
