// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LocalCifsUser local cifs user
//
// swagger:model local_cifs_user
type LocalCifsUser struct {

	// links
	Links *LocalCifsUserInlineLinks `json:"_links,omitempty"`

	// Indicates whether the user account is enabled or disabled.
	//
	AccountDisabled *bool `json:"account_disabled,omitempty"`

	// Description for the local user.
	//
	// Example: This is local user.
	// Max Length: 256
	Description *string `json:"description,omitempty"`

	// User's full name.
	//
	// Example: user name
	// Max Length: 256
	FullName *string `json:"full_name,omitempty"`

	// Specifies local groups of which this local user is a member.
	//
	// Read Only: true
	LocalCifsUserInlineMembership []*LocalCifsUserInlineMembershipInlineArrayItem `json:"membership,omitempty"`

	// Local user name. The maximum supported length of an user name is 20 characters.
	//
	// Example: SMB_SERVER01\\user
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Password for the local user.
	//
	// Min Length: 6
	Password *string `json:"password,omitempty"`

	// The security ID of the local user which uniquely identifies the user. The user SID is automatically generated in POST and it is retrieved using the GET method.
	//
	// Example: S-1-5-21-256008430-3394229847-3930036330-1001
	// Read Only: true
	Sid *string `json:"sid,omitempty"`

	// svm
	Svm *LocalCifsUserInlineSvm `json:"svm,omitempty"`
}

// Validate validates this local cifs user
func (m *LocalCifsUser) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFullName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalCifsUserInlineMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUser) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUser) validateDescription(formats strfmt.Registry) error {
	if swag.IsZero(m.Description) { // not required
		return nil
	}

	if err := validate.MaxLength("description", "body", *m.Description, 256); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUser) validateFullName(formats strfmt.Registry) error {
	if swag.IsZero(m.FullName) { // not required
		return nil
	}

	if err := validate.MaxLength("full_name", "body", *m.FullName, 256); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUser) validateLocalCifsUserInlineMembership(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalCifsUserInlineMembership) { // not required
		return nil
	}

	for i := 0; i < len(m.LocalCifsUserInlineMembership); i++ {
		if swag.IsZero(m.LocalCifsUserInlineMembership[i]) { // not required
			continue
		}

		if m.LocalCifsUserInlineMembership[i] != nil {
			if err := m.LocalCifsUserInlineMembership[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("membership" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LocalCifsUser) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUser) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.MinLength("password", "body", *m.Password, 6); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUser) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user based on the context it is used
func (m *LocalCifsUser) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalCifsUserInlineMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUser) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUser) contextValidateLocalCifsUserInlineMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "membership", "body", []*LocalCifsUserInlineMembershipInlineArrayItem(m.LocalCifsUserInlineMembership)); err != nil {
		return err
	}

	for i := 0; i < len(m.LocalCifsUserInlineMembership); i++ {

		if m.LocalCifsUserInlineMembership[i] != nil {
			if err := m.LocalCifsUserInlineMembership[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("membership" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LocalCifsUser) contextValidateSid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "sid", "body", m.Sid); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUser) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUser) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUser) UnmarshalBinary(b []byte) error {
	var res LocalCifsUser
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUserInlineLinks local cifs user inline links
//
// swagger:model local_cifs_user_inline__links
type LocalCifsUserInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this local cifs user inline links
func (m *LocalCifsUserInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline links based on the context it is used
func (m *LocalCifsUserInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUserInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUserInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUserInlineMembershipInlineArrayItem local cifs user inline membership inline array item
//
// swagger:model local_cifs_user_inline_membership_inline_array_item
type LocalCifsUserInlineMembershipInlineArrayItem struct {

	// links
	Links *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Local group name. The maximum supported length of a group name is 256 characters.
	//
	// Example: SMB_SERVER01\\group
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The security ID of the local group which uniquely identifies the group. The group SID is automatically generated in POST and it is retrieved using the GET method.
	//
	// Example: S-1-5-21-256008430-3394229847-3930036330-1001
	// Read Only: true
	Sid *string `json:"sid,omitempty"`
}

// Validate validates this local cifs user inline membership inline array item
func (m *LocalCifsUserInlineMembershipInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineMembershipInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUserInlineMembershipInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this local cifs user inline membership inline array item based on the context it is used
func (m *LocalCifsUserInlineMembershipInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineMembershipInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUserInlineMembershipInlineArrayItem) contextValidateSid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "sid", "body", m.Sid); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUserInlineMembershipInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUserInlineMembershipInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineMembershipInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUserInlineMembershipInlineArrayItemInlineLinks local cifs user inline membership inline array item inline links
//
// swagger:model local_cifs_user_inline_membership_inline_array_item_inline__links
type LocalCifsUserInlineMembershipInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this local cifs user inline membership inline array item inline links
func (m *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline membership inline array item inline links based on the context it is used
func (m *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineMembershipInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUserInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model local_cifs_user_inline_svm
type LocalCifsUserInlineSvm struct {

	// links
	Links *LocalCifsUserInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this local cifs user inline svm
func (m *LocalCifsUserInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline svm based on the context it is used
func (m *LocalCifsUserInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUserInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUserInlineSvm) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUserInlineSvmInlineLinks local cifs user inline svm inline links
//
// swagger:model local_cifs_user_inline_svm_inline__links
type LocalCifsUserInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this local cifs user inline svm inline links
func (m *LocalCifsUserInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline svm inline links based on the context it is used
func (m *LocalCifsUserInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUserInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUserInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUserInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
