// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LocalCifsUsersAndGroupsImport local cifs users and groups import
//
// swagger:model local_cifs_users_and_groups_import
type LocalCifsUsersAndGroupsImport struct {

	// links
	Links *LocalCifsUsersAndGroupsImportInlineLinks `json:"_links,omitempty"`

	// Password to decrypt the compressed file.
	// Max Length: 128
	DecryptionPassword *string `json:"decryption_password,omitempty"`

	// detailed status
	DetailedStatus *LocalCifsUsersAndGroupsImportInlineDetailedStatus `json:"detailed_status,omitempty"`

	// Number of elements ignored.
	// Read Only: true
	ElementsIgnored *int64 `json:"elements_ignored,omitempty"`

	// Number of elements successfully imported.
	// Read Only: true
	ElementsImported *int64 `json:"elements_imported,omitempty"`

	// import uri
	ImportURI *LocalCifsUsersAndGroupsImportInlineImportURI `json:"import_uri,omitempty"`

	// Operation status.
	// Read Only: true
	// Enum: ["failed","success","success_with_warnings","in_progress","unknown"]
	State *string `json:"state,omitempty"`

	// status uri
	StatusURI *LocalCifsUsersAndGroupsImportInlineStatusURI `json:"status_uri,omitempty"`

	// svm
	Svm *LocalCifsUsersAndGroupsImportInlineSvm `json:"svm,omitempty"`
}

// Validate validates this local cifs users and groups import
func (m *LocalCifsUsersAndGroupsImport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDecryptionPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDetailedStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateImportURI(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusURI(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImport) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) validateDecryptionPassword(formats strfmt.Registry) error {
	if swag.IsZero(m.DecryptionPassword) { // not required
		return nil
	}

	if err := validate.MaxLength("decryption_password", "body", *m.DecryptionPassword, 128); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) validateDetailedStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.DetailedStatus) { // not required
		return nil
	}

	if m.DetailedStatus != nil {
		if err := m.DetailedStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("detailed_status")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) validateImportURI(formats strfmt.Registry) error {
	if swag.IsZero(m.ImportURI) { // not required
		return nil
	}

	if m.ImportURI != nil {
		if err := m.ImportURI.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("import_uri")
			}
			return err
		}
	}

	return nil
}

var localCifsUsersAndGroupsImportTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["failed","success","success_with_warnings","in_progress","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		localCifsUsersAndGroupsImportTypeStatePropEnum = append(localCifsUsersAndGroupsImportTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// local_cifs_users_and_groups_import
	// LocalCifsUsersAndGroupsImport
	// state
	// State
	// failed
	// END DEBUGGING
	// LocalCifsUsersAndGroupsImportStateFailed captures enum value "failed"
	LocalCifsUsersAndGroupsImportStateFailed string = "failed"

	// BEGIN DEBUGGING
	// local_cifs_users_and_groups_import
	// LocalCifsUsersAndGroupsImport
	// state
	// State
	// success
	// END DEBUGGING
	// LocalCifsUsersAndGroupsImportStateSuccess captures enum value "success"
	LocalCifsUsersAndGroupsImportStateSuccess string = "success"

	// BEGIN DEBUGGING
	// local_cifs_users_and_groups_import
	// LocalCifsUsersAndGroupsImport
	// state
	// State
	// success_with_warnings
	// END DEBUGGING
	// LocalCifsUsersAndGroupsImportStateSuccessWithWarnings captures enum value "success_with_warnings"
	LocalCifsUsersAndGroupsImportStateSuccessWithWarnings string = "success_with_warnings"

	// BEGIN DEBUGGING
	// local_cifs_users_and_groups_import
	// LocalCifsUsersAndGroupsImport
	// state
	// State
	// in_progress
	// END DEBUGGING
	// LocalCifsUsersAndGroupsImportStateInProgress captures enum value "in_progress"
	LocalCifsUsersAndGroupsImportStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// local_cifs_users_and_groups_import
	// LocalCifsUsersAndGroupsImport
	// state
	// State
	// unknown
	// END DEBUGGING
	// LocalCifsUsersAndGroupsImportStateUnknown captures enum value "unknown"
	LocalCifsUsersAndGroupsImportStateUnknown string = "unknown"
)

// prop value enum
func (m *LocalCifsUsersAndGroupsImport) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, localCifsUsersAndGroupsImportTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImport) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) validateStatusURI(formats strfmt.Registry) error {
	if swag.IsZero(m.StatusURI) { // not required
		return nil
	}

	if m.StatusURI != nil {
		if err := m.StatusURI.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_uri")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs users and groups import based on the context it is used
func (m *LocalCifsUsersAndGroupsImport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDetailedStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateElementsIgnored(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateElementsImported(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImportURI(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatusURI(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateDetailedStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.DetailedStatus != nil {
		if err := m.DetailedStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("detailed_status")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateElementsIgnored(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "elements_ignored", "body", m.ElementsIgnored); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateElementsImported(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "elements_imported", "body", m.ElementsImported); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateImportURI(ctx context.Context, formats strfmt.Registry) error {

	if m.ImportURI != nil {
		if err := m.ImportURI.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("import_uri")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateStatusURI(ctx context.Context, formats strfmt.Registry) error {

	if m.StatusURI != nil {
		if err := m.StatusURI.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_uri")
			}
			return err
		}
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImport) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImport) UnmarshalBinary(b []byte) error {
	var res LocalCifsUsersAndGroupsImport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUsersAndGroupsImportInlineDetailedStatus local cifs users and groups import inline detailed status
//
// swagger:model local_cifs_users_and_groups_import_inline_detailed_status
type LocalCifsUsersAndGroupsImportInlineDetailedStatus struct {

	// Code corresponding to the import status failure.
	//
	// Example: 6684732
	Code *string `json:"code,omitempty"`

	// Detailed description of the import status.
	//
	Message *string `json:"message,omitempty"`
}

// Validate validates this local cifs users and groups import inline detailed status
func (m *LocalCifsUsersAndGroupsImportInlineDetailedStatus) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this local cifs users and groups import inline detailed status based on context it is used
func (m *LocalCifsUsersAndGroupsImportInlineDetailedStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineDetailedStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineDetailedStatus) UnmarshalBinary(b []byte) error {
	var res LocalCifsUsersAndGroupsImportInlineDetailedStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUsersAndGroupsImportInlineImportURI local cifs users and groups import inline import uri
//
// swagger:model local_cifs_users_and_groups_import_inline_import_uri
type LocalCifsUsersAndGroupsImportInlineImportURI struct {

	// Password of the specified URI.
	// Max Length: 128
	Password *string `json:"password,omitempty"`

	// URI from which to load the input file containing the CIFS local users and groups. The file must be encrypted using the 7zip utility. URI can be FTP or HTTP.
	// Example: http://web.sample.com/web1/file1.7z
	Path *string `json:"path,omitempty"`

	// Username of the specified URI.
	// Example: user1
	// Max Length: 128
	Username *string `json:"username,omitempty"`
}

// Validate validates this local cifs users and groups import inline import uri
func (m *LocalCifsUsersAndGroupsImportInlineImportURI) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineImportURI) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.MaxLength("import_uri"+"."+"password", "body", *m.Password, 128); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineImportURI) validateUsername(formats strfmt.Registry) error {
	if swag.IsZero(m.Username) { // not required
		return nil
	}

	if err := validate.MaxLength("import_uri"+"."+"username", "body", *m.Username, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this local cifs users and groups import inline import uri based on context it is used
func (m *LocalCifsUsersAndGroupsImportInlineImportURI) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineImportURI) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineImportURI) UnmarshalBinary(b []byte) error {
	var res LocalCifsUsersAndGroupsImportInlineImportURI
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUsersAndGroupsImportInlineLinks local cifs users and groups import inline links
//
// swagger:model local_cifs_users_and_groups_import_inline__links
type LocalCifsUsersAndGroupsImportInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this local cifs users and groups import inline links
func (m *LocalCifsUsersAndGroupsImportInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs users and groups import inline links based on the context it is used
func (m *LocalCifsUsersAndGroupsImportInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUsersAndGroupsImportInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUsersAndGroupsImportInlineStatusURI local cifs users and groups import inline status uri
//
// swagger:model local_cifs_users_and_groups_import_inline_status_uri
type LocalCifsUsersAndGroupsImportInlineStatusURI struct {

	// Password of the specified URI.
	// Max Length: 128
	Password *string `json:"password,omitempty"`

	// URI from which to load the input file containing the CIFS local users and groups. The file must be encrypted using the 7zip utility. URI can be FTP or HTTP.
	// Example: http://web.sample.com/web1/file1.7z
	Path *string `json:"path,omitempty"`

	// Username of the specified URI.
	// Example: user1
	// Max Length: 128
	Username *string `json:"username,omitempty"`
}

// Validate validates this local cifs users and groups import inline status uri
func (m *LocalCifsUsersAndGroupsImportInlineStatusURI) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineStatusURI) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.MaxLength("status_uri"+"."+"password", "body", *m.Password, 128); err != nil {
		return err
	}

	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineStatusURI) validateUsername(formats strfmt.Registry) error {
	if swag.IsZero(m.Username) { // not required
		return nil
	}

	if err := validate.MaxLength("status_uri"+"."+"username", "body", *m.Username, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this local cifs users and groups import inline status uri based on context it is used
func (m *LocalCifsUsersAndGroupsImportInlineStatusURI) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineStatusURI) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineStatusURI) UnmarshalBinary(b []byte) error {
	var res LocalCifsUsersAndGroupsImportInlineStatusURI
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUsersAndGroupsImportInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model local_cifs_users_and_groups_import_inline_svm
type LocalCifsUsersAndGroupsImportInlineSvm struct {

	// links
	Links *LocalCifsUsersAndGroupsImportInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this local cifs users and groups import inline svm
func (m *LocalCifsUsersAndGroupsImportInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs users and groups import inline svm based on the context it is used
func (m *LocalCifsUsersAndGroupsImportInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineSvm) UnmarshalBinary(b []byte) error {
	var res LocalCifsUsersAndGroupsImportInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LocalCifsUsersAndGroupsImportInlineSvmInlineLinks local cifs users and groups import inline svm inline links
//
// swagger:model local_cifs_users_and_groups_import_inline_svm_inline__links
type LocalCifsUsersAndGroupsImportInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this local cifs users and groups import inline svm inline links
func (m *LocalCifsUsersAndGroupsImportInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs users and groups import inline svm inline links based on the context it is used
func (m *LocalCifsUsersAndGroupsImportInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LocalCifsUsersAndGroupsImportInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LocalCifsUsersAndGroupsImportInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUsersAndGroupsImportInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
