// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LoginMessages The login banner and message of the day (MOTD) configuration.
//
// swagger:model login_messages
type LoginMessages struct {

	// links
	Links *LoginMessagesInlineLinks `json:"_links,omitempty"`

	// The login banner text. This message is displayed during SSH and console device
	// login just before the password prompt displays. When configured, a cluster-level
	// login banner is used for every incoming connection. Each data SVM can override
	// the cluster-level banner to instead display when you log into the SVM. To restore
	// the default setting for a data SVM, set the banner to an empty string.
	// New lines are supplied as either LF or CRLF but are always returned as LF.
	// Optional in the PATCH body.
	//
	// Max Length: 2048
	// Min Length: 0
	Banner *string `json:"banner,omitempty"`

	// The message of the day (MOTD). This message appears just before the clustershell
	// prompt after a successful login. When configured, the cluster message
	// displays first. If you log in as a data SVM administrator, the
	// SVM message is then printed. The cluster-level MOTD can be disabled
	// for a given data SVM using the "show_cluster_message" property.
	// New lines are supplied as either LF or CRLF but are always returned as LF.
	// Optional in the PATCH body.
	//
	// Max Length: 2048
	// Min Length: 0
	Message *string `json:"message,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// Specifies whether to show a cluster-level message before the SVM message
	// when logging in as an SVM administrator.
	// This setting can only be modified by cluster administrators.
	// Optional in the PATCH body.
	//
	ShowClusterMessage *bool `json:"show_cluster_message,omitempty"`

	// svm
	Svm *LoginMessagesInlineSvm `json:"svm,omitempty"`

	// The unique identifier (ID) of the login messages configuration.
	//
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this login messages
func (m *LoginMessages) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBanner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessages) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LoginMessages) validateBanner(formats strfmt.Registry) error {
	if swag.IsZero(m.Banner) { // not required
		return nil
	}

	if err := validate.MinLength("banner", "body", *m.Banner, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("banner", "body", *m.Banner, 2048); err != nil {
		return err
	}

	return nil
}

func (m *LoginMessages) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if err := validate.MinLength("message", "body", *m.Message, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("message", "body", *m.Message, 2048); err != nil {
		return err
	}

	return nil
}

var loginMessagesTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		loginMessagesTypeScopePropEnum = append(loginMessagesTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// login_messages
	// LoginMessages
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// LoginMessagesScopeSvm captures enum value "svm"
	LoginMessagesScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// login_messages
	// LoginMessages
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// LoginMessagesScopeCluster captures enum value "cluster"
	LoginMessagesScopeCluster string = "cluster"
)

// prop value enum
func (m *LoginMessages) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, loginMessagesTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LoginMessages) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *LoginMessages) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages based on the context it is used
func (m *LoginMessages) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessages) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LoginMessages) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *LoginMessages) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *LoginMessages) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LoginMessages) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LoginMessages) UnmarshalBinary(b []byte) error {
	var res LoginMessages
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LoginMessagesInlineLinks login messages inline links
//
// swagger:model login_messages_inline__links
type LoginMessagesInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this login messages inline links
func (m *LoginMessagesInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessagesInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages inline links based on the context it is used
func (m *LoginMessagesInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessagesInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LoginMessagesInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LoginMessagesInlineLinks) UnmarshalBinary(b []byte) error {
	var res LoginMessagesInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LoginMessagesInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model login_messages_inline_svm
type LoginMessagesInlineSvm struct {

	// links
	Links *LoginMessagesInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this login messages inline svm
func (m *LoginMessagesInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessagesInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages inline svm based on the context it is used
func (m *LoginMessagesInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessagesInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LoginMessagesInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LoginMessagesInlineSvm) UnmarshalBinary(b []byte) error {
	var res LoginMessagesInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LoginMessagesInlineSvmInlineLinks login messages inline svm inline links
//
// swagger:model login_messages_inline_svm_inline__links
type LoginMessagesInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this login messages inline svm inline links
func (m *LoginMessagesInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessagesInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages inline svm inline links based on the context it is used
func (m *LoginMessagesInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginMessagesInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LoginMessagesInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LoginMessagesInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LoginMessagesInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
