// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Lun A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model lun
type Lun struct {

	// links
	Links *LunInlineLinks `json:"_links,omitempty"`

	// <personalities supports=unified>This property marks the LUN for auto deletion when the volume containing the LUN runs out of space. This is most commonly set on LUN clones.<br/>
	// When set to _true_, the LUN becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the LUN is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new LUN is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// The class of LUN.<br/>
	// Optional in POST.<br/>
	// <personalities supports=asar2>
	// When set to _protocol_endpoint_, most other properties are not supported in POST and the operation can be asynchronous. The LUN is provisioned with a generated name. Protocol endpoints are provisioned in a round robin pattern across all nodes in the cluster.<br/>
	// The following properties are supported in POST:
	// * `class`
	// * `svm`
	// * `provisioning_options.count`
	// * `lun_maps`
	// * `comment`
	// </personalities>
	// <personalities supports=asar2>
	// POST is asynchronous in these cases:
	// * There are nodes in the cluster not already hosting a protocol endpoint.
	// * The request includes either the `lun_maps` or `provisioning_options.count` properties.
	// * The `records` array is used for bulk provisioning.<br/>
	// </personalities>
	// <personalities supports=asar2>
	// DELETE is asynchronous when calling DELETE on the last protocol endpoint on a node.<br/>
	// Calling implementations should not attempt to track these conditions. Instead, check the HTTP status code. A 200 or 201 status code indicates the operation is already complete. A 202 status code indicates there is an asynchronous job that can be tracked. If asynchronous requests are always preferred, wrap individual POST and DELETE requests in a `records` array to force the operation to be asynchronous.<br/>
	// For more details, see [`Asynchronous operations`](#Synchronous_and_asynchronous_operations)
	// </personalities>
	//
	// Enum: ["regular","protocol_endpoint","vvol"]
	Class *string `json:"class,omitempty"`

	// clone
	Clone *LunInlineClone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *LunInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// convert
	Convert *LunInlineConvert `json:"convert,omitempty"`

	// copy
	Copy *LunInlineCopy `json:"copy,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, check the `status.state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// encryption
	Encryption *StorageUnitEncryption `json:"encryption,omitempty"`

	// location
	Location *LunInlineLocation `json:"location,omitempty"`

	// An array of name/value pairs optionally stored with the LUN. Attributes are available to callers to persist small amounts of application-specific metadata. They are in no way interpreted by ONTAP.<br/>
	// Attribute names and values must be at least one byte and no more than 4091 bytes in length. The sum of the name and value lengths must be no more than 4092 bytes.<br/>
	// Valid in POST except when creating a LUN clone. A cloned can already have attributes from its source. You can add, modify, and delete the attributes of a LUN clone in separate requests after creation of the LUN.<br/>
	// Attributes can be added/modified/removed for an existing LUN using the /api/storage/luns/{lun.uuid}/attributes endpoint. For further information, see [`DOC /storage/luns/{lun.uuid}/attributes`](#docs-SAN-storage_luns_{lun.uuid}_attributes).<br/>
	// There is an added computational cost to retrieving property values for `attributes`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	LunInlineAttributes []*LunInlineAttributesInlineArrayItem `json:"attributes,omitempty"`

	// The LUN maps with which the LUN is associated.<br/>
	// There is an added computational cost to retrieving property values for `lun_maps`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	// <personalities supports=unified>These properties are supported for GET and POST. During POST, it requires the `provisioning_options.auto` property to be set to true.
	// See the `provisioning_options.auto` property for full details.</personalities>
	// <personalities supports=asar2>These properties are supported for GET and POST. During POST, a new or existing initiator group can be referenced. When referencing an existing initiator group, only the `name` and `uuid` properties are supported.</personalities>
	//
	LunInlineLunMaps []*LunInlineLunMapsInlineArrayItem `json:"lun_maps,omitempty"`

	// metric
	Metric *LunInlineMetric `json:"metric,omitempty"`

	// movement
	Movement *LunInlineMovement `json:"movement,omitempty"`

	// The name of the LUN. Valid in POST and PATCH.<br/>
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
	// A PATCH that modifies the qtree and/or base name portion of the LUN path is considered a rename operation.<br/>
	// A PATCH that modifies the volume portion of the LUN path begins an asynchronous LUN movement operation.</personalities>
	// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// A PATCH that modifies the name of the LUN is considered a rename operation.</personalities>
	//
	// Example: /vol/volume1/qtree1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *LunInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos policy
	QosPolicy *LunInlineQosPolicy `json:"qos_policy,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// The LUN serial number encoded in hexadecimal format. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	SerialNumberHex *string `json:"serial_number_hex,omitempty"`

	// space
	Space *LunInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *LunInlineStatistics `json:"statistics,omitempty"`

	// status
	Status *LunInlineStatus `json:"status,omitempty"`

	// svm
	Svm *LunInlineSvm `json:"svm,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// vvol
	Vvol *LunInlineVvol `json:"vvol,omitempty"`
}

// Validate validates this lun
func (m *Lun) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConvert(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCopy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunInlineAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunInlineLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVvol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Lun) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var lunTypeClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","protocol_endpoint","vvol"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunTypeClassPropEnum = append(lunTypeClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun
	// Lun
	// class
	// Class
	// regular
	// END DEBUGGING
	// LunClassRegular captures enum value "regular"
	LunClassRegular string = "regular"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// class
	// Class
	// protocol_endpoint
	// END DEBUGGING
	// LunClassProtocolEndpoint captures enum value "protocol_endpoint"
	LunClassProtocolEndpoint string = "protocol_endpoint"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// class
	// Class
	// vvol
	// END DEBUGGING
	// LunClassVvol captures enum value "vvol"
	LunClassVvol string = "vvol"
)

// prop value enum
func (m *Lun) validateClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunTypeClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Lun) validateClass(formats strfmt.Registry) error {
	if swag.IsZero(m.Class) { // not required
		return nil
	}

	// value enum
	if err := m.validateClassEnum("class", "body", *m.Class); err != nil {
		return err
	}

	return nil
}

func (m *Lun) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *Lun) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroup) { // not required
		return nil
	}

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateConvert(formats strfmt.Registry) error {
	if swag.IsZero(m.Convert) { // not required
		return nil
	}

	if m.Convert != nil {
		if err := m.Convert.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateCopy(formats strfmt.Registry) error {
	if swag.IsZero(m.Copy) { // not required
		return nil
	}

	if m.Copy != nil {
		if err := m.Copy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Lun) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	if m.Encryption != nil {
		if err := m.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateLunInlineAttributes(formats strfmt.Registry) error {
	if swag.IsZero(m.LunInlineAttributes) { // not required
		return nil
	}

	for i := 0; i < len(m.LunInlineAttributes); i++ {
		if swag.IsZero(m.LunInlineAttributes[i]) { // not required
			continue
		}

		if m.LunInlineAttributes[i] != nil {
			if err := m.LunInlineAttributes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Lun) validateLunInlineLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.LunInlineLunMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.LunInlineLunMaps); i++ {
		if swag.IsZero(m.LunInlineLunMaps[i]) { // not required
			continue
		}

		if m.LunInlineLunMaps[i] != nil {
			if err := m.LunInlineLunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Lun) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(m.Movement) { // not required
		return nil
	}

	if m.Movement != nil {
		if err := m.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

var lunTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunTypeOsTypePropEnum = append(lunTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// LunOsTypeAix captures enum value "aix"
	LunOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// LunOsTypeHpux captures enum value "hpux"
	LunOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// LunOsTypeHyperv captures enum value "hyper_v"
	LunOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// LunOsTypeLinux captures enum value "linux"
	LunOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// LunOsTypeNetware captures enum value "netware"
	LunOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// LunOsTypeOpenvms captures enum value "openvms"
	LunOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// LunOsTypeSolaris captures enum value "solaris"
	LunOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// LunOsTypeSolarisEfi captures enum value "solaris_efi"
	LunOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// LunOsTypeVmware captures enum value "vmware"
	LunOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// LunOsTypeWindows captures enum value "windows"
	LunOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// LunOsTypeWindows2008 captures enum value "windows_2008"
	LunOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// LunOsTypeWindowsGpt captures enum value "windows_gpt"
	LunOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// lun
	// Lun
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// LunOsTypeXen captures enum value "xen"
	LunOsTypeXen string = "xen"
)

// prop value enum
func (m *Lun) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Lun) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *Lun) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (m *Lun) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) validateVvol(formats strfmt.Registry) error {
	if swag.IsZero(m.Vvol) { // not required
		return nil
	}

	if m.Vvol != nil {
		if err := m.Vvol.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vvol")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun based on the context it is used
func (m *Lun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConvert(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCopy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunInlineAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunInlineLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumberHex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVvol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Lun) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateConvert(ctx context.Context, formats strfmt.Registry) error {

	if m.Convert != nil {
		if err := m.Convert.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateCopy(ctx context.Context, formats strfmt.Registry) error {

	if m.Copy != nil {
		if err := m.Copy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *Lun) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.Encryption != nil {
		if err := m.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateLunInlineAttributes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LunInlineAttributes); i++ {

		if m.LunInlineAttributes[i] != nil {
			if err := m.LunInlineAttributes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Lun) contextValidateLunInlineLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LunInlineLunMaps); i++ {

		if m.LunInlineLunMaps[i] != nil {
			if err := m.LunInlineLunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Lun) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if m.Movement != nil {
		if err := m.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *Lun) contextValidateSerialNumberHex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number_hex", "body", m.SerialNumberHex); err != nil {
		return err
	}

	return nil
}

func (m *Lun) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Lun) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Lun) contextValidateVvol(ctx context.Context, formats strfmt.Registry) error {

	if m.Vvol != nil {
		if err := m.Vvol.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vvol")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Lun) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Lun) UnmarshalBinary(b []byte) error {
	var res Lun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineAttributesInlineArrayItem A name/value pair optionally stored with the LUN. Attributes are available to callers to persist small amounts of application-specific metadata. They are in no way interpreted by ONTAP.<br/>
// Attribute names and values must be at least one byte and no more than 4091 bytes in length. The sum of the name and value lengths must be no more than 4092 bytes.<br/>
// Optional in POST.
//
// swagger:model lun_inline_attributes_inline_array_item
type LunInlineAttributesInlineArrayItem struct {

	// links
	Links *LunInlineAttributesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The attribute name.
	//
	// Example: name1
	// Max Length: 4091
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The attribute value.
	//
	// Example: value1
	// Max Length: 4091
	// Min Length: 1
	Value *string `json:"value,omitempty"`
}

// Validate validates this lun inline attributes inline array item
func (m *LunInlineAttributesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineAttributesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineAttributesInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 4091); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineAttributesInlineArrayItem) validateValue(formats strfmt.Registry) error {
	if swag.IsZero(m.Value) { // not required
		return nil
	}

	if err := validate.MinLength("value", "body", *m.Value, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("value", "body", *m.Value, 4091); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline attributes inline array item based on the context it is used
func (m *LunInlineAttributesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineAttributesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineAttributesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineAttributesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LunInlineAttributesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineAttributesInlineArrayItemInlineLinks lun inline attributes inline array item inline links
//
// swagger:model lun_inline_attributes_inline_array_item_inline__links
type LunInlineAttributesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline attributes inline array item inline links
func (m *LunInlineAttributesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineAttributesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline attributes inline array item inline links based on the context it is used
func (m *LunInlineAttributesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineAttributesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineAttributesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineAttributesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineAttributesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineClone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
// swagger:model lun_inline_clone
type LunInlineClone struct {

	// source
	Source *LunInlineCloneInlineSource `json:"source,omitempty"`
}

// Validate validates this lun inline clone
func (m *LunInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineClone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline clone based on the context it is used
func (m *LunInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineClone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineClone) UnmarshalBinary(b []byte) error {
	var res LunInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineCloneInlineSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
// swagger:model lun_inline_clone_inline_source
type LunInlineCloneInlineSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline clone inline source
func (m *LunInlineCloneInlineSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this lun inline clone inline source based on context it is used
func (m *LunInlineCloneInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineCloneInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineCloneInlineSource) UnmarshalBinary(b []byte) error {
	var res LunInlineCloneInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineConsistencyGroup The LUN's consistency group. This property is populated for LUNs that are members of a consistency group. If the LUN is a member of a child consistency group, the parent consistency group is reported.
// <personalities supports=unified>A LUN's consistency group is the consistency group of its containing volume.</personalities>
// <personalities supports=asar2>A LUN is optionally associated directly with a consistency group.</personalities>
//
// swagger:model lun_inline_consistency_group
type LunInlineConsistencyGroup struct {

	// links
	Links *LunInlineConsistencyGroupInlineLinks `json:"_links,omitempty"`

	// The name of the consistency group.
	//
	// Example: cg1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	//
	// Example: 4abc2317-4332-9d37-93a0-20bd29c22df0
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline consistency group
func (m *LunInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline consistency group based on the context it is used
func (m *LunInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineConsistencyGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "consistency_group"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "consistency_group"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res LunInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineConsistencyGroupInlineLinks lun inline consistency group inline links
//
// swagger:model lun_inline_consistency_group_inline__links
type LunInlineConsistencyGroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline consistency group inline links
func (m *LunInlineConsistencyGroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineConsistencyGroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline consistency group inline links based on the context it is used
func (m *LunInlineConsistencyGroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineConsistencyGroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineConsistencyGroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineConsistencyGroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineConsistencyGroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineConvert This sub-object is used in POST to convert a valid in-place NVMe namespace to a LUN. Setting a property in this sub-object indicates that a conversion from the specified NVMe namespace to LUN is desired.<br/>
//
// swagger:model lun_inline_convert
type LunInlineConvert struct {

	// namespace
	Namespace *LunInlineConvertInlineNamespace `json:"namespace,omitempty"`
}

// Validate validates this lun inline convert
func (m *LunInlineConvert) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineConvert) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespace) { // not required
		return nil
	}

	if m.Namespace != nil {
		if err := m.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert" + "." + "namespace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline convert based on the context it is used
func (m *LunInlineConvert) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineConvert) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespace != nil {
		if err := m.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert" + "." + "namespace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineConvert) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineConvert) UnmarshalBinary(b []byte) error {
	var res LunInlineConvert
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineConvertInlineNamespace The source namespace for convert operation. This can be specified using property `convert.namespace.uuid` or `convert.namespace.name`. If both properties are supplied, they must refer to the same NVMe namespace.<br/>
// Valid in POST. A convert request from NVMe namespace to LUN cannot be combined with setting any other LUN properties. All other properties of the converted LUN come from the source NVMe namespace.<br/>
//
// swagger:model lun_inline_convert_inline_namespace
type LunInlineConvertInlineNamespace struct {

	// The name of the source NVMe namespace. Valid in POST.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<NVMe namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the source NVMe namespace. Valid in POST.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline convert inline namespace
func (m *LunInlineConvertInlineNamespace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this lun inline convert inline namespace based on context it is used
func (m *LunInlineConvertInlineNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineConvertInlineNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineConvertInlineNamespace) UnmarshalBinary(b []byte) error {
	var res LunInlineConvertInlineNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineCopy <personalities supports=unified>This sub-object applies to LUN copy operations. A LUN can be copied with a POST request that supplies `copy.source` properties.<br/>
// Copying a LUN is an asynchronous activity begun by a POST request that specifies the source of the copy in the `copy.source` properties. The data for the LUN is then asynchronously copied from the source to the destination. The time required to complete the copy depends on the size of the LUN and the load on the cluster. The `copy` sub-object is populated while a LUN copy is in progress and for two (2) minutes following completion of a copy.<br/>
// While LUNs are being copied, the status of the LUN copy operations can be obtained using a GET of the source or destination LUN that requests the `copy` properties. If the LUN is the source LUN for one or more copy operations, the `copy.destinations` array is populated in GET. If the containing LUN is the destination LUN for a copy operation, the `copy.source` sub-object is populated in GET. The LUN copy operation can be further modified using a PATCH on the properties on the `copy.source` sub-object of the copy destination LUN.<br/>
// There is an added computational cost to retrieving property values for `copy`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
// <personalities supports=asar2>LUN copies are not supported. No properties in this sub-object can be set in POST or PATCH and none will be returned by GET.</personalities>
//
// swagger:model lun_inline_copy
type LunInlineCopy struct {

	// An array of destination LUNs of LUN copy operations in which the containing LUN is the source of the copy.
	//
	// Read Only: true
	Destinations []*LunCopyDestinationsItems0 `json:"destinations,omitempty"`

	// source
	Source *LunInlineCopyInlineSource `json:"source,omitempty"`
}

// Validate validates this lun inline copy
func (m *LunInlineCopy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDestinations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopy) validateDestinations(formats strfmt.Registry) error {
	if swag.IsZero(m.Destinations) { // not required
		return nil
	}

	for i := 0; i < len(m.Destinations); i++ {
		if swag.IsZero(m.Destinations[i]) { // not required
			continue
		}

		if m.Destinations[i] != nil {
			if err := m.Destinations[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("copy" + "." + "destinations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunInlineCopy) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline copy based on the context it is used
func (m *LunInlineCopy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestinations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopy) contextValidateDestinations(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "copy"+"."+"destinations", "body", []*LunCopyDestinationsItems0(m.Destinations)); err != nil {
		return err
	}

	for i := 0; i < len(m.Destinations); i++ {

		if m.Destinations[i] != nil {
			if err := m.Destinations[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("copy" + "." + "destinations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunInlineCopy) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineCopy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineCopy) UnmarshalBinary(b []byte) error {
	var res LunInlineCopy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunCopyDestinationsItems0 A LUN copy operation in which the containing LUN is the source of the copy.
//
// swagger:model LunCopyDestinationsItems0
type LunCopyDestinationsItems0 struct {

	// links
	Links *LunCopyDestinationsItems0Links `json:"_links,omitempty"`

	// The maximum data throughput, in bytes per second, that should be utilized in support of the LUN copy. See property `copy.source.max_throughput` for further details.
	//
	// Read Only: true
	MaxThroughput *int64 `json:"max_throughput,omitempty"`

	// The fully qualified path of the LUN copy destination composed of a "/vol" prefix, the volume name, the optional qtree name, and base name of the LUN.
	//
	// Example: /vol/vol1/lun1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// peer
	Peer *LunCopyDestinationsItems0Peer `json:"peer,omitempty"`

	// progress
	Progress *LunCopyDestinationsItems0Progress `json:"progress,omitempty"`

	// The unique identifier of the LUN copy destination.
	//
	// Example: 1bc327d5-4654-5284-a116-f182282240b4
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun copy destinations items0
func (m *LunCopyDestinationsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProgress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunCopyDestinationsItems0) validatePeer(formats strfmt.Registry) error {
	if swag.IsZero(m.Peer) { // not required
		return nil
	}

	if m.Peer != nil {
		if err := m.Peer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer")
			}
			return err
		}
	}

	return nil
}

func (m *LunCopyDestinationsItems0) validateProgress(formats strfmt.Registry) error {
	if swag.IsZero(m.Progress) { // not required
		return nil
	}

	if m.Progress != nil {
		if err := m.Progress.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("progress")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun copy destinations items0 based on the context it is used
func (m *LunCopyDestinationsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunCopyDestinationsItems0) contextValidateMaxThroughput(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "max_throughput", "body", m.MaxThroughput); err != nil {
		return err
	}

	return nil
}

func (m *LunCopyDestinationsItems0) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *LunCopyDestinationsItems0) contextValidatePeer(ctx context.Context, formats strfmt.Registry) error {

	if m.Peer != nil {
		if err := m.Peer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer")
			}
			return err
		}
	}

	return nil
}

func (m *LunCopyDestinationsItems0) contextValidateProgress(ctx context.Context, formats strfmt.Registry) error {

	if m.Progress != nil {
		if err := m.Progress.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("progress")
			}
			return err
		}
	}

	return nil
}

func (m *LunCopyDestinationsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunCopyDestinationsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunCopyDestinationsItems0) UnmarshalBinary(b []byte) error {
	var res LunCopyDestinationsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunCopyDestinationsItems0Links lun copy destinations items0 links
//
// swagger:model LunCopyDestinationsItems0Links
type LunCopyDestinationsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun copy destinations items0 links
func (m *LunCopyDestinationsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun copy destinations items0 links based on the context it is used
func (m *LunCopyDestinationsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunCopyDestinationsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunCopyDestinationsItems0Links) UnmarshalBinary(b []byte) error {
	var res LunCopyDestinationsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunCopyDestinationsItems0Peer The SVM peer relationship object for an inter-SVM LUN copy operation. The peer SVM in the relationship is the source SVM and the local SVM is the destination SVM.<br/>
// This is only populated by GET when the LUN copy is inter-SVM.
//
// swagger:model LunCopyDestinationsItems0Peer
type LunCopyDestinationsItems0Peer struct {

	// links
	Links *LunCopyDestinationsItems0PeerLinks `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun copy destinations items0 peer
func (m *LunCopyDestinationsItems0Peer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0Peer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun copy destinations items0 peer based on the context it is used
func (m *LunCopyDestinationsItems0Peer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0Peer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunCopyDestinationsItems0Peer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunCopyDestinationsItems0Peer) UnmarshalBinary(b []byte) error {
	var res LunCopyDestinationsItems0Peer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunCopyDestinationsItems0PeerLinks lun copy destinations items0 peer links
//
// swagger:model LunCopyDestinationsItems0PeerLinks
type LunCopyDestinationsItems0PeerLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun copy destinations items0 peer links
func (m *LunCopyDestinationsItems0PeerLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0PeerLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun copy destinations items0 peer links based on the context it is used
func (m *LunCopyDestinationsItems0PeerLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0PeerLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunCopyDestinationsItems0PeerLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunCopyDestinationsItems0PeerLinks) UnmarshalBinary(b []byte) error {
	var res LunCopyDestinationsItems0PeerLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunCopyDestinationsItems0Progress Properties related to the progress of an active or recently completed LUN copy.
//
// swagger:model LunCopyDestinationsItems0Progress
type LunCopyDestinationsItems0Progress struct {

	// The amount of time that has elapsed since the start of the LUN copy, in seconds.
	//
	// Read Only: true
	Elapsed *int64 `json:"elapsed,omitempty"`

	// Error information provided if the asynchronous LUN copy operation fails.
	//
	// Read Only: true
	Failure *Error `json:"failure,omitempty"`

	// The percentage completed of the LUN copy.
	//
	// Read Only: true
	// Maximum: 100
	// Minimum: 0
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// The state of the LUN copy.
	//
	// Read Only: true
	// Enum: ["preparing","replicating","paused","paused_error","complete","reverting","failed"]
	State *string `json:"state,omitempty"`

	// This property reports if volume snapshots are blocked by the LUN copy. This property can be polled to identify when volume snapshots can be resumed after beginning a LUN copy.
	//
	// Read Only: true
	VolumeSnapshotBlocked *bool `json:"volume_snapshot_blocked,omitempty"`
}

// Validate validates this lun copy destinations items0 progress
func (m *LunCopyDestinationsItems0Progress) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePercentComplete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0Progress) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("progress" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *LunCopyDestinationsItems0Progress) validatePercentComplete(formats strfmt.Registry) error {
	if swag.IsZero(m.PercentComplete) { // not required
		return nil
	}

	if err := validate.MinimumInt("progress"+"."+"percent_complete", "body", *m.PercentComplete, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("progress"+"."+"percent_complete", "body", *m.PercentComplete, 100, false); err != nil {
		return err
	}

	return nil
}

var lunCopyDestinationsItems0ProgressTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["preparing","replicating","paused","paused_error","complete","reverting","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunCopyDestinationsItems0ProgressTypeStatePropEnum = append(lunCopyDestinationsItems0ProgressTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LunCopyDestinationsItems0Progress
	// LunCopyDestinationsItems0Progress
	// state
	// State
	// preparing
	// END DEBUGGING
	// LunCopyDestinationsItems0ProgressStatePreparing captures enum value "preparing"
	LunCopyDestinationsItems0ProgressStatePreparing string = "preparing"

	// BEGIN DEBUGGING
	// LunCopyDestinationsItems0Progress
	// LunCopyDestinationsItems0Progress
	// state
	// State
	// replicating
	// END DEBUGGING
	// LunCopyDestinationsItems0ProgressStateReplicating captures enum value "replicating"
	LunCopyDestinationsItems0ProgressStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// LunCopyDestinationsItems0Progress
	// LunCopyDestinationsItems0Progress
	// state
	// State
	// paused
	// END DEBUGGING
	// LunCopyDestinationsItems0ProgressStatePaused captures enum value "paused"
	LunCopyDestinationsItems0ProgressStatePaused string = "paused"

	// BEGIN DEBUGGING
	// LunCopyDestinationsItems0Progress
	// LunCopyDestinationsItems0Progress
	// state
	// State
	// paused_error
	// END DEBUGGING
	// LunCopyDestinationsItems0ProgressStatePausedError captures enum value "paused_error"
	LunCopyDestinationsItems0ProgressStatePausedError string = "paused_error"

	// BEGIN DEBUGGING
	// LunCopyDestinationsItems0Progress
	// LunCopyDestinationsItems0Progress
	// state
	// State
	// complete
	// END DEBUGGING
	// LunCopyDestinationsItems0ProgressStateComplete captures enum value "complete"
	LunCopyDestinationsItems0ProgressStateComplete string = "complete"

	// BEGIN DEBUGGING
	// LunCopyDestinationsItems0Progress
	// LunCopyDestinationsItems0Progress
	// state
	// State
	// reverting
	// END DEBUGGING
	// LunCopyDestinationsItems0ProgressStateReverting captures enum value "reverting"
	LunCopyDestinationsItems0ProgressStateReverting string = "reverting"

	// BEGIN DEBUGGING
	// LunCopyDestinationsItems0Progress
	// LunCopyDestinationsItems0Progress
	// state
	// State
	// failed
	// END DEBUGGING
	// LunCopyDestinationsItems0ProgressStateFailed captures enum value "failed"
	LunCopyDestinationsItems0ProgressStateFailed string = "failed"
)

// prop value enum
func (m *LunCopyDestinationsItems0Progress) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunCopyDestinationsItems0ProgressTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunCopyDestinationsItems0Progress) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("progress"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun copy destinations items0 progress based on the context it is used
func (m *LunCopyDestinationsItems0Progress) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateElapsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeSnapshotBlocked(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunCopyDestinationsItems0Progress) contextValidateElapsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "progress"+"."+"elapsed", "body", m.Elapsed); err != nil {
		return err
	}

	return nil
}

func (m *LunCopyDestinationsItems0Progress) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("progress" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *LunCopyDestinationsItems0Progress) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "progress"+"."+"percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *LunCopyDestinationsItems0Progress) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "progress"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *LunCopyDestinationsItems0Progress) contextValidateVolumeSnapshotBlocked(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "progress"+"."+"volume_snapshot_blocked", "body", m.VolumeSnapshotBlocked); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunCopyDestinationsItems0Progress) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunCopyDestinationsItems0Progress) UnmarshalBinary(b []byte) error {
	var res LunCopyDestinationsItems0Progress
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineCopyInlineSource The source LUN of a LUN copy operation in which the containing LUN is the destination of the copy.<br/>
// Valid in POST except when creating a LUN clone. A LUN copy request cannot be combined with setting any other LUN properties except the destination location. All other properties of the destination LUN come from the source LUN.
//
// swagger:model lun_inline_copy_inline_source
type LunInlineCopyInlineSource struct {

	// links
	Links *LunInlineCopyInlineSourceInlineLinks `json:"_links,omitempty"`

	// The maximum data throughput, in bytes per second, that should be utilized in support of the LUN copy. This property can be used to throttle a transfer and limit its impact on the performance of the source and destination nodes. The specified value will be rounded up to the nearest megabyte.<br/>
	// If this property is not specified in a POST that begins a LUN copy, throttling is not applied to the data transfer.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.<br/>
	// Valid only in a POST that begins a LUN copy or a PATCH when a LUN copy is already in process.
	//
	MaxThroughput *int64 `json:"max_throughput,omitempty"`

	// The fully qualified path of the LUN copy source composed of a "/vol" prefix, the volume name, the optional qtree name, and base name of the LUN.<br/>
	// Set this property in POST to specify the source for a LUN copy operation.
	//
	// Example: /vol/vol2/lun1
	Name *string `json:"name,omitempty"`

	// peer
	Peer *LunInlineCopyInlineSourceInlinePeer `json:"peer,omitempty"`

	// progress
	Progress *LunInlineCopyInlineSourceInlineProgress `json:"progress,omitempty"`

	// The unique identifier of the LUN copy source.<br/>
	// Set this property in POST to specify the source for a LUN copy operation.
	//
	// Example: 03c05019-40d9-3945-c767-dca4c3be5e90
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline copy inline source
func (m *LunInlineCopyInlineSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProgress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSource) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineCopyInlineSource) validatePeer(formats strfmt.Registry) error {
	if swag.IsZero(m.Peer) { // not required
		return nil
	}

	if m.Peer != nil {
		if err := m.Peer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "peer")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineCopyInlineSource) validateProgress(formats strfmt.Registry) error {
	if swag.IsZero(m.Progress) { // not required
		return nil
	}

	if m.Progress != nil {
		if err := m.Progress.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "progress")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline copy inline source based on the context it is used
func (m *LunInlineCopyInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSource) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineCopyInlineSource) contextValidatePeer(ctx context.Context, formats strfmt.Registry) error {

	if m.Peer != nil {
		if err := m.Peer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "peer")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineCopyInlineSource) contextValidateProgress(ctx context.Context, formats strfmt.Registry) error {

	if m.Progress != nil {
		if err := m.Progress.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "progress")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineCopyInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineCopyInlineSource) UnmarshalBinary(b []byte) error {
	var res LunInlineCopyInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineCopyInlineSourceInlineLinks lun inline copy inline source inline links
//
// swagger:model lun_inline_copy_inline_source_inline__links
type LunInlineCopyInlineSourceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline copy inline source inline links
func (m *LunInlineCopyInlineSourceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline copy inline source inline links based on the context it is used
func (m *LunInlineCopyInlineSourceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineCopyInlineSourceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineCopyInlineSourceInlinePeer The SVM peer relationship object for an inter-SVM LUN copy operation. The peer SVM in the relationship is the source SVM and the local SVM is the destination SVM.<br/>
// Set this in POST to specify the source SVM for an inter-SVM LUN copy. Only populated by GET when the LUN copy is inter-SVM.
//
// swagger:model lun_inline_copy_inline_source_inline_peer
type LunInlineCopyInlineSourceInlinePeer struct {

	// links
	Links *LunInlineCopyInlineSourceInlinePeerInlineLinks `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline copy inline source inline peer
func (m *LunInlineCopyInlineSourceInlinePeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlinePeer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "peer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline copy inline source inline peer based on the context it is used
func (m *LunInlineCopyInlineSourceInlinePeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlinePeer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "peer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlinePeer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlinePeer) UnmarshalBinary(b []byte) error {
	var res LunInlineCopyInlineSourceInlinePeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineCopyInlineSourceInlinePeerInlineLinks lun inline copy inline source inline peer inline links
//
// swagger:model lun_inline_copy_inline_source_inline_peer_inline__links
type LunInlineCopyInlineSourceInlinePeerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline copy inline source inline peer inline links
func (m *LunInlineCopyInlineSourceInlinePeerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlinePeerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "peer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline copy inline source inline peer inline links based on the context it is used
func (m *LunInlineCopyInlineSourceInlinePeerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlinePeerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "peer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlinePeerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlinePeerInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineCopyInlineSourceInlinePeerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineCopyInlineSourceInlineProgress Properties related to the progress of an active or recently completed LUN copy.
//
// swagger:model lun_inline_copy_inline_source_inline_progress
type LunInlineCopyInlineSourceInlineProgress struct {

	// The amount of time that has elapsed since the start of the LUN copy, in seconds.
	//
	// Read Only: true
	Elapsed *int64 `json:"elapsed,omitempty"`

	// Error information provided if the asynchronous LUN copy operation fails.
	//
	// Read Only: true
	Failure *Error `json:"failure,omitempty"`

	// The percentage completed of the LUN copy.
	//
	// Read Only: true
	// Maximum: 100
	// Minimum: 0
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// The state of the LUN copy.<br/>
	// Valid in PATCH when an LUN copy is active. Set to _paused_ to pause a LUN copy. Set to _replicating_ to resume a paused LUN copy.
	//
	// Enum: ["preparing","replicating","paused","paused_error","complete","reverting","failed"]
	State *string `json:"state,omitempty"`

	// This property reports if volume snapshots are blocked by the LUN copy. This property can be polled to identify when volume snapshots can be resumed after beginning a LUN copy.
	//
	// Read Only: true
	VolumeSnapshotBlocked *bool `json:"volume_snapshot_blocked,omitempty"`
}

// Validate validates this lun inline copy inline source inline progress
func (m *LunInlineCopyInlineSourceInlineProgress) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePercentComplete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlineProgress) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "progress" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineCopyInlineSourceInlineProgress) validatePercentComplete(formats strfmt.Registry) error {
	if swag.IsZero(m.PercentComplete) { // not required
		return nil
	}

	if err := validate.MinimumInt("copy"+"."+"source"+"."+"progress"+"."+"percent_complete", "body", *m.PercentComplete, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("copy"+"."+"source"+"."+"progress"+"."+"percent_complete", "body", *m.PercentComplete, 100, false); err != nil {
		return err
	}

	return nil
}

var lunInlineCopyInlineSourceInlineProgressTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["preparing","replicating","paused","paused_error","complete","reverting","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineCopyInlineSourceInlineProgressTypeStatePropEnum = append(lunInlineCopyInlineSourceInlineProgressTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_copy_inline_source_inline_progress
	// LunInlineCopyInlineSourceInlineProgress
	// state
	// State
	// preparing
	// END DEBUGGING
	// LunInlineCopyInlineSourceInlineProgressStatePreparing captures enum value "preparing"
	LunInlineCopyInlineSourceInlineProgressStatePreparing string = "preparing"

	// BEGIN DEBUGGING
	// lun_inline_copy_inline_source_inline_progress
	// LunInlineCopyInlineSourceInlineProgress
	// state
	// State
	// replicating
	// END DEBUGGING
	// LunInlineCopyInlineSourceInlineProgressStateReplicating captures enum value "replicating"
	LunInlineCopyInlineSourceInlineProgressStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// lun_inline_copy_inline_source_inline_progress
	// LunInlineCopyInlineSourceInlineProgress
	// state
	// State
	// paused
	// END DEBUGGING
	// LunInlineCopyInlineSourceInlineProgressStatePaused captures enum value "paused"
	LunInlineCopyInlineSourceInlineProgressStatePaused string = "paused"

	// BEGIN DEBUGGING
	// lun_inline_copy_inline_source_inline_progress
	// LunInlineCopyInlineSourceInlineProgress
	// state
	// State
	// paused_error
	// END DEBUGGING
	// LunInlineCopyInlineSourceInlineProgressStatePausedError captures enum value "paused_error"
	LunInlineCopyInlineSourceInlineProgressStatePausedError string = "paused_error"

	// BEGIN DEBUGGING
	// lun_inline_copy_inline_source_inline_progress
	// LunInlineCopyInlineSourceInlineProgress
	// state
	// State
	// complete
	// END DEBUGGING
	// LunInlineCopyInlineSourceInlineProgressStateComplete captures enum value "complete"
	LunInlineCopyInlineSourceInlineProgressStateComplete string = "complete"

	// BEGIN DEBUGGING
	// lun_inline_copy_inline_source_inline_progress
	// LunInlineCopyInlineSourceInlineProgress
	// state
	// State
	// reverting
	// END DEBUGGING
	// LunInlineCopyInlineSourceInlineProgressStateReverting captures enum value "reverting"
	LunInlineCopyInlineSourceInlineProgressStateReverting string = "reverting"

	// BEGIN DEBUGGING
	// lun_inline_copy_inline_source_inline_progress
	// LunInlineCopyInlineSourceInlineProgress
	// state
	// State
	// failed
	// END DEBUGGING
	// LunInlineCopyInlineSourceInlineProgressStateFailed captures enum value "failed"
	LunInlineCopyInlineSourceInlineProgressStateFailed string = "failed"
)

// prop value enum
func (m *LunInlineCopyInlineSourceInlineProgress) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineCopyInlineSourceInlineProgressTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlineProgress) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("copy"+"."+"source"+"."+"progress"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline copy inline source inline progress based on the context it is used
func (m *LunInlineCopyInlineSourceInlineProgress) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateElapsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeSnapshotBlocked(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineCopyInlineSourceInlineProgress) contextValidateElapsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "copy"+"."+"source"+"."+"progress"+"."+"elapsed", "body", m.Elapsed); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineCopyInlineSourceInlineProgress) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("copy" + "." + "source" + "." + "progress" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineCopyInlineSourceInlineProgress) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "copy"+"."+"source"+"."+"progress"+"."+"percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineCopyInlineSourceInlineProgress) contextValidateVolumeSnapshotBlocked(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "copy"+"."+"source"+"."+"progress"+"."+"volume_snapshot_blocked", "body", m.VolumeSnapshotBlocked); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlineProgress) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineCopyInlineSourceInlineProgress) UnmarshalBinary(b []byte) error {
	var res LunInlineCopyInlineSourceInlineProgress
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLinks lun inline links
//
// swagger:model lun_inline__links
type LunInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline links
func (m *LunInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline links based on the context it is used
func (m *LunInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocation The location of the LUN within the ONTAP cluster.
// <personalities supports=unified>LUNs support rename and move between volumes. Valid in POST and PATCH.</personalities>
// <personalities supports=asar2>The LUN name can be changed by PATCHing the `name` property. The `location` properties are read-only.</personalities>
//
// swagger:model lun_inline_location
type LunInlineLocation struct {

	// <personalities supports=unified>The base name component of the LUN. Valid in POST and PATCH.<br/>
	// If properties `name` and `location.logical_unit` are specified in the same request, they must refer to the base name.<br/>
	// A PATCH that modifies the base name of the LUN is considered a rename operation.</personalities>
	// <personalities supports=asar2>The volume logical unit property is read-only and cannot be set in POST or PATCH. Use the `name` property for POST.</personalities>
	//
	// Example: lun1
	LogicalUnit *string `json:"logical_unit,omitempty"`

	// node
	Node *LunInlineLocationInlineNode `json:"node,omitempty"`

	// qtree
	Qtree *LunInlineLocationInlineQtree `json:"qtree,omitempty"`

	// storage availability zone
	StorageAvailabilityZone *LunInlineLocationInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`

	// volume
	Volume *LunInlineLocationInlineVolume `json:"volume,omitempty"`
}

// Validate validates this lun inline location
func (m *LunInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQtree(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLocation) validateQtree(formats strfmt.Registry) error {
	if swag.IsZero(m.Qtree) { // not required
		return nil
	}

	if m.Qtree != nil {
		if err := m.Qtree.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLocation) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZone) { // not required
		return nil
	}

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLocation) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location based on the context it is used
func (m *LunInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQtree(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLocation) contextValidateQtree(ctx context.Context, formats strfmt.Registry) error {

	if m.Qtree != nil {
		if err := m.Qtree.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLocation) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLocation) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocation) UnmarshalBinary(b []byte) error {
	var res LunInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineNode The cluster node that hosts the LUN.
//
// swagger:model lun_inline_location_inline_node
type LunInlineLocationInlineNode struct {

	// links
	Links *LunInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline location inline node
func (m *LunInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location inline node based on the context it is used
func (m *LunInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineNodeInlineLinks lun inline location inline node inline links
//
// swagger:model lun_inline_location_inline_node_inline__links
type LunInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline location inline node inline links
func (m *LunInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location inline node inline links based on the context it is used
func (m *LunInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineQtree <personalities supports=unified>The qtree in which the LUN is optionally located. Valid in POST and PATCH.<br/>
// If properties `name` and `location.qtree.name` and/or `location.qtree.id` are specified in the same request, they must refer to the same qtree.<br/>
// A PATCH that modifies the qtree of the LUN is considered a rename operation.</personalities>
// <personalities supports=asar2>The qtrees are not supported. The properties of the qtree sub-object cannot be set in POST or PATCH.</personalities>
//
// swagger:model lun_inline_location_inline_qtree
type LunInlineLocationInlineQtree struct {

	// links
	Links *LunInlineLocationInlineQtreeInlineLinks `json:"_links,omitempty"`

	// The identifier for the qtree, unique within the qtree's volume.
	//
	// Example: 1
	// Maximum: 4994
	// Minimum: 0
	ID *int64 `json:"id,omitempty"`

	// The name of the qtree.
	// Example: qt1
	Name *string `json:"name,omitempty"`
}

// Validate validates this lun inline location inline qtree
func (m *LunInlineLocationInlineQtree) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineQtree) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLocationInlineQtree) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.MinimumInt("location"+"."+"qtree"+"."+"id", "body", *m.ID, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("location"+"."+"qtree"+"."+"id", "body", *m.ID, 4994, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline location inline qtree based on the context it is used
func (m *LunInlineLocationInlineQtree) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineQtree) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineQtree) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineQtree) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineQtree
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineQtreeInlineLinks lun inline location inline qtree inline links
//
// swagger:model lun_inline_location_inline_qtree_inline__links
type LunInlineLocationInlineQtreeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline location inline qtree inline links
func (m *LunInlineLocationInlineQtreeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineQtreeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location inline qtree inline links based on the context it is used
func (m *LunInlineLocationInlineQtreeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineQtreeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineQtreeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineQtreeInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineQtreeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineStorageAvailabilityZone The storage availability zone that contains the LUN.
// Valid in POST when creating LUNs of class `protocol_endpoint` only, otherwise read-only.
//
// swagger:model lun_inline_location_inline_storage_availability_zone
type LunInlineLocationInlineStorageAvailabilityZone struct {

	// links
	Links *LunInlineLocationInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline location inline storage availability zone
func (m *LunInlineLocationInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location inline storage availability zone based on the context it is used
func (m *LunInlineLocationInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineStorageAvailabilityZoneInlineLinks lun inline location inline storage availability zone inline links
//
// swagger:model lun_inline_location_inline_storage_availability_zone_inline__links
type LunInlineLocationInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline location inline storage availability zone inline links
func (m *LunInlineLocationInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location inline storage availability zone inline links based on the context it is used
func (m *LunInlineLocationInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineVolume <personalities supports=unified>The volume in which the LUN is located. Valid in POST and PATCH.<br/>
// If properties `name` and `location.volume.name` and/or `location.volume.uuid` are specified in the same request, they must refer to the same volume.<br/>
// A PATCH that modifies the volume of the LUN begins an asynchronous LUN movement operation.</personalities>
// <personalities supports=asar2>The volume sub-object is read-only and its properties cannot be set in POST or PATCH. Use the `name` property for POST.</personalities>
//
// swagger:model lun_inline_location_inline_volume
type LunInlineLocationInlineVolume struct {

	// links
	Links *LunInlineLocationInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline location inline volume
func (m *LunInlineLocationInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location inline volume based on the context it is used
func (m *LunInlineLocationInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineVolume) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLocationInlineVolumeInlineLinks lun inline location inline volume inline links
//
// swagger:model lun_inline_location_inline_volume_inline__links
type LunInlineLocationInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline location inline volume inline links
func (m *LunInlineLocationInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline location inline volume inline links based on the context it is used
func (m *LunInlineLocationInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLocationInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLocationInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLocationInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineLocationInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLunMapsInlineArrayItem A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
// swagger:model lun_inline_lun_maps_inline_array_item
type LunInlineLunMapsInlineArrayItem struct {

	// links
	Links *LunInlineLunMapsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// igroup
	Igroup *LunInlineLunMapsInlineArrayItemInlineIgroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this lun inline lun maps inline array item
func (m *LunInlineLunMapsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLunMapsInlineArrayItem) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline lun maps inline array item based on the context it is used
func (m *LunInlineLunMapsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLunMapsInlineArrayItem) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LunInlineLunMapsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLunMapsInlineArrayItemInlineIgroup The initiator group to which the LUN is mapped.
//
// swagger:model lun_inline_lun_maps_inline_array_item_inline_igroup
type LunInlineLunMapsInlineArrayItemInlineIgroup struct {

	// links
	Links *LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*LunLunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*LunLunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group.
	//
	// Example: igroup1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline lun maps inline array item inline igroup
func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(m.Igroups); i++ {
		if swag.IsZero(m.Igroups[i]) { // not required
			continue
		}

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(m.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(m.Initiators); i++ {
		if swag.IsZero(m.Initiators[i]) { // not required
			continue
		}

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var lunInlineLunMapsInlineArrayItemInlineIgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineLunMapsInlineArrayItemInlineIgroupTypeOsTypePropEnum = append(lunInlineLunMapsInlineArrayItemInlineIgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeAix captures enum value "aix"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeHpux captures enum value "hpux"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeHyperv captures enum value "hyper_v"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeLinux captures enum value "linux"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeNetware captures enum value "netware"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeOpenvms captures enum value "openvms"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeSolaris captures enum value "solaris"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeVmware captures enum value "vmware"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeWindows captures enum value "windows"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeXen captures enum value "xen"
	LunInlineLunMapsInlineArrayItemInlineIgroupOsTypeXen string = "xen"
)

// prop value enum
func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineLunMapsInlineArrayItemInlineIgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("igroup"+"."+"os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var lunInlineLunMapsInlineArrayItemInlineIgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineLunMapsInlineArrayItemInlineIgroupTypeProtocolPropEnum = append(lunInlineLunMapsInlineArrayItemInlineIgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupProtocolFcp captures enum value "fcp"
	LunInlineLunMapsInlineArrayItemInlineIgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupProtocolIscsi captures enum value "iscsi"
	LunInlineLunMapsInlineArrayItemInlineIgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// lun_inline_lun_maps_inline_array_item_inline_igroup
	// LunInlineLunMapsInlineArrayItemInlineIgroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// LunInlineLunMapsInlineArrayItemInlineIgroupProtocolMixed captures enum value "mixed"
	LunInlineLunMapsInlineArrayItemInlineIgroupProtocolMixed string = "mixed"
)

// prop value enum
func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineLunMapsInlineArrayItemInlineIgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("igroup"+"."+"protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline lun maps inline array item inline igroup based on the context it is used
func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Igroups); i++ {

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Initiators); i++ {

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItemInlineIgroup) UnmarshalBinary(b []byte) error {
	var res LunInlineLunMapsInlineArrayItemInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunLunMapsItems0IgroupIgroupsItems0 lun lun maps items0 igroup igroups items0
//
// swagger:model LunLunMapsItems0IgroupIgroupsItems0
type LunLunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun lun maps items0 igroup igroups items0
func (m *LunLunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunLunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunLunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun lun maps items0 igroup igroups items0 based on the context it is used
func (m *LunLunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunLunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunLunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunLunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res LunLunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunLunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
//
// swagger:model LunLunMapsItems0IgroupInitiatorsItems0
type LunLunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this lun lun maps items0 igroup initiators items0
func (m *LunLunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunLunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this lun lun maps items0 igroup initiators items0 based on context it is used
func (m *LunLunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LunLunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunLunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res LunLunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks lun inline lun maps inline array item inline igroup inline links
//
// swagger:model lun_inline_lun_maps_inline_array_item_inline_igroup_inline__links
type LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline lun maps inline array item inline igroup inline links
func (m *LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline lun maps inline array item inline igroup inline links based on the context it is used
func (m *LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineLunMapsInlineArrayItemInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineLunMapsInlineArrayItemInlineLinks lun inline lun maps inline array item inline links
//
// swagger:model lun_inline_lun_maps_inline_array_item_inline__links
type LunInlineLunMapsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline lun maps inline array item inline links
func (m *LunInlineLunMapsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline lun maps inline array item inline links based on the context it is used
func (m *LunInlineLunMapsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineLunMapsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineLunMapsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineLunMapsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMetric Performance numbers, such as IOPS latency and throughput.
//
// swagger:model lun_inline_metric
type LunInlineMetric struct {

	// links
	Links *LunInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *LunInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *LunInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *LunInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this lun inline metric
func (m *LunInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var lunInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineMetricTypeDurationPropEnum = append(lunInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// LunInlineMetricDurationPT15S captures enum value "PT15S"
	LunInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// LunInlineMetricDurationPT4M captures enum value "PT4M"
	LunInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// LunInlineMetricDurationPT30M captures enum value "PT30M"
	LunInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// LunInlineMetricDurationPT2H captures enum value "PT2H"
	LunInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// LunInlineMetricDurationP1D captures enum value "P1D"
	LunInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// LunInlineMetricDurationPT5M captures enum value "PT5M"
	LunInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *LunInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var lunInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineMetricTypeStatusPropEnum = append(lunInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// LunInlineMetricStatusOk captures enum value "ok"
	LunInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// LunInlineMetricStatusError captures enum value "error"
	LunInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// LunInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	LunInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// LunInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	LunInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// LunInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	LunInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// LunInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	LunInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// LunInlineMetricStatusNotFound captures enum value "not_found"
	LunInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// LunInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	LunInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// LunInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	LunInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// LunInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	LunInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// lun_inline_metric
	// LunInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// LunInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	LunInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *LunInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline metric based on the context it is used
func (m *LunInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMetric) UnmarshalBinary(b []byte) error {
	var res LunInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model lun_inline_metric_inline_iops
type LunInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this lun inline metric inline iops
func (m *LunInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline metric inline iops based on the context it is used
func (m *LunInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res LunInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model lun_inline_metric_inline_latency
type LunInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this lun inline metric inline latency
func (m *LunInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline metric inline latency based on the context it is used
func (m *LunInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res LunInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMetricInlineLinks lun inline metric inline links
//
// swagger:model lun_inline_metric_inline__links
type LunInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline metric inline links
func (m *LunInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline metric inline links based on the context it is used
func (m *LunInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model lun_inline_metric_inline_throughput
type LunInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this lun inline metric inline throughput
func (m *LunInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline metric inline throughput based on the context it is used
func (m *LunInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res LunInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMovement <personalities supports=unified>This sub-object applies to LUN movement between volumes. A LUN can be moved to a new volume with a PATCH request that changes either the volume portion of property `name`, `location.volume.uuid`, or `location.volume.name`. If the volume is changed using more than one of these properties, the supplied properties used must refer to the same volume.<br/>
// Moving a LUN between volumes is an asynchronous activity begun by a PATCH request. The data for the LUN is then asynchronously copied from the source volume to the destination volume. The time required to complete the move depends on the size of the LUN and the load on the cluster. The `movement` sub-object is populated while a LUN movement is in progress and for two (2) minutes following completion of a movement.<br/>
// While the LUN is being moved, the status of the LUN movement operation can be obtained using a GET for the LUN that requests the `movement` properties. The LUN movement operation can be further modified using a PATCH on the properties on the `movement` sub-object.<br/>
// There is an added computational cost to retrieving property values for `movement`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
// <personalities supports=asar2>LUN movement is not supported. No properties in this sub-object can be set in POST or PATCH and none will be returned by GET.</personalities>
//
// swagger:model lun_inline_movement
type LunInlineMovement struct {

	// The maximum data throughput, in bytes per second, that should be utilized in support of the LUN movement. This property can be used to throttle a transfer and limit its impact on the performance of the source and destination nodes. The specified value will be rounded up to the nearest megabyte.<br/>
	// If this property is not specified in a POST that begins a LUN movement, throttling is not applied to the data transfer.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.<br/>
	// This property is valid only in a POST that begins a LUN movement or a PATCH when a LUN movement is already in process.
	//
	MaxThroughput *int64 `json:"max_throughput,omitempty"`

	// paths
	Paths *LunInlineMovementInlinePaths `json:"paths,omitempty"`

	// progress
	Progress *LunInlineMovementInlineProgress `json:"progress,omitempty"`
}

// Validate validates this lun inline movement
func (m *LunInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProgress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMovement) validatePaths(formats strfmt.Registry) error {
	if swag.IsZero(m.Paths) { // not required
		return nil
	}

	if m.Paths != nil {
		if err := m.Paths.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "paths")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMovement) validateProgress(formats strfmt.Registry) error {
	if swag.IsZero(m.Progress) { // not required
		return nil
	}

	if m.Progress != nil {
		if err := m.Progress.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "progress")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline movement based on the context it is used
func (m *LunInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePaths(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMovement) contextValidatePaths(ctx context.Context, formats strfmt.Registry) error {

	if m.Paths != nil {
		if err := m.Paths.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "paths")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMovement) contextValidateProgress(ctx context.Context, formats strfmt.Registry) error {

	if m.Progress != nil {
		if err := m.Progress.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "progress")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMovement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMovement) UnmarshalBinary(b []byte) error {
	var res LunInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMovementInlinePaths The fully qualified LUN path names involved in the LUN movement.
//
// swagger:model lun_inline_movement_inline_paths
type LunInlineMovementInlinePaths struct {

	// The fully qualified path of the LUN movement destination composed of a "/vol" prefix, the volume name, the optional qtree name, and base name of the LUN.
	//
	// Example: /vol/vol1/lun1
	// Read Only: true
	Destination *string `json:"destination,omitempty"`

	// The fully qualified path of the LUN movement source composed of a "/vol" prefix, the volume name, the optional qtree name, and base name of the LUN.
	//
	// Example: /vol/vol2/lun2
	// Read Only: true
	Source *string `json:"source,omitempty"`
}

// Validate validates this lun inline movement inline paths
func (m *LunInlineMovementInlinePaths) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline movement inline paths based on the context it is used
func (m *LunInlineMovementInlinePaths) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMovementInlinePaths) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"paths"+"."+"destination", "body", m.Destination); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineMovementInlinePaths) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"paths"+"."+"source", "body", m.Source); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMovementInlinePaths) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMovementInlinePaths) UnmarshalBinary(b []byte) error {
	var res LunInlineMovementInlinePaths
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineMovementInlineProgress Properties related to the progress of an active or recently completed LUN movement.
//
// swagger:model lun_inline_movement_inline_progress
type LunInlineMovementInlineProgress struct {

	// The amount of time that has elapsed since the start of the LUN movement, in seconds.
	//
	// Read Only: true
	Elapsed *int64 `json:"elapsed,omitempty"`

	// Error information provided if the asynchronous LUN movement operation fails.
	//
	// Read Only: true
	Failure *Error `json:"failure,omitempty"`

	// The percentage completed of the LUN movement.
	//
	// Read Only: true
	// Maximum: 100
	// Minimum: 0
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// The state of the LUN movement.<br/>
	// Valid in PATCH when an LUN movement is active. Set to _paused_ to pause a LUN movement. Set to _replicating_ to resume a paused LUN movement.
	//
	// Enum: ["preparing","replicating","paused","paused_error","complete","reverting","failed"]
	State *string `json:"state,omitempty"`

	// This property reports if volume snapshots are blocked by the LUN movement. This property can be polled to identify when volume snapshots can be resumed after beginning a LUN movement.
	//
	// Read Only: true
	VolumeSnapshotBlocked *bool `json:"volume_snapshot_blocked,omitempty"`
}

// Validate validates this lun inline movement inline progress
func (m *LunInlineMovementInlineProgress) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePercentComplete(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMovementInlineProgress) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "progress" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMovementInlineProgress) validatePercentComplete(formats strfmt.Registry) error {
	if swag.IsZero(m.PercentComplete) { // not required
		return nil
	}

	if err := validate.MinimumInt("movement"+"."+"progress"+"."+"percent_complete", "body", *m.PercentComplete, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("movement"+"."+"progress"+"."+"percent_complete", "body", *m.PercentComplete, 100, false); err != nil {
		return err
	}

	return nil
}

var lunInlineMovementInlineProgressTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["preparing","replicating","paused","paused_error","complete","reverting","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineMovementInlineProgressTypeStatePropEnum = append(lunInlineMovementInlineProgressTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_movement_inline_progress
	// LunInlineMovementInlineProgress
	// state
	// State
	// preparing
	// END DEBUGGING
	// LunInlineMovementInlineProgressStatePreparing captures enum value "preparing"
	LunInlineMovementInlineProgressStatePreparing string = "preparing"

	// BEGIN DEBUGGING
	// lun_inline_movement_inline_progress
	// LunInlineMovementInlineProgress
	// state
	// State
	// replicating
	// END DEBUGGING
	// LunInlineMovementInlineProgressStateReplicating captures enum value "replicating"
	LunInlineMovementInlineProgressStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// lun_inline_movement_inline_progress
	// LunInlineMovementInlineProgress
	// state
	// State
	// paused
	// END DEBUGGING
	// LunInlineMovementInlineProgressStatePaused captures enum value "paused"
	LunInlineMovementInlineProgressStatePaused string = "paused"

	// BEGIN DEBUGGING
	// lun_inline_movement_inline_progress
	// LunInlineMovementInlineProgress
	// state
	// State
	// paused_error
	// END DEBUGGING
	// LunInlineMovementInlineProgressStatePausedError captures enum value "paused_error"
	LunInlineMovementInlineProgressStatePausedError string = "paused_error"

	// BEGIN DEBUGGING
	// lun_inline_movement_inline_progress
	// LunInlineMovementInlineProgress
	// state
	// State
	// complete
	// END DEBUGGING
	// LunInlineMovementInlineProgressStateComplete captures enum value "complete"
	LunInlineMovementInlineProgressStateComplete string = "complete"

	// BEGIN DEBUGGING
	// lun_inline_movement_inline_progress
	// LunInlineMovementInlineProgress
	// state
	// State
	// reverting
	// END DEBUGGING
	// LunInlineMovementInlineProgressStateReverting captures enum value "reverting"
	LunInlineMovementInlineProgressStateReverting string = "reverting"

	// BEGIN DEBUGGING
	// lun_inline_movement_inline_progress
	// LunInlineMovementInlineProgress
	// state
	// State
	// failed
	// END DEBUGGING
	// LunInlineMovementInlineProgressStateFailed captures enum value "failed"
	LunInlineMovementInlineProgressStateFailed string = "failed"
)

// prop value enum
func (m *LunInlineMovementInlineProgress) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineMovementInlineProgressTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineMovementInlineProgress) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("movement"+"."+"progress"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline movement inline progress based on the context it is used
func (m *LunInlineMovementInlineProgress) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateElapsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeSnapshotBlocked(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineMovementInlineProgress) contextValidateElapsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"progress"+"."+"elapsed", "body", m.Elapsed); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineMovementInlineProgress) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("movement" + "." + "progress" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineMovementInlineProgress) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"progress"+"."+"percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineMovementInlineProgress) contextValidateVolumeSnapshotBlocked(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "movement"+"."+"progress"+"."+"volume_snapshot_blocked", "body", m.VolumeSnapshotBlocked); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineMovementInlineProgress) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineMovementInlineProgress) UnmarshalBinary(b []byte) error {
	var res LunInlineMovementInlineProgress
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model lun_inline_provisioning_options
type LunInlineProvisioningOptions struct {

	// If the volume specified in the request does not exist, automatically provision one of appropriate size. If the volume does exist, resize it to accommodate the new LUN.<br/>
	// This property is only supported on Unified ONTAP.<br/>
	// The following behavior is different from a traditional POST request:
	// * The operation is asynchronous.
	// * The `qos_policy` property is applied to the provisioned volume instead of the LUN. A default QoS policy is applied to the volume if one is not provided.
	// * The `provisioning_options.count` property is supported, provisioning _count_ LUNs on the volume using the specified properties.
	// * The `lun_maps` property is supported. If the specified initiator group does not exist, it is created. The LUN is mapped to this initiator group. If an initiator group is provisioned in this way, it is deleted after it is no longer mapped to any LUNs.
	// * The `clone`, `copy`, and `convert` properties are not supported.
	// * When performing `records` based operations, specifying this property in the query applies to the entire operation. Specifying it for an individual record within the request applies to only that record.
	// * Many other `provisioning_options` properties are supported to control the placement of the LUN and the properties of the volume containing the LUN.
	//
	Auto *bool `json:"auto,omitempty"`

	// The number of LUNs to provision with these properties. Only POST requests based on `space.size` are supported. When provided, the name is considered a prefix, and a suffix of the form __&lt;N&gt;_ is generated where N is the next available numeric index, starting with 1.
	// Maximum: 80
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// A list of aggregates to exclude when determining the placement of the volume. <br/>
	//
	// Max Items: 100
	// Min Items: 0
	ExcludeAggregates []*LunProvisioningOptionsExcludeAggregatesItems0 `json:"exclude_aggregates,omitempty"`

	// qos policy
	QosPolicy *LunInlineProvisioningOptionsInlineQosPolicy `json:"qos_policy,omitempty"`

	// This must be set to _true_ to provision a secondary LUN. A secondary LUN must refer to a primary LUN and will be included in snapshots of the primary LUN. Valid in POST when creating LUNs of class `vvol` only.
	//
	Secondary *bool `json:"secondary,omitempty"`

	// The snapshot policy for the volume provisioned to host the LUN. This property is only supported when the request provisions a new volume.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// storage service
	StorageService *LunInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *LunInlineProvisioningOptionsInlineTiering `json:"tiering,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume to host the LUN. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`
}

// Validate validates this lun inline provisioning options
func (m *LunInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineProvisioningOptions) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(m.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("provisioning_options"+"."+"count", "body", *m.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("provisioning_options"+"."+"count", "body", *m.Count, 80, false); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineProvisioningOptions) validateExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ExcludeAggregates) { // not required
		return nil
	}

	iExcludeAggregatesSize := int64(len(m.ExcludeAggregates))

	if err := validate.MinItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 100); err != nil {
		return err
	}

	for i := 0; i < len(m.ExcludeAggregates); i++ {
		if swag.IsZero(m.ExcludeAggregates[i]) { // not required
			continue
		}

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunInlineProvisioningOptions) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineProvisioningOptions) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineProvisioningOptions) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline provisioning options based on the context it is used
func (m *LunInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineProvisioningOptions) contextValidateExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ExcludeAggregates); i++ {

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunInlineProvisioningOptions) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineProvisioningOptions) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineProvisioningOptions) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res LunInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunProvisioningOptionsExcludeAggregatesItems0 lun provisioning options exclude aggregates items0
//
// swagger:model LunProvisioningOptionsExcludeAggregatesItems0
type LunProvisioningOptionsExcludeAggregatesItems0 struct {

	// The aggregate name.
	//
	// Example: aggr1
	Name *string `json:"name,omitempty"`
}

// Validate validates this lun provisioning options exclude aggregates items0
func (m *LunProvisioningOptionsExcludeAggregatesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this lun provisioning options exclude aggregates items0 based on context it is used
func (m *LunProvisioningOptionsExcludeAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LunProvisioningOptionsExcludeAggregatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunProvisioningOptionsExcludeAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res LunProvisioningOptionsExcludeAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineProvisioningOptionsInlineQosPolicy The QoS policy for the volume provisioned to host the LUN. This property is only supported when the request provisions a new volume. This property is mutually exclusive with the LUN granular `qos_policy`. If no `qos_policy` is provided at LUN or volume granularity, a volume granular policy is set based on the `storage_service.name`, which defaults to the most performant service available.
//
// swagger:model lun_inline_provisioning_options_inline_qos_policy
type LunInlineProvisioningOptionsInlineQosPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline provisioning options inline qos policy
func (m *LunInlineProvisioningOptionsInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineProvisioningOptionsInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline provisioning options inline qos policy based on the context it is used
func (m *LunInlineProvisioningOptionsInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineProvisioningOptionsInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineProvisioningOptionsInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineProvisioningOptionsInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res LunInlineProvisioningOptionsInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineProvisioningOptionsInlineStorageService Determines the placement of the LUN based on the value specified. This property is only supported for regular and vvol LUNs. Valid in POST.
//
// swagger:model lun_inline_provisioning_options_inline_storage_service
type LunInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this lun inline provisioning options inline storage service
func (m *LunInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var lunInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(lunInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_storage_service
	// LunInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	LunInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_storage_service
	// LunInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	LunInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_storage_service
	// LunInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	LunInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *LunInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this lun inline provisioning options inline storage service based on context it is used
func (m *LunInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res LunInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineProvisioningOptionsInlineTiering The tiering placement and policy definitions for the volume provisioned to host the LUN. This property is only supported when the request provisions a new volume.
//
// swagger:model lun_inline_provisioning_options_inline_tiering
type LunInlineProvisioningOptionsInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*LunProvisioningOptionsTieringObjectStoresItems0 `json:"object_stores,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this lun inline provisioning options inline tiering
func (m *LunInlineProvisioningOptionsInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var lunInlineProvisioningOptionsInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineProvisioningOptionsInlineTieringTypeControlPropEnum = append(lunInlineProvisioningOptionsInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringControlAllowed captures enum value "allowed"
	LunInlineProvisioningOptionsInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringControlBestEffort captures enum value "best_effort"
	LunInlineProvisioningOptionsInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringControlDisallowed captures enum value "disallowed"
	LunInlineProvisioningOptionsInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringControlRequired captures enum value "required"
	LunInlineProvisioningOptionsInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *LunInlineProvisioningOptionsInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineProvisioningOptionsInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineProvisioningOptionsInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("provisioning_options"+"."+"tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineProvisioningOptionsInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("provisioning_options"+"."+"tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("provisioning_options"+"."+"tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var lunInlineProvisioningOptionsInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineProvisioningOptionsInlineTieringTypePolicyPropEnum = append(lunInlineProvisioningOptionsInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringPolicyAll captures enum value "all"
	LunInlineProvisioningOptionsInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringPolicyAuto captures enum value "auto"
	LunInlineProvisioningOptionsInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringPolicyBackup captures enum value "backup"
	LunInlineProvisioningOptionsInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringPolicyNone captures enum value "none"
	LunInlineProvisioningOptionsInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// lun_inline_provisioning_options_inline_tiering
	// LunInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// LunInlineProvisioningOptionsInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	LunInlineProvisioningOptionsInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *LunInlineProvisioningOptionsInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineProvisioningOptionsInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineProvisioningOptionsInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("provisioning_options"+"."+"tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline provisioning options inline tiering based on the context it is used
func (m *LunInlineProvisioningOptionsInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineProvisioningOptionsInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineProvisioningOptionsInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineProvisioningOptionsInlineTiering) UnmarshalBinary(b []byte) error {
	var res LunInlineProvisioningOptionsInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunProvisioningOptionsTieringObjectStoresItems0 lun provisioning options tiering object stores items0
//
// swagger:model LunProvisioningOptionsTieringObjectStoresItems0
type LunProvisioningOptionsTieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this lun provisioning options tiering object stores items0
func (m *LunProvisioningOptionsTieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this lun provisioning options tiering object stores items0 based on context it is used
func (m *LunProvisioningOptionsTieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LunProvisioningOptionsTieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunProvisioningOptionsTieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res LunProvisioningOptionsTieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineQosPolicy The QoS policy for the LUN. Both traditional and adaptive QoS policies are supported. If both property `qos_policy.uuid` and `qos_policy.name` are specified in the same request, they must refer to the same QoS policy. To remove the QoS policy from a LUN, leaving it with no QoS policy, set the property `qos_policy.name` to an empty string ("") in a PATCH request. Valid in POST and PATCH.
// <personalities supports=asar2>To remove the QoS policy, set it to `null` in a PATCH request.</personalities>
//
// swagger:model lun_inline_qos_policy
type LunInlineQosPolicy struct {

	// links
	Links *LunInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// The name of the QoS policy. To remove the QoS policy from a LUN, leaving it with no QoS policy, set this property to an empty string ("") in a PATCH request. Valid in POST and PATCH.
	//
	// Example: qos1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the QoS policy. Valid in POST and PATCH.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline qos policy
func (m *LunInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline qos policy based on the context it is used
func (m *LunInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res LunInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineQosPolicyInlineLinks lun inline qos policy inline links
//
// swagger:model lun_inline_qos_policy_inline__links
type LunInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline qos policy inline links
func (m *LunInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline qos policy inline links based on the context it is used
func (m *LunInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineSpace The storage space related properties of the LUN.
//
// swagger:model lun_inline_space
type LunInlineSpace struct {

	// The storage efficiency ratio of the LUN without snapshots. (Logical Used / Used)
	// <personalities supports=unified>This property is not available on the LUN object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 2.5
	// Read Only: true
	EfficiencyRatio *float64 `json:"efficiency_ratio,omitempty"`

	// guarantee
	Guarantee *LunInlineSpaceInlineGuarantee `json:"guarantee,omitempty"`

	// The number of bytes consumed on the disk by the LUN, excluding snapshots.
	// <personalities supports=unified>This property is not available on the LUN object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The number of bytes consumed on the disk by the LUN's snapshots.
	// This property has been replaced by `space.snapshot.used`.
	// <personalities supports=unified>This property is not available on the LUN object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsedBySnapshots *int64 `json:"physical_used_by_snapshots,omitempty"`

	// To leverage the benefits of SCSI thin provisioning, it must be supported by your host. SCSI thin provisioning uses the Logical Block Provisioning feature as defined in the SCSI SBC-3 standard. Only hosts that support this standard can use SCSI thin provisioning in ONTAP.<br/>
	// When you disable SCSI thin provisioning support in ONTAP, you turn off the following SCSI thin provisioning features:
	// - Unmapping and reporting space usage for space reclamation
	// - Reporting resource exhaustion errors
	// <p/>
	// The value of this property is not propagated to the destination when a LUN is cloned as a new LUN or copied; it is reset to false. The value of this property is maintained from the destination LUN when a LUN is overwritten as a clone.<br/>
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property cannot be set. All LUNs are provisioned with SCSI thin provisioning enabled.</personalities>
	//
	ScsiThinProvisioningSupportEnabled *bool `json:"scsi_thin_provisioning_support_enabled,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not decreased using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform and the available space in the containing volume and aggregate.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this lun inline space
func (m *LunInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineSpace) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline space based on the context it is used
func (m *LunInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiencyRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineSpace) contextValidateEfficiencyRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_ratio", "body", m.EfficiencyRatio); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineSpace) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineSpace) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used", "body", m.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineSpace) contextValidatePhysicalUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used_by_snapshots", "body", m.PhysicalUsedBySnapshots); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineSpace) UnmarshalBinary(b []byte) error {
	var res LunInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineSpaceInlineGuarantee Properties that request and report the space guarantee for the LUN.
//
// swagger:model lun_inline_space_inline_guarantee
type LunInlineSpaceInlineGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=unified>This property is caller settable as described above.</personalities>
	// <personalities supports=asar2>This property cannot be set. All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this lun inline space inline guarantee
func (m *LunInlineSpaceInlineGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline space inline guarantee based on the context it is used
func (m *LunInlineSpaceInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineSpaceInlineGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineSpaceInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineSpaceInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res LunInlineSpaceInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model lun_inline_statistics
type LunInlineStatistics struct {

	// iops raw
	IopsRaw *LunInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *LunInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *LunInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this lun inline statistics
func (m *LunInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var lunInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineStatisticsTypeStatusPropEnum = append(lunInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// LunInlineStatisticsStatusOk captures enum value "ok"
	LunInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// LunInlineStatisticsStatusError captures enum value "error"
	LunInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// LunInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	LunInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// LunInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	LunInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// LunInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	LunInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// LunInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	LunInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// LunInlineStatisticsStatusNotFound captures enum value "not_found"
	LunInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// LunInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	LunInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// LunInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	LunInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// LunInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	LunInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// lun_inline_statistics
	// LunInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// LunInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	LunInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *LunInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline statistics based on the context it is used
func (m *LunInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *LunInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineStatistics) UnmarshalBinary(b []byte) error {
	var res LunInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model lun_inline_statistics_inline_iops_raw
type LunInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this lun inline statistics inline iops raw
func (m *LunInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline statistics inline iops raw based on the context it is used
func (m *LunInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res LunInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model lun_inline_statistics_inline_latency_raw
type LunInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this lun inline statistics inline latency raw
func (m *LunInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline statistics inline latency raw based on the context it is used
func (m *LunInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res LunInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model lun_inline_statistics_inline_throughput_raw
type LunInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this lun inline statistics inline throughput raw
func (m *LunInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun inline statistics inline throughput raw based on the context it is used
func (m *LunInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res LunInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineStatus Status information about the LUN.
//
// swagger:model lun_inline_status
type LunInlineStatus struct {

	// The state of the volume and aggregate that contain the LUN. LUNs are only available when their containers are available.
	//
	// Read Only: true
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the LUN is mapped to one or more initiator groups.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the LUN allows only read access.
	//
	// Read Only: true
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the LUN. Normal states for a LUN are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Read Only: true
	// Enum: ["foreign_lun_error","nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this lun inline status
func (m *LunInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var lunInlineStatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineStatusTypeContainerStatePropEnum = append(lunInlineStatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// LunInlineStatusContainerStateOnline captures enum value "online"
	LunInlineStatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// LunInlineStatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	LunInlineStatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// LunInlineStatusContainerStateVolumeOffline captures enum value "volume_offline"
	LunInlineStatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (m *LunInlineStatus) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineStatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineStatus) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := m.validateContainerStateEnum("status"+"."+"container_state", "body", *m.ContainerState); err != nil {
		return err
	}

	return nil
}

var lunInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["foreign_lun_error","nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunInlineStatusTypeStatePropEnum = append(lunInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// state
	// State
	// foreign_lun_error
	// END DEBUGGING
	// LunInlineStatusStateForeignLunError captures enum value "foreign_lun_error"
	LunInlineStatusStateForeignLunError string = "foreign_lun_error"

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// state
	// State
	// nvfail
	// END DEBUGGING
	// LunInlineStatusStateNvfail captures enum value "nvfail"
	LunInlineStatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// state
	// State
	// offline
	// END DEBUGGING
	// LunInlineStatusStateOffline captures enum value "offline"
	LunInlineStatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// state
	// State
	// online
	// END DEBUGGING
	// LunInlineStatusStateOnline captures enum value "online"
	LunInlineStatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// lun_inline_status
	// LunInlineStatus
	// state
	// State
	// space_error
	// END DEBUGGING
	// LunInlineStatusStateSpaceError captures enum value "space_error"
	LunInlineStatusStateSpaceError string = "space_error"
)

// prop value enum
func (m *LunInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun inline status based on the context it is used
func (m *LunInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContainerState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMapped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadOnly(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineStatus) contextValidateContainerState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"container_state", "body", m.ContainerState); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineStatus) contextValidateMapped(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"mapped", "body", m.Mapped); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineStatus) contextValidateReadOnly(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"read_only", "body", m.ReadOnly); err != nil {
		return err
	}

	return nil
}

func (m *LunInlineStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineStatus) UnmarshalBinary(b []byte) error {
	var res LunInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineSvm The SVM in which the LUN is located.
//
// swagger:model lun_inline_svm
type LunInlineSvm struct {

	// links
	Links *LunInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun inline svm
func (m *LunInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline svm based on the context it is used
func (m *LunInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineSvm) UnmarshalBinary(b []byte) error {
	var res LunInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineSvmInlineLinks lun inline svm inline links
//
// swagger:model lun_inline_svm_inline__links
type LunInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun inline svm inline links
func (m *LunInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun inline svm inline links based on the context it is used
func (m *LunInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunInlineVvol A VMware virtual volume (vVol) binding is an association between a LUN of class `protocol_endpoint` and a LUN of class `vvol`. Class `protocol_endpoint` LUNs are mapped to igroups and granted access using the same configuration as class `regular` LUNs. When a class `vvol` LUN is bound to a mapped class `protocol_endpoint` LUN, VMware can access the class `vvol` LUN through the class `protocol_endpoint` LUN mapping.<br/>
// See [`POST /protocols/san/vvol-bindings`](#/SAN/vvol_binding_create) to learn more about creating vVol bindings and [`DELETE /protocols/san/vvol-bindings`](#/SAN/vvol_binding_delete) to learn more about deleting vVol bindings.<br/>
// There is an added computational cost to retrieving property values for `vvol`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
//
// swagger:model lun_inline_vvol
type LunInlineVvol struct {

	// Bindings between the LUN, which must be of class `protocol_endpoint` or `vvol`, and LUNs of the opposite class.<br/>
	// A class `vvol` LUN must be bound to a class `protocol_endpoint` LUN in order to be accessed. Class `protocol_endpoint` and `vvol` LUNs allow many-to-many bindings. A LUN of one class is allowed to be bound to zero or more LUNs of the opposite class. The binding between any two specific LUNs is reference counted. When a binding is created that already exists, the binding count is incremented. When a binding is deleted, the binding count is decremented, but the LUNs remain bound if the resultant reference count is greater than zero. When the binding count reaches zero, the binding is destroyed.<br/>
	// The bindings array contains LUNs of the opposite class of the containing LUN object.<br/>
	// There is an added computational cost to retrieving property values for `vvol.bindings`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Bindings []*LunVvolBindingsItems0 `json:"bindings,omitempty"`

	// Reports if the LUN is part of a VMware virtual volume (vVol) bind relationship. This is `true` if the LUN is of class `protocol_endpoint` or `vvol` and has one or more bindings to a LUN of the opposite class. This is false if the LUN is of class `regular` or unbound.
	//
	// Read Only: true
	IsBound *bool `json:"is_bound,omitempty"`
}

// Validate validates this lun inline vvol
func (m *LunInlineVvol) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBindings(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineVvol) validateBindings(formats strfmt.Registry) error {
	if swag.IsZero(m.Bindings) { // not required
		return nil
	}

	for i := 0; i < len(m.Bindings); i++ {
		if swag.IsZero(m.Bindings[i]) { // not required
			continue
		}

		if m.Bindings[i] != nil {
			if err := m.Bindings[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("vvol" + "." + "bindings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this lun inline vvol based on the context it is used
func (m *LunInlineVvol) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBindings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsBound(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunInlineVvol) contextValidateBindings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vvol"+"."+"bindings", "body", []*LunVvolBindingsItems0(m.Bindings)); err != nil {
		return err
	}

	for i := 0; i < len(m.Bindings); i++ {

		if m.Bindings[i] != nil {
			if err := m.Bindings[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("vvol" + "." + "bindings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunInlineVvol) contextValidateIsBound(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vvol"+"."+"is_bound", "body", m.IsBound); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunInlineVvol) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunInlineVvol) UnmarshalBinary(b []byte) error {
	var res LunInlineVvol
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunVvolBindingsItems0 A vVol binding with which the LUN is associated.
//
// swagger:model LunVvolBindingsItems0
type LunVvolBindingsItems0 struct {

	// links
	Links *LunVvolBindingsItems0Links `json:"_links,omitempty"`

	// The ONTAP internal identifier assigned to the vVol binding. The bind identifier is unique amongst all class `vvol` LUNs bound to the same class `protocol_endpoint` LUN.<br/>
	// This property was included in early releases of the REST API for vVols and is maintained for backward compatibility. See the `secondary_id` property, which replaces `id`.
	//
	// Example: 1
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// partner
	Partner *LunVvolBindingsItems0Partner `json:"partner,omitempty"`

	// The identifier assigned to the vVol binding, known as the secondary LUN ID. The identifier is unique amongst all class `vvol` LUNs bound to the same class `protocol_endpoint` LUN.<br/>
	// The format for a secondary LUN ID is 16 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 0000D20000010000h
	// Read Only: true
	SecondaryID *string `json:"secondary_id,omitempty"`
}

// Validate validates this lun vvol bindings items0
func (m *LunVvolBindingsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunVvolBindingsItems0) validatePartner(formats strfmt.Registry) error {
	if swag.IsZero(m.Partner) { // not required
		return nil
	}

	if m.Partner != nil {
		if err := m.Partner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun vvol bindings items0 based on the context it is used
func (m *LunVvolBindingsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecondaryID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunVvolBindingsItems0) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *LunVvolBindingsItems0) contextValidatePartner(ctx context.Context, formats strfmt.Registry) error {

	if m.Partner != nil {
		if err := m.Partner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner")
			}
			return err
		}
	}

	return nil
}

func (m *LunVvolBindingsItems0) contextValidateSecondaryID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "secondary_id", "body", m.SecondaryID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunVvolBindingsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunVvolBindingsItems0) UnmarshalBinary(b []byte) error {
	var res LunVvolBindingsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunVvolBindingsItems0Links lun vvol bindings items0 links
//
// swagger:model LunVvolBindingsItems0Links
type LunVvolBindingsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun vvol bindings items0 links
func (m *LunVvolBindingsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun vvol bindings items0 links based on the context it is used
func (m *LunVvolBindingsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunVvolBindingsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunVvolBindingsItems0Links) UnmarshalBinary(b []byte) error {
	var res LunVvolBindingsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunVvolBindingsItems0Partner The LUN partner that this LUN is bound to. If this LUN is a `vvol` class LUN, the partner is a `protocol_endpoint` class LUN.
//
// swagger:model LunVvolBindingsItems0Partner
type LunVvolBindingsItems0Partner struct {

	// links
	Links *LunVvolBindingsItems0PartnerLinks `json:"_links,omitempty"`

	// The name of the partner LUN.
	//
	// Example: /vol/vol1/lun1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the partner LUN.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun vvol bindings items0 partner
func (m *LunVvolBindingsItems0Partner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0Partner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun vvol bindings items0 partner based on the context it is used
func (m *LunVvolBindingsItems0Partner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0Partner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunVvolBindingsItems0Partner) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partner"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *LunVvolBindingsItems0Partner) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "partner"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunVvolBindingsItems0Partner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunVvolBindingsItems0Partner) UnmarshalBinary(b []byte) error {
	var res LunVvolBindingsItems0Partner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunVvolBindingsItems0PartnerLinks lun vvol bindings items0 partner links
//
// swagger:model LunVvolBindingsItems0PartnerLinks
type LunVvolBindingsItems0PartnerLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun vvol bindings items0 partner links
func (m *LunVvolBindingsItems0PartnerLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0PartnerLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun vvol bindings items0 partner links based on the context it is used
func (m *LunVvolBindingsItems0PartnerLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunVvolBindingsItems0PartnerLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunVvolBindingsItems0PartnerLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunVvolBindingsItems0PartnerLinks) UnmarshalBinary(b []byte) error {
	var res LunVvolBindingsItems0PartnerLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
