// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LunMap A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
// swagger:model lun_map
type LunMap struct {

	// links
	Links *LunMapInlineLinks `json:"_links,omitempty"`

	// igroup
	Igroup *LunMapInlineIgroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value.
	//
	// Example: 1
	// Maximum: 4095
	// Minimum: 0
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`

	// lun
	Lun *LunMapInlineLun `json:"lun,omitempty"`

	// The cluster nodes from which network paths to the mapped LUNs are advertised via the SAN protocols as part of the Selective LUN Map (SLM) feature of ONTAP.<br/>
	// When a LUN map is created, the cluster node hosting the LUN and its high availability (HA) partner are set as the default reporting node. In POST, the property `additional_reporting_node` may be used to add an additional node and its HA partner.<br/>
	// For further information, see [`DOC /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes`](#docs-SAN-protocols_san_lun-maps_{lun.uuid}_{igroup.uuid}_reporting-nodes).
	//
	// Read Only: true
	LunMapInlineReportingNodes []*LunMapInlineReportingNodesInlineArrayItem `json:"reporting_nodes,omitempty"`

	// svm
	Svm *LunMapInlineSvm `json:"svm,omitempty"`
}

// Validate validates this lun map
func (m *LunMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogicalUnitNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLun(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunMapInlineReportingNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMap) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *LunMap) validateLogicalUnitNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.LogicalUnitNumber) { // not required
		return nil
	}

	if err := validate.MinimumInt("logical_unit_number", "body", *m.LogicalUnitNumber, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("logical_unit_number", "body", *m.LogicalUnitNumber, 4095, false); err != nil {
		return err
	}

	return nil
}

func (m *LunMap) validateLun(formats strfmt.Registry) error {
	if swag.IsZero(m.Lun) { // not required
		return nil
	}

	if m.Lun != nil {
		if err := m.Lun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

func (m *LunMap) validateLunMapInlineReportingNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.LunMapInlineReportingNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.LunMapInlineReportingNodes); i++ {
		if swag.IsZero(m.LunMapInlineReportingNodes[i]) { // not required
			continue
		}

		if m.LunMapInlineReportingNodes[i] != nil {
			if err := m.LunMapInlineReportingNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("reporting_nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunMap) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map based on the context it is used
func (m *LunMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunMapInlineReportingNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMap) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *LunMap) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if m.Lun != nil {
		if err := m.Lun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

func (m *LunMap) contextValidateLunMapInlineReportingNodes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reporting_nodes", "body", []*LunMapInlineReportingNodesInlineArrayItem(m.LunMapInlineReportingNodes)); err != nil {
		return err
	}

	for i := 0; i < len(m.LunMapInlineReportingNodes); i++ {

		if m.LunMapInlineReportingNodes[i] != nil {
			if err := m.LunMapInlineReportingNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("reporting_nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LunMap) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMap) UnmarshalBinary(b []byte) error {
	var res LunMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineIgroup The initiator group to which the LUN is mapped. Required in POST by supplying either the `igroup.uuid`, `igroup.name`, or both.
//
// swagger:model lun_map_inline_igroup
type LunMapInlineIgroup struct {

	// links
	Links *LunMapInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The initiators that are members of the initiator group.
	//
	// Read Only: true
	Initiators []*string `json:"initiators,omitempty"`

	// The name of the initiator group. Valid in POST.
	//
	// Example: igroup1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system.
	//
	// Read Only: true
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group.
	//
	// Read Only: true
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// This property reports if the initiator group is replicated.
	//
	// Read Only: true
	Replicated *bool `json:"replicated,omitempty"`

	// The unique identifier of the initiator group. Valid in POST.
	//
	// Example: 1ad8544d-8cd1-91e0-9e1c-723478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map inline igroup
func (m *LunMapInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var lunMapInlineIgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunMapInlineIgroupTypeOsTypePropEnum = append(lunMapInlineIgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeAix captures enum value "aix"
	LunMapInlineIgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeHpux captures enum value "hpux"
	LunMapInlineIgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeHyperv captures enum value "hyper_v"
	LunMapInlineIgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeLinux captures enum value "linux"
	LunMapInlineIgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeNetware captures enum value "netware"
	LunMapInlineIgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeOpenvms captures enum value "openvms"
	LunMapInlineIgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeSolaris captures enum value "solaris"
	LunMapInlineIgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeVmware captures enum value "vmware"
	LunMapInlineIgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeWindows captures enum value "windows"
	LunMapInlineIgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// LunMapInlineIgroupOsTypeXen captures enum value "xen"
	LunMapInlineIgroupOsTypeXen string = "xen"
)

// prop value enum
func (m *LunMapInlineIgroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunMapInlineIgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunMapInlineIgroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("igroup"+"."+"os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var lunMapInlineIgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		lunMapInlineIgroupTypeProtocolPropEnum = append(lunMapInlineIgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// LunMapInlineIgroupProtocolFcp captures enum value "fcp"
	LunMapInlineIgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// LunMapInlineIgroupProtocolIscsi captures enum value "iscsi"
	LunMapInlineIgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// lun_map_inline_igroup
	// LunMapInlineIgroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// LunMapInlineIgroupProtocolMixed captures enum value "mixed"
	LunMapInlineIgroupProtocolMixed string = "mixed"
)

// prop value enum
func (m *LunMapInlineIgroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, lunMapInlineIgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LunMapInlineIgroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("igroup"+"."+"protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun map inline igroup based on the context it is used
func (m *LunMapInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOsType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReplicated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineIgroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"initiators", "body", []*string(m.Initiators)); err != nil {
		return err
	}

	for i := 0; i < len(m.Initiators); i++ {

		if err := validate.ReadOnly(ctx, "igroup"+"."+"initiators"+"."+strconv.Itoa(i), "body", m.Initiators[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *LunMapInlineIgroup) contextValidateOsType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"os_type", "body", m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *LunMapInlineIgroup) contextValidateProtocol(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"protocol", "body", m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *LunMapInlineIgroup) contextValidateReplicated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"replicated", "body", m.Replicated); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineIgroup) UnmarshalBinary(b []byte) error {
	var res LunMapInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineIgroupInlineLinks lun map inline igroup inline links
//
// swagger:model lun_map_inline_igroup_inline__links
type LunMapInlineIgroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map inline igroup inline links
func (m *LunMapInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline igroup inline links based on the context it is used
func (m *LunMapInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineLinks lun map inline links
//
// swagger:model lun_map_inline__links
type LunMapInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map inline links
func (m *LunMapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline links based on the context it is used
func (m *LunMapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineLun The LUN to which the initiator group is mapped. Required in POST by supplying either the `lun.uuid`, `lun.name`, or both.
//
// swagger:model lun_map_inline_lun
type LunMapInlineLun struct {

	// links
	Links *LunMapInlineLunInlineLinks `json:"_links,omitempty"`

	// The name of the LUN. Valid in POST.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>LUN names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/qtree1/lun1
	Name *string `json:"name,omitempty"`

	// node
	Node *LunMapInlineLunInlineNode `json:"node,omitempty"`

	// smbc
	Smbc *LunMapInlineLunInlineSmbc `json:"smbc,omitempty"`

	// The unique identifier of the LUN. Valid in POST.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map inline lun
func (m *LunMapInlineLun) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSmbc(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLun) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineLun) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineLun) validateSmbc(formats strfmt.Registry) error {
	if swag.IsZero(m.Smbc) { // not required
		return nil
	}

	if m.Smbc != nil {
		if err := m.Smbc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "smbc")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline lun based on the context it is used
func (m *LunMapInlineLun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSmbc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLun) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineLun) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineLun) contextValidateSmbc(ctx context.Context, formats strfmt.Registry) error {

	if m.Smbc != nil {
		if err := m.Smbc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "smbc")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineLun) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineLun) UnmarshalBinary(b []byte) error {
	var res LunMapInlineLun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineLunInlineLinks lun map inline lun inline links
//
// swagger:model lun_map_inline_lun_inline__links
type LunMapInlineLunInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map inline lun inline links
func (m *LunMapInlineLunInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLunInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline lun inline links based on the context it is used
func (m *LunMapInlineLunInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLunInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineLunInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineLunInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapInlineLunInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineLunInlineNode The LUN node.
//
// swagger:model lun_map_inline_lun_inline_node
type LunMapInlineLunInlineNode struct {

	// links
	Links *LunMapInlineLunInlineNodeInlineLinks `json:"_links,omitempty"`

	// The name of the LUN's node.
	//
	// Example: node1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the LUN node.
	//
	// Example: 1cf8aa42-8cd1-12e0-a11c-423468563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map inline lun inline node
func (m *LunMapInlineLunInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLunInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline lun inline node based on the context it is used
func (m *LunMapInlineLunInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLunInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineLunInlineNode) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"node"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *LunMapInlineLunInlineNode) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"node"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineLunInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineLunInlineNode) UnmarshalBinary(b []byte) error {
	var res LunMapInlineLunInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineLunInlineNodeInlineLinks lun map inline lun inline node inline links
//
// swagger:model lun_map_inline_lun_inline_node_inline__links
type LunMapInlineLunInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map inline lun inline node inline links
func (m *LunMapInlineLunInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLunInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline lun inline node inline links based on the context it is used
func (m *LunMapInlineLunInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLunInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineLunInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineLunInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapInlineLunInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineLunInlineSmbc "Properties related to SM-BC replication."
//
// swagger:model lun_map_inline_lun_inline_smbc
type LunMapInlineLunInlineSmbc struct {

	// This property reports if the LUN is replicated via SM-BC.
	//
	// Read Only: true
	Replicated *bool `json:"replicated,omitempty"`
}

// Validate validates this lun map inline lun inline smbc
func (m *LunMapInlineLunInlineSmbc) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this lun map inline lun inline smbc based on the context it is used
func (m *LunMapInlineLunInlineSmbc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReplicated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineLunInlineSmbc) contextValidateReplicated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"smbc"+"."+"replicated", "body", m.Replicated); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineLunInlineSmbc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineLunInlineSmbc) UnmarshalBinary(b []byte) error {
	var res LunMapInlineLunInlineSmbc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineReportingNodesInlineArrayItem A cluster node from which network paths to the LUN are advertised by ONTAP via the SAN protocols.
//
// swagger:model lun_map_inline_reporting_nodes_inline_array_item
type LunMapInlineReportingNodesInlineArrayItem struct {

	// links
	Links *LunMapInlineReportingNodesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The name of the node.<br/>
	// Either `uuid` or `name` are required in POST.
	//
	// Example: node1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the node.<br/>
	// Either `uuid` or `name` are required in POST.
	//
	// Example: 5ac8eb9c-4e32-dbaa-57ca-fb905976f54e
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map inline reporting nodes inline array item
func (m *LunMapInlineReportingNodesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineReportingNodesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline reporting nodes inline array item based on the context it is used
func (m *LunMapInlineReportingNodesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineReportingNodesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineReportingNodesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineReportingNodesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LunMapInlineReportingNodesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineReportingNodesInlineArrayItemInlineLinks lun map inline reporting nodes inline array item inline links
//
// swagger:model lun_map_inline_reporting_nodes_inline_array_item_inline__links
type LunMapInlineReportingNodesInlineArrayItemInlineLinks struct {

	// node
	Node *Href `json:"node,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map inline reporting nodes inline array item inline links
func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline reporting nodes inline array item inline links based on the context it is used
func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineReportingNodesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapInlineReportingNodesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model lun_map_inline_svm
type LunMapInlineSvm struct {

	// links
	Links *LunMapInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map inline svm
func (m *LunMapInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline svm based on the context it is used
func (m *LunMapInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineSvm) UnmarshalBinary(b []byte) error {
	var res LunMapInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapInlineSvmInlineLinks lun map inline svm inline links
//
// swagger:model lun_map_inline_svm_inline__links
type LunMapInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map inline svm inline links
func (m *LunMapInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map inline svm inline links based on the context it is used
func (m *LunMapInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
