// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LunMapReportingNode A cluster node from which network paths to the LUN are advertised by ONTAP via the SAN protocols.
//
// swagger:model lun_map_reporting_node
type LunMapReportingNode struct {

	// links
	Links *LunMapReportingNodeInlineLinks `json:"_links,omitempty"`

	// igroup
	Igroup *LunMapReportingNodeInlineIgroup `json:"igroup,omitempty"`

	// lun
	Lun *LunMapReportingNodeInlineLun `json:"lun,omitempty"`

	// The name of the node.<br/>
	// Either `uuid` or `name` are required in POST.
	//
	// Example: node1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the node.<br/>
	// Either `uuid` or `name` are required in POST.
	//
	// Example: 5ac8eb9c-4e32-dbaa-57ca-fb905976f54e
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map reporting node
func (m *LunMapReportingNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLun(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNode) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNode) validateLun(formats strfmt.Registry) error {
	if swag.IsZero(m.Lun) { // not required
		return nil
	}

	if m.Lun != nil {
		if err := m.Lun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map reporting node based on the context it is used
func (m *LunMapReportingNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNode) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNode) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if m.Lun != nil {
		if err := m.Lun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapReportingNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapReportingNode) UnmarshalBinary(b []byte) error {
	var res LunMapReportingNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapReportingNodeInlineIgroup The initiator group of the LUN map of the reporting node.
//
// swagger:model lun_map_reporting_node_inline_igroup
type LunMapReportingNodeInlineIgroup struct {

	// links
	Links *LunMapReportingNodeInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map reporting node inline igroup
func (m *LunMapReportingNodeInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map reporting node inline igroup based on the context it is used
func (m *LunMapReportingNodeInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNodeInlineIgroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapReportingNodeInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapReportingNodeInlineIgroup) UnmarshalBinary(b []byte) error {
	var res LunMapReportingNodeInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapReportingNodeInlineIgroupInlineLinks lun map reporting node inline igroup inline links
//
// swagger:model lun_map_reporting_node_inline_igroup_inline__links
type LunMapReportingNodeInlineIgroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map reporting node inline igroup inline links
func (m *LunMapReportingNodeInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map reporting node inline igroup inline links based on the context it is used
func (m *LunMapReportingNodeInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapReportingNodeInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapReportingNodeInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapReportingNodeInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapReportingNodeInlineLinks lun map reporting node inline links
//
// swagger:model lun_map_reporting_node_inline__links
type LunMapReportingNodeInlineLinks struct {

	// node
	Node *Href `json:"node,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map reporting node inline links
func (m *LunMapReportingNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineLinks) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map reporting node inline links based on the context it is used
func (m *LunMapReportingNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineLinks) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapReportingNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapReportingNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapReportingNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapReportingNodeInlineLun The LUN of the LUN map of the reporting node.
//
// swagger:model lun_map_reporting_node_inline_lun
type LunMapReportingNodeInlineLun struct {

	// links
	Links *LunMapReportingNodeInlineLunInlineLinks `json:"_links,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun map reporting node inline lun
func (m *LunMapReportingNodeInlineLun) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineLun) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map reporting node inline lun based on the context it is used
func (m *LunMapReportingNodeInlineLun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineLun) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *LunMapReportingNodeInlineLun) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapReportingNodeInlineLun) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapReportingNodeInlineLun) UnmarshalBinary(b []byte) error {
	var res LunMapReportingNodeInlineLun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// LunMapReportingNodeInlineLunInlineLinks lun map reporting node inline lun inline links
//
// swagger:model lun_map_reporting_node_inline_lun_inline__links
type LunMapReportingNodeInlineLunInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this lun map reporting node inline lun inline links
func (m *LunMapReportingNodeInlineLunInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineLunInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun map reporting node inline lun inline links based on the context it is used
func (m *LunMapReportingNodeInlineLunInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LunMapReportingNodeInlineLunInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LunMapReportingNodeInlineLunInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LunMapReportingNodeInlineLunInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunMapReportingNodeInlineLunInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
